/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.api;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.bos.exception.ErrorCode;

public class APIResultHelper {
    public static Map<String, Object> buildOk(String requestId, Object data) {
        HashMap<String, Object> resp = new HashMap<String, Object>(6);
        resp.put("requestId", requestId);
        resp.put("errCode", GaiErrorCode.OK.getCode());
        resp.put("errMsg", GaiErrorCode.OK.getMsg());
        resp.put("data", data);
        resp.put("status", Boolean.TRUE);
        return resp;
    }

    public static Map<String, Object> buildOk(String requestId, Object data, String msg) {
        HashMap<String, Object> resp = new HashMap<String, Object>(6);
        resp.put("requestId", requestId);
        resp.put("errCode", GaiErrorCode.OK.getCode());
        resp.put("errMsg", msg);
        resp.put("data", data);
        resp.put("status", Boolean.TRUE);
        return resp;
    }

    public static Map<String, Object> buildErr(String requestId, ErrorCode errorCode) {
        HashMap<String, Object> resp = new HashMap<String, Object>(4);
        resp.put("requestId", requestId);
        resp.put("errCode", errorCode.getCode());
        resp.put("errMsg", errorCode.getMessage());
        resp.put("status", Boolean.FALSE);
        return resp;
    }

    public static Map<String, Object> buildErr(ErrorCode errorCode) {
        HashMap<String, Object> resp = new HashMap<String, Object>(4);
        resp.put("errCode", errorCode.getCode());
        resp.put("errMsg", errorCode.getMessage());
        resp.put("status", Boolean.FALSE);
        return resp;
    }

    public static Map<String, Object> buildErr(String requestId, GaiErrorCode errorCode) {
        HashMap<String, Object> resp = new HashMap<String, Object>(4);
        resp.put("requestId", requestId);
        resp.put("errCode", errorCode.getCode());
        resp.put("errMsg", errorCode.getMsg());
        resp.put("status", Boolean.FALSE);
        return resp;
    }

    public static Map<String, Object> buildErr(String requestId, GaiErrorCode errorCode, String extMsg) {
        HashMap<String, Object> resp = new HashMap<String, Object>(4);
        resp.put("requestId", requestId);
        resp.put("errCode", errorCode.getCode());
        resp.put("errMsg", String.format("%s%s", errorCode.getMsg(), extMsg));
        resp.put("status", Boolean.FALSE);
        return resp;
    }

    public static String buildRequestId() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }
}

