/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.api.mservice;

import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.api.APIResultHelper;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.domain.llm.base.Result2User;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.message.llmcallback.LLMParsedMessage;
import kd.ai.gai.core.helper.KnowledgeCitationHelper;
import kd.bos.util.StringUtils;

public class MserviceResultHelper
extends APIResultHelper {
    private MserviceResultHelper() {
    }

    public static Map<String, Object> build(String requestId, Result result) {
        HashMap<String, Object> resp = new HashMap<String, Object>(6);
        resp.put("requestId", requestId);
        resp.put("errCode", result.getErrorCode().getCode());
        resp.put("errMsg", result.getErrorCode().getMessage());
        resp.put("data", result.getData());
        resp.put("isCallback", result.isCallback());
        resp.put("status", GaiErrorCode.OK.getCode().equalsIgnoreCase(result.getErrorCode().getCode()));
        return resp;
    }

    public static Map<String, Object> build(String requestId, Result2User result) {
        HashMap<String, Object> resp = new HashMap<String, Object>(5);
        HashMap<String, String> data = new HashMap<String, String>(2);
        data.put("taskId", result.getTaskId());
        data.put("llmValue", result.getContent());
        resp.put("requestId", requestId);
        resp.put("errCode", result.getCode());
        resp.put("errMsg", result.getErrMsg());
        resp.put("data", data);
        resp.put("status", GaiErrorCode.OK.getCode().equalsIgnoreCase(result.getCode()));
        return resp;
    }

    public static Map<String, Object> buildCallMsg(LLMParsedMessage respMsg) {
        HashMap<String, Object> resp = new HashMap<String, Object>(5);
        HashMap<String, Object> data = new HashMap<String, Object>(8);
        data.put("taskId", respMsg.getTaskId());
        data.put("chatSessionId", respMsg.getChatSessionId());
        data.put("seqNo", respMsg.getSeqNo());
        data.put("isStream", respMsg.isStream());
        data.put("isEnd", respMsg.isEnd());
        data.put("llmValue", respMsg.getLlmValue());
        data.put("llmThink", respMsg.getLlmThink());
        data.put("referenceInfos", KnowledgeCitationHelper.boxCitationInfoToAPIService(respMsg.getCitationInfos()));
        data.put("jsonValue", respMsg.getJsonValue());
        resp.put("requestId", MserviceResultHelper.buildRequestId());
        resp.put("errCode", StringUtils.isEmpty((String)respMsg.getErrCode()) ? GaiErrorCode.MESSAGE_CALLBACK_ERROR.getCode() : respMsg.getErrCode());
        resp.put("errMsg", StringUtils.isEmpty((String)respMsg.getErrCode()) ? GaiErrorCode.MESSAGE_CALLBACK_ERROR.getMsg() : respMsg.getErrMsg());
        resp.put("data", data);
        resp.put("status", "0".equalsIgnoreCase(respMsg.getErrCode()));
        return resp;
    }
}

