/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.audio;

import com.alibaba.fastjson.JSONObject;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.ai.gai.core.audio.AudioConfigService;
import kd.ai.gai.core.audio.AudioParam;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class AudioServiceHelper {
    public static final String MODEL_OWNER = "modelowner";
    public static final String AICC_SERVICE = "aicc_service";
    public static final String SELECT_PROPERTIES = "id,configmodel,modelowner,entryentity,entryentity.modelurl,entryentity.clientid,entryentity.secretkey,entryentity.usersecretkey,entryentity.instanceenable";
    public static final String CONFIG_MODEL = "configmodel";
    public static final String MODEL_URL = "modelurl";
    public static final String CLIENT_ID = "clientid";
    public static final String SECRET_KEY = "secretkey";
    public static final String USER_SECRET_KEY = "usersecretkey";
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"gai-openAudio", (int)10);
    private static final Log logger = LogFactory.getLog(AudioServiceHelper.class);

    public static AudioParam openAudio(String audioModelId) {
        Future submit = threadPool.submit(() -> AudioServiceHelper.getAudioParam(audioModelId));
        AudioParam audioParam = null;
        try {
            audioParam = (AudioParam)submit.get(15000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return audioParam;
    }

    public static String getAudioModel() {
        Optional<DynamicObject> instanceenable;
        DynamicObject dynamicObject;
        DynamicObjectCollection entryentity;
        DynamicObject[] load = BusinessDataServiceHelper.load((String)AICC_SERVICE, (String)"id,modeltype,entryentity,entryentity.instanceenable", (QFilter[])new QFilter[]{new QFilter("modeltype", "=", (Object)"AUDIO").and("enable", "=", (Object)"1")}, (String)"createtime desc");
        if (load.length > 0 && !(entryentity = (dynamicObject = load[0]).getDynamicObjectCollection("entryentity")).isEmpty() && (instanceenable = entryentity.stream().filter(v -> v.getBoolean("instanceenable")).findFirst()).isPresent()) {
            return dynamicObject.getString("id");
        }
        return null;
    }

    private static AudioParam getAudioParam(String audioModelId) {
        JSONObject object = AudioServiceHelper.loadAudio(audioModelId);
        if (object.isEmpty()) {
            return null;
        }
        AudioConfigService audioConfigService = AudioConfigService.createInstance(object.getString(MODEL_OWNER));
        if (audioConfigService != null) {
            return audioConfigService.buildAudioParam(object);
        }
        return null;
    }

    private static JSONObject loadAudio(String audioModelId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)AICC_SERVICE, (String)SELECT_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(audioModelId))});
        if (dynamicObject != null) {
            Optional<DynamicObject> instanceenable;
            JSONObject object = new JSONObject();
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            if (entryEntity != null && !entryEntity.isEmpty() && (instanceenable = entryEntity.stream().filter(v -> v.getBoolean("instanceenable")).findFirst()).isPresent()) {
                object.put(CONFIG_MODEL, (Object)dynamicObject.getString(CONFIG_MODEL));
                object.put(MODEL_OWNER, (Object)dynamicObject.getString(MODEL_OWNER));
                DynamicObject dynamicObject1 = instanceenable.get();
                String clientId = dynamicObject1.getString(CLIENT_ID);
                String secretKey = dynamicObject1.getString(SECRET_KEY);
                String userSecretKey = dynamicObject1.getString(USER_SECRET_KEY);
                if (Encrypters.isEncrypted((String)clientId)) {
                    clientId = Encrypters.decode((String)clientId);
                }
                if (Encrypters.isEncrypted((String)secretKey)) {
                    secretKey = Encrypters.decode((String)secretKey);
                }
                if (Encrypters.isEncrypted((String)userSecretKey)) {
                    userSecretKey = Encrypters.decode((String)userSecretKey);
                }
                object.put(MODEL_URL, (Object)dynamicObject1.getString(MODEL_URL));
                object.put(CLIENT_ID, (Object)clientId);
                object.put(SECRET_KEY, (Object)secretKey);
                object.put(USER_SECRET_KEY, (Object)userSecretKey);
            }
            return object;
        }
        return new JSONObject();
    }
}

