/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.audio.baidu;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.UUID;
import kd.ai.gai.core.audio.AudioConfigService;
import kd.ai.gai.core.audio.AudioParam;
import kd.ai.gai.core.audio.AudioType;
import kd.ai.gai.core.audio.CryptoUtils;
import kd.ai.gai.core.audio.baidu.BaiduAsrParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import org.apache.commons.lang3.StringUtils;

public class BaiduAudioConfigServiceImpl
implements AudioConfigService {
    @Override
    public AudioParam buildAudioParam(JSONObject config) {
        String clientId = config.getString("clientid");
        if (StringUtils.isBlank((CharSequence)clientId)) {
            throw new KDException(new ErrorCode("clientIdErr", "clientId is null"), new Object[0]);
        }
        int model = 15372;
        String modelStr = config.getString("configmodel");
        if (StringUtils.isNotBlank((CharSequence)modelStr)) {
            try {
                model = Integer.parseInt(modelStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AudioParam audioParam = new AudioParam();
        BaiduAsrParam.Data data = new BaiduAsrParam.Data(Long.parseLong(clientId), config.getString("secretkey"), model);
        String uuid = UUID.randomUUID().toString();
        data.setCuid(uuid);
        BaiduAsrParam baiduAsrParam = new BaiduAsrParam(data, config.getString("modelurl"));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("sn", uuid);
        audioParam.setUrlParams(hashMap);
        String key = uuid.replace("-", "");
        audioParam.setUrl(config.getString("modelurl"));
        try {
            String encrypt = CryptoUtils.encrypt(JSON.toJSONString((Object)baiduAsrParam), key.getBytes(StandardCharsets.UTF_8));
            audioParam.setConfig(encrypt);
            audioParam.setEk(key);
            audioParam.setEncode(true);
            audioParam.setModelType(AudioType.BAIDU.getModel());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return audioParam;
    }
}

