/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.audio.openspeech;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpUtils {
    public static final String URL = "https://openspeech.bytedance.com/api/v1/sts/token";
    public static final String AUTHORIZATION = "Authorization";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_TYPE_JSON = "application/json";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getToken(String appId, String key) {
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).build();
        MediaType json = MediaType.parse((String)CONTENT_TYPE_JSON);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appid", (Object)appId);
        jsonObject.put("duration", (Object)300);
        RequestBody body = RequestBody.create((String)jsonObject.toJSONString(), (MediaType)json);
        Request request = new Request.Builder().url(URL).addHeader(AUTHORIZATION, "Bearer; " + key).addHeader(CONTENT_TYPE, CONTENT_TYPE_JSON).post(body).build();
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new RuntimeException("Request failed: " + response.code());
            }
            if (response.body() == null) {
                throw new RuntimeException("Request failed: response body is null");
            }
            JSONObject res = JSON.parseObject((String)response.body().string());
            String string = res.getString("jwt_token");
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

