/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.audio.openspeech;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.UUID;
import kd.ai.gai.core.audio.AudioConfigService;
import kd.ai.gai.core.audio.AudioParam;
import kd.ai.gai.core.audio.AudioType;
import kd.ai.gai.core.audio.openspeech.AsrParam;
import kd.ai.gai.core.audio.openspeech.HttpUtils;
import kd.ai.gai.exception.ErrorCode;
import kd.ai.gai.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class OpenSpeechAudioConfigServiceImpl
implements AudioConfigService {
    private static final Log log = LogFactory.getLog(OpenSpeechAudioConfigServiceImpl.class);
    private static final String BIGMODEL = "bigmodel";
    private static final String WORKFLOW = "audio_in,resample,partition,vad,fe,decode,nlu_punctuate";

    @Override
    public AudioParam buildAudioParam(JSONObject config) {
        String clientId = config.getString("clientid");
        String secretKey = config.getString("secretkey");
        if (StringUtils.isBlank((CharSequence)clientId) || StringUtils.isBlank((CharSequence)secretKey)) {
            throw new KDException(new ErrorCode("client", "clientId or secretKey is null"), new Object[0]);
        }
        String token = "";
        try {
            token = HttpUtils.getToken(clientId, secretKey);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        if (BIGMODEL.equals(config.getString("configmodel"))) {
            return this.buildBigModelParams(token, config);
        }
        return OpenSpeechAudioConfigServiceImpl.buildParam(config, token, clientId);
    }

    private static AudioParam buildParam(JSONObject config, String token, String clientId) {
        AudioParam audioParam = new AudioParam();
        audioParam.setModelType(AudioType.VOLCENGINE.getModel());
        audioParam.setUrl(config.getString("modelurl"));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("api_jwt", token);
        audioParam.setUrlParams(hashMap);
        AsrParam.App app = new AsrParam.App(clientId, config.getString("usersecretkey"), token);
        AsrParam.User user = new AsrParam.User(clientId);
        AsrParam.Audio audio = new AsrParam.Audio("pcm", 16000, 16, 1);
        AsrParam.Request request = new AsrParam.Request(UUID.randomUUID().toString(), WORKFLOW, false, 1);
        request.setModel_name("");
        AsrParam asrParam = new AsrParam(app, user, request, audio);
        audioParam.setConfig(asrParam);
        return audioParam;
    }

    private AudioParam buildBigModelParams(String token, JSONObject config) {
        AudioParam audioParam = new AudioParam();
        audioParam.setModelType(AudioType.VOLCENGINE.getModel());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("api_access_key", "Jwt; " + token);
        hashMap.put("api_app_key", config.getString("clientid"));
        hashMap.put("api_resource_id", "volc.bigasr.sauc.duration");
        audioParam.setUrlParams(hashMap);
        audioParam.setUrl(config.getString("modelurl"));
        AsrParam.App app = new AsrParam.App(config.getString("clientid"), config.getString("usersecretkey"), token);
        AsrParam.User user = new AsrParam.User(config.getString("clientid"));
        AsrParam.Audio audio = new AsrParam.Audio("pcm", 16000, 16, 1);
        AsrParam.Request request = new AsrParam.Request(UUID.randomUUID().toString(), WORKFLOW, true, 1);
        request.setModel_name(BIGMODEL);
        AsrParam asrParam = new AsrParam(app, user, request, audio);
        audioParam.setConfig(asrParam);
        return audioParam;
    }
}

