/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.audio.xunfei;

import com.alibaba.fastjson.JSONObject;
import java.util.LinkedHashMap;
import kd.ai.gai.core.audio.AudioConfigService;
import kd.ai.gai.core.audio.AudioParam;
import kd.ai.gai.core.audio.AudioType;
import kd.ai.gai.core.audio.xunfei.EncryptUtil;

public class XunfeiAudioConfigServiceImpl
implements AudioConfigService {
    @Override
    public AudioParam buildAudioParam(JSONObject object) {
        LinkedHashMap<String, Object> hashMap = new LinkedHashMap<String, Object>();
        String appId = object.getString("clientid");
        String ts = System.currentTimeMillis() / 1000L + "";
        hashMap.put("appid", appId);
        hashMap.put("ts", ts);
        String signa = "";
        try {
            String md5 = EncryptUtil.MD5(appId + ts);
            signa = EncryptUtil.HmacSHA1Encrypt(md5, object.getString("secretkey"));
            hashMap.put("signa", signa);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        AudioParam audioParam = new AudioParam();
        audioParam.setUrlParams(hashMap);
        audioParam.setUrl(object.getString("modelurl"));
        audioParam.setModelType(AudioType.XUNFEI.getModel());
        return audioParam;
    }
}

