/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.cache;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;

public class GaiCache {
    private static final int TIME_OUT_MAX = 600;
    private static DistributeSessionlessCache gaiCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ai_gai_cache");
    private static final String CACHE_PRE = "gai_";
    public static final String CHAT_TASK_OPEN_API_PRE = "openAPI_";
    private static final String COUNT_PRE = "count_";

    private GaiCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DistributeSessionlessCache getGaiCache() {
        Class<GaiCache> clazz = GaiCache.class;
        synchronized (GaiCache.class) {
            if (gaiCache == null) {
                gaiCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ai_gai_cache");
                // ** MonitorExit[var0] (shouldn't be in output)
                return gaiCache;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return gaiCache;
        }
    }

    public static void put(String key, String val) {
        GaiCache.getGaiCache().put(key, (Object)val, 600);
    }

    private static String buildCacheKeyPre(String key) {
        return String.format("%s%s", CACHE_PRE, key);
    }

    public static String buildOpenApiKey(String taskId, long seqNo) {
        return GaiCache.buildCacheKeyPre(String.format("%s%s_%s", CHAT_TASK_OPEN_API_PRE, taskId, seqNo));
    }

    public static String buildCounterKey(String val) {
        return GaiCache.buildCacheKeyPre(String.format("%s%s", COUNT_PRE, val));
    }

    public static long counter(String counterKey) {
        return GaiCache.getGaiCache().inc(GaiCache.buildCounterKey(counterKey), 600);
    }

    public static long getCounterVal(String counterKey) {
        return Long.parseLong((String)GaiCache.getGaiCache().get(GaiCache.buildCounterKey(counterKey)));
    }
}

