/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.code;

import kd.ai.gai.core.code.GaiErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;

public class GaiExceptionUtil {
    public static ErrorCode buildErr(GaiErrorCode errorCode) {
        return new ErrorCode(errorCode.getCode(), errorCode.getMsg());
    }

    public static ErrorCode buildExtMsgErr(GaiErrorCode errorCode, String extMsg) {
        return new ErrorCode(errorCode.getCode(), String.format(errorCode.getMsg(), extMsg));
    }

    public static void throwGaiException(GaiErrorCode errorCode) {
        throw new KDBizException(new ErrorCode(errorCode.getCode(), errorCode.getMsg()), new Object[0]);
    }

    public static void throwGaiException(GaiErrorCode errorCode, String extMsg) {
        throw new KDBizException(new ErrorCode(errorCode.getCode(), String.format("%s %s", errorCode.getMsg(), extMsg)), new Object[0]);
    }

    public static ErrorCode buildCvpErr(int code, String msg) {
        return new ErrorCode(String.format("ai.cvp.%s", code), msg);
    }

    public static void throwFormatGaiException(GaiErrorCode errorCode, Object ... args) {
        throw new KDBizException(new ErrorCode(errorCode.getCode(), String.format(errorCode.getMsg(), args)), new Object[0]);
    }

    public static void throwFormatGaiException(Throwable ex, GaiErrorCode errorCode, Object ... args) {
        throw new KDBizException(ex, new ErrorCode(errorCode.getCode(), String.format(errorCode.getMsg(), args)), new Object[0]);
    }

    public static void checkCondition(boolean condition, GaiErrorCode falseThrow) {
        if (!condition) {
            throw new KDBizException(new ErrorCode(falseThrow.getCode(), falseThrow.getMsg()), new Object[0]);
        }
    }
}

