/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.domain.llm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.ai.gai.core.domain.llm.base.AliLlmParamInput;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.MessageItem4AzureBaiduTencentXf;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.trust.annotation.MaskingField;
import kd.bos.dataentity.utils.StringUtils;

public class AliLlmParam
extends LlmParam {
    private JSONObject parameters;
    private String model;
    @MaskingField
    private AliLlmParamInput input;
    @MaskingField
    private List<MessageItem4AzureBaiduTencentXf> messages;
    private boolean stream;
    private JSONArray tools;
    private Float top_p;
    private Float temperature;
    private Integer max_tokens;

    public Integer getMax_tokens() {
        return this.max_tokens;
    }

    public void setMax_tokens(Integer max_tokens) {
        this.max_tokens = max_tokens;
    }

    public Float getTop_p() {
        return this.top_p;
    }

    public void setTop_p(Float top_p) {
        this.top_p = top_p;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public JSONObject getParameters() {
        return this.parameters;
    }

    public void setParameters(JSONObject parameters) {
        this.parameters = parameters;
    }

    public AliLlmParamInput getInput() {
        return this.input;
    }

    public void setInput(AliLlmParamInput input) {
        this.input = input;
    }

    public JSONArray getTools() {
        return this.tools;
    }

    public void setTools(JSONArray tools) {
        this.tools = tools;
    }

    public AliLlmParam() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("M6_SEARCH_IN_FIRST_QUERY", (Object)0);
        jsonObject.put("M6_NUM_WEB_SEARCH", (Object)0);
        this.parameters = jsonObject;
    }

    public AliLlmParam(LLM llm, String paramJson) {
        switch (llm.getNumber()) {
            case "ALI_GPT_QWEN_LONG": {
                this.model = "qwen-long";
                break;
            }
            case "ALI_GPT_QWEN_MAX": {
                this.model = "qwen-max";
                break;
            }
            case "ALI_GPT_QWEN_PLUS": {
                this.model = "qwen-plus";
                break;
            }
            case "ALI_GPT_QWEN_TURBO": {
                this.model = "qwen-turbo";
                break;
            }
            case "ALI_GPT_QWEN_2.5": {
                this.model = "qwen2-57b-a14b-instruct";
                break;
            }
            default: {
                this.model = "qwen-long";
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)paramJson)) {
            JSONObject paramObj = JSON.parseObject((String)paramJson);
            this.temperature = paramObj.getFloat("temperature");
            this.top_p = paramObj.getFloat("top_p");
            this.max_tokens = paramObj.getInteger("max_tokens");
        } else {
            this.temperature = null;
            this.top_p = null;
        }
    }

    public boolean isStream() {
        return this.stream;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public List<MessageItem4AzureBaiduTencentXf> getMessages() {
        return this.messages;
    }

    public void setMessages(List<MessageItem4AzureBaiduTencentXf> messages) {
        this.messages = messages;
    }

    @Override
    protected void setLlmStyle(LlmStyle llmStyle, String paramJson) {
        if (StringUtils.isNotEmpty((CharSequence)paramJson)) {
            JSONObject paramObj = JSON.parseObject((String)paramJson);
            this.temperature = paramObj.getFloat("temperature");
            this.top_p = paramObj.getFloat("top_p");
            this.max_tokens = paramObj.getInteger("max_tokens");
        } else {
            switch (llmStyle) {
                case CREATIVITY: {
                    this.temperature = Float.valueOf(0.8f);
                    this.top_p = Float.valueOf(0.9f);
                    break;
                }
                case PRECISION: {
                    this.temperature = Float.valueOf(0.0f);
                    this.top_p = Float.valueOf(1.0f);
                    break;
                }
                default: {
                    this.temperature = Float.valueOf(0.0f);
                    this.top_p = Float.valueOf(0.95f);
                }
            }
        }
    }

    @Override
    public JSONObject getDefaultTypeParam(LlmStyle llmStyle) {
        JSONObject typeParam = new JSONObject(true);
        JSONObject temperatureJson = new JSONObject();
        temperatureJson.put("min", (Object)0);
        temperatureJson.put("max", (Object)2);
        temperatureJson.put("ranger", (Object)1);
        temperatureJson.put("desc", (Object)this.modelParamLang.TEMPERATURE_DESC);
        temperatureJson.put("name", (Object)this.modelParamLang.TEMPERATURE_NAME);
        temperatureJson.put("title", (Object)this.modelParamLang.TEMPERATURE_TITLE);
        JSONObject topPJson = new JSONObject();
        topPJson.put("min", (Object)0);
        topPJson.put("max", (Object)1);
        topPJson.put("ranger", (Object)3);
        topPJson.put("desc", (Object)this.modelParamLang.TOP_P_DESC);
        topPJson.put("name", (Object)this.modelParamLang.TOP_P_NAME);
        topPJson.put("title", (Object)this.modelParamLang.TOP_P_TITLE);
        switch (llmStyle) {
            case CREATIVITY: {
                temperatureJson.put("value", (Object)0.8);
                topPJson.put("value", (Object)1);
                break;
            }
            case BALANCE: {
                temperatureJson.put("value", (Object)0);
                topPJson.put("value", (Object)0.95);
                break;
            }
            case PRECISION: {
                temperatureJson.put("value", (Object)0);
                topPJson.put("value", (Object)0.9);
            }
        }
        typeParam.put("temperature", (Object)temperatureJson);
        typeParam.put("top_p", (Object)topPJson);
        typeParam.put("max_tokens", (Object)this.maxTokensKey());
        return typeParam;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }
}

