/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.domain.llm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.List;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.MessageItem4Claude3;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.trust.annotation.MaskingField;
import kd.bos.dataentity.utils.StringUtils;

public class AwsAnthropicClaudeMessagesParam
extends LlmParam {
    private String anthropic_version = "bedrock-2023-05-31";
    private int max_tokens = 4096;
    @MaskingField
    private String system;
    @MaskingField
    private List<MessageItem4Claude3> messages;
    private float temperature;
    private List<String> stop_sequences;
    @JSONField(serialize=false)
    private int inPutToken;

    public AwsAnthropicClaudeMessagesParam() {
        this.setLlmStyle(LlmStyle.BALANCE, null);
    }

    public AwsAnthropicClaudeMessagesParam(LlmStyle llmStyle, String paramJson) {
        this.setLlmStyle(llmStyle, paramJson);
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    public String getAnthropic_version() {
        return this.anthropic_version;
    }

    public void setAnthropic_version(String anthropic_version) {
        this.anthropic_version = anthropic_version;
    }

    public int getMax_tokens() {
        return this.max_tokens;
    }

    public void setMax_tokens(int max_tokens) {
        this.max_tokens = max_tokens;
    }

    public List<MessageItem4Claude3> getMessages() {
        return this.messages;
    }

    public void setMessages(List<MessageItem4Claude3> messages) {
        this.messages = messages;
    }

    @Override
    public int getInPutToken() {
        return this.inPutToken;
    }

    @Override
    public void setInPutToken(int inPutToken) {
        this.inPutToken = inPutToken;
    }

    @Override
    public JSONObject getDefaultTypeParam(LlmStyle llmStyle) {
        JSONObject typeParam = new JSONObject(true);
        JSONObject temperatureJson = new JSONObject();
        temperatureJson.put("min", (Object)0);
        temperatureJson.put("max", (Object)1);
        temperatureJson.put("ranger", (Object)3);
        temperatureJson.put("desc", (Object)this.modelParamLang.TEMPERATURE_DESC);
        temperatureJson.put("name", (Object)this.modelParamLang.TEMPERATURE_NAME);
        temperatureJson.put("title", (Object)this.modelParamLang.TEMPERATURE_TITLE);
        switch (llmStyle) {
            case CREATIVITY: {
                temperatureJson.put("value", (Object)1);
                break;
            }
            case PRECISION: {
                temperatureJson.put("value", (Object)0);
                break;
            }
            case BALANCE: {
                temperatureJson.put("value", (Object)0.5);
            }
        }
        typeParam.put("temperature", (Object)temperatureJson);
        typeParam.put("max_tokens", (Object)this.maxTokensKey());
        return typeParam;
    }

    public String getSystem() {
        return this.system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setStop_sequences(List<String> stop_sequences) {
        this.stop_sequences = stop_sequences;
    }

    public List<String> getStop_sequences() {
        return this.stop_sequences;
    }

    @Override
    protected final void setLlmStyle(LlmStyle llmStyle, String paramJson) {
        if (StringUtils.isNotEmpty((CharSequence)paramJson)) {
            JSONObject paramObj = JSON.parseObject((String)paramJson);
            this.temperature = paramObj.getFloat("temperature").floatValue();
            this.max_tokens = paramObj.getInteger("max_tokens");
        } else {
            switch (llmStyle) {
                case CREATIVITY: {
                    this.temperature = 1.0f;
                    break;
                }
                case PRECISION: {
                    this.temperature = 0.0f;
                    break;
                }
                case BALANCE: {
                    this.temperature = 0.5f;
                    break;
                }
                default: {
                    this.max_tokens = 4096;
                }
            }
        }
    }
}

