/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.domain.llm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.trust.annotation.MaskingField;
import kd.bos.dataentity.utils.StringUtils;

public class AwsClaude2Param
extends LlmParam {
    private int top_p;
    private int top_k;
    private int max_tokens_to_sample = 8000;
    private float temperature;
    @MaskingField
    private String prompt;
    private List<String> stop_sequences;
    @JSONField(serialize=false)
    private int inPutToken;

    public AwsClaude2Param() {
        this.setLlmStyle(LlmStyle.BALANCE, null);
    }

    public AwsClaude2Param(LlmStyle llmStyle, String paramJson) {
        this.setLlmStyle(llmStyle, paramJson);
        this.stop_sequences = new ArrayList<String>();
        this.stop_sequences.add("\\n\\nHuman:");
    }

    public int getTop_p() {
        return this.top_p;
    }

    public void setTop_p(int top_p) {
        this.top_p = top_p;
    }

    public int getTop_k() {
        return this.top_k;
    }

    public void setTop_k(int top_k) {
        this.top_k = top_k;
    }

    public int getMax_tokens_to_sample() {
        return this.max_tokens_to_sample;
    }

    public void setMax_tokens_to_sample(int max_tokens_to_sample) {
        this.max_tokens_to_sample = max_tokens_to_sample;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    public List<String> getStop_sequences() {
        return this.stop_sequences;
    }

    public void setStop_sequences(List<String> stop_sequences) {
        this.stop_sequences = stop_sequences;
    }

    @Override
    public int getInPutToken() {
        return this.inPutToken;
    }

    @Override
    public void setInPutToken(int inPutToken) {
        this.inPutToken = inPutToken;
    }

    @Override
    public JSONObject getDefaultTypeParam(LlmStyle llmStyle) {
        JSONObject typeParam = new JSONObject(true);
        JSONObject temperatureJson = new JSONObject();
        temperatureJson.put("min", (Object)0);
        temperatureJson.put("max", (Object)1);
        temperatureJson.put("ranger", (Object)1);
        temperatureJson.put("desc", (Object)this.modelParamLang.TEMPERATURE_DESC);
        temperatureJson.put("name", (Object)this.modelParamLang.TEMPERATURE_NAME);
        temperatureJson.put("title", (Object)this.modelParamLang.TEMPERATURE_TITLE);
        JSONObject topPJson = new JSONObject();
        topPJson.put("min", (Object)0);
        topPJson.put("max", (Object)1);
        topPJson.put("ranger", (Object)3);
        topPJson.put("desc", (Object)this.modelParamLang.TOP_P_DESC);
        topPJson.put("name", (Object)this.modelParamLang.TOP_P_NAME);
        topPJson.put("title", (Object)this.modelParamLang.TOP_P_TITLE);
        JSONObject topKJson = new JSONObject();
        topKJson.put("min", (Object)0);
        topKJson.put("max", (Object)500);
        topKJson.put("ranger", (Object)3);
        topKJson.put("desc", (Object)this.modelParamLang.TOP_K_DESC);
        topKJson.put("name", (Object)this.modelParamLang.TOP_K_NAME);
        topKJson.put("title", (Object)this.modelParamLang.TOP_K_TITLE);
        switch (llmStyle) {
            case CREATIVITY: {
                temperatureJson.put("value", (Object)0.8);
                topPJson.put("value", (Object)1);
                topKJson.put("value", (Object)1);
                break;
            }
            case BALANCE: {
                temperatureJson.put("value", (Object)0.5);
                topPJson.put("value", (Object)1);
                topKJson.put("value", (Object)250);
                break;
            }
            case PRECISION: {
                temperatureJson.put("value", (Object)0);
                topPJson.put("value", (Object)1);
                topKJson.put("value", (Object)250);
            }
        }
        typeParam.put("temperature", (Object)temperatureJson);
        typeParam.put("top_p", (Object)topPJson);
        typeParam.put("top_k", (Object)topKJson);
        typeParam.put("max_tokens", (Object)"max_tokens_to_sample");
        return typeParam;
    }

    @Override
    protected final void setLlmStyle(LlmStyle llmStyle, String paramJson) {
        if (StringUtils.isNotEmpty((CharSequence)paramJson)) {
            JSONObject paramObj = JSON.parseObject((String)paramJson);
            this.temperature = paramObj.getFloat("temperature").floatValue();
            this.top_p = paramObj.getInteger("top_p");
            this.top_k = paramObj.getInteger("top_k");
            this.max_tokens_to_sample = paramObj.getInteger("max_tokens_to_sample");
        } else {
            switch (llmStyle) {
                case CREATIVITY: {
                    this.temperature = 0.8f;
                    this.top_p = 1;
                    this.top_k = 1;
                    break;
                }
                case PRECISION: {
                    this.temperature = 0.0f;
                    this.top_p = 1;
                    this.top_k = 250;
                    break;
                }
                default: {
                    this.temperature = 0.5f;
                    this.top_p = 1;
                    this.top_k = 250;
                }
            }
        }
    }
}

