/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.domain.llm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.List;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.MessageItem4AzureBaiduTencentXf;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.trust.annotation.MaskingField;
import kd.bos.dataentity.utils.StringUtils;

public class AzureLlmParam
extends LlmParam {
    private boolean stream;
    private float top_p;
    private float frequency_penalty;
    private float presence_penalty;
    private float temperature;
    private String user;
    private Integer max_tokens;
    @MaskingField
    private List<MessageItem4AzureBaiduTencentXf> messages;
    private JSONArray tools;
    @JSONField(serialize=false)
    private int inPutToken;

    public Integer getMax_tokens() {
        return this.max_tokens;
    }

    public void setMax_tokens(Integer max_tokens) {
        this.max_tokens = max_tokens;
    }

    public JSONArray getTools() {
        return this.tools;
    }

    public void setTools(JSONArray tools) {
        this.tools = tools;
    }

    public boolean isStream() {
        return this.stream;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public AzureLlmParam() {
        this.setLlmStyle(LlmStyle.BALANCE, null);
    }

    public AzureLlmParam(LlmStyle llmStyle, String paramJson) {
        this.setLlmStyle(llmStyle, paramJson);
    }

    public float getTop_p() {
        return this.top_p;
    }

    public void setTop_p(float top_p) {
        this.top_p = top_p;
    }

    public float getFrequency_penalty() {
        return this.frequency_penalty;
    }

    public void setFrequency_penalty(float frequency_penalty) {
        this.frequency_penalty = frequency_penalty;
    }

    public float getPresence_penalty() {
        return this.presence_penalty;
    }

    public void setPresence_penalty(float presence_penalty) {
        this.presence_penalty = presence_penalty;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public List<MessageItem4AzureBaiduTencentXf> getMessages() {
        return this.messages;
    }

    public void setMessages(List<MessageItem4AzureBaiduTencentXf> messages) {
        this.messages = messages;
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    @Override
    public int getInPutToken() {
        return this.inPutToken;
    }

    @Override
    public void setInPutToken(int inPutToken) {
        this.inPutToken = inPutToken;
    }

    @Override
    public JSONObject getDefaultTypeParam(LlmStyle llmStyle) {
        JSONObject typeParam = new JSONObject(true);
        JSONObject temperatureJson = new JSONObject();
        temperatureJson.put("min", (Object)0);
        temperatureJson.put("max", (Object)2);
        temperatureJson.put("ranger", (Object)0);
        temperatureJson.put("desc", (Object)this.modelParamLang.TEMPERATURE_DESC);
        temperatureJson.put("name", (Object)this.modelParamLang.TEMPERATURE_NAME);
        temperatureJson.put("title", (Object)this.modelParamLang.TEMPERATURE_TITLE);
        JSONObject topPJson = new JSONObject();
        topPJson.put("min", (Object)0);
        topPJson.put("max", (Object)1);
        topPJson.put("ranger", (Object)3);
        topPJson.put("desc", (Object)this.modelParamLang.TOP_P_DESC);
        topPJson.put("name", (Object)this.modelParamLang.TOP_P_NAME);
        topPJson.put("title", (Object)this.modelParamLang.TOP_P_TITLE);
        JSONObject presenceJson = new JSONObject();
        presenceJson.put("min", (Object)-2);
        presenceJson.put("max", (Object)2);
        presenceJson.put("ranger", (Object)3);
        presenceJson.put("desc", (Object)this.modelParamLang.PRESENCE_PENALTY_DESC);
        presenceJson.put("name", (Object)this.modelParamLang.PRESENCE_PENALTY_NAME);
        presenceJson.put("title", (Object)this.modelParamLang.PRESENCE_PENALTY_TITLE);
        JSONObject frequencyJson = new JSONObject();
        frequencyJson.put("min", (Object)-2);
        frequencyJson.put("max", (Object)2);
        frequencyJson.put("ranger", (Object)3);
        frequencyJson.put("desc", (Object)this.modelParamLang.FREQUENCY_PENALTY_DESC);
        frequencyJson.put("name", (Object)this.modelParamLang.FREQUENCY_PENALTY_NAME);
        frequencyJson.put("title", (Object)this.modelParamLang.FREQUENCY_PENALTY_TITLE);
        switch (llmStyle) {
            case CREATIVITY: {
                temperatureJson.put("value", (Object)0.8);
                topPJson.put("value", (Object)1);
                presenceJson.put("value", (Object)0.1);
                frequencyJson.put("value", (Object)0.1);
                break;
            }
            case BALANCE: {
                temperatureJson.put("value", (Object)0);
                topPJson.put("value", (Object)0.95);
                presenceJson.put("value", (Object)0);
                frequencyJson.put("value", (Object)0);
                break;
            }
            case PRECISION: {
                temperatureJson.put("value", (Object)0);
                topPJson.put("value", (Object)0.9);
                presenceJson.put("value", (Object)0);
                frequencyJson.put("value", (Object)0);
            }
        }
        typeParam.put("temperature", (Object)temperatureJson);
        typeParam.put("top_p", (Object)topPJson);
        typeParam.put("presence_penalty", (Object)presenceJson);
        typeParam.put("frequency_penalty", (Object)frequencyJson);
        typeParam.put("max_tokens", (Object)this.maxTokensKey());
        return typeParam;
    }

    @Override
    protected final void setLlmStyle(LlmStyle llmStyle, String paramJson) {
        if (StringUtils.isNotEmpty((CharSequence)paramJson)) {
            JSONObject paramObj = JSON.parseObject((String)paramJson);
            this.temperature = paramObj.getFloat("temperature").floatValue();
            this.top_p = paramObj.getFloat("top_p").floatValue();
            this.presence_penalty = paramObj.getFloat("presence_penalty").floatValue();
            this.frequency_penalty = paramObj.getFloat("frequency_penalty").floatValue();
            this.max_tokens = paramObj.getInteger("max_tokens");
        } else {
            switch (llmStyle) {
                case CREATIVITY: {
                    this.temperature = 0.8f;
                    this.top_p = 0.9f;
                    this.presence_penalty = 0.1f;
                    this.frequency_penalty = 0.1f;
                    break;
                }
                case PRECISION: {
                    this.temperature = 0.0f;
                    this.top_p = 1.0f;
                    this.presence_penalty = 0.0f;
                    this.frequency_penalty = 0.0f;
                    break;
                }
                default: {
                    this.temperature = 0.0f;
                    this.top_p = 0.95f;
                    this.presence_penalty = 0.0f;
                    this.frequency_penalty = 0.0f;
                }
            }
        }
    }
}

