/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.domain.llm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.MessageItem4AzureBaiduTencentXf;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.trust.annotation.MaskingField;
import kd.bos.dataentity.utils.StringUtils;

public class BaiduLlmParam
extends LlmParam {
    private boolean stream = false;
    private String user_id;
    private boolean disable_search = false;
    private boolean enable_trace = true;
    @MaskingField
    private List<MessageItem4AzureBaiduTencentXf> messages;
    private float temperature;
    private float top_p;
    private float penalty_score;
    private JSONArray functions;
    private Integer max_output_tokens;

    public BaiduLlmParam() {
        this.setLlmStyle(LlmStyle.PRECISION, null);
    }

    public BaiduLlmParam(LlmStyle llmStyle, String paramJson) {
        this.setLlmStyle(llmStyle, paramJson);
    }

    public Integer getMax_output_tokens() {
        return this.max_output_tokens;
    }

    public void setMax_output_tokens(Integer max_output_tokens) {
        this.max_output_tokens = max_output_tokens;
    }

    public boolean isStream() {
        return this.stream;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public String getUser_id() {
        return this.user_id;
    }

    public void setUser_id(String user_id) {
        this.user_id = user_id;
    }

    public List<MessageItem4AzureBaiduTencentXf> getMessages() {
        return this.messages;
    }

    public void setMessages(List<MessageItem4AzureBaiduTencentXf> messages) {
        this.messages = messages;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public float getTop_p() {
        return this.top_p;
    }

    public void setTop_p(float top_p) {
        this.top_p = top_p;
    }

    public float getPenalty_score() {
        return this.penalty_score;
    }

    public void setPenalty_score(float penalty_score) {
        this.penalty_score = penalty_score;
    }

    public boolean isEnable_trace() {
        return this.enable_trace;
    }

    public void setEnable_trace(boolean enable_trace) {
        this.enable_trace = enable_trace;
    }

    public JSONArray getFunctions() {
        return this.functions;
    }

    public void setFunctions(JSONArray functions) {
        this.functions = functions;
    }

    @Override
    protected final void setLlmStyle(LlmStyle llmStyle, String paramJson) {
        if (StringUtils.isNotEmpty((CharSequence)paramJson)) {
            JSONObject paramObj = JSON.parseObject((String)paramJson);
            this.temperature = paramObj.getFloat("temperature").floatValue();
            this.top_p = paramObj.getFloat("top_p").floatValue();
            this.penalty_score = paramObj.getFloat("penalty_score").floatValue();
            this.max_output_tokens = paramObj.getInteger(this.maxTokensKey());
        } else {
            switch (llmStyle) {
                case CREATIVITY: {
                    this.temperature = 0.8f;
                    this.top_p = 1.0f;
                    this.penalty_score = 2.0f;
                    break;
                }
                case PRECISION: {
                    this.temperature = 0.01f;
                    this.top_p = 0.0f;
                    this.penalty_score = 1.0f;
                    break;
                }
                default: {
                    this.temperature = 0.2f;
                    this.top_p = 1.0f;
                    this.penalty_score = 1.0f;
                }
            }
        }
    }

    @Override
    public JSONObject getDefaultTypeParam(LlmStyle llmStyle) {
        JSONObject typeParam = new JSONObject(true);
        JSONObject temperatureJson = new JSONObject();
        temperatureJson.put("min", (Object)0);
        temperatureJson.put("max", (Object)1);
        temperatureJson.put("ranger", (Object)1);
        temperatureJson.put("desc", (Object)this.modelParamLang.TEMPERATURE_DESC);
        temperatureJson.put("name", (Object)this.modelParamLang.TEMPERATURE_NAME);
        temperatureJson.put("title", (Object)this.modelParamLang.TEMPERATURE_TITLE);
        JSONObject topPJson = new JSONObject();
        topPJson.put("min", (Object)0);
        topPJson.put("max", (Object)1);
        topPJson.put("ranger", (Object)3);
        topPJson.put("desc", (Object)this.modelParamLang.TOP_P_DESC);
        topPJson.put("name", (Object)this.modelParamLang.TOP_P_NAME);
        topPJson.put("title", (Object)this.modelParamLang.TOP_P_TITLE);
        JSONObject penaltyScoreJson = new JSONObject();
        penaltyScoreJson.put("min", (Object)1);
        penaltyScoreJson.put("max", (Object)2);
        penaltyScoreJson.put("ranger", (Object)3);
        penaltyScoreJson.put("desc", (Object)this.modelParamLang.PENALTY_SCORE_DESC);
        penaltyScoreJson.put("name", (Object)this.modelParamLang.PENALTY_SCORE_NAME);
        penaltyScoreJson.put("title", (Object)this.modelParamLang.PENALTY_SCORE_TITLE);
        switch (llmStyle) {
            case CREATIVITY: {
                temperatureJson.put("value", (Object)0.8);
                topPJson.put("value", (Object)1.0);
                penaltyScoreJson.put("value", (Object)2.0);
                break;
            }
            case BALANCE: {
                temperatureJson.put("value", (Object)0.2);
                topPJson.put("value", (Object)1);
                penaltyScoreJson.put("value", (Object)1);
                break;
            }
            case PRECISION: {
                temperatureJson.put("value", (Object)0.01);
                topPJson.put("value", (Object)0);
                penaltyScoreJson.put("value", (Object)1);
            }
        }
        typeParam.put("temperature", (Object)temperatureJson);
        typeParam.put("top_p", (Object)topPJson);
        typeParam.put("penalty_score", (Object)penaltyScoreJson);
        typeParam.put("max_tokens", (Object)this.maxTokensKey());
        return typeParam;
    }

    @Override
    public String maxTokensKey() {
        return "max_output_tokens";
    }

    public boolean isDisable_search() {
        return this.disable_search;
    }

    public void setDisable_search(boolean disable_search) {
        this.disable_search = disable_search;
    }
}

