/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.domain.llm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.List;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.MessageItem4AzureBaiduTencentXf;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.trust.annotation.MaskingField;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class DeepSeekParam
extends LlmParam {
    private Log logger = LogFactory.getLog(DeepSeekParam.class);
    private String model;
    private boolean stream;
    private float temperature;
    private float top_p;
    @JSONField(serialize=false)
    private int inPutToken;
    private Integer max_tokens;
    @MaskingField
    private List<MessageItem4AzureBaiduTencentXf> messages;

    public Integer getMax_tokens() {
        return this.max_tokens;
    }

    public void setMax_tokens(Integer max_tokens) {
        this.max_tokens = max_tokens;
    }

    public DeepSeekParam() {
    }

    public DeepSeekParam(LlmStyle llmStyle, LLM llm) {
        String llmNumber = llm.getNumber();
        QFilter filter = new QFilter("number", "=", (Object)llmNumber);
        DynamicObject llmObj = BusinessDataServiceHelper.loadSingle((String)"aicc_llm", (QFilter[])filter.toArray());
        if (llmObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u6a21\u578b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DeepSeekParam_001", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        Object pkValue = llmObj.getPkValue();
        QFilter qFilter = new QFilter("llmtype.id", "=", pkValue);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"aicc_service", (QFilter[])qFilter.toArray());
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u6a21\u578b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DeepSeekParam_001", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        String configModel = dynamicObject.getString("configmodel");
        if (configModel != null && StringUtils.isNotEmpty((String)configModel)) {
            this.logger.info("model:{}", (Object)configModel);
            this.model = configModel;
            this.setLlmStyle(llmStyle, null);
        }
    }

    @Override
    protected void setLlmStyle(LlmStyle llmStyle, String paramJson) {
        if (StringUtils.isNotEmpty((String)paramJson)) {
            JSONObject paramObj = JSON.parseObject((String)paramJson);
            this.temperature = paramObj.getFloat("temperature").floatValue();
            this.top_p = paramObj.getFloat("top_p").floatValue();
            this.max_tokens = paramObj.getInteger("max_tokens");
        } else {
            this.top_p = 1.0f;
            switch (llmStyle) {
                case PRECISION: {
                    this.temperature = 0.6f;
                    break;
                }
                default: {
                    this.temperature = 1.0f;
                }
            }
        }
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public boolean isStream() {
        return this.stream;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public float getTop_p() {
        return this.top_p;
    }

    public void setTop_p(float top_p) {
        this.top_p = top_p;
    }

    public List<MessageItem4AzureBaiduTencentXf> getMessages() {
        return this.messages;
    }

    public void setMessages(List<MessageItem4AzureBaiduTencentXf> messages) {
        this.messages = messages;
    }

    @Override
    public int getInPutToken() {
        return this.inPutToken;
    }

    @Override
    public void setInPutToken(int inPutToken) {
        this.inPutToken = inPutToken;
    }

    @Override
    public JSONObject getDefaultTypeParam(LlmStyle llmStyle) {
        JSONObject typeParam = new JSONObject(true);
        JSONObject temperatureJson = new JSONObject();
        temperatureJson.put("min", (Object)0);
        temperatureJson.put("max", (Object)2);
        temperatureJson.put("ranger", (Object)1);
        temperatureJson.put("desc", (Object)this.modelParamLang.TEMPERATURE_DESC);
        temperatureJson.put("name", (Object)this.modelParamLang.TEMPERATURE_NAME);
        temperatureJson.put("title", (Object)this.modelParamLang.TEMPERATURE_TITLE);
        JSONObject topPJson = new JSONObject();
        topPJson.put("min", (Object)0);
        topPJson.put("max", (Object)1);
        topPJson.put("ranger", (Object)3);
        topPJson.put("desc", (Object)this.modelParamLang.TOP_P_DESC);
        topPJson.put("name", (Object)this.modelParamLang.TOP_P_NAME);
        topPJson.put("title", (Object)this.modelParamLang.TOP_P_TITLE);
        switch (llmStyle) {
            case CREATIVITY: 
            case BALANCE: {
                temperatureJson.put("value", (Object)1);
                topPJson.put("value", (Object)1);
                break;
            }
            case PRECISION: {
                temperatureJson.put("value", (Object)0.6);
                topPJson.put("value", (Object)1);
            }
        }
        typeParam.put("temperature", (Object)temperatureJson);
        typeParam.put("top_p", (Object)topPJson);
        typeParam.put("max_tokens", (Object)this.maxTokensKey());
        return typeParam;
    }
}

