/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.domain.llm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.List;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.MessageItem4AzureBaiduTencentXf;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.trust.annotation.MaskingField;
import kd.bos.dataentity.utils.StringUtils;

public class KimiParam
extends LlmParam {
    private String model;
    private float temperature;
    @MaskingField
    private List<MessageItem4AzureBaiduTencentXf> messages;
    private boolean stream;
    private float top_p;
    private int n;
    @JSONField(serialize=false)
    private int inPutToken;
    private Integer max_tokens;

    public Integer getMax_tokens() {
        return this.max_tokens;
    }

    public void setMax_tokens(Integer max_tokens) {
        this.max_tokens = max_tokens;
    }

    public boolean isStream() {
        return this.stream;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public KimiParam() {
        this.setLlmStyle(LlmStyle.BALANCE, null);
    }

    public KimiParam(LlmStyle llmStyle, LLM llm, String paramJson) {
        this.setLlmStyle(llmStyle, llm, paramJson);
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        this.n = n;
    }

    public float getTop_p() {
        return this.top_p;
    }

    public void setTop_p(float top_p) {
        this.top_p = top_p;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public List<MessageItem4AzureBaiduTencentXf> getMessages() {
        return this.messages;
    }

    public void setMessages(List<MessageItem4AzureBaiduTencentXf> messages) {
        this.messages = messages;
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    @Override
    protected final void setLlmStyle(LlmStyle llmStyle, String paramJson) {
        this.setLlmStyle(llmStyle, LLM.MOONSHOT_V1_8K, paramJson);
    }

    @Override
    public int getInPutToken() {
        return this.inPutToken;
    }

    @Override
    public void setInPutToken(int inPutToken) {
        this.inPutToken = inPutToken;
    }

    @Override
    public JSONObject getDefaultTypeParam(LlmStyle llmStyle) {
        JSONObject typeParam = new JSONObject(true);
        JSONObject temperatureJson = new JSONObject();
        temperatureJson.put("min", (Object)0);
        temperatureJson.put("max", (Object)1);
        temperatureJson.put("ranger", (Object)0);
        temperatureJson.put("desc", (Object)this.modelParamLang.TEMPERATURE_DESC);
        temperatureJson.put("name", (Object)this.modelParamLang.TEMPERATURE_NAME);
        temperatureJson.put("title", (Object)this.modelParamLang.TEMPERATURE_TITLE);
        JSONObject topPJson = new JSONObject();
        topPJson.put("min", (Object)0);
        topPJson.put("max", (Object)1);
        topPJson.put("ranger", (Object)3);
        topPJson.put("desc", (Object)this.modelParamLang.TOP_P_DESC);
        topPJson.put("name", (Object)this.modelParamLang.TOP_P_NAME);
        topPJson.put("title", (Object)this.modelParamLang.TOP_P_TITLE);
        switch (llmStyle) {
            case CREATIVITY: {
                temperatureJson.put("value", (Object)0.7);
                topPJson.put("value", (Object)1);
                break;
            }
            case BALANCE: {
                temperatureJson.put("value", (Object)0.3);
                topPJson.put("value", (Object)1);
                break;
            }
            case PRECISION: {
                temperatureJson.put("value", (Object)0.2);
                topPJson.put("value", (Object)1);
            }
        }
        typeParam.put("temperature", (Object)temperatureJson);
        typeParam.put("top_p", (Object)topPJson);
        typeParam.put("max_tokens", (Object)this.maxTokensKey());
        return typeParam;
    }

    protected final void setLlmStyle(LlmStyle llmStyle, LLM llm, String paramJson) {
        this.n = 1;
        if (StringUtils.isNotEmpty((CharSequence)paramJson)) {
            JSONObject paramObj = JSON.parseObject((String)paramJson);
            this.temperature = paramObj.getFloat("temperature").floatValue();
            this.top_p = paramObj.getFloat("top_p").floatValue();
            this.max_tokens = paramObj.getInteger("max_tokens");
        } else {
            switch (llmStyle) {
                case CREATIVITY: {
                    this.temperature = 0.7f;
                    this.top_p = 1.0f;
                    break;
                }
                case PRECISION: {
                    this.temperature = 0.2f;
                    this.top_p = 1.0f;
                    break;
                }
                default: {
                    this.temperature = 0.3f;
                    this.top_p = 1.0f;
                }
            }
        }
        switch (llm) {
            case MOONSHOT_V1_8K: {
                this.model = "moonshot-v1-8k";
                break;
            }
            case MOONSHOT_V1_32K: {
                this.model = "moonshot-v1-32k";
                break;
            }
            case MOONSHOT_V1_128K: {
                this.model = "moonshot-v1-128k";
            }
        }
    }
}

