/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.domain.llm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.trust.annotation.MaskingField;
import kd.bos.dataentity.utils.StringUtils;

public class KingdeeLlmParam
extends LlmParam {
    @MaskingField
    private List<String> instructions;
    @MaskingField
    private List<String> inputs;
    private List<Float> temperatures;
    private Integer max_tokens;
    private boolean stream;

    public Integer getMax_tokens() {
        return this.max_tokens;
    }

    public void setMax_tokens(Integer max_tokens) {
        this.max_tokens = max_tokens;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<String> inputs) {
        this.inputs = inputs;
    }

    public List<String> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(List<String> instructions) {
        this.instructions = instructions;
    }

    public void setUserInput(String userInput) {
        if (this.instructions == null) {
            this.instructions = new ArrayList<String>();
        }
        this.instructions.add(userInput);
    }

    public boolean isStream() {
        return this.stream;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public List<Float> getTemperatures() {
        return this.temperatures;
    }

    public void setTemperatures(List<Float> temperatures) {
        this.temperatures = temperatures;
    }

    public void setSystem(String system) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<String>();
        }
        if (!StringUtils.isEmpty((CharSequence)system)) {
            this.inputs.add(system);
        }
    }

    @Override
    protected final void setLlmStyle(LlmStyle llmStyle, String paramJson) {
        this.temperatures = new ArrayList<Float>();
        if (StringUtils.isNotEmpty((CharSequence)paramJson)) {
            JSONObject paramObj = JSON.parseObject((String)paramJson);
            this.temperatures.add(paramObj.getFloat("temperatures"));
            this.max_tokens = paramObj.getInteger("max_tokens");
        } else {
            switch (llmStyle) {
                case CREATIVITY: {
                    this.temperatures.add(Float.valueOf(0.8f));
                    break;
                }
                case PRECISION: {
                    this.temperatures.add(Float.valueOf(0.01f));
                    break;
                }
                default: {
                    this.temperatures.add(Float.valueOf(0.5f));
                }
            }
        }
    }

    @Override
    public JSONObject getDefaultTypeParam(LlmStyle llmStyle) {
        JSONObject typeParam = new JSONObject(true);
        JSONObject temperatureJson = new JSONObject();
        temperatureJson.put("min", (Object)0);
        temperatureJson.put("max", (Object)1);
        temperatureJson.put("ranger", (Object)3);
        temperatureJson.put("desc", (Object)this.modelParamLang.TEMPERATURE_DESC);
        temperatureJson.put("name", (Object)this.modelParamLang.TEMPERATURE_NAME);
        temperatureJson.put("title", (Object)this.modelParamLang.TEMPERATURE_TITLE);
        switch (llmStyle) {
            case CREATIVITY: {
                temperatureJson.put("value", (Object)0.8);
                break;
            }
            case BALANCE: {
                temperatureJson.put("value", (Object)0.5);
                break;
            }
            case PRECISION: {
                temperatureJson.put("value", (Object)0.01);
            }
        }
        typeParam.put("temperatures", (Object)temperatureJson);
        typeParam.put("max_tokens", (Object)this.maxTokensKey());
        return typeParam;
    }
}

