/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.domain.llm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.List;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.MessageItem4Tencent;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.trust.annotation.MaskingField;
import kd.bos.dataentity.utils.StringUtils;

public class TencentLlmV3Param
extends LlmParam {
    @JSONField(name="Temperature")
    private float temperature;
    @JSONField(name="TopP")
    private float topP;
    @JSONField(name="Stream")
    private boolean stream;
    @JSONField(name="Model")
    private String model;
    @JSONField(name="StreamModeration")
    private boolean streamModeration = true;
    @MaskingField
    @JSONField(name="Messages")
    private List<MessageItem4Tencent> messages;
    @JSONField(serialize=false)
    private int inPutToken;

    public TencentLlmV3Param() {
    }

    public TencentLlmV3Param(LlmStyle llmStyle, String paramJson) {
        this.setLlmStyle(llmStyle, paramJson);
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public float getTopP() {
        return this.topP;
    }

    public void setTopP(float topP) {
        this.topP = topP;
    }

    public boolean isStream() {
        return this.stream;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public boolean isStreamModeration() {
        return this.streamModeration;
    }

    public void setStreamModeration(boolean streamModeration) {
        this.streamModeration = streamModeration;
    }

    public List<MessageItem4Tencent> getMessages() {
        return this.messages;
    }

    public void setMessages(List<MessageItem4Tencent> messages) {
        this.messages = messages;
    }

    @Override
    public int getInPutToken() {
        return this.inPutToken;
    }

    @Override
    public void setInPutToken(int inPutToken) {
        this.inPutToken = inPutToken;
    }

    @Override
    public JSONObject getDefaultTypeParam(LlmStyle llmStyle) {
        JSONObject typeParam = new JSONObject(true);
        JSONObject temperatureJson = new JSONObject();
        temperatureJson.put("min", (Object)0);
        temperatureJson.put("max", (Object)2);
        temperatureJson.put("ranger", (Object)3);
        temperatureJson.put("desc", (Object)this.modelParamLang.TEMPERATURE_DESC);
        temperatureJson.put("name", (Object)this.modelParamLang.TEMPERATURE_NAME);
        temperatureJson.put("title", (Object)this.modelParamLang.TEMPERATURE_TITLE);
        JSONObject topPJson = new JSONObject();
        topPJson.put("min", (Object)0);
        topPJson.put("max", (Object)1);
        topPJson.put("ranger", (Object)3);
        topPJson.put("desc", (Object)this.modelParamLang.TOP_P_DESC);
        topPJson.put("name", (Object)this.modelParamLang.TOP_P_NAME);
        topPJson.put("title", (Object)this.modelParamLang.TOP_P_TITLE);
        switch (llmStyle) {
            case CREATIVITY: {
                temperatureJson.put("value", (Object)0.8);
                topPJson.put("value", (Object)1);
                break;
            }
            case BALANCE: {
                temperatureJson.put("value", (Object)0.5);
                topPJson.put("value", (Object)1);
                break;
            }
            case PRECISION: {
                temperatureJson.put("value", (Object)0);
                topPJson.put("value", (Object)1);
            }
        }
        typeParam.put("Temperature", (Object)temperatureJson);
        typeParam.put("TopP", (Object)topPJson);
        typeParam.put("max_tokens", (Object)this.maxTokensKey());
        return typeParam;
    }

    @Override
    protected final void setLlmStyle(LlmStyle llmStyle, String paramJson) {
        if (StringUtils.isNotEmpty((CharSequence)paramJson)) {
            JSONObject paramObj = JSON.parseObject((String)paramJson);
            this.temperature = paramObj.getFloat("Temperature").floatValue();
            this.topP = paramObj.getFloat("TopP").floatValue();
        } else {
            switch (llmStyle) {
                case CREATIVITY: {
                    this.temperature = 0.8f;
                    this.topP = 1.0f;
                    break;
                }
                case BALANCE: {
                    this.temperature = 0.5f;
                    this.topP = 1.0f;
                    break;
                }
                default: {
                    this.temperature = 0.0f;
                    this.topP = 1.0f;
                }
            }
        }
    }
}

