/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.domain.llm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.bos.dataentity.utils.StringUtils;

public class TsingHuaLlmParam
extends LlmParam {
    private List<Float> temperatures;
    private String query;
    private boolean stream = false;

    public TsingHuaLlmParam() {
        this.setLlmStyle(LlmStyle.BALANCE, null);
    }

    public TsingHuaLlmParam(LlmStyle llmStyle, String paramJson) {
        this.setLlmStyle(llmStyle, paramJson);
    }

    public List<Float> getTemperatures() {
        return this.temperatures;
    }

    public void setTemperatures(List<Float> temperatures) {
        this.temperatures = temperatures;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean isStream() {
        return this.stream;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    @Override
    protected final void setLlmStyle(LlmStyle llmStyle, String paramJson) {
        if (StringUtils.isNotEmpty((CharSequence)paramJson)) {
            JSONObject paramObj = JSON.parseObject((String)paramJson);
            this.temperatures.add(paramObj.getFloat("temperature"));
        } else {
            this.temperatures = new ArrayList<Float>();
            switch (llmStyle) {
                case CREATIVITY: {
                    this.temperatures.add(Float.valueOf(0.8f));
                    break;
                }
                case PRECISION: {
                    this.temperatures.add(Float.valueOf(0.01f));
                    break;
                }
                default: {
                    this.temperatures.add(Float.valueOf(0.5f));
                }
            }
        }
    }

    @Override
    public JSONObject getDefaultTypeParam(LlmStyle llmStyle) {
        JSONObject typeParam = new JSONObject(true);
        JSONObject temperatureJson = new JSONObject();
        temperatureJson.put("min", (Object)0);
        temperatureJson.put("max", (Object)1);
        temperatureJson.put("ranger", (Object)3);
        temperatureJson.put("desc", (Object)this.modelParamLang.TEMPERATURE_DESC);
        temperatureJson.put("name", (Object)this.modelParamLang.TEMPERATURE_NAME);
        temperatureJson.put("title", (Object)this.modelParamLang.TEMPERATURE_TITLE);
        switch (llmStyle) {
            case CREATIVITY: {
                temperatureJson.put("value", (Object)0.8);
                break;
            }
            case BALANCE: {
                temperatureJson.put("value", (Object)0.5);
                break;
            }
            case PRECISION: {
                temperatureJson.put("value", (Object)0.01);
            }
        }
        typeParam.put("temperature", (Object)temperatureJson);
        return typeParam;
    }
}

