/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.domain.llm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.MessageItem4AzureBaiduTencentXf;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.trust.annotation.MaskingField;
import kd.bos.dataentity.utils.StringUtils;

public class XunFeiLlmParam
extends LlmParam {
    private Parameter parameter;
    @MaskingField
    private Payload payload;

    public XunFeiLlmParam() {
    }

    public XunFeiLlmParam(LlmStyle llmStyle, String paramJson) {
        this.setLlmStyle(llmStyle, paramJson);
    }

    public void setTemperature(float temperature) {
        ParameterChat chat;
        if (this.parameter == null) {
            this.parameter = new Parameter();
        }
        if ((chat = this.parameter.chat) == null) {
            chat = new ParameterChat();
        }
        chat.setTemperature(temperature);
    }

    public void setMessages(List<MessageItem4AzureBaiduTencentXf> textList) {
        PayloadMessage payloadMessage;
        if (this.payload == null) {
            this.payload = new Payload();
        }
        if ((payloadMessage = this.payload.getMessage()) == null) {
            payloadMessage = new PayloadMessage();
        }
        payloadMessage.setText(textList);
        this.payload.setMessage(payloadMessage);
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public void setParameter(Parameter parameter) {
        this.parameter = parameter;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    @Override
    public final void setLlmStyle(LlmStyle llmStyle, String paramJson) {
        if (StringUtils.isNotEmpty((CharSequence)paramJson)) {
            JSONObject paramObj = JSON.parseObject((String)paramJson);
            this.setTemperature(paramObj.getFloat("temperature").floatValue());
        } else {
            switch (llmStyle) {
                case CREATIVITY: {
                    this.setTemperature(0.8f);
                    break;
                }
                case BALANCE: {
                    this.setTemperature(0.5f);
                    break;
                }
                default: {
                    this.setTemperature(0.01f);
                }
            }
        }
    }

    @Override
    public JSONObject getDefaultTypeParam(LlmStyle llmStyle) {
        JSONObject typeParam = new JSONObject(true);
        JSONObject temperatureJson = new JSONObject();
        temperatureJson.put("min", (Object)0);
        temperatureJson.put("max", (Object)1);
        temperatureJson.put("ranger", (Object)1);
        temperatureJson.put("desc", (Object)this.modelParamLang.TEMPERATURE_DESC);
        temperatureJson.put("name", (Object)this.modelParamLang.TEMPERATURE_NAME);
        temperatureJson.put("title", (Object)this.modelParamLang.TEMPERATURE_TITLE);
        switch (llmStyle) {
            case CREATIVITY: {
                temperatureJson.put("value", (Object)0.8);
                break;
            }
            case BALANCE: {
                temperatureJson.put("value", (Object)0.5);
                break;
            }
            case PRECISION: {
                temperatureJson.put("value", (Object)0.01);
            }
        }
        typeParam.put("temperature", (Object)temperatureJson);
        typeParam.put("max_tokens", (Object)this.maxTokensKey());
        return typeParam;
    }

    public static class PayloadMessage {
        @MaskingField
        private List<MessageItem4AzureBaiduTencentXf> text;

        public List<MessageItem4AzureBaiduTencentXf> getText() {
            return this.text;
        }

        public void setText(List<MessageItem4AzureBaiduTencentXf> text) {
            this.text = text;
        }
    }

    public static class Payload {
        @MaskingField
        private PayloadMessage message;

        public PayloadMessage getMessage() {
            return this.message;
        }

        public void setMessage(PayloadMessage message) {
            this.message = message;
        }
    }

    public static class ParameterChat {
        private String domain = "generalv3";
        private float temperature;

        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public float getTemperature() {
            return this.temperature;
        }

        public void setTemperature(float temperature) {
            this.temperature = temperature;
        }
    }

    public static class Parameter {
        private ParameterChat chat = new ParameterChat();

        public ParameterChat getChat() {
            return this.chat;
        }

        public void setChat(ParameterChat chat) {
            this.chat = chat;
        }
    }
}

