/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.domain.op;

import kd.ai.gai.core.domain.dto.FeedParams;
import kd.ai.gai.core.domain.op.EventParams;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.bos.service.KDDateUtils;
import org.apache.commons.lang3.StringUtils;

public class UserFeedbackEventParams
extends EventParams {
    private SLIDEENV slideenv;
    private String chatTraceId;
    private long traceId;
    private String feedbackType;
    private String contentType;
    private String content;
    private long opTimeTs;
    private String errorMsg;
    private FeedParams feedParams;
    private int opType = EnableEnum.YES.getKey();

    public UserFeedbackEventParams() {
    }

    public UserFeedbackEventParams(SLIDEENV slideenv, FeedParams feedParams) {
        this.slideenv = slideenv;
        this.feedParams = feedParams;
    }

    public UserFeedbackEventParams(SLIDEENV slideenv, String chatTraceId, long traceId, String feedbackType, long opTimeTs) {
        this.slideenv = slideenv;
        this.chatTraceId = chatTraceId;
        this.traceId = traceId;
        this.feedbackType = feedbackType;
        this.opTimeTs = opTimeTs;
    }

    public UserFeedbackEventParams(SLIDEENV slideenv, String chatTraceId, long traceId, String feedbackType, long opTimeTs, String errorMsg) {
        this.slideenv = slideenv;
        this.chatTraceId = chatTraceId;
        this.traceId = traceId;
        this.feedbackType = feedbackType;
        this.opTimeTs = opTimeTs;
        this.errorMsg = errorMsg;
    }

    public UserFeedbackEventParams(SLIDEENV slideenv, String chatTraceId, long traceId, String feedbackType, long opTimeTs, String contentType, String content, int opType) {
        this.slideenv = slideenv;
        this.chatTraceId = chatTraceId;
        this.traceId = traceId;
        this.feedbackType = feedbackType;
        this.opTimeTs = opTimeTs;
        this.contentType = contentType;
        this.content = content;
        this.opType = opType;
    }

    public SLIDEENV getSlideenv() {
        return this.slideenv;
    }

    public void setSlideenv(SLIDEENV slideenv) {
        this.slideenv = slideenv;
    }

    public String getChatTraceId() {
        return this.chatTraceId;
    }

    public void setChatTraceId(String chatTraceId) {
        this.chatTraceId = chatTraceId;
    }

    public long getTraceId() {
        return this.traceId;
    }

    public void setTraceId(long traceId) {
        this.traceId = traceId;
    }

    public String getFeedbackType() {
        return this.feedbackType;
    }

    public void setFeedbackType(String feedbackType) {
        this.feedbackType = feedbackType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public long getOpTimeTs() {
        return this.opTimeTs;
    }

    public void setOpTimeTs(long opTimeTs) {
        if (opTimeTs == 0L) {
            opTimeTs = KDDateUtils.now().getTime();
        }
        this.opTimeTs = opTimeTs;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public FeedParams getFeedParams() {
        return this.feedParams;
    }

    public void setFeedParams(FeedParams feedParams) {
        this.feedParams = feedParams;
    }

    public int getOpType() {
        return this.opType;
    }

    public void setOpType(int opType) {
        this.opType = opType;
    }

    public String convertContentName() {
        if (StringUtils.isBlank((CharSequence)this.contentType)) {
            return null;
        }
        String[] split = this.contentType.split(",");
        StringBuilder b = new StringBuilder();
        for (String s : split) {
            b.append(this.contentType2Name(s)).append(",");
        }
        if (b.length() > 0) {
            b.deleteCharAt(b.length() - 1);
        }
        return b.toString();
    }

    public String contentType2Name(String contentType) {
        for (CONTENT_TYPE contentTypeEnum : CONTENT_TYPE.values()) {
            if (!contentTypeEnum.getValue().equals(contentType)) continue;
            return contentTypeEnum.getName();
        }
        return null;
    }

    public static enum CONTENT_TYPE {
        CONTENT_NOT_ACCURATE("1", "\u5185\u5bb9\u4e0d\u51c6\u786e"),
        ANSWER_NOT_RELATED("2", "\u7b54\u975e\u6240\u95ee"),
        OPERATION_NOT_EASY("3", "\u64cd\u4f5c\u4e0d\u65b9\u4fbf");

        private final String name;
        private final String value;

        private CONTENT_TYPE(String value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }
    }
}

