/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.domain.vo;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.ai.gai.core.domain.dto.GaiInitConfig;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.dto.agent.MessageConfig;
import kd.ai.gai.core.domain.llm.LLMSearchInfo;
import kd.ai.gai.core.domain.vo.ActionVO;
import kd.ai.gai.core.domain.vo.ChatData;
import kd.ai.gai.core.domain.vo.ContextData;
import kd.ai.gai.core.domain.vo.GetChatInfoData;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.message.MsgNodeMessage;
import kd.ai.gai.core.enuz.ForwardType;
import kd.ai.gai.core.enuz.ResultActionType;
import kd.ai.gai.core.service.agent.MessageService;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;

public class ResultVoHelper {
    public static final String ACTION_LIST = "actionList";
    private static final String REQUEST_ID = "requestId";

    public static Map<String, Object> buildInitial(GaiInitConfig gaiInitConfig) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.initial);
        actionVO.setData(gaiInitConfig);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("time", System.currentTimeMillis() + "");
        dataMap.put(ACTION_LIST, Collections.singletonList(actionVO));
        return dataMap;
    }

    public static Map<String, Object> buildPreSaveSkillList() {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.preSaveSkillList);
        actionVO.setData(Collections.emptyList());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        map.put("time", System.currentTimeMillis());
        return map;
    }

    public static Map<String, Object> buildTips(String chatId, String tips) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.chat);
        ChatData chatData = new ChatData();
        chatData.setId(chatId);
        chatData.setStream(false);
        chatData.setMessage(tips);
        actionVO.setData(chatData);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("time", System.currentTimeMillis() + "");
        dataMap.put(ACTION_LIST, Collections.singletonList(actionVO));
        return dataMap;
    }

    public static Map<String, Object> buildChat(boolean stream, String chatId, String taskId, int index, String chatMessage, boolean concat, List<LLMSearchInfo> searchInfo, Context context) {
        return ResultVoHelper.buildChat(stream, chatId, taskId, "0", index, chatMessage, concat, searchInfo, context);
    }

    public static Map<String, Object> buildChat(boolean stream, String chatId, String taskId, String flowId, int index, String chatMessage, boolean concat, List<LLMSearchInfo> searchInfo, Context context) {
        return ResultVoHelper.buildChat(stream, chatId, taskId, flowId, index, ResultActionType.chat, chatMessage, concat, searchInfo, context);
    }

    public static Map<String, Object> buildThinkChat(boolean stream, String chatId, String taskId, int index, String think, boolean concat, List<LLMSearchInfo> searchInfo, Context context) {
        return ResultVoHelper.buildThinkChat(stream, chatId, taskId, "0", index, think, concat, searchInfo, context);
    }

    public static Map<String, Object> buildThinkChat(boolean stream, String chatId, String taskId, String flowId, int index, String chatMessage, boolean concat, List<LLMSearchInfo> searchInfo, Context context) {
        return ResultVoHelper.buildChat(stream, chatId, taskId, flowId, index, ResultActionType.think_chat, chatMessage, concat, searchInfo, context);
    }

    public static Map<String, Object> buildChat(boolean stream, String chatId, String taskId, String flowId, int index, ResultActionType actionType, String chatMessage, boolean concat, List<LLMSearchInfo> searchInfo, Context context) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(actionType);
        ChatData chatData = new ChatData();
        chatData.setMessage(chatMessage);
        chatData.setConcatLast(concat);
        chatData.setId(chatId);
        chatData.setIndex(index);
        chatData.setTaskId(taskId);
        chatData.setFlowId(flowId);
        chatData.setStream(stream);
        chatData.setSearchInfo(searchInfo);
        chatData.setChatTraceId(context != null ? context.getChatTraceId() : null);
        actionVO.setData(chatData);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", System.currentTimeMillis() + "");
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildMultiMsg(String chatSessionId, Boolean replaceLast, List<MsgNodeMessage.MessageElement> messageElementList, String messageId, Context context) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.multiMsg);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", chatSessionId);
        data.put("replaceLast", replaceLast);
        data.put("msgList", messageElementList);
        data.put("time", System.currentTimeMillis() + "");
        data.put("messageId", messageId);
        data.put("chatTraceId", context.getChatTraceId());
        actionVO.setData(data);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildMultiMsg(String chatSessionId, Boolean replaceLast, List<MsgNodeMessage.MessageElement> messageElementList, String messageId, Context context, Action action) {
        Map<String, Object> resultVoMap = ResultVoHelper.buildMultiMsg(chatSessionId, replaceLast, messageElementList, messageId, context);
        List actionList = (List)resultVoMap.get(ACTION_LIST);
        Map data = (Map)((ActionVO)actionList.get(0)).getData();
        data.put("nodeId", action.getId());
        data.put("nodeName", action.getName());
        return resultVoMap;
    }

    public static Map<String, Object> buildAskUserMsg(String chatSessionId, List<MsgNodeMessage.MessageElement> messageElementList, String messageId, MessageConfig messageConfig, boolean allowUserInput, boolean sseAutoClose, Context context) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.multiMsg);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", chatSessionId);
        data.put("config", messageConfig);
        data.put("msgList", messageElementList);
        data.put("time", System.currentTimeMillis() + "");
        data.put("messageId", messageId);
        data.put("allowUserInput", allowUserInput);
        data.put("sseAutoClose", sseAutoClose);
        data.put("chatTraceId", context.getChatTraceId());
        actionVO.setData(data);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildGetChatInfo(String llm, String llmStyle, String promptTemplate) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.getChatInfo);
        GetChatInfoData chatData = new GetChatInfoData(llm, promptTemplate, llmStyle);
        actionVO.setData(chatData);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildGetChatInfo(String llm, String llmStyle, String promptTemplate, boolean configSuccess) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.getChatInfo);
        GetChatInfoData chatData = new GetChatInfoData(llm, promptTemplate, llmStyle, configSuccess);
        actionVO.setData(chatData);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildGetChatInfo(String llm, String llmStyle, String llmCustomStyle, String promptTemplate, boolean configSuccess) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.getChatInfo);
        GetChatInfoData chatData = new GetChatInfoData(llm, promptTemplate, llmStyle, llmCustomStyle, configSuccess);
        actionVO.setData(chatData);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildInjectInfo(Map<String, String> varMap) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.injectInfo);
        actionVO.setData(varMap == null ? new HashMap() : varMap);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", System.currentTimeMillis() + "");
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildForward(String chatSessionId, ForwardType type, String actionKey, String forwardMsgKey) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.forward);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("id", chatSessionId);
        dataMap.put("type", type.toString());
        dataMap.put("actionKey", actionKey);
        dataMap.put("forwardMsgKey", forwardMsgKey);
        actionVO.setData(dataMap);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", System.currentTimeMillis() + "");
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildErrMsg(ErrorCode error, String chatSessionId, Context context) {
        return ResultVoHelper.buildErrMsg(error.getCode(), error.getMessage(), chatSessionId, context);
    }

    public static Map<String, Object> buildErrMsg(String code, String msg, String chatSessionId, Context context) {
        if (code.equals(Errors.STOP_STREAM.getCode())) {
            return ResultVoHelper.buildStopStream(chatSessionId, context);
        }
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.error);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("id", chatSessionId);
        dataMap.put("code", code);
        dataMap.put("desc", msg);
        dataMap.put("time", System.currentTimeMillis() + "");
        dataMap.put("chatTraceId", context != null ? context.getChatTraceId() : null);
        actionVO.setData(dataMap);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildFakeErrMsg(String code, String msg, String chatSessionId) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.fakeOk);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("id", chatSessionId);
        dataMap.put("code", code);
        dataMap.put("desc", msg);
        dataMap.put("time", System.currentTimeMillis() + "");
        actionVO.setData(dataMap);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildWaiting(long flowId, String taskId, String chatSessionId, Context context) {
        Long lngTaskId = StringUtils.isEmpty((CharSequence)taskId) ? null : Long.valueOf(Long.parseLong(taskId));
        Message lastUserMessage = MessageService.getLastUserMessage(chatSessionId, lngTaskId);
        String messageId = lastUserMessage == null ? "0" : String.valueOf(lastUserMessage.getMessageId());
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.waiting);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("id", chatSessionId);
        dataMap.put("flowId", String.valueOf(flowId));
        dataMap.put("taskId", taskId);
        dataMap.put("chatTraceId", context.getChatTraceId());
        dataMap.put("userInputMessageId", messageId);
        actionVO.setData(dataMap);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", System.currentTimeMillis() + "");
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildEndOutput(String chatSessionId, long flowId, Map<String, String> outputDataMap, Context context) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.endOutput);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("id", chatSessionId);
        dataMap.put("flowId", String.valueOf(flowId));
        dataMap.put("output", outputDataMap);
        dataMap.put("chatTraceId", context.getChatTraceId());
        actionVO.setData(dataMap);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", System.currentTimeMillis() + "");
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildWaitingDone(String chatSessionId, Context context) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.waitingDone);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("id", chatSessionId);
        dataMap.put("chatTraceId", context.getChatTraceId());
        actionVO.setData(dataMap);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", System.currentTimeMillis() + "");
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildWaitingDone(String chatSessionId, long flowId, String taskId, Context context) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.waitingDone);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("id", chatSessionId);
        dataMap.put("taskId", taskId);
        dataMap.put("flowId", String.valueOf(flowId));
        dataMap.put("chatTraceId", context.getChatTraceId());
        actionVO.setData(dataMap);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", System.currentTimeMillis() + "");
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildRecommendQuestion(List<Map<String, Object>> questionList, Context context) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.recommendQuestion);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(4);
        dataMap.put("questionList", questionList);
        dataMap.put("chatTraceId", context.getChatTraceId());
        actionVO.setData(dataMap);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", System.currentTimeMillis() + "");
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildStopStream(String chatSessionId, Context context) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.stopStream);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("id", chatSessionId);
        dataMap.put("chatTraceId", context.getChatTraceId());
        actionVO.setData(dataMap);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", System.currentTimeMillis() + "");
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildChangeConfig(GaiInitConfig gaiInitConfig) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.changeConfig);
        actionVO.setData(gaiInitConfig);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", System.currentTimeMillis() + "");
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildStreamDone(final String chatId, final String taskId, final String flowId, String chatMsgJustRecord, final String messageId, final String runId, final Context context) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.streamDone);
        actionVO.setData(new HashMap<String, String>(){
            {
                this.put("id", chatId);
                this.put("taskId", taskId);
                this.put("flowId", flowId);
                this.put("runId", runId);
                this.put("messageId", messageId);
                this.put("chatTraceId", context.getChatTraceId());
            }
        });
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", System.currentTimeMillis() + "");
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildStreamDone(final String chatId, final String taskId, final String flowId, String chatMsgJustRecord, final String messageId, final Context context) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.streamDone);
        actionVO.setData(new HashMap<String, String>(){
            {
                this.put("id", chatId);
                this.put("taskId", taskId);
                this.put("flowId", flowId);
                this.put("messageId", messageId);
                this.put("chatTraceId", context.getChatTraceId());
            }
        });
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", System.currentTimeMillis() + "");
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildStreamStart(final String chatId, final String taskId, final String flowId, final Context context) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.streamStart);
        actionVO.setData(new HashMap<String, String>(){
            {
                this.put("id", chatId);
                this.put("taskId", taskId);
                this.put("flowId", flowId);
                this.put("chatTraceId", context.getChatTraceId());
            }
        });
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", System.currentTimeMillis() + "");
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildProcessList(List<Skill> skillList) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.processList);
        actionVO.setData(skillList);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", System.currentTimeMillis());
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildChatBottom(ContextData contextData, Context context) {
        contextData.setChatTraceId(context.getChatTraceId());
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.chatBottom);
        actionVO.setData(contextData);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", System.currentTimeMillis() + "");
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildUserAgree(GaiInitConfig gaiInitConfig) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.userAgree);
        actionVO.setData(gaiInitConfig);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", System.currentTimeMillis() + "");
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildResult(String resultActionType, Object data, Context context) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.valueOf(resultActionType));
        actionVO.setData(data);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", System.currentTimeMillis() + "");
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        map.put(REQUEST_ID, UUID.randomUUID().toString());
        return map;
    }

    public static Map<String, Object> buildIdentifySkill(String skillId) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(ResultActionType.identifySkill);
        actionVO.setData(skillId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", System.currentTimeMillis() + "");
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        return map;
    }

    public static Map<String, Object> buildCustomCtrlResult(ResultActionType resultActionType, Object data) {
        ActionVO actionVO = new ActionVO();
        actionVO.setType(resultActionType);
        actionVO.setData(data);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", System.currentTimeMillis() + "");
        map.put(ACTION_LIST, Collections.singletonList(actionVO));
        map.put(REQUEST_ID, UUID.randomUUID().toString());
        return map;
    }
}

