/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import kd.ai.gai.core.domain.dto.Assistant;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.bos.context.RequestContext;
import org.apache.commons.lang3.StringUtils;

public class Context
implements Serializable {
    private long userId;
    private String globalSessionId;
    private String chatSessionId;
    private String chatTraceId;
    private String assistantPageId;
    private String callbackUrl;
    private String bizPageId;
    private String rootPageId;
    private Assistant assistant;
    private SLIDEENV slideenv;
    private String clientType = "cosmicPC";
    private List<Skill> skillList;
    private Skill currentSkill;
    private String accountId;
    private String tenantId;
    private String userName;
    private long traceId;
    private Long opUserId;
    private String opUserName;
    private String taskId;
    private long flowId;
    private long time;
    private boolean enableDeepSeek = true;

    public Context() {
    }

    public Context(SLIDEENV slideenv) {
        this.slideenv = slideenv;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public String getGlobalSessionId() {
        return this.globalSessionId;
    }

    public void setGlobalSessionId(String globalSessionId) {
        this.globalSessionId = globalSessionId;
    }

    public String getChatSessionId() {
        return this.chatSessionId;
    }

    public void setChatSessionId(String chatSessionId) {
        this.chatSessionId = chatSessionId;
    }

    public String getAssistantPageId() {
        return this.assistantPageId;
    }

    public void setAssistantPageId(String assistantPageId) {
        this.assistantPageId = assistantPageId;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public SLIDEENV getSlideenv() {
        return this.slideenv;
    }

    public void setSlideenv(SLIDEENV slideenv) {
        this.slideenv = slideenv;
    }

    public String getBizPageId() {
        return this.bizPageId;
    }

    public void setBizPageId(String bizPageId) {
        this.bizPageId = bizPageId;
    }

    public Assistant getAssistant() {
        return this.assistant;
    }

    public void setAssistant(Assistant assistant) {
        this.assistant = assistant;
    }

    public List<Skill> getSkillList() {
        return this.skillList;
    }

    public void setSkillList(List<Skill> skillList) {
        this.skillList = skillList;
    }

    public String getRootPageId() {
        return this.rootPageId;
    }

    public void setRootPageId(String rootPageId) {
        this.rootPageId = rootPageId;
    }

    public String getChatTraceId() {
        return this.chatTraceId;
    }

    public void setChatTraceId(String chatTraceId) {
        this.chatTraceId = chatTraceId;
    }

    public Skill getCurrentSkill() {
        return this.currentSkill;
    }

    public void setCurrentSkill(Skill currentSkill) {
        this.currentSkill = currentSkill;
    }

    public static Context create(SLIDEENV slideenv, Assistant assistant, String callbackUrl) {
        RequestContext rc = RequestContext.get();
        Context context = new Context(slideenv);
        String chatSessionId = UUID.randomUUID().toString().replace("-", "");
        context.setChatSessionId(chatSessionId);
        context.setGlobalSessionId(rc.getGlobalSessionId());
        context.setUserId(rc.getCurrUserId());
        context.setUserName(rc.getUserName());
        context.setAccountId(rc.getAccountId());
        context.setTenantId(rc.getTenantId());
        context.setChatTraceId(rc.getTraceId());
        context.setCallbackUrl(callbackUrl);
        if (assistant != null) {
            context.setAssistant(assistant);
        }
        FlowCacheData.putContext(chatSessionId, context);
        return context;
    }

    public static Context create(SLIDEENV slideenv, long assistantId, String rootPageId, String assistantPageId, String bizPageId, List<Skill> processData) {
        RequestContext rc = RequestContext.get();
        Context context = new Context(slideenv);
        String chatSessionId = UUID.randomUUID().toString().replace("-", "");
        context.setChatSessionId(chatSessionId);
        context.setGlobalSessionId(rc.getGlobalSessionId());
        context.setUserId(rc.getCurrUserId());
        context.setUserName(rc.getUserName());
        context.setAccountId(rc.getAccountId());
        context.setTenantId(rc.getTenantId());
        context.setChatTraceId(rc.getTraceId());
        Assistant assistant = new Assistant();
        assistant.setId(assistantId);
        context.setAssistant(assistant);
        context.setRootPageId(rootPageId);
        context.setAssistantPageId(assistantPageId);
        context.setBizPageId(bizPageId);
        context.setSkillList(processData);
        FlowCacheData.putContext(chatSessionId, context);
        return context;
    }

    public static Context create(SLIDEENV slideenv, String chatSessionId, String rootPageId, long assistantId, String assistantPageId, String bizPageId, List<Skill> processData) {
        RequestContext rc = RequestContext.get();
        Context context = new Context(slideenv);
        context.setChatSessionId(chatSessionId);
        context.setGlobalSessionId(rc.getGlobalSessionId());
        context.setUserId(rc.getCurrUserId());
        context.setUserName(rc.getUserName());
        context.setAccountId(rc.getAccountId());
        context.setTenantId(rc.getTenantId());
        context.setChatTraceId(rc.getTraceId());
        Assistant assistant = new Assistant();
        assistant.setId(assistantId);
        context.setRootPageId(rootPageId);
        context.setAssistant(assistant);
        context.setAssistantPageId(assistantPageId);
        context.setBizPageId(bizPageId);
        context.setSkillList(processData);
        FlowCacheData.putContext(chatSessionId, context);
        return context;
    }

    public static Context create(SLIDEENV slideenv, Assistant assistant, String rootPageId, String assistantPageId, String bizPageId, List<Skill> processData, String chatSessionId) {
        RequestContext rc = RequestContext.get();
        Context context = new Context(slideenv);
        if (StringUtils.isEmpty((CharSequence)chatSessionId)) {
            chatSessionId = UUID.randomUUID().toString().replace("-", "");
        }
        context.setChatSessionId(chatSessionId);
        context.setGlobalSessionId(RequestContext.get().getGlobalSessionId());
        context.setUserId(RequestContext.get().getCurrUserId());
        context.setUserName(rc.getUserName());
        context.setAccountId(rc.getAccountId());
        context.setTenantId(rc.getTenantId());
        context.setChatTraceId(rc.getTraceId());
        context.setAssistant(assistant);
        context.setAssistantPageId(assistantPageId);
        context.setRootPageId(rootPageId);
        context.setBizPageId(bizPageId);
        context.setSkillList(processData);
        FlowCacheData.putContext(chatSessionId, context);
        return context;
    }

    public static Context create4API() {
        RequestContext rc = RequestContext.get();
        Context context = new Context(SLIDEENV.API_MSERVICE);
        String chatSessionId = UUID.randomUUID().toString().replace("-", "");
        context.setChatSessionId(chatSessionId);
        context.setGlobalSessionId(RequestContext.get().getGlobalSessionId());
        context.setUserId(RequestContext.get().getCurrUserId());
        context.setUserName(rc.getUserName());
        context.setAccountId(rc.getAccountId());
        context.setTenantId(rc.getTenantId());
        context.setChatTraceId(rc.getTraceId());
        context.setAssistant(new Assistant());
        FlowCacheData.putContext(chatSessionId, context);
        return context;
    }

    public static boolean needCheckLicense(Context context) {
        return context.getSlideenv() != SLIDEENV.PLAYGROUND && context.getSlideenv() != SLIDEENV.ASSISTANT && context.getSlideenv() != SLIDEENV.AGENT;
    }

    public EnableEnum messageIsEnable() {
        return this.slideenv == SLIDEENV.MAIN || this.slideenv == SLIDEENV.H5 || this.slideenv == SLIDEENV.HTTP_API ? EnableEnum.YES : EnableEnum.NO;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public long getTraceId() {
        return this.traceId;
    }

    public void setTraceId(long traceId) {
        this.traceId = traceId;
    }

    public Long getOpUserId() {
        return this.opUserId;
    }

    public void setOpUserId(Long opUserId) {
        this.opUserId = opUserId;
    }

    public String getOpUserName() {
        return this.opUserName;
    }

    public void setOpUserName(String opUserName) {
        this.opUserName = opUserName;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public long getFlowId() {
        return this.flowId;
    }

    public boolean isEnableDeepSeek() {
        return this.enableDeepSeek;
    }

    public void setEnableDeepSeek(boolean enableDeepSeek) {
        this.enableDeepSeek = enableDeepSeek;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public Context putTask(long flowId, String taskId) {
        this.taskId = taskId;
        this.flowId = flowId;
        return this;
    }

    public String getClientType() {
        return this.clientType;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }
}

