/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kd.ai.gai.core.engine.Errors;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;

public class EngineCache {
    private static final Map<String, LocalMemoryCache> cacheMap = new ConcurrentHashMap<String, LocalMemoryCache>();
    private static final int MAX_KEY_LENGTH = 4;
    private static final String region = UUID.randomUUID().toString();

    private EngineCache() {
    }

    public static IAppCache getAppCache(String chatSessionId) {
        if (Objects.isNull(chatSessionId)) {
            throw new KDBizException(Errors.APPCACHE_KEY_ISNULL, new Object[0]);
        }
        return AppCache.get((String)("gai-" + chatSessionId));
    }

    public static LocalMemoryCache getLocalCache(String key) {
        if (Objects.isNull(key)) {
            throw new KDBizException(Errors.APPCACHE_KEY_ISNULL, new Object[0]);
        }
        LocalMemoryCache localMemoryCache = cacheMap.get(key);
        if (localMemoryCache == null) {
            CacheConfigInfo cacheConfigInfo = new CacheConfigInfo();
            cacheConfigInfo.setMaxItemSize(30000);
            cacheConfigInfo.setTimeout(300);
            String type = CacheKeyUtil.getAcctId() + '.' + key + "_localcache_";
            localMemoryCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(region, type, cacheConfigInfo);
            cacheMap.put(key, localMemoryCache);
        }
        return localMemoryCache;
    }

    public static IAppCache getAppCache4UserSession(String userSessionId) {
        if (Objects.nonNull(userSessionId)) {
            int length = userSessionId.length();
            if (length > 4) {
                userSessionId = userSessionId.substring(0, 4);
            }
        } else {
            throw new KDBizException(Errors.APPCACHE_KEY_ISNULL, new Object[0]);
        }
        return AppCache.get((String)("gai-u-" + userSessionId));
    }

    public static IAppCache getAppCacheForFile() {
        return AppCache.get((String)"gai-file");
    }
}

