/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import kd.ai.gai.core.domain.dto.Process;
import kd.ai.gai.core.engine.ChatSessionService;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.Message;
import kd.ai.gai.core.engine.RootPageIdContext;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.json.FlowRuntimeParserConfig;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.service.ProcessService;
import kd.ai.gai.core.trace.entity.FlowNodeLog;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.flow.flow.core.FlowRuntime;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.context.RequestContextThreadBinder;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;

public class FlowCacheData {
    public static final Log log = LogFactory.getLog(FlowCacheData.class);
    private static final FlowRuntimeParserConfig FLOW_RUNTIME_PARSER_CONFIG = new FlowRuntimeParserConfig();

    private FlowCacheData() {
    }

    private static void initParserConfig() {
        Reflections reflections = new Reflections("kd.ai.gai.core.engine.message", new Scanner[]{new SubTypesScanner()});
        Set messageTypes = reflections.getSubTypesOf(Message.class);
        messageTypes.forEach(messageType -> FLOW_RUNTIME_PARSER_CONFIG.addAccept(messageType.getName()));
        FLOW_RUNTIME_PARSER_CONFIG.addAccept(FlowNodeLog.class.getName());
    }

    public static Flow createFlow(String chatSessionId, long processId) {
        return FlowCacheData.createFlow(chatSessionId, processId, null);
    }

    public static Flow createFlow(String chatSessionId, long processId, Consumer<Flow> beforeCacheAction) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        LocalMemoryCache localMemoryCache = EngineCache.getLocalCache(chatSessionId);
        Process process = ProcessService.getProcessById(processId);
        if (process == null) {
            throw new KDBizException(Errors.flowNotExistedError(String.valueOf(processId)), new Object[0]);
        }
        String flowBase64Str = process.getFlow();
        if (StringUtils.isEmpty((String)flowBase64Str)) {
            throw new KDBizException(Errors.flowNotDataError(String.valueOf(processId)), new Object[0]);
        }
        Flow flow = JsonUtil.fromBase64String(flowBase64Str);
        long flowId = DB.genLongId((String)"t_gai_process");
        flow.setId(flowId);
        flow.setDefId(processId);
        flow.setNumber(process.getNumber());
        flow.setName(process.getName());
        if (beforeCacheAction != null) {
            beforeCacheAction.accept((Object)flow);
        }
        log.info("\u5b9e\u4f8b\u5316\u6d41\u7a0b{}-{}, \u6d41\u7a0b\u5b9e\u4f8bID{}", new Object[]{chatSessionId, processId, flowId});
        flowBase64Str = JsonUtil.toBase64String(flow);
        String key = FlowCacheData.buildFlowInstanceIdKey(flowId);
        appCache.put(key, (Object)flowBase64Str);
        localMemoryCache.put(key, (Object)flowBase64Str);
        String resultKey = String.format("%s_%s", chatSessionId, processId);
        FlowCacheData.clearCache(chatSessionId, resultKey);
        return flow;
    }

    public static Flow getFlowById(String chatSessionId, long flowId) {
        String flowBase64Str;
        String key;
        LocalMemoryCache localMemoryCache = EngineCache.getLocalCache(chatSessionId);
        if (localMemoryCache.contains(key = FlowCacheData.buildFlowInstanceIdKey(flowId))) {
            flowBase64Str = (String)localMemoryCache.get(key);
        } else {
            IAppCache appCache = EngineCache.getAppCache(chatSessionId);
            flowBase64Str = (String)appCache.get(key, String.class);
            if (StringUtils.isNotEmpty((String)flowBase64Str)) {
                localMemoryCache.put(key, (Object)flowBase64Str);
            }
        }
        if (StringUtils.isNotEmpty((String)flowBase64Str)) {
            return JsonUtil.fromBase64String(flowBase64Str);
        }
        return null;
    }

    public static void clearFlow(String chatSessionId, long flowId) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        String key = FlowCacheData.buildFlowInstanceIdKey(flowId);
        appCache.remove(key);
        LocalMemoryCache localMemoryCache = EngineCache.getLocalCache(chatSessionId);
        localMemoryCache.remove(new String[]{key});
    }

    public static String buildFlowInstanceIdKey(long flowId) {
        return "F_IT_" + flowId;
    }

    public static Map<String, String> getFlowNodeData(String chatSessionId, long flowId, int nodeId) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        Map data = (Map)appCache.get(FlowCacheData.flowNodeKey(flowId, nodeId), Map.class);
        if (data != null) {
            return data;
        }
        return Collections.emptyMap();
    }

    public static void setFlowNodeData(String chatSessionId, long flowId, int nodeId, Map<String, String> data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        appCache.put(FlowCacheData.flowNodeKey(flowId, nodeId), data);
    }

    public static void clearFlowNodeData(String chatSessionId, long flowId, int nodeId) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        appCache.remove(FlowCacheData.flowNodeKey(flowId, nodeId));
    }

    private static String flowNodeKey(long flowId, int nodeId) {
        return String.format("ND-%s-%s", flowId, nodeId);
    }

    public static void putContext(String chatSessionId, Context context) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        appCache.put("CTX-" + chatSessionId, (Object)context);
        if (StringUtils.isEmpty((String)((String)appCache.get("RC-" + chatSessionId, String.class)))) {
            appCache.put("RC-" + chatSessionId, (Object)SerializationUtils.serializeToBase64((Object)RequestContext.get()));
        }
    }

    public static Context getContext(String chatSessionId) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        Context context = (Context)appCache.get("CTX-" + chatSessionId, Context.class);
        if (context != null) {
            return context;
        }
        Context chatContext = ChatSessionService.getChatContext(chatSessionId);
        if (chatContext != null) {
            FlowCacheData.putContext(chatSessionId, chatContext);
            return chatContext;
        }
        log.error("Context error\uff0cchatSessionId:{}", (Object)chatSessionId);
        return new Context();
    }

    public static void restoreRequestContext(String chatSessionId) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        try {
            String rcBase64 = (String)appCache.get("RC-" + chatSessionId, String.class);
            if (rcBase64 != null) {
                RequestContext rc = (RequestContext)SerializationUtils.deSerializeFromBase64((String)rcBase64);
                String curTraceId = RequestContext.get().getTraceId();
                RequestContextCreator.restoreForThreadPool((RequestContext)rc);
                RequestContext.get().setTraceId(curTraceId);
                RequestContextThreadBinder.bind((RequestContext)RequestContext.get());
            }
        }
        catch (Exception e) {
            appCache.remove("RC-" + chatSessionId);
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static RootPageIdContext getContextByRootPageId(String rootPageId) {
        IAppCache appCache = EngineCache.getAppCache(rootPageId);
        return (RootPageIdContext)appCache.get("RootPageId-" + rootPageId, RootPageIdContext.class);
    }

    public static void putRootPageId2ChatSessionId(String rootPageId, RootPageIdContext rootPageIdContext) {
        IAppCache appCache = EngineCache.getAppCache(rootPageId);
        appCache.put("RootPageId-" + rootPageId, (Object)rootPageIdContext);
    }

    public static void putCache(String chatSessionId, String key, String value) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        appCache.put(key, (Object)value);
    }

    public static String getCache(String chatSessionId, String key) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        return (String)appCache.get(key, String.class);
    }

    public static void clearCache(String chatSessionId, String key) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        appCache.remove(key);
    }

    public static String getAndRemoveCache(String chatSessionId, String key) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        String val = (String)appCache.get(key, String.class);
        if (val != null) {
            appCache.remove(key);
        }
        return val;
    }

    public static void putRuntimeDoc(String chatSessionId, long flowId, FlowRuntime runtime) {
        FlowCacheData.putCache(chatSessionId, String.format("%s_%s", flowId, "FLOW_RUNTIME_DOC"), JSON.toJSONString((Object)runtime.toJson(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}));
    }

    public static FlowRuntime getRuntime(String chatSessionId, long flowId) {
        String runtimeJson = FlowCacheData.getCache(chatSessionId, String.format("%s_%s", flowId, "FLOW_RUNTIME_DOC"));
        if (StringUtils.isNotEmpty((String)runtimeJson)) {
            Context context = FlowCacheData.getContext(chatSessionId);
            Flow gaiFlow = FlowCacheData.getFlowById(chatSessionId, flowId);
            kd.ai.gai.flow.flow.core.Flow flow = FlowUtils.buildFlow(context, gaiFlow);
            Map runtimeDoc = (Map)JSON.parseObject((String)runtimeJson, Map.class, (ParserConfig)FLOW_RUNTIME_PARSER_CONFIG, (Feature[])new Feature[0]);
            return flow.fromJson(runtimeDoc);
        }
        return null;
    }

    static {
        FlowCacheData.initParserConfig();
    }
}

