/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine;

import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.engine.ActionCallbackMessage;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.IActionCallBack;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Message;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.agent.AgentCallBackMessage;
import kd.ai.gai.core.engine.agent.AgentHandler;
import kd.ai.gai.core.engine.agent.AgentMessage;
import kd.ai.gai.core.engine.handler.APILLMHandler;
import kd.ai.gai.core.engine.handler.AskUserHandler;
import kd.ai.gai.core.engine.handler.ChatHandler;
import kd.ai.gai.core.engine.handler.ConfirmHandler;
import kd.ai.gai.core.engine.handler.EndFlowHandler;
import kd.ai.gai.core.engine.handler.FlowErrorHandler;
import kd.ai.gai.core.engine.handler.FlowNextHandler;
import kd.ai.gai.core.engine.handler.JavaActionHandler;
import kd.ai.gai.core.engine.handler.LLMActionHandler;
import kd.ai.gai.core.engine.handler.LLMHandler;
import kd.ai.gai.core.engine.handler.MessageHandler;
import kd.ai.gai.core.engine.handler.MessageSplitHandler;
import kd.ai.gai.core.engine.handler.MserviceLLMHandler;
import kd.ai.gai.core.engine.handler.PromptTestHandler;
import kd.ai.gai.core.engine.handler.RepoHandler;
import kd.ai.gai.core.engine.handler.RepoReplyHandler;
import kd.ai.gai.core.engine.handler.StartFlowHandler;
import kd.ai.gai.core.engine.handler.StopStreamHandler;
import kd.ai.gai.core.engine.handler.UndoHandler;
import kd.ai.gai.core.engine.message.APILLMMessage;
import kd.ai.gai.core.engine.message.AskUserCallbackMessage;
import kd.ai.gai.core.engine.message.AskUserMessage;
import kd.ai.gai.core.engine.message.ChatMessage;
import kd.ai.gai.core.engine.message.ConfirmCallbackMessage;
import kd.ai.gai.core.engine.message.ConfirmMessage;
import kd.ai.gai.core.engine.message.EndFlowMessage;
import kd.ai.gai.core.engine.message.FlowErrorMessage;
import kd.ai.gai.core.engine.message.FlowNextMessage;
import kd.ai.gai.core.engine.message.ForwardMessage;
import kd.ai.gai.core.engine.message.JavaActionMessage;
import kd.ai.gai.core.engine.message.LLMActionMessage;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.engine.message.MsgNodeMessage;
import kd.ai.gai.core.engine.message.RepoCallbackMessage;
import kd.ai.gai.core.engine.message.RepoMessage;
import kd.ai.gai.core.engine.message.RepoReplyCallbackMessage;
import kd.ai.gai.core.engine.message.RepoReplyMessage;
import kd.ai.gai.core.engine.message.StartFlowMessage;
import kd.ai.gai.core.engine.message.StopStreamMessage;
import kd.ai.gai.core.engine.message.UndoCallbackMessage;
import kd.ai.gai.core.engine.message.UndoMessage;
import kd.ai.gai.core.engine.message.llmcallback.APICallbackMessage;
import kd.ai.gai.core.engine.message.llmcallback.ChatCallbackMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMActionCallbackMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMRawMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMSplitMessage;
import kd.ai.gai.core.engine.message.llmcallback.MserviceLLMCallbackMessage;
import kd.ai.gai.core.engine.message.llmcallback.PromptTestCallbackMessage;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class HandlerFactory {
    private static final Log log = LogFactory.getLog(HandlerFactory.class);
    private static final Map<Class<? extends Message>, Class<? extends IMessageHandler<? extends Message>>> messageHandlerTypeMap = new HashMap<Class<? extends Message>, Class<? extends IMessageHandler<? extends Message>>>();
    private static final Map<Class<? extends ActionCallbackMessage>, Class<? extends IActionCallBack<? extends ActionCallbackMessage>>> messageCallbackTypeMap;

    private HandlerFactory() {
    }

    public static <T extends IMessageHandler<? extends Message>> void registerHandler(Class<? extends Message> messageType, Class<T> handlerType) {
        messageHandlerTypeMap.put(messageType, handlerType);
    }

    public static <T extends IActionCallBack<? extends ActionCallbackMessage>> void registerCallbackHandler(Class<? extends ActionCallbackMessage> messageType, Class<T> callbackType) {
        messageCallbackTypeMap.put(messageType, callbackType);
    }

    public static <T extends IMessageHandler<? extends Message>> T getHandler(Class<? extends Message> messageType) {
        Class<? extends IMessageHandler<? extends Message>> handlerType = messageHandlerTypeMap.get(messageType);
        if (handlerType == null) {
            throw new KDBizException(Errors.handlerNotExistedError(messageType.getName()), new Object[0]);
        }
        try {
            return (T)handlerType.newInstance();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(Errors.instanceHandlerError(e.getMessage()), new Object[0]);
        }
    }

    public static <T extends IActionCallBack<? extends ActionCallbackMessage>> T getHandlerCallback(Class<? extends ActionCallbackMessage> messageType) {
        Class<? extends IActionCallBack<? extends ActionCallbackMessage>> handlerType = messageCallbackTypeMap.get(messageType);
        if (handlerType == null) {
            throw new KDBizException(Errors.handlerNotExistedError(messageType.getName()), new Object[0]);
        }
        try {
            return (T)handlerType.newInstance();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(Errors.instanceHandlerError(e.getMessage()), new Object[0]);
        }
    }

    public static <T extends Message> Result runHandler(Context context, T message) {
        T handler = HandlerFactory.getHandler(message.getClass());
        return handler.process(context, message);
    }

    public static <T extends ActionCallbackMessage> void callback(T message) {
        T handlerCallback = HandlerFactory.getHandlerCallback(message.getClass());
        handlerCallback.callback(message);
    }

    public static void unRegister(Class<? extends Message> messageType) {
        log.warn("un register handler message: {}", messageType);
        messageHandlerTypeMap.remove(messageType);
    }

    public static void unRegisterCallback(Class<? extends ActionCallbackMessage> messageType) {
        log.warn("un register callback handler message : {}", messageType);
        messageCallbackTypeMap.remove(messageType);
    }

    static {
        messageHandlerTypeMap.put(ChatMessage.class, ChatHandler.class);
        messageHandlerTypeMap.put(ConfirmMessage.class, ConfirmHandler.class);
        messageHandlerTypeMap.put(EndFlowMessage.class, EndFlowHandler.class);
        messageHandlerTypeMap.put(FlowNextMessage.class, FlowNextHandler.class);
        messageHandlerTypeMap.put(JavaActionMessage.class, JavaActionHandler.class);
        messageHandlerTypeMap.put(LLMActionMessage.class, LLMActionHandler.class);
        messageHandlerTypeMap.put(LLMMessage.class, LLMHandler.class);
        messageHandlerTypeMap.put(StartFlowMessage.class, StartFlowHandler.class);
        messageHandlerTypeMap.put(UndoMessage.class, UndoHandler.class);
        messageHandlerTypeMap.put(FlowErrorMessage.class, FlowErrorHandler.class);
        messageHandlerTypeMap.put(StopStreamMessage.class, StopStreamHandler.class);
        messageHandlerTypeMap.put(MsgNodeMessage.class, MessageHandler.class);
        messageHandlerTypeMap.put(APILLMMessage.class, APILLMHandler.class);
        messageHandlerTypeMap.put(AskUserMessage.class, AskUserHandler.class);
        messageHandlerTypeMap.put(AgentMessage.class, AgentHandler.class);
        messageHandlerTypeMap.put(RepoMessage.class, RepoHandler.class);
        messageHandlerTypeMap.put(RepoReplyMessage.class, RepoReplyHandler.class);
        messageCallbackTypeMap = new HashMap<Class<? extends ActionCallbackMessage>, Class<? extends IActionCallBack<? extends ActionCallbackMessage>>>();
        messageCallbackTypeMap.put(LLMSplitMessage.class, MessageSplitHandler.class);
        messageCallbackTypeMap.put(LLMRawMessage.class, LLMHandler.class);
        messageCallbackTypeMap.put(ChatCallbackMessage.class, ChatHandler.class);
        messageCallbackTypeMap.put(ConfirmCallbackMessage.class, ConfirmHandler.class);
        messageCallbackTypeMap.put(ForwardMessage.class, JavaActionHandler.class);
        messageCallbackTypeMap.put(LLMActionCallbackMessage.class, LLMActionHandler.class);
        messageCallbackTypeMap.put(MserviceLLMCallbackMessage.class, MserviceLLMHandler.class);
        messageCallbackTypeMap.put(UndoCallbackMessage.class, UndoHandler.class);
        messageCallbackTypeMap.put(PromptTestCallbackMessage.class, PromptTestHandler.class);
        messageCallbackTypeMap.put(APICallbackMessage.class, APILLMHandler.class);
        messageCallbackTypeMap.put(AskUserCallbackMessage.class, AskUserHandler.class);
        messageCallbackTypeMap.put(AgentCallBackMessage.class, AgentHandler.class);
        messageCallbackTypeMap.put(RepoCallbackMessage.class, RepoHandler.class);
        messageCallbackTypeMap.put(RepoReplyCallbackMessage.class, RepoReplyHandler.class);
    }
}

