/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.agent;

import java.util.Map;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.domain.dto.agent.Agent;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.IActionCallBack;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.agent.AgentCallBackMessage;
import kd.ai.gai.core.engine.agent.AgentMessage;
import kd.ai.gai.core.engine.agent.Planner;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.FlowErrorMessage;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class AgentHandler
implements IMessageHandler<AgentMessage>,
IActionCallBack<AgentCallBackMessage> {
    private static final Log log = LogFactory.getLog(AgentHandler.class);

    private void sendError(Context context, ErrorCode errorCode) {
        log.error("code: {} message: {}", (Object)errorCode.getCode(), (Object)errorCode.getMessage());
        PushMsgService.pushErrMsg(context, errorCode.getCode(), errorCode.getMessage());
    }

    @Override
    public Result process(Context context, AgentMessage message) {
        if (message.getRunId() == null) {
            message.setRunId(String.valueOf(ID.genLongId()));
        }
        try {
            Agent agent = message.getAgent();
            if (agent.getToolList() == null && agent.getPromptList() == null && agent.getProcessList() == null) {
                agent.setRoleMode("Rag");
                message.setStream(true);
            }
            Planner planner = Planner.getInstance(agent.getRoleMode());
            Map<String, String> paramMap = planner.getPromptParam(message);
            Prompt prompt = planner.buildPrompt(context, message);
            AgentCallBackMessage callbackMessage = new AgentCallBackMessage();
            callbackMessage.setParseOutput(false);
            callbackMessage.setChatSessionId(context.getChatSessionId());
            callbackMessage.setFlowId(message.getFlowId());
            callbackMessage.setNodeId(message.getNodeId());
            callbackMessage.setAgentMessage(message);
            LLMMessage llmMessage = new LLMMessage();
            llmMessage.setCallbackMessage(callbackMessage);
            llmMessage.setPrompt(prompt);
            llmMessage.setParamMap(paramMap);
            llmMessage.setStream(message.isStream());
            llmMessage.setUserInput(message.getUserInput());
            Result result = HandlerFactory.runHandler(context, llmMessage);
            if (!result.getErrorCode().equals((Object)Errors.OK)) {
                return AgentHandler.flowError(context, 0L, result.getErrorCode());
            }
            Map<String, String> data = result.getData();
            if (data != null) {
                data.put("runId", message.getRunId());
            }
            result.setData(data);
            result.setCallback(true);
            return result;
        }
        catch (Exception exp) {
            log.error(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6d88\u606f{%s}\u53d1\u751f\u5f02\u5e38", (String)"GaiAgentReact_16", (String)"ai-gai-core", (Object[])new Object[0]), JsonUtil.toJson(message)), (Throwable)exp);
            ErrorCode errorCode = AgentHandler.getErrorCode(exp);
            return AgentHandler.flowError(context, 0L, errorCode);
        }
    }

    public static Result flowError(Context context, long flowId, ErrorCode errorCode) {
        FlowErrorMessage flowErrorMessage = new FlowErrorMessage();
        flowErrorMessage.setFlowId(flowId);
        flowErrorMessage.setErrorCode(errorCode);
        flowErrorMessage.setMsg(errorCode.getMessage());
        log.info("flow error {}", (Object)JsonUtil.toJson(flowErrorMessage));
        return HandlerFactory.runHandler(context, flowErrorMessage);
    }

    public static ErrorCode getErrorCode(Exception exp) {
        ErrorCode errorCode = null;
        if (exp instanceof KDBizException) {
            errorCode = ((KDBizException)((Object)exp)).getErrorCode();
        }
        if (errorCode == null || kd.bos.util.StringUtils.isEmpty((String)errorCode.getCode())) {
            errorCode = Errors.internalError(exp.getMessage());
        }
        return errorCode;
    }

    @Override
    public void callback(AgentCallBackMessage callbackMessage) {
        String chatSessionId = callbackMessage.getChatSessionId();
        Context context = FlowCacheData.getContext(chatSessionId);
        String errCode = callbackMessage.getErrCode();
        if (!Errors.OK.getCode().equals(errCode)) {
            errCode = StringUtils.isEmpty((CharSequence)errCode) ? Errors.LLM_ERROR.getCode() : errCode;
            log.error("\u56de\u8c03\u9519\u8bef", (Object)callbackMessage);
            FlowErrorMessage message = new FlowErrorMessage();
            message.setErrorCode(new ErrorCode(errCode, callbackMessage.getErrMsg()));
            message.setFlowId(callbackMessage.getFlowId());
            message.setChatSessionId(callbackMessage.getChatSessionId());
            HandlerFactory.runHandler(FlowCacheData.getContext(callbackMessage.getChatSessionId()), message);
            TraceUtil.saveAsyncLLMLog(context, callbackMessage);
            return;
        }
        try {
            AgentMessage agentMessage = callbackMessage.getAgentMessage();
            Agent agent = agentMessage.getAgent();
            Planner planner = Planner.getInstance(agent.getRoleMode());
            Result result = planner.callback(context, callbackMessage);
        }
        catch (Exception e) {
            log.error(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6d88\u606f{%s}\u53d1\u751f\u5f02\u5e38", (String)"GaiAgentReact_16", (String)"ai-gai-core", (Object[])new Object[0]), JsonUtil.toJson(callbackMessage)), (Throwable)e);
            ErrorCode errorCode = AgentHandler.getErrorCode(e);
            AgentHandler.flowError(context, 0L, errorCode);
        }
    }
}

