/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.agent;

import java.util.Map;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.agent.AgentCallBackMessage;
import kd.ai.gai.core.engine.agent.AgentMessage;
import kd.ai.gai.core.engine.agent.plan.ExecutingPlanner;
import kd.ai.gai.core.engine.agent.plan.ExpressingPlanner;
import kd.ai.gai.core.engine.agent.plan.FunctionCallPlanner;
import kd.ai.gai.core.engine.agent.plan.PlanningPlanner;
import kd.ai.gai.core.engine.agent.plan.RagPlanner;
import kd.ai.gai.core.engine.agent.plan.ReActPlanner;
import kd.ai.gai.core.engine.agent.plan.ReviewingPlanner;
import kd.bos.exception.KDBizException;

public interface Planner {
    public static Planner getInstance(String planner) {
        switch (planner) {
            case "planning": {
                return new PlanningPlanner();
            }
            case "executing": {
                return new ExecutingPlanner();
            }
            case "expressing": {
                return new ExpressingPlanner();
            }
            case "reviewing": {
                return new ReviewingPlanner();
            }
            case "react": {
                return new ReActPlanner();
            }
            case "functioncall": {
                return new FunctionCallPlanner();
            }
            case "Rag": {
                return new RagPlanner();
            }
        }
        throw new KDBizException(Errors.plannerNotExisted(planner), new Object[0]);
    }

    public Prompt buildPrompt(Context var1, AgentMessage var2);

    public Map<String, String> getPromptParam(AgentMessage var1);

    public Result callback(Context var1, AgentCallBackMessage var2);
}

