/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.agent.parser;

import com.alibaba.fastjson.JSONObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.ai.gai.core.engine.agent.AgentParser;
import kd.ai.gai.core.engine.agent.AgentResult;
import kd.ai.gai.core.engine.agent.result.AgentAction;
import kd.ai.gai.core.engine.agent.result.AgentFinish;
import kd.ai.gai.core.util.StrUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ReActJsonOutputParser
implements AgentParser {
    private static final Log log = LogFactory.getLog(ReActJsonOutputParser.class);
    public static final String THOUGHT = "Thought";
    public static final String ACTION = "Action";
    public static final String ActionInput = "Action_input";
    public static final String FinalAnswer = "Final_answer";

    @Override
    public AgentResult parse(String text) {
        AgentResult agentResult;
        block9: {
            agentResult = null;
            log.info("llm generation value:{}", (Object)text);
            String regex = "```json.*?\\s+(.*?)```";
            String thoughtRegex = "<think>(.*?)</think>";
            Pattern thoughtPattern = Pattern.compile(thoughtRegex, 32);
            Matcher thoughtMatcher = thoughtPattern.matcher(text);
            Pattern pattern = Pattern.compile(regex, 32);
            Matcher matcher = pattern.matcher(text);
            String thought = null;
            try {
                if (matcher.find()) {
                    text = matcher.group(1);
                }
                if (thoughtMatcher.find()) {
                    thought = thoughtMatcher.group(1);
                }
                text = text.replace("'''", "").replace("```", "");
                int begin = text.indexOf("{");
                int end = text.lastIndexOf("}");
                if (begin < 0 || end < 0) {
                    return new AgentFinish(text, text);
                }
                log.info("parse object text:{}", (Object)text);
                if (StrUtils.isValidJson(text)) {
                    JSONObject jsonObject = JSONObject.parseObject((String)text);
                    if (jsonObject.getString(ACTION) != null && jsonObject.getString(ACTION).length() > 0) {
                        String action = jsonObject.getString(ACTION);
                        String actionInput = jsonObject.getString(ActionInput);
                        if (thought == null && (thought = jsonObject.getString(THOUGHT)) == null) {
                            thought = jsonObject.getString("thought");
                        }
                        return new AgentAction(action, thought, actionInput, text);
                    }
                    if (jsonObject.getString(FinalAnswer) != null && jsonObject.getString(FinalAnswer).length() > 0) {
                        String finalAnswer = jsonObject.getString(FinalAnswer);
                        return new AgentFinish(finalAnswer, text);
                    }
                    break block9;
                }
                return new AgentFinish(text, text);
            }
            catch (Exception e) {
                return new AgentFinish(text, text);
            }
        }
        return agentResult;
    }
}

