/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.agent.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.agent.AgentParser;
import kd.ai.gai.core.engine.agent.AgentResult;
import kd.ai.gai.core.engine.agent.result.AgentAction;
import kd.ai.gai.core.engine.agent.result.AgentFinish;
import kd.bos.exception.KDBizException;

public class ReActOutputParser
implements AgentParser {
    public static final String FINAL_ANSWER_ACTION = "Final_answer";

    @Override
    public AgentResult parse(String text) {
        boolean includesAnswer = text.contains(FINAL_ANSWER_ACTION);
        String regex = "Action\\s*\\d*\\s*:\\s*(.*?)\\s*Action_input\\s*\\d*\\s*:\\s*(.*)";
        Pattern pattern = Pattern.compile(regex, 32);
        Matcher actionMatcher = pattern.matcher(text);
        if (actionMatcher.find()) {
            if (includesAnswer) {
                throw new KDBizException(Errors.FINAL_ANSWER_AND_PARSABLE_ACTION_ERROR_MESSAGE, new Object[0]);
            }
            String action = actionMatcher.group(1).trim();
            if (action.endsWith("\\n")) {
                action = action.substring(0, action.length() - 2);
            }
            String actionInput = actionMatcher.group(2);
            String toolInput = actionInput.trim().replaceAll("^\"|\"$", "");
            return new AgentAction(action, "", toolInput, text);
        }
        if (includesAnswer) {
            String output = text.split(FINAL_ANSWER_ACTION)[1].trim();
            if (output.startsWith(":")) {
                output = output.substring(1);
            }
            return new AgentFinish(output, text);
        }
        Pattern actionPattern = Pattern.compile("Action\\s*\\d*\\s*:\\s*(.*?)", 32);
        if (!actionPattern.matcher(text).find()) {
            throw new KDBizException(Errors.MISSING_ACTION_AFTER_THOUGHT_ERROR_MESSAGE, new Object[0]);
        }
        Pattern actionInputPattern = Pattern.compile("\\s*Action_input\\s*\\d*\\s*:\\s*(.*)", 32);
        if (!actionInputPattern.matcher(text).find()) {
            throw new KDBizException(Errors.MISSING_ACTION_INPUT_AFTER_ACTION_ERROR_MESSAGE, new Object[0]);
        }
        throw new KDBizException(Errors.parserLLMOutputError(text), new Object[0]);
    }
}

