/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.agent.plan;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.dto.Chunks4LLMItem;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.domain.dto.agent.Agent;
import kd.ai.gai.core.domain.dto.agent.ChatSessionDTO;
import kd.ai.gai.core.domain.dto.agent.GaiMsgConfig;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.dto.agent.Repo;
import kd.ai.gai.core.domain.dto.agent.RunStep;
import kd.ai.gai.core.domain.vo.RepoVO;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.agent.AgentMessage;
import kd.ai.gai.core.engine.agent.result.AgentAction;
import kd.ai.gai.core.engine.agent.tool.ToolParamDesc;
import kd.ai.gai.core.engine.agent.tool.ToolService;
import kd.ai.gai.core.engine.agent.tool.ToolServiceFunctionCall;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.VectorMetricType;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.RunStepStatusEnum;
import kd.ai.gai.core.service.RepoService;
import kd.ai.gai.core.service.agent.AgentService;
import kd.ai.gai.core.service.agent.AnnotationService;
import kd.ai.gai.core.service.agent.ChatService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.service.embedding.EmbeddingServiceFactory;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class AgentCommonService {
    private static final Log log = LogFactory.getLog(AgentCommonService.class);
    public static final String AI_CLOUD_ID = "ai";
    public static final String KM_APP_ID = "aikm";
    public static final String KM_SERVICE_NAME = "AIKMService";
    public static final String KM_RETRIEVAL_METHOD_NAME = "retrieval";
    public static final String TEXT_QA = "TEXT_QA";
    public static final String Q = "Q_ONLY";
    public static final String QA = "QA_ONLY";
    private static final int MaxRetries = 15;
    private static final long ms_max_task_time = 600000L;

    public Message getLastMessge(String chatSessionId, AgentMessage agentMessage, String taskId) {
        String lastMessageCacheKey = "lastMessageCache_" + taskId;
        String lastMessageCache = (String)EngineCache.getAppCache(taskId).get(lastMessageCacheKey, String.class);
        Message lastMessage = null;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)lastMessageCache)) {
            lastMessage = MessageService.getLastMessage(chatSessionId, Long.parseLong(agentMessage.getRunId()));
            EngineCache.getAppCache(taskId).put(lastMessageCacheKey, (Object)JSONObject.toJSONString((Object)lastMessage));
        } else {
            lastMessage = (Message)JSONObject.parseObject((String)((String)EngineCache.getAppCache(taskId).get(lastMessageCacheKey, String.class)), Message.class);
        }
        return lastMessage;
    }

    public Boolean isNeedStopMessage(String chatSessionId, Message message, Message lastMessage) {
        GaiMsgConfig gaiMsgConfig;
        if (lastMessage != null && (gaiMsgConfig = AnnotationService.parseGaiMsgConfig(lastMessage.getContentTag())) != null && !gaiMsgConfig.getNeedPushMsg().booleanValue()) {
            message.setEnable(EnableEnum.NO.getKeyStr());
            MessageService.saveJavaMessage(chatSessionId, message);
            return true;
        }
        return false;
    }

    public static Message createNewAssistantMessage(String chatSessionId, long userMessageId, long assistantMessageId, String runId) {
        Message message = MessageService.getMessageById(userMessageId);
        ChatSessionDTO chatSessionDTO = ChatService.getChatSession(chatSessionId);
        message.setMessageId(assistantMessageId);
        message.setSessionId(Long.parseLong(chatSessionDTO.getSessionId()));
        message.setType(ChatMessageTypeEnum.ASSISTANT.getId());
        message.setEnable(EnableEnum.NO.getKeyStr());
        message.setRunId(Long.parseLong(runId));
        return MessageService.saveJavaMessage(chatSessionId, message);
    }

    public boolean shouldBeContinue(Context context, AgentMessage agentMessage) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - agentMessage.getStartTime() > 600000L) {
            log.info("Agent\u4efb\u52a1\u6267\u884c\u8d85\u65f6");
            return false;
        }
        int retries = agentMessage.getRetries();
        if (retries >= 15) {
            log.info("Agent\u4efb\u52a1React\u6b21\u6570\u8d85\u8fc7\u6700\u5927\u6b21\u6570\u9650\u5236");
            return false;
        }
        agentMessage.setRetries(retries + 1);
        return true;
    }

    public String performAgentAction(Context context, AgentMessage agentMessage, AgentAction action, RunStep runStep) {
        Agent agent;
        String chatSessionId = context.getChatSessionId();
        BaseResult baseResult = ToolService.functionCall(chatSessionId, agent = AgentService.getAgent(agentMessage.getAgent().getAgentId(), true), action, runStep);
        if (baseResult != null) {
            if (baseResult.getErrCode().equals("0")) {
                Object data = baseResult.getData();
                if (Objects.isNull(data) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)data.toString())) {
                    if (runStep.getAgentSkillType().equals("process")) {
                        return "process";
                    }
                    return "";
                }
                return data instanceof String ? data.toString() : JSONObject.toJSONString((Object)data);
            }
            if (baseResult.getErrCode().equals("cancell")) {
                if (runStep.getAgentSkillType().equals("process")) {
                    runStep.setStepStatus(RunStepStatusEnum.CANCELLED.getId());
                }
            } else {
                return baseResult.getErrMsg();
            }
        }
        return null;
    }

    public void handleRepoAutoCall(Agent agent, AgentMessage agentMessage, StringBuilder builder, Prompt prompt) {
        List<Repo> list;
        if (agent.getRepoAutoCall() == 1 && (list = agent.getRepoList()) != null) {
            ArrayList<Long> repoIds = new ArrayList<Long>(list.size());
            for (Repo repo : list) {
                repoIds.add(repo.getId());
            }
            builder.append(this.retrive(repoIds, agentMessage.getUserInput(), 5));
            prompt.setPrompt(builder.toString());
        }
    }

    public Map<String, String> getPromptParam(AgentMessage agentMessage, JSONArray functionCalls) {
        String chatSessionId = agentMessage.getChatSessionId();
        String runId = agentMessage.getRunId();
        String toolSCacheKey = "toolSCacheKey_" + runId;
        Map toolSCache = (Map)EngineCache.getAppCache(chatSessionId).get(toolSCacheKey, Map.class);
        if (toolSCache != null) {
            return toolSCache;
        }
        Agent agent = AgentService.getAgent(agentMessage.getAgent().getAgentId(), true);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (agentMessage.isLastMessage()) {
            paramMap.put("instruction", agent.getRoleDescTag());
            return paramMap;
        }
        try {
            JSONArray tools = this.buildToolsList(agent, chatSessionId, functionCalls);
            StringBuilder toolStr = new StringBuilder();
            ArrayList<String> toolsName = new ArrayList<String>(10);
            for (int i = 0; i < tools.size(); ++i) {
                JSONObject json = tools.getJSONObject(i);
                String param = json.getJSONArray("param").toJSONString();
                String name = json.getString("name");
                String desc = json.getString("desc");
                toolsName.add(name);
                toolStr.append(this.formatToolDescription(ToolParamDesc.NAME.getDesc(), name));
                toolStr.append(this.formatToolDescription(ToolParamDesc.DESC.getDesc(), desc));
                toolStr.append(this.formatToolDescription(ToolParamDesc.PARAM.getDesc(), param));
            }
            paramMap.put("tools", toolStr.toString());
            if (functionCalls != null) {
                paramMap.put("function", functionCalls.toJSONString());
            }
            paramMap.put("tool_names", ((Object)toolsName).toString());
            paramMap.put("instruction", agent.getRoleDescTag());
            EngineCache.getAppCache(chatSessionId).put(toolSCacheKey, paramMap);
        }
        catch (Exception e) {
            log.error(ResManager.loadKDString((String)"\u89e3\u6790\u5de5\u5177\u53c2\u6570\u5931\u8d25{}", (String)"GaiAgentReact_01", (String)"ai-gai-core", (Object[])new Object[0]), (Object)e.getMessage());
        }
        return paramMap;
    }

    private JSONArray buildToolsList(Agent agent, String chatSessionId, JSONArray functionCalls) {
        JSONArray prompts = ToolServiceFunctionCall.promtToFunction(chatSessionId, agent.getPromptList(), functionCalls);
        JSONArray processes = ToolServiceFunctionCall.processToFunction(chatSessionId, agent.getProcessList(), functionCalls);
        JSONArray apis = ToolServiceFunctionCall.toolToFunction(chatSessionId, agent.getToolList(), functionCalls);
        JSONArray openApi = ToolServiceFunctionCall.openApiToFunction(chatSessionId, agent.getOpenApiList(), functionCalls);
        JSONArray tools = new JSONArray();
        tools.addAll((Collection)prompts);
        tools.addAll((Collection)apis);
        tools.addAll((Collection)processes);
        tools.addAll((Collection)openApi);
        if (agent.getRepoAutoCall() == 0) {
            JSONArray rags = ToolServiceFunctionCall.ragToFunction(chatSessionId, agent.getRepoList(), functionCalls);
            tools.addAll((Collection)rags);
        }
        return tools;
    }

    private String formatToolDescription(String label, String value) {
        return label + value + "\n";
    }

    public List<String> retrive(List<Long> repoIdList, String userInput, int useKnowledgeTopK) {
        ArrayList<String> results = new ArrayList<String>(16);
        LinkedHashMap<String, Object> maps = new LinkedHashMap<String, Object>(16);
        maps.put("query", userInput);
        maps.put("knowledgeIds", repoIdList);
        maps.put("searchMode", QA);
        maps.put("topK", useKnowledgeTopK);
        maps.put("threshold", Float.valueOf(0.75f));
        maps.put("rerank", false);
        maps.put("rerankNumber", null);
        List vectorResult = (List)DispatchServiceHelper.invokeBizService((String)AI_CLOUD_ID, (String)KM_APP_ID, (String)KM_SERVICE_NAME, (String)KM_RETRIEVAL_METHOD_NAME, (Object[])maps.values().toArray());
        if (vectorResult == null || vectorResult.size() == 0) {
            maps.put("searchMode", TEXT_QA);
            maps.put("threshold", Float.valueOf(0.0f));
            vectorResult = (List)DispatchServiceHelper.invokeBizService((String)AI_CLOUD_ID, (String)KM_APP_ID, (String)KM_SERVICE_NAME, (String)KM_RETRIEVAL_METHOD_NAME, (Object[])maps.values().toArray());
        }
        log.info("<\u901a\u7528\u77e5\u8bc6\u5e93>\u77e5\u8bc6\u5e93\u68c0\u7d22\u8c03\u7528\u5fae\u670d\u52a1,vectorResult:[{}]", (Object)vectorResult.toString());
        try {
            for (Object result : vectorResult) {
                JSONObject vector = JSON.parseObject((String)JSONObject.toJSONString(result));
                JSONObject chunk = vector.getJSONObject("chunk");
                if (chunk == null) continue;
                results.add(chunk.getString("content"));
            }
        }
        catch (Exception e) {
            log.error("<\u901a\u7528\u77e5\u8bc6\u5e93>\u77e5\u8bc6\u5e93\u68c0\u7d22\u8c03\u7528\u5fae\u670d\u52a1,KM\u670d\u52a1\u8fd4\u56de\u7ed3\u679c\u5904\u7406\u5f02\u5e38,query:[{}],repoIdList:[{}],searchMode:[{}],topK:[{}],similarity:[{}]", new Object[]{userInput, repoIdList, maps.get("searchMode"), maps.get("topK"), maps.get("similarity"), e});
            throw new KDBizException("KM\u670d\u52a1\u8fd4\u56de\u7ed3\u679c\u5904\u7406\u5f02\u5e38");
        }
        return results;
    }

    public List<Chunk> addChunkId(List<Long> repoIdList, String userInput, int useKnowledgeTopK) {
        List<Chunk> chunkList = new ArrayList<Chunk>();
        log.info("\u4e0a\u4e0b\u6587repoIdList:{}", JSON.toJSON(repoIdList));
        if (repoIdList != null && !repoIdList.isEmpty() && !StringUtils.isEmpty((CharSequence)userInput)) {
            RepoVO repoInfo = RepoService.queryRepoMainInfo(repoIdList.get(0));
            LLM embeddingModel = repoInfo.getLlm();
            VectorMetricType vectorMetricType = repoInfo.getVectorMetricType();
            chunkList = useKnowledgeTopK <= 0 ? EmbeddingServiceFactory.getExecutor(embeddingModel, vectorMetricType).search(repoIdList, userInput) : (useKnowledgeTopK > 20 ? EmbeddingServiceFactory.getExecutor(embeddingModel, vectorMetricType).search(repoIdList, userInput, 20) : EmbeddingServiceFactory.getExecutor(embeddingModel, vectorMetricType).search(repoIdList, userInput, useKnowledgeTopK));
            log.info("\u4e0a\u4e0b\u6587chunkIdList:{}", JSON.toJSON(chunkList));
        }
        return chunkList;
    }

    public List<Chunks4LLMItem> chunkList2LLMList(List<Chunk> chunkList) {
        ArrayList<Chunks4LLMItem> resultList = new ArrayList<Chunks4LLMItem>(chunkList.size());
        for (Chunk chunk : chunkList) {
            Chunks4LLMItem chunks4LLMItem = new Chunks4LLMItem(chunk.getId(), chunk.getChunk());
            resultList.add(chunks4LLMItem);
        }
        return resultList;
    }
}

