/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.agent.plan;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Map;
import kd.ai.gai.core.domain.dto.ChatItem;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.domain.dto.agent.Agent;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.dto.agent.Run;
import kd.ai.gai.core.domain.dto.agent.RunStep;
import kd.ai.gai.core.domain.op.UserFeedbackEventParams;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.agent.AgentCallBackMessage;
import kd.ai.gai.core.engine.agent.AgentMessage;
import kd.ai.gai.core.engine.agent.AgentResult;
import kd.ai.gai.core.engine.agent.Planner;
import kd.ai.gai.core.engine.agent.parser.FunctionOutputParser;
import kd.ai.gai.core.engine.agent.plan.AgentCommonService;
import kd.ai.gai.core.engine.agent.result.AgentAction;
import kd.ai.gai.core.engine.agent.tool.ToolServiceFunctionCall;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.enuz.agent.RunStepStatusEnum;
import kd.ai.gai.core.enuz.op.UserFeedbackTypeEnum;
import kd.ai.gai.core.service.AiccService;
import kd.ai.gai.core.service.ChatHistoryService;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.agent.AgentService;
import kd.ai.gai.core.service.agent.ChatService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.service.agent.RunService;
import kd.ai.gai.core.service.op.IUserFeedbackService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;

public class FunctionCallPlanner
extends AgentCommonService
implements Planner {
    public static final long promptId = 2108086076261305344L;
    private static final Log log = LogFactory.getLog(FunctionCallPlanner.class);
    final String cacheKey = "llmTaskLLMOutputCache_";
    final String msgPushedCacheKey = "llmTaskLLMOutputCache_msgPushed_";
    final String msgFunctionNameCacheKey = "llmTaskFunction_name_";
    final String msgFunctionArgumentsCacheKey = "llmTaskFunction_arguments_";
    final String secondFunctionCacheKey = "secondFunction_key";
    final String messageCacheKey = "llmTaskMessageCache_";
    final String stopFunctionCacheKey = "stopFunctionCachekey";

    @Override
    public Map<String, String> getPromptParam(AgentMessage agentMessage) {
        return this.getPromptParam(agentMessage, new JSONArray());
    }

    @Override
    public Prompt buildPrompt(Context context, AgentMessage agentMessage) {
        Agent agent = agentMessage.getAgent();
        Prompt prompt = new Prompt();
        prompt.setId(2108086076261305344L);
        agentMessage.setRememberCount(agent.getRememberCount() * 10 + 10);
        log.info("functionCall rememberCount{}", (Object)agentMessage.getRememberCount());
        prompt.setRemembercount(agentMessage.getRememberCount());
        prompt.setPrecision(true);
        Map<String, Object> service = AiccService.queryLlmAiccService(agent.getLlm());
        if (service == null || service.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63d0\u793a\u5bf9\u5e94\u7684\u6a21\u578b\u670d\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728\u3010Agent\u5e73\u53f0\u3011-\u3010\u914d\u7f6e\u4e2d\u5fc3\u3011-\u3010\u6a21\u578b\u670d\u52a1\u3011\u786e\u8ba4\u3002", (String)"GaiAgentReact_04", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        String llmNumber = (String)service.get("llm");
        prompt.setServiceNumber(agent.getLlm());
        prompt.setLlmStyle(LlmStyle.PRECISION);
        StringBuilder builder = new StringBuilder();
        builder.append(ResManager.loadKDString((String)"\u4e25\u683c\u9650\u5236\u5de5\u5177\u9009\u62e9\uff1a\u53ea\u80fd\u4f7f\u7528[{{tool_names}}]\u4e2d\u7684\u5de5\u5177\u4e4b\u4e00\uff0c\u4e0d\u80fd\u4f7f\u7528\u5176\u4ed6\u5de5\u5177\uff0c\u4e5f\u4e0d\u80fd\u968f\u610f\u634f\u9020\u5de5\u5177\uff0c\u8bf7\u4f18\u5148\u5206\u6790\u7528\u6237\u7684\u610f\u56fe\uff0c\u751f\u6210\u5de5\u5177\u7684\u6267\u884c\u8ba1\u5212\uff0c\u5e76\u6267\u884c\u5bf9\u5e94\u7684\u5de5\u5177\uff0c\u6240\u6709\u5de5\u5177\u6267\u884c\u5b8c\u6210\u4e4b\u540e\uff0c\u518d\u8fdb\u884c\u603b\u7ed3\r\n", (String)"GaiAgentFunction_01", (String)"ai-gai-core", (Object[])new Object[0]));
        builder.append("{{instruction}}\n\n");
        prompt.setReference(Boolean.FALSE);
        this.handleRepoAutoCall(agent, agentMessage, builder, prompt);
        prompt.setPrompt(builder.toString());
        LLM llm = LLM.parse(llmNumber);
        prompt.setLlm(llm);
        return prompt;
    }

    public void saveRunStepMessage(Context context, AgentCallBackMessage callBackMessage, String observation, RunStep runStep) {
        AgentMessage agentMessage = callBackMessage.getAgentMessage();
        Message message = MessageService.getMessageById(agentMessage.getMessageId());
        String chatSessionId = agentMessage.getChatSessionId();
        message.setMessageId(0L);
        message.setType(ChatMessageTypeEnum.RUNSTEP.getId());
        message.setContentTag(observation);
        message.setRunId(Long.parseLong(agentMessage.getRunId()));
        Long runStepId = ID.genLongId();
        if (runStep.getRunStepId() != null && runStep.getRunStepId() > 0L) {
            runStepId = runStep.getRunStepId();
        }
        message.setRunStepId(runStepId);
        message.setCreateTime(KDDateUtils.now());
        if (!agentMessage.isLastMessage()) {
            Message ms = MessageService.saveJavaMessage(chatSessionId, message);
            agentMessage.setUserInput(observation);
            runStep.setStepDetailsTag(callBackMessage.getLlmValue());
            runStep.setStepStatus(RunStepStatusEnum.COMPLETED.getId());
            runStep.setMessageId(ms.getMessageId());
            runStep.setRunStepId(runStepId);
            RunService.saveJavaRunStep(context, runStep);
        } else {
            agentMessage.setUserInput(observation);
        }
    }

    @Override
    public Result callback(Context context, AgentCallBackMessage callBackMessage) {
        Result result = new Result();
        String taskId = callBackMessage.getTaskId();
        if (callBackMessage.isStream()) {
            String hisMsg = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskLLMOutputCache_", taskId), String.class);
            String cacheMessages = String.format("%s%s", org.apache.commons.lang3.StringUtils.defaultString((String)hisMsg, (String)""), org.apache.commons.lang3.StringUtils.defaultString((String)callBackMessage.getLlmValue(), (String)""));
            result = callBackMessage.isEnd() ? this.handleEndMessage(context, callBackMessage, cacheMessages, result) : this.handlerStream(context, callBackMessage, hisMsg, cacheMessages, result);
        }
        return result;
    }

    private Result handleEndMessage(Context context, AgentCallBackMessage callBackMessage, String cacheMessages, Result result) {
        String llmValue = callBackMessage.getLlmValue();
        AgentMessage agentMessage = callBackMessage.getAgentMessage();
        String chatSessionId = context.getChatSessionId();
        String taskId = callBackMessage.getTaskId();
        String stopFunction = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "stopFunctionCachekey", taskId), String.class);
        Message lastMessage = this.getLastMessge(chatSessionId, agentMessage, taskId);
        log.info("llmValue is end: '{}'", (Object)llmValue);
        Boolean msgPushed = (Boolean)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskLLMOutputCache_msgPushed_", taskId), Boolean.class);
        Message message = (Message)JSONObject.parseObject((String)((String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskMessageCache_", taskId), String.class)), Message.class);
        Message userMessage = MessageService.getLastUserMessage(chatSessionId, Long.parseLong(agentMessage.getRunId()));
        if (message != null) {
            message.setContentTag(cacheMessages);
            message.setEnable(userMessage.getEnable());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)callBackMessage.getAllThink())) {
                message.setThought(callBackMessage.getAllThink());
            }
            if (stopFunction == null) {
                message = MessageService.saveJavaMessage(context.getChatSessionId(), message);
            }
            IUserFeedbackService.create().reportUserFeedback(new UserFeedbackEventParams(context.getSlideenv(), context.getChatTraceId(), context.getTraceId(), UserFeedbackTypeEnum.OK.getId(), KDDateUtils.now().getTime()));
            Run run = RunService.getRunById(message.getRunId());
            run.setRunStatus(RunStepStatusEnum.COMPLETED.getId());
            RunService.saveRun(run);
            if (!(msgPushed != null && msgPushed.booleanValue() || stopFunction == null)) {
                return this.executeFunction(context, callBackMessage, result, stopFunction);
            }
            log.info("gaiMsgConfig.msgPushed:{}", (Object)msgPushed);
            if (!this.isNeedStopMessage(chatSessionId, message, lastMessage).booleanValue()) {
                ChatService.pushAssistantStreamMessage(context, message, llmValue, true, message.getConfigTag(), callBackMessage.getSeqNo(), callBackMessage.getTaskId());
            }
        }
        TraceUtil.saveIfStreamAsyncLLMLog(context, callBackMessage);
        return result;
    }

    private void clearFunctionCaches(String taskId) {
        EngineCache.getAppCache(taskId).remove(String.format("%s%s", "llmTaskFunction_name_", taskId));
        EngineCache.getAppCache(taskId).remove(String.format("%s%s", "llmTaskFunction_arguments_", taskId));
        EngineCache.getAppCache(taskId).remove(String.format("%s%s", "secondFunction_key", taskId));
        EngineCache.getAppCache(taskId).remove(String.format("%s%s", "stopFunctionCachekey", taskId));
    }

    private Result executeFunction(Context context, AgentCallBackMessage callBackMessage, Result result, String stopFunction) {
        String taskId = callBackMessage.getTaskId();
        AgentMessage agentMessage = callBackMessage.getAgentMessage();
        String chatSessionId = context.getChatSessionId();
        FunctionOutputParser parser = new FunctionOutputParser();
        JSONArray functionArry = new JSONArray();
        JSONObject function = new JSONObject();
        String id = stopFunction.split("&")[1];
        String name = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskFunction_name_", taskId), String.class);
        String arguments = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskFunction_arguments_", taskId), String.class);
        function.put("name", (Object)name);
        function.put("arguments", (Object)arguments);
        JSONObject functionJson = new JSONObject();
        functionJson.put("function", (Object)function);
        functionJson.put("id", (Object)id);
        functionJson.put("type", (Object)"function");
        functionArry.add((Object)functionJson);
        JSONObject tool_calls = new JSONObject();
        tool_calls.put("tool_calls", (Object)functionArry);
        log.info("functionname:{},functionarguments{},id{}", new Object[]{name, arguments, id});
        this.clearFunctionCaches(taskId);
        AgentResult agentResult = parser.parse(function.toJSONString());
        if (agentResult instanceof AgentAction) {
            AgentAction action = (AgentAction)agentResult;
            RunStep runStep = new RunStep();
            runStep.setRunId(Long.parseLong(agentMessage.getRunId()));
            runStep.setRunStepId(ID.genLongId());
            String functionName = (String)EngineCache.getAppCache(chatSessionId).get(String.format("%s%s%s%s%s", chatSessionId, "_", "name", "_", action.getName()), String.class);
            tool_calls.put("functionName", (Object)functionName);
            long start = System.currentTimeMillis();
            String observation = this.performAgentAction(context, callBackMessage.getAgentMessage(), action, runStep);
            log.info("observation:{}", (Object)observation);
            ChatHistoryService.save(chatSessionId, 2108086076261305344L, Collections.singletonList(new ChatItem(1, JSON.toJSONString((Object)tool_calls))));
            callBackMessage.setLlmValue(JSON.toJSONString((Object)tool_calls));
            if (observation != null && observation.equals("failed")) {
                runStep.setStepStatus(RunStepStatusEnum.FAILED.getId());
                RunService.pushRunStepResultMessage(context, runStep);
                PushMsgService.pushStreamDown(context, agentMessage.getRunId(), "0", "", "", agentMessage.getRunId());
                PushMsgService.pushWaitingDone(context, 0L, agentMessage.getRunId());
                return result;
            }
            if (this.isMessageCanceled(agentMessage, taskId, chatSessionId)) {
                runStep.setStepStatus(RunStepStatusEnum.CANCELLED.getId());
                this.saveRunStepMessage(context, callBackMessage, observation == null ? "" : observation, runStep);
                RunService.pushRunStepResultMessage(context, runStep);
                PushMsgService.pushStreamDown(context, agentMessage.getRunId(), "0", "", "", agentMessage.getRunId());
                PushMsgService.pushWaitingDone(context, 0L, agentMessage.getRunId());
                return result;
            }
            this.saveRunStepMessage(context, callBackMessage, observation == null ? "" : observation, runStep);
            long end = System.currentTimeMillis();
            runStep.setTime(String.valueOf(end - start));
            RunService.pushRunStepResultMessage(context, runStep);
            agentMessage.setUserInput(String.format("%s%s%s%s%s", "functioncall", "&", observation == null ? "" : observation, "&", id));
            if (this.shouldBeContinue(context, agentMessage)) {
                result = HandlerFactory.runHandler(context, agentMessage);
                result.setCallback(true);
            } else {
                ChatHistoryService.save(chatSessionId, 2108086076261305344L, Collections.singletonList(new ChatItem(0, agentMessage.getUserInput())));
                PushMsgService.pushStreamDown(context, agentMessage.getRunId(), "0", "", "", agentMessage.getRunId());
                PushMsgService.pushWaitingDone(context, 0L, agentMessage.getRunId());
            }
        }
        EngineCache.getAppCache(taskId).remove(String.format("%s%s", "llmTaskLLMOutputCache_msgPushed_", taskId));
        callBackMessage.setLlmValue(function.toJSONString());
        TraceUtil.saveIfStreamAsyncLLMLog(context, callBackMessage);
        return result;
    }

    @Override
    public String performAgentAction(Context context, AgentMessage agentMessage, AgentAction action, RunStep runStep) {
        Agent agent;
        String chatSessionId = context.getChatSessionId();
        BaseResult baseResult = ToolServiceFunctionCall.functionCall(chatSessionId, agent = AgentService.getAgent(agentMessage.getAgent().getAgentId(), true), action, runStep);
        if (baseResult != null) {
            if (baseResult.getErrCode().equals("0")) {
                if (baseResult.getData() == null) {
                    if (runStep.getAgentSkillType().equalsIgnoreCase("process")) {
                        return "process";
                    }
                    return "";
                }
                if (baseResult.getData().toString().length() > 0) {
                    return baseResult.getData().toString();
                }
                return baseResult.getErrMsg();
            }
            if (baseResult.getErrCode().equals("-1")) {
                if (runStep.getAgentSkillType().equalsIgnoreCase("process")) {
                    return "failed";
                }
            } else if (baseResult.getErrCode().equals("cancell")) {
                if (runStep.getAgentSkillType().equalsIgnoreCase("process")) {
                    runStep.setStepStatus(RunStepStatusEnum.CANCELLED.getId());
                }
            } else {
                return baseResult.getErrMsg();
            }
        }
        return null;
    }

    private boolean isMessageCanceled(AgentMessage agentMessage, String taskId, String chatSessionId) {
        String runId = agentMessage.getRunId();
        if (runId != null) {
            String messageCanceledKey = "messageCanceledKey_" + runId;
            String messageCanceled = (String)EngineCache.getAppCache(chatSessionId).get(messageCanceledKey, String.class);
            if (messageCanceled != null && messageCanceled.equals(RunStepStatusEnum.CANCELLED.getId())) {
                log.info("user message cancelled : {}", (Object)taskId);
                return true;
            }
        }
        return false;
    }

    private Result handlerStream(Context context, AgentCallBackMessage callBackMessage, String hisMsg, String cacheMessages, Result result) {
        String llmValue = callBackMessage.getLlmValue();
        AgentMessage agentMessage = callBackMessage.getAgentMessage();
        String chatSessionId = context.getChatSessionId();
        String taskId = callBackMessage.getTaskId();
        long assistantMessageId = agentMessage.getAssistantMessageId();
        Message lastMessage = this.getLastMessge(chatSessionId, agentMessage, taskId);
        log.info("llmValue is not end {}", (Object)llmValue);
        if (this.isMessageCanceled(agentMessage, taskId, chatSessionId)) {
            return result;
        }
        if (StringUtils.isNotEmpty((CharSequence)callBackMessage.getLlmThink())) {
            log.info("think:{}", (Object)callBackMessage.getLlmThink());
            PushMsgService.pushStreamThinkChat(context, agentMessage.getRunId(), "0", callBackMessage.getSeqNo(), callBackMessage.getLlmThink(), false, callBackMessage.getSearchInfos());
            TraceUtil.saveIfStreamAsyncLLMLog(context, callBackMessage);
            return result;
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)hisMsg) && llmValue.length() > 0) {
            Message message = FunctionCallPlanner.createNewAssistantMessage(chatSessionId, agentMessage.getMessageId(), assistantMessageId, agentMessage.getRunId());
            EngineCache.getAppCache(taskId).put(String.format("%s%s", "llmTaskMessageCache_", taskId), (Object)JSONObject.toJSONString((Object)message));
        }
        boolean msgPushed = true;
        if (callBackMessage.getLlmValue().contains("callStopTag")) {
            msgPushed = false;
            EngineCache.getAppCache(taskId).put(String.format("%s%s", "llmTaskLLMOutputCache_msgPushed_", taskId), (Object)msgPushed);
            EngineCache.getAppCache(taskId).put(String.format("%s%s", "stopFunctionCachekey", taskId), (Object)callBackMessage.getLlmValue());
            return result;
        }
        if (org.apache.commons.lang3.StringUtils.startsWithIgnoreCase((CharSequence)callBackMessage.getLlmValue(), (CharSequence)"function.")) {
            result = this.handleFunctionCall(callBackMessage, result);
            callBackMessage.setLlmValue(callBackMessage.getLlmValue().replace("function.name&", "").replace("function.arguments&", ""));
            TraceUtil.saveIfStreamAsyncLLMLog(context, callBackMessage);
            return result;
        }
        if (org.apache.commons.lang3.StringUtils.startsWithIgnoreCase((CharSequence)cacheMessages, (CharSequence)"[")) {
            log.info("msgPushed:{}", (Object)false);
            TraceUtil.saveIfStreamAsyncLLMLog(context, callBackMessage);
            msgPushed = false;
            EngineCache.getAppCache(taskId).put(String.format("%s%s", "llmTaskLLMOutputCache_msgPushed_", taskId), (Object)msgPushed);
            return result;
        }
        EngineCache.getAppCache(taskId).put(String.format("%s%s", "llmTaskLLMOutputCache_msgPushed_", taskId), (Object)msgPushed);
        Message message = (Message)JSONObject.parseObject((String)((String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskMessageCache_", taskId), String.class)), Message.class);
        message.setContentTag(cacheMessages);
        EngineCache.getAppCache(taskId).put(String.format("%s%s", "llmTaskMessageCache_", taskId), (Object)JSONObject.toJSONString((Object)message));
        if (!this.isNeedStopMessage(chatSessionId, message, lastMessage).booleanValue() && msgPushed) {
            log.info("is NeedStopMessage");
            ChatService.pushAssistantStreamMessage(context, message, llmValue, false, message.getConfigTag(), callBackMessage.getSeqNo(), callBackMessage.getTaskId());
        }
        TraceUtil.saveIfStreamAsyncLLMLog(context, callBackMessage);
        return result;
    }

    private Result handleFunctionCall(AgentCallBackMessage callBackMessage, Result result) {
        String taskId = callBackMessage.getTaskId();
        String msg = callBackMessage.getLlmValue();
        boolean msgPushed = true;
        log.info("function");
        if (org.apache.commons.lang3.StringUtils.startsWithIgnoreCase((CharSequence)callBackMessage.getLlmValue(), (CharSequence)"function.name")) {
            int index = StringUtils.indexOf((CharSequence)msg, (CharSequence)"function.arguments");
            String nameStr = callBackMessage.getLlmValue();
            if (index >= 0) {
                msg = msg.substring(index);
                nameStr = nameStr.substring(0, index);
            }
            String[] functionName = nameStr.split("&");
            String nameCache = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskFunction_name_", taskId), String.class);
            msgPushed = false;
            if (nameCache != null) {
                log.info("namecache:{}", (Object)nameCache);
                EngineCache.getAppCache(taskId).put(String.format("%s%s", "secondFunction_key", taskId), (Object)true);
                return result;
            }
            if (functionName.length > 1) {
                String name = functionName[1];
                EngineCache.getAppCache(taskId).put(String.format("%s%s", "llmTaskFunction_name_", taskId), (Object)name);
                log.info("functionName:{}", (Object)name);
            }
            EngineCache.getAppCache(taskId).put(String.format("%s%s", "llmTaskLLMOutputCache_msgPushed_", taskId), (Object)msgPushed);
        }
        if (org.apache.commons.lang3.StringUtils.startsWithIgnoreCase((CharSequence)msg, (CharSequence)"function.arguments")) {
            msgPushed = false;
            EngineCache.getAppCache(taskId).put(String.format("%s%s", "llmTaskLLMOutputCache_msgPushed_", taskId), (Object)msgPushed);
            Boolean flag = (Boolean)EngineCache.getAppCache(taskId).get(String.format("%s%s", "secondFunction_key", taskId), Boolean.class);
            if (flag != null && flag.booleanValue()) {
                return result;
            }
            String arguments = msg.split("&")[1];
            log.info("functionArguments:{}", (Object)arguments);
            String argumentsCache = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskFunction_arguments_", taskId), String.class);
            if (argumentsCache != null) {
                EngineCache.getAppCache(taskId).put(String.format("%s%s", "llmTaskFunction_arguments_", taskId), (Object)String.format("%s%s", argumentsCache, arguments));
            } else {
                EngineCache.getAppCache(taskId).put(String.format("%s%s", "llmTaskFunction_arguments_", taskId), (Object)String.format("%s", arguments));
            }
        }
        return result;
    }
}

