/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.agent.plan;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.domain.dto.agent.Agent;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.dto.agent.Repo;
import kd.ai.gai.core.domain.dto.agent.Run;
import kd.ai.gai.core.domain.op.UserFeedbackEventParams;
import kd.ai.gai.core.domain.vo.KnowledgeCitationData;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.agent.AgentCallBackMessage;
import kd.ai.gai.core.engine.agent.AgentMessage;
import kd.ai.gai.core.engine.agent.Planner;
import kd.ai.gai.core.engine.agent.plan.AgentCommonService;
import kd.ai.gai.core.engine.handler.LLMActionHandler;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.enuz.agent.RunStepStatusEnum;
import kd.ai.gai.core.enuz.op.UserFeedbackTypeEnum;
import kd.ai.gai.core.service.AiccService;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.service.agent.RunService;
import kd.ai.gai.core.service.op.IUserFeedbackService;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;

public class RagPlanner
extends AgentCommonService
implements Planner {
    private static final Log log = LogFactory.getLog(RagPlanner.class);

    @Override
    public Map<String, String> getPromptParam(AgentMessage agentMessage) {
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        paramMap.put("instruction", agentMessage.getAgent().getRoleDescTag());
        return paramMap;
    }

    @Override
    public Prompt buildPrompt(Context context, AgentMessage agentMessage) {
        Agent agent = agentMessage.getAgent();
        StringBuilder builder = new StringBuilder();
        builder.append("{{instruction}}\n\n");
        Prompt prompt = new Prompt();
        List<Repo> list = agent.getRepoList();
        if (list != null) {
            ArrayList<Long> repoIds = new ArrayList<Long>(list.size());
            for (Repo repo : list) {
                repoIds.add(repo.getId());
            }
            prompt.setReference(false);
            if (prompt.getReference().booleanValue()) {
                prompt.setRepoIds(repoIds);
            } else {
                builder.append(this.retrive(repoIds, agentMessage.getUserInput(), 5));
            }
        }
        agentMessage.setRememberCount(agent.getRememberCount() * 6 + 6);
        prompt.setRemembercount(agentMessage.getRememberCount());
        prompt.setId(2002989110637102080L);
        prompt.setPrecision(true);
        Map<String, Object> service = AiccService.queryLlmAiccService(agent.getLlm());
        if (service == null || service.isEmpty()) {
            throw new KDBizException("\u63d0\u793a\u5bf9\u5e94\u7684\u6a21\u578b\u670d\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728\u3010Agent\u5e73\u53f0\u3011-\u3010\u914d\u7f6e\u4e2d\u5fc3\u3011-\u3010\u6a21\u578b\u670d\u52a1\u3011\u786e\u8ba4\u3002");
        }
        String llmNumber = (String)service.get("llm");
        prompt.setServiceNumber(agent.getLlm());
        prompt.setLlmStyle(LlmStyle.PRECISION);
        prompt.setPrompt(builder.toString());
        prompt.setPrecision(true);
        LLM llm = LLM.parse(llmNumber);
        prompt.setLlm(llm);
        return prompt;
    }

    @Override
    public Result callback(Context context, AgentCallBackMessage callBackMessage) {
        String chatSessionId = callBackMessage.getChatSessionId();
        String errCode = callBackMessage.getErrCode();
        AgentMessage agentMessage = callBackMessage.getAgentMessage();
        String runId = agentMessage.getRunId();
        long assistantMessageId = agentMessage.getAssistantMessageId();
        String taskId = callBackMessage.getTaskId();
        String cacheKey = "llmTaskLLMOutputCache_";
        String messageCacheKey = "llmTaskMessageCache_" + taskId;
        String hisMsg = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskLLMOutputCache_", taskId), String.class);
        String cacheMessages = String.format("%s%s", org.apache.commons.lang3.StringUtils.defaultString((String)hisMsg, (String)""), org.apache.commons.lang3.StringUtils.defaultString((String)callBackMessage.getLlmValue(), (String)""));
        log.info("cacheMessages: {}", (Object)cacheMessages);
        if (kd.bos.util.StringUtils.isEmpty((String)errCode) || !errCode.equals(Errors.OK.getCode())) {
            errCode = kd.bos.util.StringUtils.isEmpty((String)errCode) ? Errors.LLM_ERROR.getCode() : errCode;
            log.error("\u56de\u8c03\u9519\u8bef", (Object)callBackMessage);
            TraceUtil.saveIfStreamAsyncLLMLog(context, callBackMessage);
            return new Result(new ErrorCode(errCode, "\u5927\u8bed\u8a00\u6a21\u578b\u51fa\u9519\uff1a" + callBackMessage.getErrMsg()));
        }
        String llmValue = callBackMessage.getLlmValue();
        if (callBackMessage.isStream() && !callBackMessage.isEnd()) {
            Message message;
            if (runId != null) {
                String messageCanceledKey = "messageCanceledKey_" + runId;
                String messageCanceled = (String)EngineCache.getAppCache(chatSessionId).get(messageCanceledKey, String.class);
                if (messageCanceled != null && messageCanceled.equals(RunStepStatusEnum.CANCELLED.getId())) {
                    log.info("user message cancelled : {}", (Object)taskId);
                    return new Result(new ErrorCode(errCode, "\u505c\u6b62\u8f93\u51fa"));
                }
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)callBackMessage.getLlmThink())) {
                PushMsgService.pushStreamThinkChat(context, agentMessage.getRunId(), "0", callBackMessage.getSeqNo(), callBackMessage.getLlmThink(), false, callBackMessage.getSearchInfos());
                TraceUtil.saveIfStreamAsyncLLMLog(context, callBackMessage);
                return new Result(Errors.OK);
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)hisMsg)) {
                message = RagPlanner.createNewAssistantMessage(chatSessionId, agentMessage.getMessageId(), assistantMessageId, agentMessage.getRunId());
                EngineCache.getAppCache(taskId).put(messageCacheKey, (Object)JSONObject.toJSONString((Object)message));
            }
            message = (Message)JSONObject.parseObject((String)((String)EngineCache.getAppCache(taskId).get(messageCacheKey, String.class)), Message.class);
            message.setContentTag(cacheMessages);
            EngineCache.getAppCache(taskId).put(messageCacheKey, (Object)JSONObject.toJSONString((Object)message));
            PushMsgService.pushStreamChat(context, agentMessage.getRunId(), callBackMessage.getFlowId() + "", callBackMessage.getSeqNo(), llmValue, false, callBackMessage.getSearchInfos());
            TraceUtil.saveIfStreamAsyncLLMLog(context, callBackMessage);
        } else if (callBackMessage.isEnd()) {
            Message message = (Message)JSONObject.parseObject((String)((String)EngineCache.getAppCache(taskId).get(messageCacheKey, String.class)), Message.class);
            Message userMessage = MessageService.getLastUserMessage(chatSessionId, Long.parseLong(agentMessage.getRunId()));
            if (message != null) {
                message.setContentTag(cacheMessages);
                message.setEnable(userMessage.getEnable());
                message.setThought(callBackMessage.getAllThink());
                message = MessageService.saveJavaMessage(context.getChatSessionId(), message);
                IUserFeedbackService.create().reportUserFeedback(new UserFeedbackEventParams(context.getSlideenv(), context.getChatTraceId(), context.getTraceId(), UserFeedbackTypeEnum.OK.getId(), KDDateUtils.now().getTime()));
                Run run = RunService.getRunById(message.getRunId());
                run.setRunStatus(RunStepStatusEnum.COMPLETED.getId());
                RunService.saveRun(run);
                if (callBackMessage.isStream()) {
                    if (StringUtils.isNotEmpty((CharSequence)llmValue)) {
                        PushMsgService.pushStreamChat(context, callBackMessage.getTaskId(), callBackMessage.getFlowId() + "", callBackMessage.getSeqNo(), llmValue, false, callBackMessage.getSearchInfos());
                    }
                    List<KnowledgeCitationData> citationInfos = callBackMessage.getCitationInfos();
                    LLMActionHandler.sendChatBottomMsg(context, null, context.getAssistantPageId(), context.getRootPageId(), context.getGlobalSessionId(), callBackMessage.getChatSessionId(), agentMessage.getRunId(), callBackMessage.getFlowId() + "", "\u53c2\u8003\u6587\u4ef6", citationInfos);
                    PushMsgService.pushStreamDown(context, agentMessage.getRunId(), callBackMessage.getFlowId() + "", llmValue, message.getMessageId() + "", runId);
                }
            }
            PushMsgService.pushWaitingDone(context);
            TraceUtil.saveIfStreamAsyncLLMLog(context, callBackMessage);
        }
        return new Result(Errors.OK);
    }
}

