/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.agent.plan;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.dto.Chunks4LLMItem;
import kd.ai.gai.core.domain.vo.RepoVO;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.VectorMetricType;
import kd.ai.gai.core.service.RepoService;
import kd.ai.gai.core.service.embedding.EmbeddingServiceFactory;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class RagRetrival {
    private static final Log log = LogFactory.getLog(RagRetrival.class);
    public static final String AI_CLOUD_ID = "ai";
    public static final String KM_APP_ID = "aikm";
    public static final String KM_SERVICE_NAME = "AIKMService";
    public static final String KM_RETRIEVAL_METHOD_NAME = "retrieval";
    public static final String TEXT_QA = "TEXT_QA";
    public static final String Q = "Q_ONLY";
    public static final String QA = "QA_ONLY";

    public List<String> retrive(List<Long> repoIdList, String userInput, int useKnowledgeTopK) {
        ArrayList<String> results = new ArrayList<String>(16);
        LinkedHashMap<String, Object> maps = new LinkedHashMap<String, Object>(16);
        maps.put("query", userInput);
        maps.put("knowledgeIds", repoIdList);
        maps.put("searchMode", QA);
        maps.put("topK", useKnowledgeTopK);
        maps.put("threshold", Float.valueOf(0.75f));
        maps.put("rerank", false);
        maps.put("rerankNumber", null);
        List vectorResult = (List)DispatchServiceHelper.invokeBizService((String)AI_CLOUD_ID, (String)KM_APP_ID, (String)KM_SERVICE_NAME, (String)KM_RETRIEVAL_METHOD_NAME, (Object[])maps.values().toArray());
        if (vectorResult == null || vectorResult.size() == 0) {
            maps.put("searchMode", TEXT_QA);
            maps.put("threshold", Float.valueOf(0.0f));
            vectorResult = (List)DispatchServiceHelper.invokeBizService((String)AI_CLOUD_ID, (String)KM_APP_ID, (String)KM_SERVICE_NAME, (String)KM_RETRIEVAL_METHOD_NAME, (Object[])maps.values().toArray());
        }
        log.info("<\u901a\u7528\u77e5\u8bc6\u5e93>\u77e5\u8bc6\u5e93\u68c0\u7d22\u8c03\u7528\u5fae\u670d\u52a1,vectorResult:[{}]", (Object)vectorResult.toString());
        try {
            for (Object result : vectorResult) {
                JSONObject vector = JSON.parseObject((String)JSONObject.toJSONString(result));
                JSONObject chunk = vector.getJSONObject("chunk");
                if (chunk == null) continue;
                results.add(chunk.getString("content"));
            }
        }
        catch (Exception e) {
            log.error("<\u901a\u7528\u77e5\u8bc6\u5e93>\u77e5\u8bc6\u5e93\u68c0\u7d22\u8c03\u7528\u5fae\u670d\u52a1,KM\u670d\u52a1\u8fd4\u56de\u7ed3\u679c\u5904\u7406\u5f02\u5e38,query:[{}],repoIdList:[{}],searchMode:[{}],topK:[{}],similarity:[{}]", new Object[]{userInput, repoIdList, maps.get("searchMode"), maps.get("topK"), maps.get("similarity"), e});
            throw new KDBizException("KM\u670d\u52a1\u8fd4\u56de\u7ed3\u679c\u5904\u7406\u5f02\u5e38");
        }
        return results;
    }

    public List<Chunk> addChunkId(List<Long> repoIdList, String userInput, int useKnowledgeTopK) {
        List<Chunk> chunkList = new ArrayList<Chunk>();
        log.info("\u4e0a\u4e0b\u6587repoIdList:{}", JSON.toJSON(repoIdList));
        if (repoIdList != null && !repoIdList.isEmpty() && !StringUtils.isEmpty((CharSequence)userInput)) {
            RepoVO repoInfo = RepoService.queryRepoMainInfo(repoIdList.get(0));
            LLM embeddingModel = repoInfo.getLlm();
            VectorMetricType vectorMetricType = repoInfo.getVectorMetricType();
            chunkList = useKnowledgeTopK <= 0 ? EmbeddingServiceFactory.getExecutor(embeddingModel, vectorMetricType).search(repoIdList, userInput) : (useKnowledgeTopK > 20 ? EmbeddingServiceFactory.getExecutor(embeddingModel, vectorMetricType).search(repoIdList, userInput, 20) : EmbeddingServiceFactory.getExecutor(embeddingModel, vectorMetricType).search(repoIdList, userInput, useKnowledgeTopK));
            log.info("\u4e0a\u4e0b\u6587chunkIdList:{}", JSON.toJSON(chunkList));
        }
        return chunkList;
    }

    public List<Chunks4LLMItem> chunkList2LLMList(List<Chunk> chunkList) {
        ArrayList<Chunks4LLMItem> resultList = new ArrayList<Chunks4LLMItem>(chunkList.size());
        for (Chunk chunk : chunkList) {
            Chunks4LLMItem chunks4LLMItem = new Chunks4LLMItem(chunk.getId(), chunk.getChunk());
            resultList.add(chunks4LLMItem);
        }
        return resultList;
    }
}

