/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.agent.plan;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.ChatItem;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.domain.dto.agent.Agent;
import kd.ai.gai.core.domain.dto.agent.GaiMsgConfig;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.dto.agent.Repo;
import kd.ai.gai.core.domain.dto.agent.Run;
import kd.ai.gai.core.domain.dto.agent.RunStep;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.domain.op.UserFeedbackEventParams;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.agent.AgentCallBackMessage;
import kd.ai.gai.core.engine.agent.AgentMessage;
import kd.ai.gai.core.engine.agent.AgentResult;
import kd.ai.gai.core.engine.agent.Planner;
import kd.ai.gai.core.engine.agent.parser.ReActJsonOutputParser;
import kd.ai.gai.core.engine.agent.plan.AgentCommonService;
import kd.ai.gai.core.engine.agent.result.AgentAction;
import kd.ai.gai.core.engine.agent.result.AgentFinish;
import kd.ai.gai.core.engine.agent.tool.ToolParamDesc;
import kd.ai.gai.core.engine.agent.tool.ToolService;
import kd.ai.gai.core.engine.message.FlowErrorMessage;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.RunStepStatusEnum;
import kd.ai.gai.core.enuz.op.UserFeedbackTypeEnum;
import kd.ai.gai.core.service.AiccService;
import kd.ai.gai.core.service.ChatHistoryService;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.agent.AgentService;
import kd.ai.gai.core.service.agent.AnnotationService;
import kd.ai.gai.core.service.agent.ChatService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.service.agent.RunService;
import kd.ai.gai.core.service.op.IUserFeedbackService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.io.IOUtils;

public class ReActPlanner
extends AgentCommonService
implements Planner {
    private static final Log log = LogFactory.getLog(ReActPlanner.class);
    private static final long ReactPromptId = 2108085560353502208L;
    private static final long SummaryPromptId = 2108086076261305344L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getPromptParam(AgentMessage agentMessage) {
        JSONArray functionCalls = null;
        String chatSessionId = agentMessage.getChatSessionId();
        String runId = agentMessage.getRunId();
        String toolSCacheKey = "toolSCacheKey_" + runId;
        Map toolSCache = (Map)EngineCache.getAppCache(chatSessionId).get(toolSCacheKey, Map.class);
        Agent agent = AgentService.getAgent(agentMessage.getAgent().getAgentId(), true);
        InputStream inputStream = null;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (agentMessage.isLastMessage()) {
            paramMap.put("instruction", agent.getRoleDescTag());
            return paramMap;
        }
        if (toolSCache != null) {
            return toolSCache;
        }
        try {
            JSONArray prompts = ToolService.promtToFunction(chatSessionId, agent.getPromptList(), functionCalls);
            JSONArray processes = ToolService.processToFunction(chatSessionId, agent.getProcessList(), functionCalls);
            JSONArray apis = ToolService.toolToFunction(chatSessionId, agent.getToolList(), functionCalls);
            JSONArray openApi = ToolService.openApiToFunction(chatSessionId, agent.getOpenApiList(), functionCalls);
            JSONArray tools = new JSONArray();
            tools.addAll((Collection)prompts);
            tools.addAll((Collection)apis);
            tools.addAll((Collection)processes);
            tools.addAll((Collection)openApi);
            if (agent.getRepoAutoCall() == 0) {
                JSONArray rags = ToolService.ragToFunction(chatSessionId, agent.getRepoList(), functionCalls);
                tools.addAll((Collection)rags);
            }
            StringBuilder toolStr = new StringBuilder();
            ArrayList<String> toolsName = new ArrayList<String>(10);
            for (int i = 0; i < tools.size(); ++i) {
                JSONObject json = tools.getJSONObject(i);
                String param = json.getJSONArray("param").toJSONString();
                String name = json.getString("name");
                toolsName.add(name);
                String desc = json.getString("desc");
                toolStr.append(ToolParamDesc.NAME.getDesc());
                name = name + "\n";
                toolStr.append(name);
                desc = desc + "\n";
                toolStr.append(ToolParamDesc.DESC.getDesc());
                toolStr.append(desc);
                toolStr.append(ToolParamDesc.PARAM.getDesc());
                param = param + "\n\n";
                toolStr.append(param);
            }
            paramMap.put("tools", toolStr.toString());
            if (functionCalls != null) {
                paramMap.put("function", functionCalls.toJSONString());
            }
            paramMap.put("tool_names", ((Object)toolsName).toString());
            paramMap.put("instruction", agent.getRoleDescTag());
        }
        catch (Exception e) {
            log.error(ResManager.loadKDString((String)"\u89e3\u6790\u5de5\u5177\u53c2\u6570\u5931\u8d25{}", (String)"GaiAgentReact_01", (String)"ai-gai-core", (Object[])new Object[0]), (Object)e.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.error(ResManager.loadKDString((String)"\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25", (String)"GaiAgentReact_02", (String)"ai-gai-core", (Object[])new Object[0]));
            }
        }
        EngineCache.getAppCache(chatSessionId).put(toolSCacheKey, paramMap);
        return paramMap;
    }

    public String queryPromptTemplate(String name) {
        QFilter qFilter = new QFilter("name", "=", (Object)name);
        String selectFields = "id,name,prompt_tag";
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"gai_prompt", (String)selectFields, (QFilter[])qFilters);
        if (dynamicObject == null) {
            return null;
        }
        return dynamicObject.getString("prompt_tag");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Prompt buildPrompt(Context context, AgentMessage agentMessage) {
        Agent agent = agentMessage.getAgent();
        String chatSessionId = context.getChatSessionId();
        Prompt prompt = new Prompt();
        StringBuilder builder = new StringBuilder();
        agentMessage.setRememberCount(agent.getRememberCount() * 10 + 10);
        log.info("rememberCount{}", (Object)agentMessage.getRememberCount());
        prompt.setRemembercount(agentMessage.getRememberCount());
        prompt.setPrecision(true);
        InputStream inputStream = null;
        String assistantMsgCacheKey = "lastRunId_" + chatSessionId;
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        String msgStr = (String)appCache.get(assistantMsgCacheKey, String.class);
        try {
            String promptTemplate;
            if (!agentMessage.isLastMessage()) {
                prompt.setId(2108085560353502208L);
                promptTemplate = this.queryPromptTemplate("ReactPromptTemplate");
                if (promptTemplate == null || promptTemplate.length() == 0) {
                    inputStream = this.getClass().getClassLoader().getResourceAsStream("META-INF/kd/ai/gai/ai-gai-react.txt");
                    String templateContent = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
                    prompt.setPrompt(builder.append(templateContent).toString());
                } else {
                    prompt.setPrompt(builder.append(promptTemplate).toString());
                }
                if (msgStr != null) {
                    log.info(ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u8f93\u51fa\u7684\u6d88\u606f{}", (String)"GaiAgentReact_03", (String)"ai-gai-core", (Object[])new Object[0]), (Object)msgStr);
                    appCache.remove(assistantMsgCacheKey);
                    ChatHistoryService.save(chatSessionId, prompt.getId(), Collections.singletonList(new ChatItem(0, msgStr)));
                }
            } else {
                promptTemplate = this.queryPromptTemplate("ReactSummary");
                List<UserHistoryMessage> history = ChatHistoryService.getPromptHistory(chatSessionId, prompt.getRemembercount(), 2108085560353502208L);
                String historyCacheKey = "history_" + chatSessionId;
                Integer hisSize = (Integer)appCache.get(historyCacheKey, Integer.class);
                if (hisSize == null) {
                    hisSize = 0;
                }
                appCache.put(historyCacheKey, (Object)history.size());
                int i = 0;
                int j = 0;
                for (UserHistoryMessage userHistoryMessage : history) {
                    log.info("user message:{},assistant:{}", (Object)userHistoryMessage.getUser(), (Object)userHistoryMessage.getAssistant());
                    ++j;
                    if (i < hisSize) {
                        ++i;
                        continue;
                    }
                    if (userHistoryMessage.getUser() != null && userHistoryMessage.getUser().trim().length() != 0) {
                        ChatHistoryService.save(chatSessionId, 2108086076261305344L, Collections.singletonList(new ChatItem(0, userHistoryMessage.getUser())));
                    }
                    if (userHistoryMessage.getAssistant() == null || userHistoryMessage.getAssistant().trim().length() == 0) continue;
                    if (j < history.size()) {
                        ChatHistoryService.save(chatSessionId, 2108086076261305344L, Collections.singletonList(new ChatItem(1, userHistoryMessage.getAssistant())));
                        continue;
                    }
                    if (msgStr != null) {
                        appCache.remove(assistantMsgCacheKey);
                        ChatHistoryService.save(chatSessionId, 2108086076261305344L, Collections.singletonList(new ChatItem(1, msgStr)));
                        continue;
                    }
                    ChatHistoryService.save(chatSessionId, 2108086076261305344L, Collections.singletonList(new ChatItem(1, userHistoryMessage.getAssistant())));
                }
                if (i == j && msgStr != null) {
                    appCache.remove(assistantMsgCacheKey);
                    ChatHistoryService.save(chatSessionId, 2108086076261305344L, Collections.singletonList(new ChatItem(1, msgStr)));
                }
                prompt.setId(2108086076261305344L);
                prompt.setPrompt(builder.append(promptTemplate).toString());
            }
            Map<String, Object> service = AiccService.queryLlmAiccService(agent.getLlm());
            if (service == null || service.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u63d0\u793a\u5bf9\u5e94\u7684\u6a21\u578b\u670d\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728\u3010Agent\u5e73\u53f0\u3011-\u3010\u914d\u7f6e\u4e2d\u5fc3\u3011-\u3010\u6a21\u578b\u670d\u52a1\u3011\u786e\u8ba4\u3002", (String)"GaiAgentReact_04", (String)"ai-gai-core", (Object[])new Object[0]));
            }
            String llmNumber = (String)service.get("llm");
            prompt.setServiceNumber(agent.getLlm());
            prompt.setLlmStyle(LlmStyle.parse(agent.getLlmStyle()));
            LLM llm = LLM.parse(llmNumber);
            prompt.setLlm(llm);
            prompt.setReference(false);
            if (agent.getRepoAutoCall() == 1) {
                List<Repo> list = agent.getRepoList();
                if (list != null) {
                    ArrayList<Long> repoIds = new ArrayList<Long>(list.size());
                    for (Repo repo : list) {
                        repoIds.add(repo.getId());
                    }
                    builder.append(this.retrive(repoIds, agentMessage.getUserInput(), 5));
                }
                prompt.setPrompt(builder.toString());
            }
        }
        catch (IOException e) {
            log.error(ResManager.loadKDString((String)"\u83b7\u53d6\u63d0\u793a\u8bcd\u5931\u8d25", (String)"GaiAgentReact_05", (String)"ai-gai-core", (Object[])new Object[0]));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error(ResManager.loadKDString((String)"\u83b7\u53d6\u63d0\u793a\u8bcd\u5931\u8d25", (String)"GaiAgentReact_05", (String)"ai-gai-core", (Object[])new Object[0]));
                }
            }
        }
        return prompt;
    }

    public void saveRunStepMessage(Context context, AgentCallBackMessage callBackMessage, String observation, RunStep runStep) {
        AgentMessage agentMessage = callBackMessage.getAgentMessage();
        Message message = MessageService.getMessageById(agentMessage.getMessageId());
        String chatSessionId = agentMessage.getChatSessionId();
        message.setMessageId(0L);
        message.setType(ChatMessageTypeEnum.RUNSTEP.getId());
        message.setContentTag(observation);
        message.setRunId(Long.parseLong(agentMessage.getRunId()));
        message.setRunStepId(runStep.getRunStepId());
        message.setCreateTime(KDDateUtils.now());
        if (!agentMessage.isLastMessage()) {
            Message ms = MessageService.saveJavaMessage(chatSessionId, message);
            agentMessage.setUserInput("Action_result: " + observation);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)callBackMessage.getAllThink())) {
                JSONObject think = new JSONObject();
                think.put("Thought", (Object)callBackMessage.getAllThink());
                runStep.setStepDetailsTag(think.toJSONString());
            } else {
                runStep.setStepDetailsTag(callBackMessage.getLlmValue());
            }
            if (runStep.getStepStatus() == null) {
                runStep.setStepStatus(RunStepStatusEnum.COMPLETED.getId());
            }
            runStep.setMessageId(ms.getMessageId());
            RunService.saveJavaRunStep(context, runStep);
        } else {
            agentMessage.setUserInput(observation);
        }
    }

    @Override
    public Result callback(Context context, AgentCallBackMessage callBackMessage) {
        log.info("callBackMessage:{}", (Object)JSONObject.toJSONString((Object)callBackMessage));
        String llmValue = callBackMessage.getLlmValue();
        String llmThink = callBackMessage.getLlmThink();
        String taskId = callBackMessage.getTaskId();
        AgentMessage agentMessage = callBackMessage.getAgentMessage();
        String chatSessionId = context.getChatSessionId();
        Message lastMessage = this.getLastMessge(chatSessionId, agentMessage, taskId);
        Result result = new Result();
        long assistantMessageId = agentMessage.getAssistantMessageId();
        if (callBackMessage.isStream()) {
            String cacheKey = "llmTaskLLMOutputCache_";
            String msgPushedCacheKey = "llmTaskLLMOutputCache_msgPushed_";
            String messageCacheKey = "llmTaskMessageCache_" + taskId;
            String hisMsg = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskLLMOutputCache_", taskId), String.class);
            String cacheMessages = String.format("%s%s", org.apache.commons.lang3.StringUtils.defaultString((String)hisMsg, (String)""), org.apache.commons.lang3.StringUtils.defaultString((String)callBackMessage.getLlmValue(), (String)""));
            log.info("cacheMessages: {}", (Object)cacheMessages);
            if (callBackMessage.isEnd()) {
                log.info("llmValue is end: '{}'", (Object)llmValue);
                Boolean msgPushed = (Boolean)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskLLMOutputCache_msgPushed_", taskId), Boolean.class);
                Message message = (Message)JSONObject.parseObject((String)((String)EngineCache.getAppCache(taskId).get(messageCacheKey, String.class)), Message.class);
                Message userMessage = MessageService.getLastUserMessage(chatSessionId, Long.parseLong(agentMessage.getRunId()));
                if (message != null) {
                    message.setContentTag(cacheMessages);
                    message.setEnable(userMessage.getEnable());
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)callBackMessage.getAllThink())) {
                        message.setThought(callBackMessage.getAllThink());
                    }
                    message = MessageService.saveJavaMessage(context.getChatSessionId(), message);
                    IUserFeedbackService.create().reportUserFeedback(new UserFeedbackEventParams(context.getSlideenv(), context.getChatTraceId(), context.getTraceId(), UserFeedbackTypeEnum.OK.getId(), KDDateUtils.now().getTime()));
                    Run run = RunService.getRunById(message.getRunId());
                    run.setRunStatus(RunStepStatusEnum.COMPLETED.getId());
                    RunService.saveRun(run);
                    if (msgPushed != null && msgPushed.booleanValue()) {
                        log.info("gaiMsgConfig.msgPushed:{}", (Object)msgPushed);
                        if (!this.isNeedStopMessage(chatSessionId, message, lastMessage).booleanValue()) {
                            ChatService.pushAssistantStreamMessage(context, message, llmValue, true, message.getConfigTag(), callBackMessage.getSeqNo(), callBackMessage.getTaskId());
                        }
                    } else {
                        GaiMsgConfig gaiMsgConfig = AnnotationService.parseGaiMsgConfig(cacheMessages);
                        if ((gaiMsgConfig == null || gaiMsgConfig.getNeedPushMsg().booleanValue()) && !this.isNeedStopMessage(chatSessionId, message, lastMessage).booleanValue()) {
                            ChatService.pushAssistantStreamMessage(context, message, cacheMessages, true, message.getConfigTag(), callBackMessage.getSeqNo(), callBackMessage.getTaskId());
                        }
                        EngineCache.getAppCache(taskId).remove(String.format("%s%s", "llmTaskLLMOutputCache_msgPushed_", taskId));
                    }
                }
                TraceUtil.saveIfStreamAsyncLLMLog(context, callBackMessage);
            } else {
                String runId = agentMessage.getRunId();
                if (runId != null) {
                    String messageCanceledKey = "messageCanceledKey_" + runId;
                    String messageCanceled = (String)EngineCache.getAppCache(chatSessionId).get(messageCanceledKey, String.class);
                    if (messageCanceled != null && messageCanceled.equals(RunStepStatusEnum.CANCELLED.getId())) {
                        log.info("user message cancelled : {}", (Object)taskId);
                        return result;
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)callBackMessage.getLlmThink())) {
                    PushMsgService.pushStreamThinkChat(context, callBackMessage.getTaskId(), "0", callBackMessage.getSeqNo(), callBackMessage.getLlmThink(), false, callBackMessage.getSearchInfos());
                    TraceUtil.saveIfStreamAsyncLLMLog(context, callBackMessage);
                    return result;
                }
                log.info("llmValue is not end {}", (Object)llmValue);
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)hisMsg)) {
                    Message message = ReActPlanner.createNewAssistantMessage(chatSessionId, agentMessage.getMessageId(), assistantMessageId, agentMessage.getRunId());
                    EngineCache.getAppCache(taskId).put(messageCacheKey, (Object)JSONObject.toJSONString((Object)message));
                }
                boolean msgPushed = true;
                if (org.apache.commons.lang3.StringUtils.startsWithIgnoreCase((CharSequence)cacheMessages, (CharSequence)"[")) {
                    log.info("msgPushed:{}", (Object)false);
                    TraceUtil.saveIfStreamAsyncLLMLog(context, callBackMessage);
                    msgPushed = false;
                    EngineCache.getAppCache(taskId).put(String.format("%s%s", "llmTaskLLMOutputCache_msgPushed_", taskId), (Object)msgPushed);
                    return result;
                }
                EngineCache.getAppCache(taskId).put(String.format("%s%s", "llmTaskLLMOutputCache_msgPushed_", taskId), (Object)msgPushed);
                Message message = (Message)JSONObject.parseObject((String)((String)EngineCache.getAppCache(taskId).get(messageCacheKey, String.class)), Message.class);
                message.setContentTag(cacheMessages);
                EngineCache.getAppCache(taskId).put(messageCacheKey, (Object)JSONObject.toJSONString((Object)message));
                if (!this.isNeedStopMessage(chatSessionId, message, lastMessage).booleanValue()) {
                    ChatService.pushAssistantStreamMessage(context, message, llmValue, false, message.getConfigTag(), callBackMessage.getSeqNo(), callBackMessage.getTaskId());
                }
                TraceUtil.saveIfStreamAsyncLLMLog(context, callBackMessage);
            }
        } else {
            TraceUtil.saveIfStreamAsyncLLMLog(context, callBackMessage);
            ReActJsonOutputParser parser = new ReActJsonOutputParser();
            RunStep runStep = new RunStep();
            runStep.setRunId(Long.parseLong(agentMessage.getRunId()));
            try {
                AgentResult agentResult;
                if (agentMessage.isLastMessage()) {
                    agentResult = new AgentFinish(callBackMessage.getLlmValue(), callBackMessage.getLlmValue());
                } else {
                    agentResult = parser.parse(callBackMessage.getLlmValue());
                    String observation = null;
                    if (agentResult instanceof AgentAction) {
                        AgentAction action = (AgentAction)agentResult;
                        String lastThought = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "thoughtKey_", agentMessage.getRunId()), String.class);
                        if (action.getName().equalsIgnoreCase("#summary#")) {
                            agentMessage.setLastMessage(true);
                            agentMessage.setStream(true);
                            observation = agentMessage.getRawUserInput();
                            String desc = ResManager.loadKDString((String)"\u4f60\u662f\u4e00\u4e2a\u603b\u7ed3\u52a9\u624b\uff0c\u53ef\u4ee5\u6839\u636e\u89d2\u8272\u4e0e\u4efb\u52a1\u8bbe\u5b9a\uff0c\u4ee5\u53ca\u4f1a\u8bdd\u8bb0\u5f55\u7684\u603b\u7ed3\u56de\u7b54\u7528\u6237\u63d0\u95ee\u3002\r\n========= \u89d2\u8272\u4e0e\u4efb\u52a1\u8bbe\u5b9a =========\r\n", (String)"GaiAgentReact_06", (String)"ai-gai-core", (Object[])new Object[0]);
                            String roleDesc = agentMessage.getAgent().getRoleDescTag() + "\r\n";
                            observation = desc + roleDesc + ResManager.loadKDString((String)"\u7528\u6237\u63d0\u95ee:", (String)"GaiAgentReact_07", (String)"ai-gai-core", (Object[])new Object[0]) + observation + "\r\n";
                            observation = observation + ResManager.loadKDString((String)"\u52a9\u624b\u56de\u7b54\uff1a", (String)"GaiAgentReact_08", (String)"ai-gai-core", (Object[])new Object[0]);
                            this.saveRunStepMessage(context, callBackMessage, observation != null ? observation : "", runStep);
                            PushMsgService.pushStreamDown(context, agentMessage.getRunId(), "0", "", "", agentMessage.getRunId());
                        } else if (lastThought != null && lastThought.equals(action.getThought())) {
                            observation = ResManager.loadKDString((String)"\u8bf7\u5bf9\u4ee5\u4e0a\u5185\u5bb9\u8fdb\u884c\u603b\u7ed3", (String)"GaiAgentReact_09", (String)"ai-gai-core", (Object[])new Object[0]);
                        } else {
                            String messageCanceled;
                            String messageCanceledKey;
                            EngineCache.getAppCache(taskId).put(String.format("%s%s", "thoughtKey_", agentMessage.getRunId()), (Object)action.getThought());
                            Long runStepId = ID.genLongId();
                            runStep.setRunStepId(runStepId);
                            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)callBackMessage.getAllThink())) {
                                JSONObject think = new JSONObject();
                                think.put("Thought", (Object)callBackMessage.getAllThink());
                                runStep.setStepDetailsTag(think.toJSONString());
                            } else {
                                runStep.setStepDetailsTag(callBackMessage.getLlmValue());
                            }
                            RunService.pushRunStepThoughtMessage(chatSessionId, context, runStep.getRunId(), runStep);
                            observation = this.performAgentAction(context, callBackMessage.getAgentMessage(), action, runStep);
                            if (observation != null && observation.equals("failed")) {
                                runStep.setStepStatus(RunStepStatusEnum.FAILED.getId());
                                RunService.pushRunStepResultMessage(context, runStep);
                                PushMsgService.pushStreamDown(context, agentMessage.getRunId(), "0", "", "", agentMessage.getRunId());
                                PushMsgService.pushWaitingDone(context, 0L, agentMessage.getRunId());
                                return result;
                            }
                            String runId = agentMessage.getRunId();
                            if (runId != null) {
                                messageCanceledKey = "messageCanceledKey_" + runId;
                                messageCanceled = (String)EngineCache.getAppCache(chatSessionId).get(messageCanceledKey, String.class);
                                if (messageCanceled != null && messageCanceled.equals(RunStepStatusEnum.CANCELLED.getId())) {
                                    runStep.setStepStatus(RunStepStatusEnum.CANCELLED.getId());
                                }
                            }
                            this.saveRunStepMessage(context, callBackMessage, observation != null && !observation.equals("process") ? observation : "", runStep);
                            if (runId != null) {
                                messageCanceledKey = "messageCanceledKey_" + runId;
                                messageCanceled = (String)EngineCache.getAppCache(chatSessionId).get(messageCanceledKey, String.class);
                                if (messageCanceled != null && messageCanceled.equals(RunStepStatusEnum.CANCELLED.getId())) {
                                    runStep.setStepStatus(RunStepStatusEnum.CANCELLED.getId());
                                    RunService.pushRunStepResultMessage(context, runStep);
                                    ChatHistoryService.save(chatSessionId, 2108085560353502208L, Collections.singletonList(new ChatItem(0, agentMessage.getUserInput())));
                                    PushMsgService.pushStreamDown(context, agentMessage.getRunId(), "0", "", "", agentMessage.getRunId());
                                    PushMsgService.pushWaitingDone(context, 0L, agentMessage.getRunId());
                                    return result;
                                }
                                RunService.pushRunStepResultMessage(context, runStep);
                            }
                        }
                        log.info("\u5de5\u5177\u8c03\u7528\u7ed3\u679c {}", (Object)observation);
                    }
                }
                if (agentResult instanceof AgentFinish) {
                    String outPut = ((AgentFinish)agentResult).getOutput();
                    Message message = MessageService.getMessageById(agentMessage.getMessageId());
                    message.setMessageId(assistantMessageId);
                    message.setType(ChatMessageTypeEnum.ASSISTANT.getId());
                    message.setContentTag(outPut);
                    message.setRunId(Long.parseLong(agentMessage.getRunId()));
                    message.setCreateTime(KDDateUtils.now());
                    MessageService.saveJavaMessage(chatSessionId, message);
                    GaiMsgConfig gaiMsgConfig = AnnotationService.parseGaiMsgConfig(lastMessage.getContentTag());
                    if (gaiMsgConfig != null && !gaiMsgConfig.getNeedPushMsg().booleanValue()) {
                        message.setEnable(EnableEnum.NO.getKeyStr());
                        MessageService.saveJavaMessage(chatSessionId, message);
                        return result;
                    }
                    ChatService.pushUserOrAssistantMessage(context, message);
                    return result;
                }
                if (this.shouldBeContinue(context, agentMessage)) {
                    result = HandlerFactory.runHandler(context, agentMessage);
                    result.setCallback(true);
                } else {
                    ChatHistoryService.save(chatSessionId, 2108085560353502208L, Collections.singletonList(new ChatItem(0, agentMessage.getUserInput())));
                    PushMsgService.pushStreamDown(context, agentMessage.getRunId(), "0", "", "", agentMessage.getRunId());
                    PushMsgService.pushWaitingDone(context, 0L, agentMessage.getRunId());
                }
            }
            catch (KDBizException exp) {
                log.error(exp.getMessage(), (Throwable)exp);
                FlowErrorMessage message = new FlowErrorMessage();
                message.setErrorCode(new ErrorCode("-1", exp.getMessage() + callBackMessage.getErrCode()));
                message.setFlowId(0L);
                message.setChatSessionId(context.getChatSessionId());
                HandlerFactory.runHandler(FlowCacheData.getContext(context.getChatSessionId()), message);
                TraceUtil.saveAsyncLLMLog(context, callBackMessage);
            }
        }
        return result;
    }

    @Override
    public String performAgentAction(Context context, AgentMessage agentMessage, AgentAction action, RunStep runStep) {
        Agent agent;
        String chatSessionId = context.getChatSessionId();
        BaseResult baseResult = ToolService.functionCall(chatSessionId, agent = AgentService.getAgent(agentMessage.getAgent().getAgentId(), true), action, runStep);
        if (baseResult != null) {
            if (baseResult.getErrCode().equals("0")) {
                if (baseResult.getData() == null) {
                    if (runStep.getAgentSkillType().equalsIgnoreCase("process")) {
                        return "process";
                    }
                    return "";
                }
                if (baseResult.getData().toString().length() > 0) {
                    return baseResult.getData().toString();
                }
                return baseResult.getErrMsg();
            }
            if (baseResult.getErrCode().equals("-1")) {
                if (runStep.getAgentSkillType().equalsIgnoreCase("process")) {
                    return "failed";
                }
            } else if (baseResult.getErrCode().equals("cancell")) {
                if (runStep.getAgentSkillType().equalsIgnoreCase("process")) {
                    runStep.setStepStatus(RunStepStatusEnum.CANCELLED.getId());
                }
            } else {
                return baseResult.getErrMsg();
            }
        }
        return null;
    }
}

