/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.agent.tool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.agent.tool.model.OperationParam;
import kd.ai.gai.core.agent.tool.openapi.v3.models.MediaType;
import kd.ai.gai.core.agent.tool.openapi.v3.models.OpenAPI;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Operation;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Parameter;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Path;
import kd.ai.gai.core.agent.tool.openapi.v3.models.RequestBody;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Schema;
import kd.ai.gai.core.agent.tool.util.CosmicOpenAPIUtils;
import kd.ai.gai.core.agent.tool.util.OpenAPIProtocolUtils;
import kd.ai.gai.core.agent.tool.util.OpenAPIUtils;
import kd.ai.gai.core.domain.dto.agent.Agent;
import kd.ai.gai.core.domain.dto.agent.BaseAPI;
import kd.ai.gai.core.domain.dto.agent.CosmicAction;
import kd.ai.gai.core.domain.dto.agent.CosmicOpenAPI;
import kd.ai.gai.core.domain.dto.agent.CosmicOpenAPIInfo;
import kd.ai.gai.core.domain.dto.agent.CosmicOpenAPIParam;
import kd.ai.gai.core.domain.dto.agent.GptPrompt;
import kd.ai.gai.core.domain.dto.agent.MCPTool;
import kd.ai.gai.core.domain.dto.agent.OpenApi;
import kd.ai.gai.core.domain.dto.agent.Process;
import kd.ai.gai.core.domain.dto.agent.Prompt;
import kd.ai.gai.core.domain.dto.agent.Repo;
import kd.ai.gai.core.domain.dto.agent.RestfulAPI;
import kd.ai.gai.core.domain.dto.agent.RunStep;
import kd.ai.gai.core.domain.dto.agent.RunStepMessage;
import kd.ai.gai.core.domain.dto.agent.ThirdOpenAPI;
import kd.ai.gai.core.domain.dto.agent.Tool;
import kd.ai.gai.core.domain.dto.agent.VarParam;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.agent.plan.AgentCommonService;
import kd.ai.gai.core.engine.agent.result.AgentAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.ResultActionType;
import kd.ai.gai.core.enuz.agent.AgentSkillTypeEnum;
import kd.ai.gai.core.enuz.agent.RunStepStatusEnum;
import kd.ai.gai.core.helper.ProcessHelper;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.agent.CosmicActionService;
import kd.ai.gai.core.service.agent.CosmicOpenAPIService;
import kd.ai.gai.core.service.agent.GPTPromptService;
import kd.ai.gai.core.service.agent.MCPService;
import kd.ai.gai.core.service.agent.OpenAPIService;
import kd.ai.gai.core.service.agent.RestfulAPIService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.ai.gai.core.util.StrUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.service.KDDateFormatUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolService {
    public static final String SPLITTAG = "&";
    public static final String CHARACTERS = "characters";
    private static final Log logger = LogFactory.getLog(ToolService.class);
    private static final Logger log = LoggerFactory.getLogger(ToolService.class);

    public static BaseResult promptFunction(String chatSessionId, Agent agent, AgentAction action, RunStep runStep) {
        List<Prompt> promptList = agent.getPromptList();
        String actionName = (String)EngineCache.getAppCache(chatSessionId).get(action.getName(), String.class);
        logger.info("actionName:{}", (Object)actionName);
        logger.info("action:{}", (Object)action.toString());
        if (promptList != null) {
            for (Prompt prompt : promptList) {
                String promptNumber = actionName.split(SPLITTAG)[1].trim();
                String promptName = actionName.split(SPLITTAG)[0].trim();
                runStep.setType(prompt.getName());
                if ((!StrUtils.isLong(promptNumber) || prompt.getId() != Long.parseLong(promptNumber)) && !promptName.equalsIgnoreCase(prompt.getNumber())) continue;
                GptPrompt gptPrompt = new GptPrompt();
                gptPrompt.setPromptId(prompt.getId());
                Map<String, Object> param = action.getInputs();
                if (param.size() > 0) {
                    String input = "";
                    input = param.get("input") == null ? "" : (String)param.get("input");
                    gptPrompt.setInput(input);
                    HashMap<String, String> varParam = new HashMap<String, String>();
                    param.forEach((key, value) -> {
                        if (!key.equals("input")) {
                            varParam.put((String)key, String.valueOf(value));
                        }
                    });
                    gptPrompt.setVarParams(varParam);
                }
                BaseResult gr = GPTPromptService.syncCall(gptPrompt, chatSessionId);
                return gr;
            }
        }
        return null;
    }

    public static BaseResult processFunction(String chatSessionId, Agent agent, AgentAction action, RunStep runStep) {
        List<Process> processList = agent.getProcessList();
        String actionName = (String)EngineCache.getAppCache(chatSessionId).get(action.getName(), String.class);
        logger.info("actionName:{}", (Object)actionName);
        try {
            if (processList != null) {
                for (Process process : processList) {
                    String processNumber = actionName.split(SPLITTAG)[1].trim();
                    String processName = actionName.split(SPLITTAG)[0].trim();
                    runStep.setType(process.getName());
                    if ((!StrUtils.isLong(processNumber) || process.getId() != Long.parseLong(processNumber)) && !processName.equalsIgnoreCase(process.getNumber())) continue;
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    Map<String, Object> param = action.getInputs();
                    String userInput = "";
                    if (param.size() > 0) {
                        userInput = (String)param.get("input");
                    }
                    for (Map.Entry<String, Object> entry : param.entrySet()) {
                        map.put(entry.getKey(), (String)entry.getValue());
                    }
                    long st = System.currentTimeMillis();
                    map.put("chatSessionId", chatSessionId);
                    map.put("system.runStepId", String.valueOf(runStep.getRunStepId()));
                    map.put("asTool", String.valueOf(true));
                    Context context = FlowCacheData.getContext(chatSessionId);
                    RunStepMessage runStepMessage = new RunStepMessage();
                    String stepType = runStep.getType();
                    runStepMessage.setId(chatSessionId);
                    runStepMessage.setStepType(stepType);
                    runStepMessage.setStepTypeName(stepType);
                    runStepMessage.setRunId(StrUtils.longAsString(runStep.getRunId()));
                    runStepMessage.setRunStepId(StrUtils.longAsString(runStep.getRunStepId()));
                    runStepMessage.setTaskId(StrUtils.longAsString(runStep.getRunId()));
                    runStepMessage.setType(ChatMessageTypeEnum.RUNSTEP.getId());
                    runStepMessage.setStream(Boolean.FALSE);
                    runStepMessage.setId(chatSessionId);
                    runStepMessage.setStepStatus(RunStepStatusEnum.IN_PROGRESS.getId());
                    runStepMessage.setAgentSkillType(AgentSkillTypeEnum.PROCESS.getId());
                    PushMsgService.pushResult(context, ResultActionType.runStepChat.name(), runStepMessage);
                    Result result = ProcessHelper.agentCallProcess(process.getId(), userInput, map);
                    long et = System.currentTimeMillis();
                    logger.info("ProcessSyncCall end: {}, cost:{} ms, result:{}", new Object[]{KDDateFormatUtils.getDateTimeFormat().format(new Date(et)), et - st, JSONObject.toJSONString((Object)result)});
                    if (result.getErrorCode().equals((Object)Errors.OK)) {
                        BaseResult br = new BaseResult(result.getData());
                        br.setErrCode(result.getErrorCode().getCode());
                        br.setErrMsg(result.getErrorCode().getMessage());
                        return br;
                    }
                    if (result.getErrorCode().getCode().equals("cancell")) {
                        BaseResult br = new BaseResult(result.getData());
                        br.setErrCode("cancell");
                        br.setErrMsg(result.getErrorCode().getMessage());
                        return br;
                    }
                    logger.error("processFunction error");
                    BaseResult br = new BaseResult();
                    br.setErrCode("-1");
                    br.setData(null);
                    return br;
                }
            }
        }
        catch (Exception e) {
            logger.error("processFunction error:{}", (Object)e.getMessage());
            BaseResult br = new BaseResult();
            br.setErrCode("-1");
            br.setData(null);
            return br;
        }
        return null;
    }

    public static String genFunctionName(int length) {
        StringBuilder functionName = new StringBuilder(length);
        functionName.append("func_");
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(CHARACTERS.length());
            functionName.append(CHARACTERS.charAt(index));
        }
        if (Character.isDigit(functionName.charAt(0))) {
            functionName.setCharAt(0, CHARACTERS.charAt(random.nextInt(26) + 26));
        }
        return functionName.toString();
    }

    public static BaseResult functionCall(String chatSessionId, Agent agent, AgentAction action, RunStep runStep) {
        try {
            String toolType = (String)EngineCache.getAppCache(chatSessionId).get(String.format("%s%s%s", chatSessionId, "_", action.getName()), String.class);
            runStep.setAgentSkillType(toolType);
            logger.info("action:{}", (Object)action.toString());
            switch (AgentSkillTypeEnum.valueOf(toolType.toUpperCase(Locale.ENGLISH))) {
                case TOOL: {
                    return ToolService.toolFunction(chatSessionId, agent, action, runStep);
                }
                case PROMPT: {
                    return ToolService.promptFunction(chatSessionId, agent, action, runStep);
                }
                case RAG: {
                    return ToolService.ragFunction(chatSessionId, agent, action, runStep);
                }
                case PROCESS: {
                    return ToolService.processFunction(chatSessionId, agent, action, runStep);
                }
                case OPENAPI: {
                    return ToolService.openApiFunction(chatSessionId, agent, action, runStep);
                }
            }
            return null;
        }
        catch (Exception e) {
            logger.error(ResManager.loadKDString((String)"\u8c03\u7528\u5de5\u5177\u5931\u8d25:{}", (String)"GaiAgentReact_12", (String)"ai-gai-core", (Object[])new Object[0]), (Object)e.getMessage());
            return null;
        }
    }

    public static BaseResult openApiFunction(String chatSessionId, Agent agent, AgentAction action, RunStep runStep) {
        List<OpenApi> openApiList = agent.getOpenApiList();
        String actionName = (String)EngineCache.getAppCache(chatSessionId).get(action.getName(), String.class);
        logger.info("actionName:{},action:{}", (Object)actionName, (Object)action.toString());
        if (openApiList != null) {
            for (OpenApi openApi : openApiList) {
                String openApiNumber = actionName.split(SPLITTAG)[1].trim();
                String openApiName = actionName.split(SPLITTAG)[0].trim();
                runStep.setType(openApi.getName());
                if ((!StrUtils.isLong(openApiNumber) || openApi.getId() != Long.parseLong(openApiNumber)) && !openApiName.equalsIgnoreCase(openApi.getName())) continue;
                Map<String, Object> param = action.getInputs();
                if (param == null) {
                    param = new HashMap<String, Object>();
                }
                if (!param.containsKey("pageSize")) {
                    param.put("pageSize", 10);
                }
                log.info("openApiFunction data:{}", (Object)JSONObject.toJSONString((Object)param.get("data")));
                param.put("optionvariables", ImmutableMap.builder().put((Object)"mutex_ignoremodify", (Object)"true").put((Object)"isStrict", (Object)"false").put((Object)"ignoreValidation", (Object)"true").build());
                log.info("openApiFunction param:{}", (Object)JSONObject.toJSONString(param));
                HashMap<String, String> header = new HashMap<String, String>(0);
                CosmicOpenAPI api = new CosmicOpenAPI(openApi.getId(), param, header);
                long start = System.currentTimeMillis();
                OpenApiResult result = CosmicOpenAPIService.getService().call(api);
                BaseResult br = new BaseResult(result.getData() != null ? JSONObject.toJSONString((Object)result.getData()) : "");
                br.setErrCode(result.getErrorCode());
                br.setErrMsg(result.getMessage());
                long end = System.currentTimeMillis();
                TraceUtil.saveAgentCallToolLog(chatSessionId, runStep.getRunId(), openApi.getId(), openApi.getName(), JSONObject.toJSONString(param), JSONObject.toJSONString((Object)result), start, end);
                return br;
            }
        }
        return null;
    }

    public static BaseResult toolFunction(String chatSessionId, Agent agent, AgentAction action, RunStep runStep) {
        String acNmae;
        List<Tool> toolList = agent.getToolList();
        String actionName = acNmae = (String)EngineCache.getAppCache(chatSessionId).get(action.getName(), String.class);
        String[] splits = actionName.split(SPLITTAG);
        logger.info("toolFunction actionName:{}, toolList:{}", (Object)actionName, (Object)JSONObject.toJSONString(toolList));
        boolean flag = false;
        if (toolList != null) {
            for (Tool tool : toolList) {
                Serializable api;
                JSONObject congfitTag;
                String name = tool.getName();
                runStep.setType(name);
                String type = tool.getType();
                String toolNumber = "";
                String operationId = "";
                String operationName = "";
                if (splits.length == 2) {
                    toolNumber = actionName.split(SPLITTAG)[1].trim();
                    operationId = actionName.split(SPLITTAG)[0].trim();
                    logger.info("toolNumber:{},operationId:{},operationName{},name{}", new Object[]{toolNumber, operationId, operationName, name});
                } else {
                    toolNumber = actionName;
                }
                logger.info("action:{},toolNumber:{},operationId:{}", new Object[]{action.getName(), toolNumber, operationId});
                if (!toolNumber.equals(tool.getNumber())) continue;
                block1: for (Tool toolDo : agent.getToolList()) {
                    JSONObject jsonObject;
                    if (toolDo.getId() != tool.getId() || !toolNumber.equalsIgnoreCase(toolDo.getNumber()) || (jsonObject = JSON.parseObject((String)toolDo.getSelected())) == null || jsonObject.size() <= 0) continue;
                    for (String key : jsonObject.keySet()) {
                        Object operationIds;
                        if (!key.equals("operations") || !((operationIds = jsonObject.getString("operations")) != null & ((String)operationIds).length() > 0) || !((String)operationIds).equalsIgnoreCase(operationId)) continue;
                        operationName = jsonObject.getString("operationName");
                        runStep.setType(name + "|" + operationName);
                        continue block1;
                    }
                }
                Map<String, Object> params = action.getInputs();
                if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)ToolConstant.ToolType.THIRD_OPENAPI.getType()) || StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)ToolConstant.ToolType.COSMIC_OPENAPI.getType())) {
                    Map<String, Path> pathMap;
                    congfitTag = tool.getConfigTag();
                    String swagger = congfitTag.getString("swaggerSchema");
                    OpenAPI openAPI = OpenAPIUtils.parserSwaggerConfig(swagger);
                    if (openAPI != null && (pathMap = openAPI.getPaths()) != null) {
                        for (Map.Entry<String, Path> entry : pathMap.entrySet()) {
                            Path path = entry.getValue();
                            if (path == null) continue;
                            Operation operation = path.getGet();
                            if (operation != null && operation.getOperationId().equals(operationId)) {
                                flag = false;
                                break;
                            }
                            Operation postOp = path.getPost();
                            if (postOp == null || !postOp.getOperationId().equals(operationId)) continue;
                            flag = true;
                            break;
                        }
                    }
                    ThirdOpenAPI api2 = new ThirdOpenAPI();
                    JSONObject body = new JSONObject();
                    JSONArray getParameters = new JSONArray();
                    for (Map.Entry entry : params.entrySet()) {
                        body.put((String)entry.getKey(), entry.getValue());
                        JSONObject json = new JSONObject();
                        json.put("name", entry.getKey());
                        json.put("value", entry.getValue());
                        getParameters.add((Object)json);
                    }
                    JSONObject toolParams = new JSONObject();
                    toolParams.put("operationId", (Object)operationId);
                    JSONArray jSONArray = new JSONArray();
                    toolParams.put("parameters", (Object)jSONArray);
                    if (flag) {
                        JSONObject requestBody = new JSONObject();
                        requestBody.put("contentType", (Object)"application/json");
                        requestBody.put("body", (Object)JSONObject.toJSONString((Object)body));
                        toolParams.put("requestBody", (Object)requestBody);
                    } else {
                        jSONArray.addAll((Collection)getParameters);
                    }
                    api2.setToolParams(toolParams);
                    api2.setToolId(tool.getId());
                    api2.setChatSessionId(chatSessionId);
                    api2.setRunId(runStep.getRunId());
                    logger.info("tool function api:{}", (Object)JSONObject.toJSONString((Object)api2));
                    long start = System.currentTimeMillis();
                    BaseResult result = OpenAPIService.getService().call(api2);
                    long end = System.currentTimeMillis();
                    String output = "";
                    if (result != null && result.getData() != null && result.getDataAsJSONObject() != null) {
                        output = result.getDataAsJSONObject().getString("output");
                        result.setData(output);
                    }
                    TraceUtil.saveAgentCallToolLog(chatSessionId, runStep.getRunId(), tool.getId(), tool.getName(), JSONObject.toJSONString((Object)toolParams), output, start, end);
                    return result;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)ToolConstant.ToolType.RESTFUL_API.getType())) {
                    congfitTag = tool.getConfigTag();
                    Map<String, OperationParam> operationParamMap = OpenAPIUtils.parserRestfulOperationParam(congfitTag, new String[0]);
                    OperationParam operationParam = operationParamMap.get(operationId);
                    List<Parameter> listParameter = operationParam.getParameters();
                    if (operationParam.getMethod().equalsIgnoreCase("post")) {
                        flag = true;
                    }
                    api = new RestfulAPI();
                    JSONObject body = new JSONObject();
                    JSONArray getParameters = new JSONArray();
                    for (Map.Entry<String, Object> entry : params.entrySet()) {
                        body.put(entry.getKey(), entry.getValue());
                        JSONObject json = new JSONObject();
                        json.put("name", (Object)entry.getKey());
                        json.put("value", entry.getValue());
                        getParameters.add((Object)json);
                    }
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("operationId", (Object)operationId);
                    JSONArray parameters = new JSONArray();
                    jSONObject.put("parameters", (Object)parameters);
                    if (flag) {
                        JSONObject requestBody = new JSONObject();
                        requestBody.put("contentType", (Object)"application/json");
                        requestBody.put("body", (Object)JSONObject.toJSONString((Object)body));
                        jSONObject.put("requestBody", (Object)requestBody);
                    } else {
                        parameters.addAll((Collection)getParameters);
                    }
                    ((BaseAPI)api).setToolParams(jSONObject);
                    ((BaseAPI)api).setToolId(tool.getId());
                    ((BaseAPI)api).setChatSessionId(chatSessionId);
                    ((BaseAPI)api).setRunId(runStep.getRunId());
                    logger.info("tool function api:{}", (Object)JSONObject.toJSONString((Object)api));
                    long start = System.currentTimeMillis();
                    BaseResult result = RestfulAPIService.getService().call((RestfulAPI)api);
                    long end = System.currentTimeMillis();
                    TraceUtil.saveAgentCallToolLog(chatSessionId, runStep.getRunId(), tool.getId(), tool.getName(), JSONObject.toJSONString((Object)jSONObject), JSONObject.toJSONString((Object)result.getData()), start, end);
                    return result;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)ToolConstant.ToolType.MCP_TOOL.getType())) {
                    congfitTag = tool.getConfigTag();
                    MCPTool mcpTool = new MCPTool();
                    JSONObject toolParams = new JSONObject();
                    toolParams.put("operationId", (Object)operationId);
                    toolParams.put("parameters", params);
                    mcpTool.setToolId(tool.getId());
                    mcpTool.setToolParams(toolParams);
                    mcpTool.setChatSessionId(chatSessionId);
                    mcpTool.setRunId(runStep.getRunId());
                    logger.info("mcp operationId:{}", (Object)operationId);
                    logger.info("tool function api.mcpTool:{}, configTag:{}", (Object)JSONObject.toJSONString((Object)mcpTool), (Object)JSONObject.toJSONString((Object)congfitTag));
                    long start = System.currentTimeMillis();
                    BaseResult result = MCPService.getService().callApi(congfitTag.toJSONString(), mcpTool);
                    logger.info("mcp toolCallResult:{}", (Object)JSONObject.toJSONString((Object)result));
                    long end = System.currentTimeMillis();
                    TraceUtil.saveAgentCallToolLog(chatSessionId, runStep.getRunId(), tool.getId(), tool.getName(), JSONObject.toJSONString((Object)toolParams), JSONObject.toJSONString((Object)result.getData()), start, end);
                    return result;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)ToolConstant.ToolType.INTERNAL_MCP.getType())) {
                    logger.info("actionName:{},action:{}", (Object)actionName, (Object)action.toString());
                    Long apiId = Long.parseLong(operationId);
                    CosmicOpenAPIInfo openApi = CosmicOpenAPIUtils.parserCosmicOpenAPIInfo(apiId);
                    runStep.setType(openApi.getName());
                    Map<String, Object> param = action.getInputs();
                    if (param == null) {
                        param = new HashMap<String, Object>();
                    }
                    if (!param.containsKey("pageSize")) {
                        param.put("pageSize", 10);
                    }
                    log.info("openApiFunction data:{}", (Object)JSONObject.toJSONString((Object)param.get("data")));
                    param.put("optionvariables", ImmutableMap.builder().put((Object)"mutex_ignoremodify", (Object)"true").put((Object)"isStrict", (Object)"false").put((Object)"ignoreValidation", (Object)"true").build());
                    log.info("openApiFunction param:{}", (Object)JSONObject.toJSONString(param));
                    HashMap header = new HashMap(0);
                    api = new CosmicOpenAPI(apiId, param, header);
                    long start = System.currentTimeMillis();
                    OpenApiResult openApiResult = CosmicOpenAPIService.getService().call((CosmicOpenAPI)api);
                    BaseResult br = new BaseResult(openApiResult.getData() != null ? JSONObject.toJSONString((Object)openApiResult.getData()) : "");
                    br.setErrCode(openApiResult.getErrorCode());
                    br.setErrMsg(openApiResult.getMessage());
                    long end = System.currentTimeMillis();
                    TraceUtil.saveAgentCallToolLog(chatSessionId, runStep.getRunId(), apiId, openApi.getName(), JSONObject.toJSONString(param), JSONObject.toJSONString((Object)openApiResult), start, end);
                    return br;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)ToolConstant.ToolType.COSMIC_ACTION.getType())) continue;
                CosmicAction cosmicAction = new CosmicAction();
                cosmicAction.setToolId(tool.getId());
                cosmicAction.setChatSessionId(chatSessionId);
                JSONObject toolParams = new JSONObject();
                cosmicAction.setToolParams(toolParams);
                cosmicAction.setRunId(runStep.getRunId());
                cosmicAction.setRunStepId(runStep.getRunStepId());
                JSONArray inputParams = new JSONArray();
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    JSONObject param = new JSONObject();
                    param.put("paramName", (Object)entry.getKey());
                    param.put("paramValue", entry.getValue());
                    inputParams.add((Object)param);
                }
                toolParams.put("inputParams", (Object)inputParams);
                long start = System.currentTimeMillis();
                BaseResult br = CosmicActionService.call(cosmicAction);
                long end = System.currentTimeMillis();
                JSONObject output = null;
                if (br != null && br.getData() != null && br.getDataAsJSONObject() != null) {
                    output = br.getDataAsJSONObject().getJSONObject("output");
                    br.setData(output);
                }
                TraceUtil.saveAgentCallToolLog(chatSessionId, runStep.getRunId(), tool.getId(), tool.getName(), JSONObject.toJSONString((Object)toolParams), JSONObject.toJSONString((Object)output), start, end);
                return br;
            }
        }
        return null;
    }

    public static BaseResult ragFunction(String chatSessionId, Agent agent, AgentAction action, RunStep runStep) {
        List<Repo> repoList = agent.getRepoList();
        String actionName = (String)EngineCache.getAppCache(chatSessionId).get(action.getName(), String.class);
        logger.info("actionName:{}", (Object)actionName);
        if (repoList != null) {
            for (Repo repo : repoList) {
                String ragNumber = actionName.split(SPLITTAG)[1].trim();
                String name = actionName.split(SPLITTAG)[0].trim();
                ragNumber = actionName.split(SPLITTAG)[1].trim();
                name = actionName.split(SPLITTAG)[0].trim();
                runStep.setType(repo.getName());
                logger.info("ragNumber:{},repo.getId:{},name:{},getNumber:{}", new Object[]{ragNumber, repo.getId(), name, repo.getNumber()});
                if ((!StrUtils.isLong(ragNumber) || repo.getId() != Long.parseLong(ragNumber)) && !name.equalsIgnoreCase(repo.getNumber())) continue;
                Map<String, Object> params = action.getInputs();
                AgentCommonService agentCommonService = new AgentCommonService();
                ArrayList<Long> repos = new ArrayList<Long>(2);
                repos.add(Long.parseLong(ragNumber));
                List<String> retrievalResult = agentCommonService.retrive(repos, params.get("text").toString(), 10);
                return new BaseResult(retrievalResult);
            }
        }
        return null;
    }

    public static JSONArray processToFunction(String chatSessionId, List<Process> processList, JSONArray functionTools) {
        JSONArray prmptArray = new JSONArray();
        if (processList != null) {
            for (Process process : processList) {
                String name = process.getName();
                String flowBase64Str = process.getFflow();
                Flow flow = JsonUtil.fromBase64String(flowBase64Str);
                List<Var> vars = flow.getStart().getInputVars();
                Long id = process.getId();
                String desc = process.getDescription();
                JSONObject processJo = new JSONObject();
                prmptArray.add((Object)processJo);
                String functionName = process.getNumber() + SPLITTAG + id;
                JSONObject functionToolJo = new JSONObject();
                String function = "";
                if (functionTools != null) {
                    functionTools.add((Object)functionToolJo);
                    function = ToolService.genFunctionName(8);
                } else {
                    function = name;
                }
                EngineCache.getAppCache(chatSessionId).put(function, (Object)functionName);
                EngineCache.getAppCache(chatSessionId).put(String.format("%s%s%s", chatSessionId, "_", function), (Object)AgentSkillTypeEnum.PROCESS.getId());
                processJo.put("name", (Object)function);
                if (desc == null || desc.length() == 0) {
                    desc = name;
                }
                processJo.put("desc", (Object)desc);
                JSONArray paramJsonArray = new JSONArray();
                processJo.put("param", (Object)paramJsonArray);
                functionToolJo.put("name", (Object)function);
                functionToolJo.put("description", (Object)desc);
                JSONObject properties = new JSONObject();
                JSONObject functionPrameters = new JSONObject();
                functionPrameters.put("type", (Object)"object");
                functionToolJo.put("parameters", (Object)functionPrameters);
                functionPrameters.put("properties", (Object)properties);
                for (Var var : vars) {
                    if (var.getName().startsWith("system") && !var.getName().equals("system.user_input")) continue;
                    if (var.getName().equals("system.user_input")) {
                        var.setName("input");
                    }
                    JSONObject param = new JSONObject();
                    param.put("type", (Object)var.getType());
                    param.put("desc", (Object)var.getDesc());
                    JSONObject paramStr = new JSONObject();
                    paramStr.put(var.getName(), (Object)param);
                    properties.put(var.getName(), (Object)paramStr);
                    paramJsonArray.add((Object)paramStr);
                }
            }
        }
        return prmptArray;
    }

    public static JSONArray promtToFunction(String chatSessionId, List<Prompt> promptList, JSONArray functionTools) {
        JSONArray prmptArray = new JSONArray();
        if (promptList != null) {
            for (Prompt prompt : promptList) {
                String name = prompt.getName();
                Long id = prompt.getId();
                String desc = prompt.getDescription();
                JSONObject promptJo = new JSONObject();
                prmptArray.add((Object)promptJo);
                String functionName = prompt.getNumber() + SPLITTAG + id;
                JSONObject functionToolJo = new JSONObject();
                String function = "";
                if (functionTools != null) {
                    functionTools.add((Object)functionToolJo);
                    function = ToolService.genFunctionName(8);
                } else {
                    function = name;
                }
                EngineCache.getAppCache(chatSessionId).put(function, (Object)functionName);
                EngineCache.getAppCache(chatSessionId).put(String.format("%s%s%s", chatSessionId, "_", function), (Object)AgentSkillTypeEnum.PROMPT.getId());
                promptJo.put("name", (Object)function);
                if (desc == null || desc.length() == 0) {
                    desc = name;
                }
                promptJo.put("desc", (Object)desc);
                JSONArray paramJsonArray = new JSONArray();
                promptJo.put("param", (Object)paramJsonArray);
                functionToolJo.put("name", (Object)function);
                functionToolJo.put("description", (Object)desc);
                JSONObject properties = new JSONObject();
                JSONObject functionPrameters = new JSONObject();
                functionPrameters.put("type", (Object)"object");
                functionToolJo.put("parameters", (Object)functionPrameters);
                functionPrameters.put("properties", (Object)properties);
                List<VarParam> varParams = prompt.getVarParams();
                for (VarParam varParam : varParams) {
                    JSONObject param = new JSONObject();
                    String type = varParam.getType();
                    if (type.equals("String")) {
                        type = "string";
                    }
                    param.put("type", (Object)type);
                    param.put("desc", (Object)varParam.getName());
                    JSONObject paramStr = new JSONObject();
                    paramStr.put(varParam.getKey(), (Object)param);
                    if ("input".equals(varParam.getKey())) continue;
                    paramJsonArray.add((Object)paramStr);
                    properties.put(varParam.getKey(), (Object)param);
                }
                JSONObject param = new JSONObject();
                param.put("type", (Object)"string");
                param.put("desc", (Object)ResManager.loadKDString((String)"\u57fa\u4e8e\u4f1a\u8bdd\u8bb0\u5f55\u8bc6\u522b\u7684\u7528\u6237\u9700\u6c42", (String)"GaiAgentReact_14", (String)"ai-gai-core", (Object[])new Object[0]));
                JSONObject paramStr = new JSONObject();
                paramStr.put("input", (Object)param);
                properties.put("input", (Object)paramStr);
                paramJsonArray.add((Object)paramStr);
            }
        }
        return prmptArray;
    }

    public static JSONArray ragToFunction(String chatSessionId, List<Repo> repoList, JSONArray functionTools) {
        JSONArray repos = new JSONArray();
        if (repoList != null) {
            for (Repo repo : repoList) {
                JSONObject repoJo = new JSONObject();
                Long repoId = repo.getId();
                String name = repo.getNumber();
                String functionName = repo.getNumber() + SPLITTAG + repoId;
                JSONObject functionToolJo = new JSONObject();
                String function = ToolService.genFunctionName(8);
                if (functionTools != null) {
                    functionTools.add((Object)functionToolJo);
                    function = ToolService.genFunctionName(8);
                } else {
                    function = name;
                }
                EngineCache.getAppCache(chatSessionId).put(function, (Object)functionName);
                EngineCache.getAppCache(chatSessionId).put(String.format("%s%s%s", chatSessionId, "_", function), (Object)AgentSkillTypeEnum.RAG.getId());
                repoJo.put("name", (Object)function);
                String desc = repo.getDescription();
                if (desc == null || desc.length() == 0) {
                    desc = name;
                }
                repoJo.put("desc", (Object)desc);
                functionToolJo.put("name", (Object)function);
                functionToolJo.put("description", (Object)desc);
                JSONObject properties = new JSONObject();
                JSONObject functionPrameters = new JSONObject();
                functionPrameters.put("type", (Object)"object");
                functionToolJo.put("parameters", (Object)functionPrameters);
                functionPrameters.put("properties", (Object)properties);
                JSONArray param = new JSONArray();
                repoJo.put("param", (Object)param);
                JSONObject paramJson = new JSONObject();
                param.add((Object)paramJson);
                JSONObject textVar = new JSONObject();
                paramJson.put("text", (Object)textVar);
                textVar.put("desc", (Object)ResManager.loadKDString((String)"\u9700\u8981\u68c0\u7d22\u7684\u5185\u5bb9", (String)"GaiAgentReact_15", (String)"ai-gai-core", (Object[])new Object[0]));
                textVar.put("type", (Object)"string");
                repos.add((Object)repoJo);
                properties.put("text", (Object)paramJson);
            }
        }
        return repos;
    }

    public static JSONArray openApiToFunction(String chatSessionId, List<OpenApi> openApiList, JSONArray functionTools) {
        JSONArray openApis = new JSONArray();
        if (openApiList == null) {
            return openApis;
        }
        for (OpenApi openApi : openApiList) {
            Long apiId = openApi.getId();
            CosmicOpenAPIInfo info = CosmicOpenAPIUtils.parserCosmicOpenAPIInfo(apiId);
            List<CosmicOpenAPIParam> params = info.getRequest();
            List<Map<String, String>> headers = info.getHeaders();
            JSONArray paramArray = new JSONArray();
            JSONObject functionToolJo = new JSONObject();
            String function = "";
            if (functionTools != null) {
                function = ToolService.genFunctionName(8);
                functionTools.add((Object)functionToolJo);
            } else {
                function = info.getName();
            }
            String functionName = openApi.getNumber() + SPLITTAG + apiId;
            EngineCache.getAppCache(chatSessionId).put(String.format("%s%s%s", chatSessionId, "_", function), (Object)AgentSkillTypeEnum.OPENAPI.getId());
            functionToolJo.put("name", (Object)function);
            EngineCache.getAppCache(chatSessionId).put(function, (Object)functionName);
            JSONObject openApiJo = new JSONObject();
            openApis.add((Object)openApiJo);
            openApiJo.put("name", (Object)function);
            String desc = openApi.getDescription();
            if (desc == null || desc.length() == 0) {
                desc = openApi.getName();
            }
            openApiJo.put("desc", (Object)desc);
            functionToolJo.put("description", (Object)desc);
            JSONObject properties = new JSONObject();
            JSONObject functionPrameters = new JSONObject();
            functionPrameters.put("type", (Object)"object");
            functionToolJo.put("parameters", (Object)functionPrameters);
            functionPrameters.put("properties", (Object)properties);
            for (CosmicOpenAPIParam cosmicOpenAPIParam : params) {
                JSONObject parammStr;
                JSONObject childParamJson;
                String childType;
                String childParamName;
                String childDesc;
                JSONObject paramJo = new JSONObject();
                String paramDesc = cosmicOpenAPIParam.getDesc();
                String paramName = cosmicOpenAPIParam.getParamName();
                String type = cosmicOpenAPIParam.getParamType();
                paramJo.put("type", (Object)type);
                paramJo.put("desc", (Object)paramDesc);
                JSONObject paramStr = new JSONObject();
                openApiJo.put("param", (Object)paramArray);
                paramStr.put(paramName, (Object)paramJo);
                paramArray.add((Object)paramStr);
                properties.put(paramName, (Object)paramStr);
                if (cosmicOpenAPIParam.getChildList().size() <= 0) continue;
                if (type.toLowerCase(Locale.ROOT).contains("array")) {
                    JSONArray jsonArray = new JSONArray();
                    paramStr.put(paramName, (Object)jsonArray);
                    for (CosmicOpenAPIParam childParam : cosmicOpenAPIParam.getChildList()) {
                        childDesc = childParam.getDesc();
                        childParamName = childParam.getParamName();
                        childType = childParam.getParamType();
                        childParamJson = new JSONObject();
                        childParamJson.put("type", (Object)childType);
                        childParamJson.put("desc", (Object)childDesc);
                        parammStr = new JSONObject();
                        parammStr.put(childParamName, (Object)childParamJson);
                        jsonArray.add((Object)parammStr);
                    }
                    continue;
                }
                JSONObject jsonJo = new JSONObject();
                paramStr.put(paramName, (Object)jsonJo);
                for (CosmicOpenAPIParam childParam : cosmicOpenAPIParam.getChildList()) {
                    childDesc = childParam.getDesc();
                    childParamName = childParam.getParamName();
                    childType = childParam.getParamType();
                    childParamJson = new JSONObject();
                    childParamJson.put("type", (Object)childType);
                    childParamJson.put("desc", (Object)childDesc);
                    parammStr = new JSONObject();
                    parammStr.put(childParamName, (Object)childParamJson);
                    jsonJo.putAll((Map)parammStr);
                }
            }
            for (Map map : headers) {
            }
        }
        return openApis;
    }

    /*
     * WARNING - void declaration
     */
    public static JSONArray toolToFunction(String chatSessionId, List<Tool> toolList, JSONArray functionTools) {
        JSONArray tools = new JSONArray();
        if (toolList != null) {
            for (Tool tool : toolList) {
                JSONObject functionPrameters;
                JSONObject properties;
                String functionName;
                String function;
                JSONObject functionToolJo;
                String name = tool.getName();
                String toolNumber = tool.getNumber();
                String desc = tool.getDescription();
                String type = tool.getType();
                String toolSelected = tool.getSelected();
                String operationId = "";
                String operationName = "";
                if (toolSelected != null) {
                    JSONObject jsonObject = JSONObject.parseObject((String)toolSelected);
                    operationId = jsonObject.getString("operations");
                    operationName = jsonObject.getString("operationName");
                }
                JSONObject congfitTag = tool.getConfigTag();
                if (type.equals(ToolConstant.ToolType.THIRD_OPENAPI.getType()) || type.equals(ToolConstant.ToolType.COSMIC_OPENAPI.getType())) {
                    String swagger = congfitTag.getString("swaggerSchema");
                    JSONObject swaggerJson = JSONObject.parseObject((String)swagger);
                    JSONObject jSONObject = swaggerJson.getJSONObject("components");
                    String components = null;
                    if (jSONObject != null) {
                        components = JSONObject.toJSONString((Object)jSONObject);
                    }
                    Map<String, OperationParam> operationParamMap = OpenAPIUtils.parseOperationParam(swagger);
                    for (Map.Entry<String, OperationParam> entry : operationParamMap.entrySet()) {
                        Map<String, MediaType> content;
                        OperationParam operationParam = entry.getValue();
                        JSONObject toolJo = new JSONObject();
                        JSONObject functionToolJo2 = new JSONObject();
                        tools.add((Object)toolJo);
                        String functionName2 = operationParam.getOperationId() + SPLITTAG + toolNumber;
                        String function2 = "";
                        if (functionTools != null) {
                            function2 = ToolService.genFunctionName(8);
                            functionTools.add((Object)functionToolJo2);
                        } else {
                            function2 = name;
                        }
                        EngineCache.getAppCache(chatSessionId).put(function2, (Object)functionName2);
                        EngineCache.getAppCache(chatSessionId).put(String.format("%s%s%s", chatSessionId, "_", function2), (Object)AgentSkillTypeEnum.TOOL.getId());
                        toolJo.put("name", (Object)function2);
                        toolJo.put("desc", (Object)operationParam.getSummary());
                        functionToolJo2.put("name", (Object)function2);
                        functionToolJo2.put("description", (Object)operationParam.getSummary());
                        List<Parameter> parameters = operationParam.getParameters();
                        JSONArray jSONArray = new JSONArray();
                        toolJo.put("param", (Object)jSONArray);
                        JSONObject properties2 = new JSONObject();
                        JSONObject functionPrameters2 = new JSONObject();
                        functionPrameters2.put("type", (Object)"object");
                        functionToolJo2.put("parameters", (Object)functionPrameters2);
                        functionPrameters2.put("properties", (Object)properties2);
                        Iterator<Parameter> iterator = parameters.iterator();
                        while (iterator.hasNext()) {
                            Parameter parameter = iterator.next();
                            JSONObject param = new JSONObject();
                            JSONObject paramVar = new JSONObject();
                            param.put(parameter.getName(), (Object)paramVar);
                            properties2.put(parameter.getName(), (Object)paramVar);
                            paramVar.put("desc", (Object)parameter.getDescription());
                            if (parameter.getSchema() != null) {
                                if (parameter.getSchema().getType().equals("String")) {
                                    parameter.getSchema().setType("string");
                                }
                                paramVar.put("type", (Object)parameter.getSchema().getType());
                            }
                            jSONArray.add((Object)param);
                        }
                        RequestBody requestBody = operationParam.getRequestBody();
                        if (requestBody != null && (content = requestBody.getContent()) != null && !content.isEmpty()) {
                            ArrayList<String> contentTypes = new ArrayList<String>(content.keySet());
                            for (String contentType : contentTypes) {
                                MediaType mediaType = content.get(contentType);
                                JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)mediaType));
                                if (jsonObject == null) continue;
                                JSON json = null;
                                if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.APPLICATION_JSON.getType())) {
                                    json = ToolService.handlerApplicationJSON(components, jsonObject);
                                } else if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.X_WWW_FORM_URLENCODED.getType())) {
                                    json = ToolService.handlerBodyURLEncodedParam(components, contentType, jsonObject);
                                } else if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.MULTIPART_FORM_DATA.getType())) {
                                    json = ToolService.handlerBodyURLEncodedParam(components, contentType, jsonObject);
                                }
                                if (json == null) continue;
                                jSONArray.add((Object)json);
                            }
                        }
                        for (int i = 0; i < jSONArray.size(); ++i) {
                            JSONObject json = jSONArray.getJSONObject(i);
                            properties2.putAll((Map)json);
                        }
                    }
                    continue;
                }
                if (type.equals(ToolConstant.ToolType.RESTFUL_API.getType()) || type.equals(ToolConstant.ToolType.MCP_TOOL.getType())) {
                    String[] stringArray;
                    if (operationId == null) {
                        stringArray = new String[]{};
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = operationId;
                    }
                    Map<String, OperationParam> operationParamMap = OpenAPIUtils.parserRestfulOperationParam(congfitTag, stringArray);
                    for (Map.Entry entry : operationParamMap.entrySet()) {
                        void var27_38;
                        Map<String, MediaType> map;
                        OperationParam operationParam = (OperationParam)entry.getValue();
                        JSONObject toolJo = new JSONObject();
                        functionToolJo = new JSONObject();
                        function = "";
                        if (functionTools != null) {
                            functionTools.add((Object)functionToolJo);
                            function = ToolService.genFunctionName(8);
                        } else {
                            function = operationName;
                        }
                        tools.add((Object)toolJo);
                        functionName = operationParam.getOperationId() + SPLITTAG + toolNumber;
                        EngineCache.getAppCache(chatSessionId).put(function, (Object)functionName);
                        EngineCache.getAppCache(chatSessionId).put(String.format("%s%s%s", chatSessionId, "_", function), (Object)AgentSkillTypeEnum.TOOL.getId());
                        toolJo.put("name", (Object)function);
                        toolJo.put("desc", (Object)operationParam.getSummary());
                        functionToolJo.put("name", (Object)function);
                        functionToolJo.put("description", (Object)operationParam.getSummary());
                        List<Parameter> parameters = operationParam.getParameters();
                        JSONArray parametersJo = new JSONArray();
                        toolJo.put("param", (Object)parametersJo);
                        properties = new JSONObject();
                        functionPrameters = new JSONObject();
                        functionPrameters.put("type", (Object)"object");
                        functionToolJo.put("parameters", (Object)functionPrameters);
                        functionPrameters.put("properties", (Object)properties);
                        for (Parameter parameter : parameters) {
                            JSONObject param = new JSONObject();
                            JSONObject paramVar = new JSONObject();
                            param.put(parameter.getName(), (Object)paramVar);
                            properties.put(parameter.getName(), (Object)paramVar);
                            paramVar.put("desc", (Object)parameter.getDescription());
                            if (parameter.getSchema() != null) {
                                if (parameter.getSchema().getType().equals("String")) {
                                    parameter.getSchema().setType("string");
                                }
                                paramVar.put("type", (Object)parameter.getSchema().getType());
                            }
                            parametersJo.add((Object)param);
                        }
                        RequestBody requestBody = operationParam.getRequestBody();
                        if (requestBody != null && (map = requestBody.getContent()) != null && !map.isEmpty()) {
                            ArrayList<String> contentTypes = new ArrayList<String>(map.keySet());
                            for (String contentType : contentTypes) {
                                MediaType mediaType = map.get(contentType);
                                JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)mediaType));
                                if (jsonObject == null) continue;
                                Schema schema = mediaType.getSchema();
                                JSONObject schemaObj = JSONObject.parseObject((String)JSONObject.toJSONString((Object)schema));
                                JSON outputSchema = OpenAPIProtocolUtils.getSchemaJSONAndType(schemaObj);
                                parametersJo.add((Object)outputSchema);
                            }
                        }
                        boolean bl = false;
                        while (var27_38 < parametersJo.size()) {
                            if (parametersJo.get((int)var27_38) instanceof JSONObject) {
                                JSONObject json = parametersJo.getJSONObject((int)var27_38);
                                properties.putAll((Map)json);
                            } else if (parametersJo.get((int)var27_38) instanceof JSONArray) {
                                JSONArray jsonArray = parametersJo.getJSONArray((int)var27_38);
                                for (int j = 0; j < jsonArray.size(); ++j) {
                                }
                            }
                            ++var27_38;
                        }
                    }
                    continue;
                }
                if (type.equals(ToolConstant.ToolType.INTERNAL_MCP.getType())) {
                    Long apiId = Long.parseLong(operationId);
                    CosmicOpenAPIInfo openApi = CosmicOpenAPIUtils.parserCosmicOpenAPIInfo(apiId);
                    List<CosmicOpenAPIParam> list = openApi.getRequest();
                    List<Map<String, String>> headers = openApi.getHeaders();
                    JSONArray paramArray = new JSONArray();
                    functionToolJo = new JSONObject();
                    function = "";
                    if (functionTools != null) {
                        function = ToolService.genFunctionName(8);
                        functionTools.add((Object)functionToolJo);
                    } else {
                        function = openApi.getName();
                    }
                    functionName = apiId + SPLITTAG + tool.getNumber();
                    EngineCache.getAppCache(chatSessionId).put(String.format("%s%s%s", chatSessionId, "_", function), (Object)AgentSkillTypeEnum.TOOL.getId());
                    functionToolJo.put("name", (Object)function);
                    EngineCache.getAppCache(chatSessionId).put(function, (Object)functionName);
                    JSONObject openApiJo = new JSONObject();
                    tools.add((Object)openApiJo);
                    openApiJo.put("name", (Object)function);
                    String openApiDesc = openApi.getDescription();
                    if (openApiDesc == null || openApiDesc.length() == 0) {
                        desc = openApi.getName();
                    }
                    openApiJo.put("desc", (Object)desc);
                    functionToolJo.put("description", (Object)desc);
                    properties = new JSONObject();
                    functionPrameters = new JSONObject();
                    functionPrameters.put("type", (Object)"object");
                    functionToolJo.put("parameters", (Object)functionPrameters);
                    functionPrameters.put("properties", (Object)properties);
                    for (CosmicOpenAPIParam cosmicOpenAPIParam : list) {
                        JSONObject parammStr;
                        JSONObject childParamJson;
                        String childType;
                        String childParamName;
                        String childDesc;
                        JSONObject paramJo = new JSONObject();
                        String paramDesc = cosmicOpenAPIParam.getDesc();
                        String paramName = cosmicOpenAPIParam.getParamName();
                        String openApiType = cosmicOpenAPIParam.getParamType();
                        paramJo.put("type", (Object)openApiType);
                        paramJo.put("desc", (Object)paramDesc);
                        JSONObject paramStr = new JSONObject();
                        openApiJo.put("param", (Object)paramArray);
                        paramStr.put(paramName, (Object)paramJo);
                        paramArray.add((Object)paramStr);
                        properties.put(paramName, (Object)paramStr);
                        if (cosmicOpenAPIParam.getChildList().size() <= 0) continue;
                        if (type.toLowerCase(Locale.ROOT).contains("array")) {
                            JSONArray jsonArray = new JSONArray();
                            paramStr.put(paramName, (Object)jsonArray);
                            for (CosmicOpenAPIParam childParam : cosmicOpenAPIParam.getChildList()) {
                                childDesc = childParam.getDesc();
                                childParamName = childParam.getParamName();
                                childType = childParam.getParamType();
                                childParamJson = new JSONObject();
                                childParamJson.put("type", (Object)childType);
                                childParamJson.put("desc", (Object)childDesc);
                                parammStr = new JSONObject();
                                parammStr.put(childParamName, (Object)childParamJson);
                                jsonArray.add((Object)parammStr);
                            }
                            continue;
                        }
                        JSONObject jsonJo = new JSONObject();
                        paramStr.put(paramName, (Object)jsonJo);
                        for (CosmicOpenAPIParam childParam : cosmicOpenAPIParam.getChildList()) {
                            childDesc = childParam.getDesc();
                            childParamName = childParam.getParamName();
                            childType = childParam.getParamType();
                            childParamJson = new JSONObject();
                            childParamJson.put("type", (Object)childType);
                            childParamJson.put("desc", (Object)childDesc);
                            parammStr = new JSONObject();
                            parammStr.put(childParamName, (Object)childParamJson);
                            jsonJo.putAll((Map)parammStr);
                        }
                    }
                    for (Map map : headers) {
                    }
                    continue;
                }
                if (!type.equals(ToolConstant.ToolType.COSMIC_ACTION.getType())) continue;
                JSONArray inputs = congfitTag.getJSONArray("inputParams");
                JSONObject toolJo = new JSONObject();
                String string = name + SPLITTAG + toolNumber;
                JSONObject functionToolJo3 = new JSONObject();
                String function3 = "";
                if (functionTools != null) {
                    function3 = ToolService.genFunctionName(8);
                    functionTools.add((Object)functionToolJo3);
                } else {
                    function3 = name;
                }
                EngineCache.getAppCache(chatSessionId).put(function3, (Object)string);
                EngineCache.getAppCache(chatSessionId).put(String.format("%s%s%s", chatSessionId, "_", function3), (Object)AgentSkillTypeEnum.TOOL.getId());
                toolJo.put("name", (Object)function3);
                toolJo.put("desc", (Object)desc);
                functionToolJo3.put("name", (Object)function3);
                functionToolJo3.put("description", (Object)desc);
                JSONObject properties3 = new JSONObject();
                JSONObject functionPrameters3 = new JSONObject();
                functionPrameters3.put("type", (Object)"object");
                functionToolJo3.put("parameters", (Object)functionPrameters3);
                functionPrameters3.put("properties", (Object)properties3);
                JSONArray parametersJo = new JSONArray();
                toolJo.put("param", (Object)parametersJo);
                tools.add((Object)toolJo);
                for (int i = 0; i < inputs.size(); ++i) {
                    JSONObject param = new JSONObject();
                    JSONObject paramVar = new JSONObject();
                    param.put("type", (Object)inputs.getJSONObject(i).getString("paramType"));
                    if (param.getString("type").equals("String")) {
                        param.put("type", (Object)"string");
                    }
                    param.put("desc", (Object)inputs.getJSONObject(i).getString("paramDesc"));
                    paramVar.put(inputs.getJSONObject(i).getString("paramName"), (Object)param);
                    properties3.put(inputs.getJSONObject(i).getString("paramName"), (Object)param);
                    parametersJo.add((Object)paramVar);
                }
            }
        }
        return tools;
    }

    public static String parseSchemaName(String pre, String $ref) {
        return $ref.substring(pre.length());
    }

    public static JSON getSchemaJSON(String components, String schemaName, String type) {
        return ToolService.getSchemaJSON(components, schemaName, type, new JSONObject());
    }

    public static JSON getSchemaJSON(String components, JSONObject schema, String type) {
        return ToolService.getSchemaJSON(components, null, schema, type, new JSONObject());
    }

    public static JSON getSchemaJSON(String components, String propName, JSONObject schema, String type, JSONObject xmlConfig) {
        JSONObject data = null;
        String schemaType = schema.getString("type");
        if (StringUtils.equalsIgnoreCase((CharSequence)schemaType, (CharSequence)"object")) {
            JSONObject props = schema.getJSONObject("properties");
            data = ToolService.handlerProperties(components, props, type, xmlConfig);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)schemaType, (CharSequence)"array")) {
            data = ToolService.handlerItems(components, propName, schema, type, xmlConfig);
        }
        return data;
    }

    public static JSON getSchemaJSON(String components, String schemaName, String type, JSONObject xmlConfig) {
        JSONObject schema;
        JSONObject data = null;
        Map<String, JSONObject> stringJSONObjectMap = ToolService.parseSchema(components);
        if (stringJSONObjectMap != null && !stringJSONObjectMap.isEmpty() && (schema = stringJSONObjectMap.get(schemaName)) != null) {
            String schemaType = schema.getString("type");
            if (StringUtils.equalsIgnoreCase((CharSequence)schemaType, (CharSequence)"object")) {
                JSONObject props = schema.getJSONObject("properties");
                data = ToolService.handlerProperties(components, props, type, xmlConfig);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)schemaType, (CharSequence)"array")) {
                data = ToolService.handlerItems(components, schemaName, schema, type, xmlConfig);
            }
        }
        return data;
    }

    public static Map<String, JSONObject> parseSchema(String componentsJson) {
        JSONObject schemas;
        HashMap<String, JSONObject> stringJSONObjectMap = new HashMap<String, JSONObject>();
        if (StringUtils.isEmpty((CharSequence)componentsJson)) {
            return new HashMap<String, JSONObject>();
        }
        JSONObject components = JSONObject.parseObject((String)componentsJson);
        if (components != null && !components.isEmpty() && (schemas = components.getJSONObject("schemas")) != null && !schemas.isEmpty()) {
            for (String schemaName : schemas.keySet()) {
                stringJSONObjectMap.put(schemaName, schemas.getJSONObject(schemaName));
            }
        }
        return stringJSONObjectMap;
    }

    public static String parseRefXMLNode(String components, String $ref) {
        JSONObject schema;
        String nodeName = "";
        String schemaName = ToolService.parseSchemaName("#/components/schemas/", $ref);
        Map<String, JSONObject> stringJSONObjectMap = ToolService.parseSchema(components);
        if (stringJSONObjectMap != null && !stringJSONObjectMap.isEmpty() && (schema = stringJSONObjectMap.get(schemaName)) != null && schema.containsKey((Object)"xml")) {
            nodeName = schema.getJSONObject("xml").getString("name");
        }
        return nodeName;
    }

    public static JSONArray handlerItems(String components, String propName, JSONObject schema, String contentType, JSONObject xmlConfig) {
        String xmlNodeName = "";
        boolean wrapped = Boolean.FALSE;
        if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.APPLICATION_XML.getType())) {
            if (schema.containsKey((Object)"xml")) {
                JSONObject xml = schema.getJSONObject("xml");
                if (xml != null) {
                    if (xml.containsKey((Object)"wrapped")) {
                        wrapped = xml.getBoolean("wrapped");
                    }
                    if (wrapped) {
                        JSONObject itemsObj = schema.getJSONObject("items");
                        if (itemsObj.containsKey((Object)"xml")) {
                            JSONObject xmlObj = itemsObj.getJSONObject("xml");
                            if (xmlObj != null && xmlObj.containsKey((Object)"name")) {
                                xmlNodeName = xmlObj.getString("name");
                            }
                        } else if (itemsObj.containsKey((Object)"$ref")) {
                            xmlNodeName = ToolService.parseRefXMLNode(components, itemsObj.getString("$ref"));
                        }
                    }
                }
            } else {
                JSONObject items = schema.getJSONObject("items");
                if (items != null && items.containsKey((Object)"$ref")) {
                    xmlNodeName = ToolService.parseRefXMLNode(components, items.getString("$ref"));
                }
            }
            if (!StringUtils.isEmpty((CharSequence)propName)) {
                JSONObject config = new JSONObject();
                config.put("_$XML_NODE_NAME$_", (Object)xmlNodeName);
                config.put("_$XML_WRAPPED$_", (Object)wrapped);
                xmlConfig.put(propName, (Object)config);
            }
        }
        return ToolService.parseItems(components, propName, schema, contentType, xmlConfig);
    }

    public static JSONArray parseItems(String components, String propName, JSONObject schema, String contentType, JSONObject xmlConfig) {
        JSONObject items = schema.getJSONObject("items");
        JSONArray data = new JSONArray();
        if (items.containsKey((Object)"$ref")) {
            String ref = items.getString("$ref");
            String schemaName = ToolService.parseSchemaName("#/components/schemas/", ref);
            JSON json = ToolService.getSchemaJSON(components, schemaName, contentType, xmlConfig);
            data.add((Object)json);
        } else {
            String itemType = items.getString("type");
            String desc = schema.getString("description");
            if (StringUtils.equalsIgnoreCase((CharSequence)itemType, (CharSequence)"object")) {
                JSONObject itemProps = items.getJSONObject("properties");
                JSONObject item = ToolService.handlerProperties(components, itemProps, contentType, xmlConfig);
                data.add((Object)item);
            } else if ("array".equalsIgnoreCase(itemType)) {
                JSONObject itemsObj = items.getJSONObject("items");
                JSONArray array = ToolService.handlerItems(components, propName, itemsObj, contentType, xmlConfig);
                data.add((Object)array);
            } else if ("integer".equalsIgnoreCase(itemType)) {
                JSONObject item = new JSONObject();
                item.put("type", (Object)itemType);
                item.put("description", (Object)desc);
                data.add((Object)item);
            } else if ("number".equalsIgnoreCase(itemType)) {
                JSONObject item = new JSONObject();
                item.put("type", (Object)itemType);
                item.put("description", (Object)desc);
                data.add((Object)item);
            } else if ("boolean".equalsIgnoreCase(itemType)) {
                JSONObject item = new JSONObject();
                item.put("type", (Object)itemType);
                item.put("description", (Object)desc);
                data.add((Object)item);
            } else if ("string".equalsIgnoreCase(itemType)) {
                JSONObject item = new JSONObject();
                item.put("type", (Object)"string");
                item.put("description", (Object)desc);
                data.add((Object)item);
            }
        }
        return data;
    }

    public static JSONObject getRefSchema(String components, String $ref) {
        String schemaName = ToolService.parseSchemaName("#/components/schemas/", $ref);
        Map<String, JSONObject> stringJSONObjectMap = ToolService.parseSchema(components);
        if (stringJSONObjectMap != null && !stringJSONObjectMap.isEmpty()) {
            JSONObject schema = stringJSONObjectMap.get(schemaName);
            return schema;
        }
        return new JSONObject();
    }

    public static JSONObject handlerProperties(String components, JSONObject props, String contentType) {
        return ToolService.handlerProperties(components, props, contentType, new JSONObject());
    }

    public static JSONObject handlerProperties(String components, JSONObject props, String contentType, JSONObject xmlConfig) {
        JSONObject data = new JSONObject();
        if (props != null && !props.isEmpty()) {
            for (String propName : props.keySet()) {
                JSONObject prop = props.getJSONObject(propName);
                String type = prop.getString("type");
                String desc = prop.getString("description");
                JSONObject propData = new JSONObject();
                data.put(propName, (Object)propData);
                if ("string".equalsIgnoreCase(type)) {
                    propData.put("description", (Object)desc);
                    propData.put("type", (Object)"string");
                    continue;
                }
                if ("integer".equalsIgnoreCase(type)) {
                    propData.put("description", (Object)desc);
                    propData.put("type", (Object)type);
                    continue;
                }
                if ("number".equalsIgnoreCase(type)) {
                    propData.put("description", (Object)desc);
                    propData.put("type", (Object)type);
                    continue;
                }
                if ("boolean".equalsIgnoreCase(type)) {
                    propData.put("description", (Object)desc);
                    propData.put("type", (Object)type);
                    continue;
                }
                if ("object".equalsIgnoreCase(type)) {
                    JSONObject subProps = prop.getJSONObject("properties");
                    JSONObject subPropsData = ToolService.handlerProperties(components, subProps, contentType);
                    propData.put(propName, (Object)subPropsData);
                    continue;
                }
                if ("array".equalsIgnoreCase(type)) {
                    JSONArray array = ToolService.handlerItems(components, propName, prop, contentType, xmlConfig);
                    data.put(propName, (Object)array);
                    continue;
                }
                if (!prop.containsKey((Object)"$ref")) continue;
                String ref = prop.getString("$ref");
                JSONObject schema = ToolService.getRefSchema(components, ref);
                JSONObject subProps = schema.getJSONObject("properties");
                JSONObject subPropsData = ToolService.handlerProperties(components, subProps, contentType, xmlConfig);
                propData.put(propName, (Object)subPropsData);
            }
        }
        return data;
    }

    public static JSON handlerApplicationJSON(String components, JSONObject mediaType) {
        JSONObject schema = mediaType.getJSONObject("schema");
        JSON data = null;
        if (schema != null) {
            String $ref = schema.getString("$ref");
            if (!StringUtils.isEmpty((CharSequence)$ref)) {
                String schemaName = ToolService.parseSchemaName("#/components/schemas/", $ref);
                data = ToolService.getSchemaJSON(components, schemaName, ToolConstant.ContentType.APPLICATION_JSON.getType());
            } else {
                data = ToolService.getSchemaJSON(components, schema, ToolConstant.ContentType.APPLICATION_JSON.getType());
            }
        }
        return data;
    }

    public static JSONArray handlerProps(JSON json) {
        JSONArray params = new JSONArray();
        if (json != null) {
            JSONArray array;
            if (json instanceof JSONObject) {
                JSONObject item = (JSONObject)json;
                ToolService.handlerParameters(params, item);
            } else if (json instanceof JSONArray && (array = (JSONArray)json) != null && !array.isEmpty()) {
                JSONObject item = array.getJSONObject(0);
                ToolService.handlerParameters(params, item);
            }
        }
        return params;
    }

    public static void handlerParameters(JSONArray params, JSONObject item) {
        for (String propName : item.keySet()) {
            JSONObject data = new JSONObject();
            Object value = item.get((Object)propName);
            data.put("name", (Object)propName);
            if (value != null) {
                String typeName = value.getClass().getName();
                int length = typeName.lastIndexOf(".");
                String type = typeName.substring(length + 1);
                data.put("dataType", (Object)type);
            }
            params.add((Object)data);
        }
    }

    public static JSON handlerBodyURLEncodedParam(String components, String contentType, JSONObject mediaType) {
        JSONObject schema = mediaType.getJSONObject("schema");
        if (schema != null) {
            String $ref = schema.getString("$ref");
            if (!StringUtils.isEmpty((CharSequence)$ref)) {
                String schemaName = ToolService.parseSchemaName("#/components/schemas/", $ref);
                JSON data = ToolService.getSchemaJSON(components, schemaName, ToolConstant.ContentType.APPLICATION_JSON.getType());
                JSONArray params = ToolService.handlerProps(data);
                return params;
            }
            JSON data = ToolService.getSchemaJSON(components, schema, ToolConstant.ContentType.APPLICATION_JSON.getType());
            JSONArray params = ToolService.handlerProps(data);
            return params;
        }
        return null;
    }

    public static BaseResult restCall(Map<String, Object> requestParams) {
        return null;
    }

    public static BaseResult cosmicCall(Map<String, Object> requestParams) {
        CosmicAction cosmicAction = new CosmicAction();
        cosmicAction.setToolId(Long.parseLong(String.valueOf(requestParams.get("toolId"))));
        String chatSessionId = String.valueOf(requestParams.get("chatSessionId"));
        cosmicAction.setChatSessionId(chatSessionId);
        Object paramsObj = requestParams.get("params");
        JSONObject toolParams = new JSONObject();
        cosmicAction.setToolParams(toolParams);
        JSONArray inputParams = new JSONArray();
        if (paramsObj != null) {
            Map params = (Map)JSON.parseObject((String)JSONObject.toJSONString((Object)paramsObj), Map.class);
            for (Map.Entry entry : params.entrySet()) {
                JSONObject param = new JSONObject();
                param.put("paramName", entry.getKey());
                param.put("paramValue", entry.getValue());
                inputParams.add((Object)param);
            }
        }
        toolParams.put("inputParams", (Object)inputParams);
        BaseResult br = CosmicActionService.call(cosmicAction);
        if (br != null && br.getData() != null && br.getDataAsJSONObject() != null) {
            br.setData(br.getDataAsJSONObject().getJSONObject("output"));
        }
        return br;
    }

    private static void validateParameters(String toolId, String toolType) {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)toolId)) {
            errors.add("toolId cannot be null or empty");
        }
        if (StringUtils.isBlank((CharSequence)toolType)) {
            errors.add("toolType cannot be null or empty");
        } else {
            try {
                ToolConstant.ToolType.valueOf(toolType.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                errors.add("invalid searchMode: " + toolType);
            }
        }
        if (!errors.isEmpty()) {
            String errorMessage = String.join((CharSequence)"; ", errors);
            logger.error("Parameter validation failed: {}", (Object)errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static BaseResult toolService(Map<String, Object> requestParams) {
        logger.info("the requestParams is {}", (Object)requestParams.toString());
        Object toolId = requestParams.get("toolId");
        String type = String.valueOf(requestParams.get("type"));
        ToolService.validateParameters(toolId == null ? "" : String.valueOf(toolId), type);
        switch (ToolConstant.ToolType.valueOf(type.toUpperCase())) {
            case COSMIC_ACTION: {
                return ToolService.cosmicCall(requestParams);
            }
        }
        logger.error("the tool type is not the cosmic or rest");
        return null;
    }
}

