/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.agent.tool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.agent.tool.model.OperationParam;
import kd.ai.gai.core.agent.tool.openapi.v3.models.MediaType;
import kd.ai.gai.core.agent.tool.openapi.v3.models.OpenAPI;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Parameter;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Path;
import kd.ai.gai.core.agent.tool.openapi.v3.models.RequestBody;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Schema;
import kd.ai.gai.core.agent.tool.util.CosmicOpenAPIUtils;
import kd.ai.gai.core.agent.tool.util.OpenAPIProtocolUtils;
import kd.ai.gai.core.agent.tool.util.OpenAPIUtils;
import kd.ai.gai.core.domain.dto.agent.Agent;
import kd.ai.gai.core.domain.dto.agent.CosmicAction;
import kd.ai.gai.core.domain.dto.agent.CosmicOpenAPI;
import kd.ai.gai.core.domain.dto.agent.CosmicOpenAPIInfo;
import kd.ai.gai.core.domain.dto.agent.CosmicOpenAPIParam;
import kd.ai.gai.core.domain.dto.agent.GptPrompt;
import kd.ai.gai.core.domain.dto.agent.MCPTool;
import kd.ai.gai.core.domain.dto.agent.OpenApi;
import kd.ai.gai.core.domain.dto.agent.Process;
import kd.ai.gai.core.domain.dto.agent.Prompt;
import kd.ai.gai.core.domain.dto.agent.Repo;
import kd.ai.gai.core.domain.dto.agent.RestfulAPI;
import kd.ai.gai.core.domain.dto.agent.RunStep;
import kd.ai.gai.core.domain.dto.agent.RunStepMessage;
import kd.ai.gai.core.domain.dto.agent.ThirdOpenAPI;
import kd.ai.gai.core.domain.dto.agent.Tool;
import kd.ai.gai.core.domain.dto.agent.VarParam;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.agent.plan.AgentCommonService;
import kd.ai.gai.core.engine.agent.result.AgentAction;
import kd.ai.gai.core.engine.agent.tool.ToolService;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.ResultActionType;
import kd.ai.gai.core.enuz.agent.AgentSkillTypeEnum;
import kd.ai.gai.core.enuz.agent.RunStepStatusEnum;
import kd.ai.gai.core.helper.ProcessHelper;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.agent.CosmicActionService;
import kd.ai.gai.core.service.agent.CosmicOpenAPIService;
import kd.ai.gai.core.service.agent.GPTPromptService;
import kd.ai.gai.core.service.agent.MCPService;
import kd.ai.gai.core.service.agent.OpenAPIService;
import kd.ai.gai.core.service.agent.RestfulAPIService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.ai.gai.core.util.StrUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.service.KDDateFormatUtils;
import org.apache.commons.lang3.StringUtils;

public class ToolServiceFunctionCall {
    public static final String SPLITTAG = "&";
    public static final String CHARACTERS = "characters";
    private static final Log logger = LogFactory.getLog(ToolService.class);

    public static BaseResult promptFunction(String chatSessionId, Agent agent, AgentAction action, RunStep runStep) {
        List<Prompt> promptList = agent.getPromptList();
        String actionName = (String)EngineCache.getAppCache(chatSessionId).get(action.getName(), String.class);
        logger.info("actionName: %s", (Object)actionName);
        if (promptList != null) {
            for (Prompt prompt : promptList) {
                String promptNumber = actionName.split(SPLITTAG)[1].trim();
                String promptName = actionName.split(SPLITTAG)[0].trim();
                runStep.setType(prompt.getName());
                if ((!StrUtils.isLong(promptNumber) || prompt.getId() != Long.parseLong(promptNumber)) && !promptName.equalsIgnoreCase(prompt.getNumber())) continue;
                GptPrompt gptPrompt = new GptPrompt();
                gptPrompt.setPromptId(prompt.getId());
                Map<String, Object> param = action.getInputs();
                if (param.size() > 0) {
                    String input = "";
                    input = param.get("input") == null ? "" : (String)param.get("input");
                    gptPrompt.setInput(input);
                    HashMap<String, String> varParam = new HashMap<String, String>();
                    param.forEach((key, value) -> {
                        if (!key.equals("input")) {
                            varParam.put((String)key, String.valueOf(value));
                        }
                    });
                    gptPrompt.setVarParams(varParam);
                }
                BaseResult gr = GPTPromptService.syncCall(gptPrompt, chatSessionId);
                return gr;
            }
        }
        return null;
    }

    public static BaseResult processFunction(String chatSessionId, Agent agent, AgentAction action, RunStep runStep) {
        List<Process> processList = agent.getProcessList();
        String actionName = (String)EngineCache.getAppCache(chatSessionId).get(action.getName(), String.class);
        logger.info("actionName:{}", (Object)actionName);
        if (processList != null) {
            for (Process process : processList) {
                String processNumber = actionName.split(SPLITTAG)[1].trim();
                String processName = actionName.split(SPLITTAG)[0].trim();
                runStep.setType(process.getName());
                if ((!StrUtils.isLong(processNumber) || process.getId() != Long.parseLong(processNumber)) && !processName.equalsIgnoreCase(process.getNumber())) continue;
                HashMap<String, String> map = new HashMap<String, String>(16);
                Map<String, Object> param = action.getInputs();
                String userInput = "";
                if (param.size() > 0) {
                    userInput = (String)param.get("input");
                }
                for (Map.Entry<String, Object> entry : param.entrySet()) {
                    map.put(entry.getKey(), (String)entry.getValue());
                }
                long st = System.currentTimeMillis();
                map.put("chatSessionId", chatSessionId);
                map.put("system.runStepId", String.valueOf(runStep.getRunStepId()));
                map.put("asTool", String.valueOf(true));
                Context context = FlowCacheData.getContext(chatSessionId);
                RunStepMessage runStepMessage = ToolServiceFunctionCall.createRunStepMessage(runStep, chatSessionId, runStep.getType());
                PushMsgService.pushResult(context, ResultActionType.runStepChat.name(), runStepMessage);
                Result result = ProcessHelper.agentCallProcess(process.getId(), userInput, map);
                long et = System.currentTimeMillis();
                logger.info("ProcessSyncCall end: {}, cost:{} ms, result:{}", new Object[]{KDDateFormatUtils.getDateTimeFormat().format(new Date(et)), et - st, JSONObject.toJSONString((Object)result)});
                if (result.getErrorCode().equals((Object)Errors.OK)) {
                    BaseResult br = new BaseResult(result.getData());
                    br.setErrCode(result.getErrorCode().getCode());
                    br.setErrMsg(result.getErrorCode().getMessage());
                    return br;
                }
                if (result.getErrorCode().getCode().equals("cancell")) {
                    BaseResult br = new BaseResult(result.getData());
                    br.setErrCode("cancell");
                    br.setErrMsg(result.getErrorCode().getMessage());
                    return br;
                }
                logger.error("processFunction error");
                BaseResult br = new BaseResult();
                br.setErrCode("-1");
                br.setData(null);
                return br;
            }
        }
        return null;
    }

    private static RunStepMessage createRunStepMessage(RunStep runStep, String chatSessionId, String stepType) {
        RunStepMessage runStepMessage = new RunStepMessage();
        runStepMessage.setId(chatSessionId);
        runStepMessage.setStepTypeName(stepType);
        runStepMessage.setRunId(StrUtils.longAsString(runStep.getRunId()));
        runStepMessage.setRunStepId(StrUtils.longAsString(runStep.getRunStepId()));
        runStepMessage.setTaskId(StrUtils.longAsString(runStep.getRunId()));
        runStepMessage.setType(ChatMessageTypeEnum.RUNSTEP.getId());
        runStepMessage.setStream(Boolean.FALSE);
        runStepMessage.setStepStatus(RunStepStatusEnum.IN_PROGRESS.getId());
        return runStepMessage;
    }

    public static BaseResult functionCall(String chatSessionId, Agent agent, AgentAction action, RunStep runStep) {
        logger.info("functionCall \u3010action\u3011:{} \u3010runStep\u3011:{}", (Object)JSONObject.toJSONString((Object)action), (Object)JSONObject.toJSONString((Object)runStep));
        String functionName = (String)EngineCache.getAppCache(chatSessionId).get(String.format("%s%s", "name_", action.getName()), String.class);
        String toolType = (String)EngineCache.getAppCache(chatSessionId).get(String.format("%s%s", "tool_", action.getName()), String.class);
        if (toolType == null || functionName == null) {
            BaseResult baseResult = new BaseResult();
            baseResult.setErrCode(Errors.OK.getCode());
            baseResult.setData("\u8bf7\u4e0d\u8981\u968f\u610f\u751f\u6210\u4e00\u4e2a\uff0c\u7cfb\u7edf\u672a\u63d0\u4f9b\u7684\u5de5\u5177\uff0c\u8bf7\u7ee7\u7eed\u6267\u884c\u4e0a\u4e00\u6761\u6307\u4ee4!");
            return baseResult;
        }
        logger.info("functionCall functionName:{} toolType:{}", (Object)functionName, (Object)toolType);
        runStep.setAgentSkillType(toolType);
        try {
            return FunctionStrategyFactory.getStrategy(toolType).execute(chatSessionId, agent, action, runStep);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5de5\u5177\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private static BaseResult invokeSafely(Supplier<BaseResult> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            logger.error("\u7b56\u7565\u6267\u884c\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static BaseResult openApiFunction(String chatSessionId, Agent agent, AgentAction action, RunStep runStep) {
        List<OpenApi> openApiList = agent.getOpenApiList();
        String actionName = (String)EngineCache.getAppCache(chatSessionId).get(action.getName(), String.class);
        logger.info("actionName:{}", (Object)actionName);
        if (openApiList != null) {
            for (OpenApi openApi : openApiList) {
                String openApiNumber = actionName.split(SPLITTAG)[1].trim();
                String openApiName = actionName.split(SPLITTAG)[0].trim();
                runStep.setType(openApi.getName());
                if ((!StrUtils.isLong(openApiNumber) || openApi.getId() != Long.parseLong(openApiNumber)) && !openApiName.equalsIgnoreCase(openApi.getName())) continue;
                Map<String, Object> param = action.getInputs();
                if (param == null) {
                    param = new HashMap<String, Object>();
                }
                if (!param.containsKey("pageSize")) {
                    param.put("pageSize", 10);
                }
                param.put("optionvariables", ImmutableMap.builder().put((Object)"mutex_ignoremodify", (Object)"true").put((Object)"isStrict", (Object)"false").put((Object)"ignoreValidation", (Object)"true").build());
                HashMap<String, String> header = new HashMap<String, String>(0);
                CosmicOpenAPI api = new CosmicOpenAPI(openApi.getId(), param, header);
                long start = System.currentTimeMillis();
                OpenApiResult result = CosmicOpenAPIService.getService().call(api);
                long end = System.currentTimeMillis();
                TraceUtil.saveAgentCallToolLog(chatSessionId, runStep.getRunId(), openApi.getId(), openApi.getName(), JSONObject.toJSONString(param), result.toString(), start, end);
                BaseResult br = new BaseResult(result.getData() != null ? JSONObject.toJSONString((Object)result.getData()) : "");
                br.setErrCode(result.getErrorCode());
                br.setErrMsg(result.getMessage());
                return br;
            }
        }
        return null;
    }

    public static BaseResult ragFunction(String chatSessionId, Agent agent, AgentAction action, RunStep runStep) {
        List<Repo> repoList = agent.getRepoList();
        String actionName = (String)EngineCache.getAppCache(chatSessionId).get(action.getName(), String.class);
        logger.info("actionName:{}", (Object)actionName);
        if (repoList != null) {
            for (Repo repo : repoList) {
                String ragNumber = actionName.split(SPLITTAG)[1].trim();
                String name = actionName.split(SPLITTAG)[0].trim();
                ragNumber = actionName.split(SPLITTAG)[1].trim();
                name = actionName.split(SPLITTAG)[0].trim();
                runStep.setType(repo.getName());
                logger.info("ragNumber:{},repo.getId:{},name:{},getNumber:{}", new Object[]{ragNumber, repo.getId(), name, repo.getNumber()});
                if ((!StrUtils.isLong(ragNumber) || repo.getId() != Long.parseLong(ragNumber)) && !name.equalsIgnoreCase(repo.getNumber())) continue;
                Map<String, Object> params = action.getInputs();
                AgentCommonService agentCommonService = new AgentCommonService();
                ArrayList<Long> repos = new ArrayList<Long>(2);
                repos.add(Long.parseLong(ragNumber));
                long start = System.currentTimeMillis();
                List<String> retrievalResult = agentCommonService.retrive(repos, params.get("text").toString(), 10);
                long end = System.currentTimeMillis();
                TraceUtil.saveAgentCallToolLog(chatSessionId, runStep.getRunId(), repo.getId(), repo.getName(), JSONObject.toJSONString(params), retrievalResult.toString(), start, end);
                return new BaseResult(retrievalResult);
            }
        }
        return null;
    }

    public static BaseResult toolFunction(String chatSessionId, Agent agent, AgentAction action, RunStep runStep) {
        List<Tool> toolList = agent.getToolList();
        if (toolList == null || toolList.isEmpty()) {
            return null;
        }
        String acName = (String)EngineCache.getAppCache(chatSessionId).get(action.getName(), String.class);
        logger.info("actionName:{}", (Object)acName);
        String[] splits = acName.split(SPLITTAG);
        String toolNumber = splits.length == 2 ? splits[1].trim() : acName;
        String operationId = splits.length == 2 ? splits[0].trim() : "";
        logger.info("action:{},toolNumber:{},operationId:{}", new Object[]{action.getName(), toolNumber, operationId});
        for (Tool tool : toolList) {
            String type;
            ToolExecutor executor;
            if (!toolNumber.equals(tool.getNumber()) || (executor = ToolExecutorFactory.getExecutor(type = tool.getType())) == null) continue;
            Map<String, Object> params = action.getInputs();
            runStep.setType(tool.getName());
            try {
                String ops;
                JSONObject selected = JSON.parseObject((String)tool.getSelected());
                if (selected.containsKey((Object)"operations") && (ops = selected.getString("operations")).equalsIgnoreCase(operationId)) {
                    String operationName = selected.getString("operationName");
                    runStep.setType(tool.getName() + "|" + operationName);
                }
            }
            catch (Exception e) {
                logger.warn("\u89e3\u6790 selected \u5b57\u6bb5\u5931\u8d25", (Throwable)e);
            }
            return executor.execute(chatSessionId, agent, action, runStep, tool, operationId, params);
        }
        return null;
    }

    public static JSONArray processToFunction(String chatSessionId, List<Process> processList, JSONArray functionTools) {
        return ToolServiceFunctionCall.createFunctionArray(chatSessionId, processList, functionTools, Process::getName, Process::getId, Process::getDescription, AgentSkillTypeEnum.PROCESS, (process, properties, paramJsonArray) -> {
            Flow flow = JsonUtil.fromBase64String(process.getFflow());
            for (Var var : flow.getStart().getInputVars()) {
                if (var.getName().startsWith("system") && !var.getName().equals("system.user_input")) continue;
                if (var.getName().equals("system.user_input")) {
                    var.setName("input");
                }
                ToolServiceFunctionCall.addParameter(var.getName(), var.getType(), var.getDesc(), properties, paramJsonArray);
            }
        });
    }

    public static JSONArray promtToFunction(String chatSessionId, List<Prompt> promptList, JSONArray functionTools) {
        return ToolServiceFunctionCall.createFunctionArray(chatSessionId, promptList, functionTools, Prompt::getName, Prompt::getId, Prompt::getDescription, AgentSkillTypeEnum.PROMPT, (prompt, properties, paramJsonArray) -> {
            for (VarParam varParam : prompt.getVarParams()) {
                if ("input".equals(varParam.getKey())) continue;
                ToolServiceFunctionCall.addParameter(varParam.getKey(), varParam.getType(), varParam.getName(), properties, paramJsonArray);
            }
            ToolServiceFunctionCall.addParameter("input", "string", "\u57fa\u4e8e\u4f1a\u8bdd\u8bb0\u5f55\u8bc6\u522b\u7684\u7528\u6237\u9700\u6c42", properties, paramJsonArray);
        });
    }

    public static JSONArray ragToFunction(String chatSessionId, List<Repo> repoList, JSONArray functionTools) {
        return ToolServiceFunctionCall.createFunctionArray(chatSessionId, repoList, functionTools, Repo::getNumber, Repo::getId, Repo::getDescription, AgentSkillTypeEnum.RAG, (repo, properties, paramJsonArray) -> ToolServiceFunctionCall.addParameter("text", "string", "\u9700\u8981\u68c0\u7d22\u7684\u5185\u5bb9", properties, paramJsonArray));
    }

    public static JSONArray openApiToFunction(String chatSessionId, List<OpenApi> openApiList, JSONArray functionTools) {
        return ToolServiceFunctionCall.createFunctionArray(chatSessionId, openApiList, functionTools, OpenApi::getName, OpenApi::getId, OpenApi::getDescription, AgentSkillTypeEnum.OPENAPI, (openApi, properties, paramJsonArray) -> {
            CosmicOpenAPIInfo info = CosmicOpenAPIUtils.parserCosmicOpenAPIInfo(openApi.getId());
            for (CosmicOpenAPIParam param : info.getRequest()) {
                JSONObject paramStr = ToolServiceFunctionCall.addParameter(param.getParamName(), param.getParamType(), param.getDesc(), properties, paramJsonArray);
                if (param.getChildList().isEmpty()) continue;
                ToolServiceFunctionCall.handleChildParameters(param, properties, paramStr);
            }
        });
    }

    private static <T> JSONArray createFunctionArray(String chatSessionId, List<T> itemList, JSONArray functionTools, Function<T, String> getName, Function<T, Long> getId, Function<T, String> getDescription, AgentSkillTypeEnum agentSkillType, TriConsumer<T, JSONObject, JSONArray> parameterHandler) {
        JSONArray result = new JSONArray();
        if (itemList != null) {
            for (T item : itemList) {
                String name;
                String sourceName = name = getName.apply(item);
                Long id = getId.apply(item);
                String desc = getDescription.apply(item);
                if (StringUtils.isEmpty((CharSequence)desc)) {
                    desc = name;
                }
                JSONObject itemJo = new JSONObject();
                result.add((Object)itemJo);
                String functionName = name + SPLITTAG + id;
                String function = name;
                logger.error("function:{},sourceName:{},tool:{}", new Object[]{function, sourceName, agentSkillType.getId()});
                EngineCache.getAppCache(chatSessionId).put(String.format("%s%s", "name_", function), (Object)sourceName);
                EngineCache.getAppCache(chatSessionId).put(function, (Object)functionName);
                EngineCache.getAppCache(chatSessionId).put(String.format("%s%s", "tool_", function), (Object)agentSkillType.getId());
                itemJo.put("name", (Object)function);
                itemJo.put("desc", (Object)desc);
                JSONArray paramJsonArray = new JSONArray();
                itemJo.put("param", (Object)paramJsonArray);
                JSONObject functionToolJo = new JSONObject();
                if (functionTools != null) {
                    functionTools.add((Object)functionToolJo);
                }
                functionToolJo.put("name", (Object)function);
                functionToolJo.put("description", (Object)desc);
                JSONObject functionPrameters = new JSONObject();
                functionPrameters.put("type", (Object)"object");
                functionToolJo.put("parameters", (Object)functionPrameters);
                JSONObject properties = new JSONObject();
                functionPrameters.put("properties", (Object)properties);
                parameterHandler.accept(item, properties, paramJsonArray);
            }
        }
        return result;
    }

    private static JSONObject addParameter(String name, String type, String desc, JSONObject properties, JSONArray paramJsonArray) {
        JSONObject param = new JSONObject();
        param.put("type", (Object)type);
        param.put("desc", (Object)desc);
        JSONObject paramStr = new JSONObject();
        paramStr.put(name, (Object)param);
        properties.put(name, (Object)param);
        paramJsonArray.add((Object)paramStr);
        return paramStr;
    }

    public static JSONArray toolToFunction(String chatSessionId, List<Tool> toolList, JSONArray functionTools) {
        if (toolList == null) {
            return new JSONArray();
        }
        JSONArray tools = new JSONArray();
        for (Tool tool : toolList) {
            ToolHandler handler = ToolServiceFunctionCall.getToolHandler(tool.getType());
            if (handler == null) continue;
            handler.handle(chatSessionId, tool, tools, functionTools);
        }
        return tools;
    }

    private static ToolHandler getToolHandler(String type) {
        switch (ToolConstant.ToolType.valueOf(type.toUpperCase())) {
            case THIRD_OPENAPI: 
            case COSMIC_OPENAPI: {
                return new OpenApiToolHandler();
            }
            case RESTFUL_API: 
            case MCP_TOOL: {
                return new RestfulApiToolHandler();
            }
            case COSMIC_ACTION: {
                return new CosmicActionToolHandler();
            }
            case INTERNAL_MCP: {
                return new InternalMcpToolHandler();
            }
        }
        return null;
    }

    private static JSONObject parseSelected(String toolSelected) {
        if (StringUtils.isBlank((CharSequence)toolSelected)) {
            return new JSONObject();
        }
        return JSONObject.parseObject((String)toolSelected);
    }

    private static void addToolAndFunction(String chatSessionId, Tool tool, OperationParam operationParam, String components, JSONArray tools, JSONArray functionTools) {
        Map<String, MediaType> content;
        String sourceName;
        JSONObject toolJo = new JSONObject();
        String function = sourceName = operationParam.getName();
        String functionName = "";
        functionName = tool.getType().equalsIgnoreCase(ToolConstant.ToolType.RESTFUL_API.getType()) || tool.getType().equalsIgnoreCase(ToolConstant.ToolType.MCP_TOOL.getType()) ? operationParam.getOperationId() + SPLITTAG + tool.getNumber() : tool.getName() + SPLITTAG + tool.getNumber();
        toolJo.put("name", (Object)function);
        toolJo.put("desc", (Object)tool.getDescription());
        JSONObject functionToolJo = new JSONObject();
        functionToolJo.put("name", (Object)function);
        functionToolJo.put("description", (Object)tool.getDescription());
        if (functionTools != null) {
            functionTools.add((Object)functionToolJo);
        }
        tools.add((Object)toolJo);
        logger.info("function:{},sourceName:{},tool:{}", new Object[]{function, sourceName, AgentSkillTypeEnum.TOOL.getId()});
        EngineCache.getAppCache(chatSessionId).put(String.format("%s%s", "name_", function), (Object)sourceName);
        EngineCache.getAppCache(chatSessionId).put(function, (Object)functionName);
        EngineCache.getAppCache(chatSessionId).put(String.format("%s%s", "tool_", function), (Object)AgentSkillTypeEnum.TOOL.getId());
        toolJo.put("name", (Object)function);
        toolJo.put("desc", (Object)operationParam.getSummary());
        functionToolJo.put("name", (Object)function);
        functionToolJo.put("description", (Object)operationParam.getSummary());
        List<Parameter> parameters = operationParam.getParameters();
        JSONArray parametersJo = new JSONArray();
        toolJo.put("param", (Object)parametersJo);
        JSONObject properties = new JSONObject();
        JSONObject functionPrameters = new JSONObject();
        functionPrameters.put("type", (Object)"object");
        functionPrameters.put("properties", (Object)properties);
        functionToolJo.put("parameters", (Object)functionPrameters);
        for (Parameter parameter : parameters) {
            JSONObject param = new JSONObject();
            JSONObject paramVar = new JSONObject();
            param.put(parameter.getName(), (Object)paramVar);
            properties.put(parameter.getName(), (Object)paramVar);
            paramVar.put("desc", (Object)parameter.getDescription());
            if (parameter.getSchema() != null) {
                if ("String".equals(parameter.getSchema().getType())) {
                    parameter.getSchema().setType("string");
                }
                paramVar.put("type", (Object)parameter.getSchema().getType());
            }
            parametersJo.add((Object)param);
        }
        RequestBody requestBody = operationParam.getRequestBody();
        if (requestBody != null && (content = requestBody.getContent()) != null && !content.isEmpty()) {
            ArrayList<String> contentTypes = new ArrayList<String>(content.keySet());
            for (String contentType : contentTypes) {
                MediaType mediaType = content.get(contentType);
                JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)mediaType));
                if (jsonObject == null) continue;
                Schema schema = mediaType.getSchema();
                JSONObject schemaObj = JSONObject.parseObject((String)JSONObject.toJSONString((Object)schema));
                JSON outputSchema = OpenAPIProtocolUtils.getSchemaJSONAndType(schemaObj);
                parametersJo.add((Object)outputSchema);
            }
        }
        for (int i = 0; i < parametersJo.size(); ++i) {
            if (parametersJo.get(i) instanceof JSONObject) {
                JSONObject json = parametersJo.getJSONObject(i);
                properties.putAll((Map)json);
                continue;
            }
            if (!(parametersJo.get(i) instanceof JSONArray)) continue;
            JSONArray jsonArray = parametersJo.getJSONArray(i);
            for (int j = 0; j < jsonArray.size(); ++j) {
            }
        }
    }

    private static JSONObject createFunctionParametersJSONObject(JSONObject properties) {
        JSONObject functionPrameters = new JSONObject();
        functionPrameters.put("type", (Object)"object");
        functionPrameters.put("properties", (Object)properties);
        return functionPrameters;
    }

    public static String genFunctionName(int length) {
        StringBuilder functionName = new StringBuilder(length);
        functionName.append("func_");
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(CHARACTERS.length());
            functionName.append(CHARACTERS.charAt(index));
        }
        if (Character.isDigit(functionName.charAt(0))) {
            functionName.setCharAt(0, CHARACTERS.charAt(random.nextInt(26) + 26));
        }
        return functionName.toString();
    }

    private static void handleChildParameters(CosmicOpenAPIParam param, JSONObject properties, JSONObject paramStr) {
        if (param.getParamType().toLowerCase(Locale.ROOT).contains("array")) {
            JSONArray jsonArray = new JSONArray();
            paramStr.put(param.getParamName(), (Object)jsonArray);
            for (CosmicOpenAPIParam childParam : param.getChildList()) {
                JSONObject childParamJson = new JSONObject();
                childParamJson.put("type", (Object)childParam.getParamType());
                childParamJson.put("desc", (Object)childParam.getDesc());
                JSONObject parammStr = new JSONObject();
                parammStr.put(childParam.getParamName(), (Object)childParamJson);
                jsonArray.add((Object)parammStr);
            }
            properties.put(param.getParamName(), (Object)jsonArray);
        } else {
            JSONObject jsonJo = new JSONObject();
            paramStr.put(param.getParamName(), (Object)jsonJo);
            for (CosmicOpenAPIParam childParam : param.getChildList()) {
                JSONObject childParamJson = new JSONObject();
                childParamJson.put("type", (Object)childParam.getParamType());
                childParamJson.put("desc", (Object)childParam.getDesc());
                JSONObject parammStr = new JSONObject();
                parammStr.put(childParam.getParamName(), (Object)childParamJson);
                jsonJo.putAll((Map)parammStr);
            }
            properties.put(param.getParamName(), (Object)jsonJo);
        }
    }

    public static String parseSchemaName(String pre, String $ref) {
        return $ref.substring(pre.length());
    }

    public static JSON getSchemaJSON(String components, String schemaName, String type) {
        return ToolServiceFunctionCall.getSchemaJSON(components, schemaName, type, new JSONObject());
    }

    public static JSON getSchemaJSON(String components, JSONObject schema, String type) {
        return ToolServiceFunctionCall.getSchemaJSON(components, null, schema, type, new JSONObject());
    }

    public static JSON getSchemaJSON(String components, String propName, JSONObject schema, String type, JSONObject xmlConfig) {
        JSONObject data = null;
        String schemaType = schema.getString("type");
        if (StringUtils.equalsIgnoreCase((CharSequence)schemaType, (CharSequence)"object")) {
            JSONObject props = schema.getJSONObject("properties");
            data = ToolServiceFunctionCall.handlerProperties(components, props, type, xmlConfig);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)schemaType, (CharSequence)"array")) {
            data = ToolServiceFunctionCall.handlerItems(components, propName, schema, type, xmlConfig);
        }
        return data;
    }

    public static JSON getSchemaJSON(String components, String schemaName, String type, JSONObject xmlConfig) {
        JSONObject schema;
        JSONObject data = null;
        Map<String, JSONObject> stringJSONObjectMap = ToolServiceFunctionCall.parseSchema(components);
        if (stringJSONObjectMap != null && !stringJSONObjectMap.isEmpty() && (schema = stringJSONObjectMap.get(schemaName)) != null) {
            String schemaType = schema.getString("type");
            if (StringUtils.equalsIgnoreCase((CharSequence)schemaType, (CharSequence)"object")) {
                JSONObject props = schema.getJSONObject("properties");
                data = ToolServiceFunctionCall.handlerProperties(components, props, type, xmlConfig);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)schemaType, (CharSequence)"array")) {
                data = ToolServiceFunctionCall.handlerItems(components, schemaName, schema, type, xmlConfig);
            }
        }
        return data;
    }

    public static Map<String, JSONObject> parseSchema(String componentsJson) {
        JSONObject schemas;
        HashMap<String, JSONObject> stringJSONObjectMap = new HashMap<String, JSONObject>();
        if (StringUtils.isEmpty((CharSequence)componentsJson)) {
            return new HashMap<String, JSONObject>();
        }
        JSONObject components = JSONObject.parseObject((String)componentsJson);
        if (components != null && !components.isEmpty() && (schemas = components.getJSONObject("schemas")) != null && !schemas.isEmpty()) {
            for (String schemaName : schemas.keySet()) {
                stringJSONObjectMap.put(schemaName, schemas.getJSONObject(schemaName));
            }
        }
        return stringJSONObjectMap;
    }

    public static String parseRefXMLNode(String components, String $ref) {
        JSONObject schema;
        String nodeName = "";
        String schemaName = ToolServiceFunctionCall.parseSchemaName("#/components/schemas/", $ref);
        Map<String, JSONObject> stringJSONObjectMap = ToolServiceFunctionCall.parseSchema(components);
        if (stringJSONObjectMap != null && !stringJSONObjectMap.isEmpty() && (schema = stringJSONObjectMap.get(schemaName)) != null && schema.containsKey((Object)"xml")) {
            nodeName = schema.getJSONObject("xml").getString("name");
        }
        return nodeName;
    }

    public static JSONArray handlerItems(String components, String propName, JSONObject schema, String contentType, JSONObject xmlConfig) {
        String xmlNodeName = "";
        boolean wrapped = Boolean.FALSE;
        if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.APPLICATION_XML.getType())) {
            if (schema.containsKey((Object)"xml")) {
                JSONObject xml = schema.getJSONObject("xml");
                if (xml != null) {
                    if (xml.containsKey((Object)"wrapped")) {
                        wrapped = xml.getBoolean("wrapped");
                    }
                    if (wrapped) {
                        JSONObject itemsObj = schema.getJSONObject("items");
                        if (itemsObj.containsKey((Object)"xml")) {
                            JSONObject xmlObj = itemsObj.getJSONObject("xml");
                            if (xmlObj != null && xmlObj.containsKey((Object)"name")) {
                                xmlNodeName = xmlObj.getString("name");
                            }
                        } else if (itemsObj.containsKey((Object)"$ref")) {
                            xmlNodeName = ToolServiceFunctionCall.parseRefXMLNode(components, itemsObj.getString("$ref"));
                        }
                    }
                }
            } else {
                JSONObject items = schema.getJSONObject("items");
                if (items != null && items.containsKey((Object)"$ref")) {
                    xmlNodeName = ToolServiceFunctionCall.parseRefXMLNode(components, items.getString("$ref"));
                }
            }
            if (!StringUtils.isEmpty((CharSequence)propName)) {
                JSONObject config = new JSONObject();
                config.put("_$XML_NODE_NAME$_", (Object)xmlNodeName);
                config.put("_$XML_WRAPPED$_", (Object)wrapped);
                xmlConfig.put(propName, (Object)config);
            }
        }
        return ToolServiceFunctionCall.parseItems(components, propName, schema, contentType, xmlConfig);
    }

    public static JSONArray parseItems(String components, String propName, JSONObject schema, String contentType, JSONObject xmlConfig) {
        JSONObject items = schema.getJSONObject("items");
        JSONArray data = new JSONArray();
        if (items.containsKey((Object)"$ref")) {
            String ref = items.getString("$ref");
            String schemaName = ToolServiceFunctionCall.parseSchemaName("#/components/schemas/", ref);
            JSON json = ToolServiceFunctionCall.getSchemaJSON(components, schemaName, contentType, xmlConfig);
            data.add((Object)json);
        } else {
            String itemType = items.getString("type");
            String desc = schema.getString("description");
            if (StringUtils.equalsIgnoreCase((CharSequence)itemType, (CharSequence)"object")) {
                JSONObject itemProps = items.getJSONObject("properties");
                JSONObject item = ToolServiceFunctionCall.handlerProperties(components, itemProps, contentType, xmlConfig);
                data.add((Object)item);
            } else if ("array".equalsIgnoreCase(itemType)) {
                JSONObject itemsObj = items.getJSONObject("items");
                JSONArray array = ToolServiceFunctionCall.handlerItems(components, propName, itemsObj, contentType, xmlConfig);
                data.add((Object)array);
            } else if ("integer".equalsIgnoreCase(itemType)) {
                JSONObject item = new JSONObject();
                item.put("type", (Object)itemType);
                item.put("description", (Object)desc);
                data.add((Object)item);
            } else if ("number".equalsIgnoreCase(itemType)) {
                JSONObject item = new JSONObject();
                item.put("type", (Object)itemType);
                item.put("description", (Object)desc);
                data.add((Object)item);
            } else if ("boolean".equalsIgnoreCase(itemType)) {
                JSONObject item = new JSONObject();
                item.put("type", (Object)itemType);
                item.put("description", (Object)desc);
                data.add((Object)item);
            } else if ("string".equalsIgnoreCase(itemType)) {
                JSONObject item = new JSONObject();
                item.put("type", (Object)"string");
                item.put("description", (Object)desc);
                data.add((Object)item);
            }
        }
        return data;
    }

    public static JSONObject getRefSchema(String components, String $ref) {
        String schemaName = ToolServiceFunctionCall.parseSchemaName("#/components/schemas/", $ref);
        Map<String, JSONObject> stringJSONObjectMap = ToolServiceFunctionCall.parseSchema(components);
        if (stringJSONObjectMap != null && !stringJSONObjectMap.isEmpty()) {
            JSONObject schema = stringJSONObjectMap.get(schemaName);
            return schema;
        }
        return new JSONObject();
    }

    public static JSONObject handlerProperties(String components, JSONObject props, String contentType) {
        return ToolServiceFunctionCall.handlerProperties(components, props, contentType, new JSONObject());
    }

    public static JSONObject handlerProperties(String components, JSONObject props, String contentType, JSONObject xmlConfig) {
        JSONObject data = new JSONObject();
        if (props != null && !props.isEmpty()) {
            for (String propName : props.keySet()) {
                JSONObject prop = props.getJSONObject(propName);
                String type = prop.getString("type");
                String desc = prop.getString("description");
                JSONObject propData = new JSONObject();
                data.put(propName, (Object)propData);
                if ("string".equalsIgnoreCase(type)) {
                    propData.put("description", (Object)desc);
                    propData.put("type", (Object)"string");
                    continue;
                }
                if ("integer".equalsIgnoreCase(type)) {
                    propData.put("description", (Object)desc);
                    propData.put("type", (Object)type);
                    continue;
                }
                if ("number".equalsIgnoreCase(type)) {
                    propData.put("description", (Object)desc);
                    propData.put("type", (Object)type);
                    continue;
                }
                if ("boolean".equalsIgnoreCase(type)) {
                    propData.put("description", (Object)desc);
                    propData.put("type", (Object)type);
                    continue;
                }
                if ("object".equalsIgnoreCase(type)) {
                    JSONObject subProps = prop.getJSONObject("properties");
                    JSONObject subPropsData = ToolServiceFunctionCall.handlerProperties(components, subProps, contentType);
                    propData.put(propName, (Object)subPropsData);
                    continue;
                }
                if ("array".equalsIgnoreCase(type)) {
                    JSONArray array = ToolServiceFunctionCall.handlerItems(components, propName, prop, contentType, xmlConfig);
                    data.put(propName, (Object)array);
                    continue;
                }
                if (!prop.containsKey((Object)"$ref")) continue;
                String ref = prop.getString("$ref");
                JSONObject schema = ToolServiceFunctionCall.getRefSchema(components, ref);
                JSONObject subProps = schema.getJSONObject("properties");
                JSONObject subPropsData = ToolServiceFunctionCall.handlerProperties(components, subProps, contentType, xmlConfig);
                propData.put(propName, (Object)subPropsData);
            }
        }
        return data;
    }

    public static JSON handlerApplicationJSON(String components, JSONObject mediaType) {
        JSONObject schema = mediaType.getJSONObject("schema");
        JSON data = null;
        if (schema != null) {
            String $ref = schema.getString("$ref");
            if (!StringUtils.isEmpty((CharSequence)$ref)) {
                String schemaName = ToolServiceFunctionCall.parseSchemaName("#/components/schemas/", $ref);
                data = ToolServiceFunctionCall.getSchemaJSON(components, schemaName, ToolConstant.ContentType.APPLICATION_JSON.getType());
            } else {
                data = ToolServiceFunctionCall.getSchemaJSON(components, schema, ToolConstant.ContentType.APPLICATION_JSON.getType());
            }
        }
        return data;
    }

    public static JSONArray handlerProps(JSON json) {
        JSONArray params = new JSONArray();
        if (json != null) {
            JSONArray array;
            if (json instanceof JSONObject) {
                JSONObject item = (JSONObject)json;
                ToolServiceFunctionCall.handlerParameters(params, item);
            } else if (json instanceof JSONArray && (array = (JSONArray)json) != null && !array.isEmpty()) {
                JSONObject item = array.getJSONObject(0);
                ToolServiceFunctionCall.handlerParameters(params, item);
            }
        }
        return params;
    }

    public static void handlerParameters(JSONArray params, JSONObject item) {
        for (String propName : item.keySet()) {
            JSONObject data = new JSONObject();
            Object value = item.get((Object)propName);
            data.put("name", (Object)propName);
            if (value != null) {
                String typeName = value.getClass().getName();
                int length = typeName.lastIndexOf(".");
                String type = typeName.substring(length + 1);
                data.put("dataType", (Object)type);
            }
            params.add((Object)data);
        }
    }

    public static JSON handlerBodyURLEncodedParam(String components, String contentType, JSONObject mediaType) {
        JSONObject schema = mediaType.getJSONObject("schema");
        if (schema != null) {
            String $ref = schema.getString("$ref");
            if (!StringUtils.isEmpty((CharSequence)$ref)) {
                String schemaName = ToolServiceFunctionCall.parseSchemaName("#/components/schemas/", $ref);
                JSON data = ToolServiceFunctionCall.getSchemaJSON(components, schemaName, ToolConstant.ContentType.APPLICATION_JSON.getType());
                JSONArray params = ToolServiceFunctionCall.handlerProps(data);
                return params;
            }
            JSON data = ToolServiceFunctionCall.getSchemaJSON(components, schema, ToolConstant.ContentType.APPLICATION_JSON.getType());
            JSONArray params = ToolServiceFunctionCall.handlerProps(data);
            return params;
        }
        return null;
    }

    public static BaseResult restCall(Map<String, Object> requestParams) {
        return null;
    }

    public static BaseResult cosmicCall(Map<String, Object> requestParams) {
        CosmicAction cosmicAction = new CosmicAction();
        cosmicAction.setToolId(Long.parseLong(String.valueOf(requestParams.get("toolId"))));
        String chatSessionId = String.valueOf(requestParams.get("chatSessionId"));
        cosmicAction.setChatSessionId(chatSessionId);
        Object paramsObj = requestParams.get("params");
        JSONObject toolParams = new JSONObject();
        cosmicAction.setToolParams(toolParams);
        JSONArray inputParams = new JSONArray();
        if (paramsObj != null) {
            Map params = (Map)JSON.parseObject((String)JSONObject.toJSONString((Object)paramsObj), Map.class);
            for (Map.Entry entry : params.entrySet()) {
                JSONObject param = new JSONObject();
                param.put("paramName", entry.getKey());
                param.put("paramValue", entry.getValue());
                inputParams.add((Object)param);
            }
        }
        toolParams.put("inputParams", (Object)inputParams);
        BaseResult br = CosmicActionService.call(cosmicAction);
        if (br != null && br.getData() != null && br.getDataAsJSONObject() != null) {
            br.setData(br.getDataAsJSONObject().getJSONObject("output"));
        }
        return br;
    }

    private static void validateParameters(String toolId, String toolType) {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)toolId)) {
            errors.add("toolId cannot be null or empty");
        }
        if (StringUtils.isBlank((CharSequence)toolType)) {
            errors.add("toolType cannot be null or empty");
        } else {
            try {
                ToolConstant.ToolType.valueOf(toolType.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                errors.add("invalid searchMode: " + toolType);
            }
        }
        if (!errors.isEmpty()) {
            String errorMessage = String.join((CharSequence)"; ", errors);
            logger.error("Parameter validation failed: {}", (Object)errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static BaseResult toolService(Map<String, Object> requestParams) {
        logger.info("the requestParams is {}", (Object)requestParams.toString());
        Object toolId = requestParams.get("toolId");
        String type = String.valueOf(requestParams.get("type"));
        ToolServiceFunctionCall.validateParameters(toolId == null ? "" : String.valueOf(toolId), type);
        switch (ToolConstant.ToolType.valueOf(type.toUpperCase())) {
            case COSMIC_ACTION: {
                return ToolServiceFunctionCall.cosmicCall(requestParams);
            }
        }
        logger.error("the tool type is not the cosmic or rest");
        return null;
    }

    @FunctionalInterface
    static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);
    }

    private static class CosmicActionToolHandler
    implements ToolHandler {
        private CosmicActionToolHandler() {
        }

        @Override
        public void handle(String chatSessionId, Tool tool, JSONArray tools, JSONArray functionTools) {
            String sourceName;
            JSONObject toolJo = new JSONObject();
            String function = sourceName = tool.getName();
            String functionName = tool.getName() + ToolServiceFunctionCall.SPLITTAG + tool.getNumber();
            logger.error("function:{},sourceName:{},tool:{}", new Object[]{function, sourceName, AgentSkillTypeEnum.TOOL.getId()});
            EngineCache.getAppCache(chatSessionId).put(String.format("%s%s", "name_", function), (Object)sourceName);
            EngineCache.getAppCache(chatSessionId).put(function, (Object)functionName);
            EngineCache.getAppCache(chatSessionId).put(String.format("%s%s", "tool_", function), (Object)AgentSkillTypeEnum.TOOL.getId());
            toolJo.put("name", (Object)function);
            toolJo.put("desc", (Object)tool.getDescription());
            JSONObject functionToolJo = new JSONObject();
            functionToolJo.put("name", (Object)function);
            functionToolJo.put("description", (Object)tool.getDescription());
            if (functionTools != null) {
                functionTools.add((Object)functionToolJo);
            }
            tools.add((Object)toolJo);
            JSONArray inputs = tool.getConfigTag().getJSONArray("inputParams");
            JSONObject properties = new JSONObject();
            JSONArray parametersJo = new JSONArray();
            toolJo.put("param", (Object)parametersJo);
            for (int i = 0; i < inputs.size(); ++i) {
                JSONObject param = new JSONObject();
                JSONObject paramVar = new JSONObject();
                param.put("type", (Object)inputs.getJSONObject(i).getString("paramType"));
                if ("String".equals(param.getString("type"))) {
                    param.put("type", (Object)"string");
                }
                param.put("desc", (Object)inputs.getJSONObject(i).getString("paramDesc"));
                paramVar.put(inputs.getJSONObject(i).getString("paramName"), (Object)param);
                properties.put(inputs.getJSONObject(i).getString("paramName"), (Object)param);
                parametersJo.add((Object)paramVar);
            }
            functionToolJo.put("parameters", (Object)ToolServiceFunctionCall.createFunctionParametersJSONObject(properties));
        }
    }

    private static class InternalMcpToolHandler
    implements ToolHandler {
        private InternalMcpToolHandler() {
        }

        @Override
        public void handle(String chatSessionId, Tool tool, JSONArray tools, JSONArray functionTools) {
            String desc = tool.getDescription();
            String type = tool.getType();
            String toolSelected = tool.getSelected();
            String operationId = "";
            if (toolSelected != null) {
                JSONObject jsonObject = JSONObject.parseObject((String)toolSelected);
                operationId = jsonObject.getString("operations");
            }
            Long apiId = Long.parseLong(operationId);
            CosmicOpenAPIInfo openApi = CosmicOpenAPIUtils.parserCosmicOpenAPIInfo(apiId);
            List<CosmicOpenAPIParam> params = openApi.getRequest();
            List<Map<String, String>> headers = openApi.getHeaders();
            JSONArray paramArray = new JSONArray();
            JSONObject functionToolJo = new JSONObject();
            String function = "";
            if (functionTools != null) {
                function = openApi.getName();
                functionTools.add((Object)functionToolJo);
            } else {
                function = openApi.getName();
            }
            String functionName = apiId + ToolServiceFunctionCall.SPLITTAG + tool.getNumber();
            EngineCache.getAppCache(chatSessionId).put(String.format("%s%s", "name_", function), (Object)openApi.getName());
            EngineCache.getAppCache(chatSessionId).put(function, (Object)functionName);
            EngineCache.getAppCache(chatSessionId).put(String.format("%s%s", "tool_", function), (Object)AgentSkillTypeEnum.TOOL.getId());
            functionToolJo.put("name", (Object)function);
            JSONObject openApiJo = new JSONObject();
            tools.add((Object)openApiJo);
            openApiJo.put("name", (Object)function);
            String openApiDesc = openApi.getDescription();
            if (openApiDesc == null || openApiDesc.length() == 0) {
                desc = openApi.getName();
            }
            openApiJo.put("desc", (Object)desc);
            functionToolJo.put("description", (Object)desc);
            JSONObject properties = new JSONObject();
            JSONObject functionPrameters = new JSONObject();
            functionPrameters.put("type", (Object)"object");
            functionToolJo.put("parameters", (Object)functionPrameters);
            functionPrameters.put("properties", (Object)properties);
            for (CosmicOpenAPIParam map : params) {
                JSONObject parammStr;
                JSONObject childParamJson;
                String childType;
                String childParamName;
                String childDesc;
                JSONObject paramJo = new JSONObject();
                String paramDesc = map.getDesc();
                String paramName = map.getParamName();
                String openApiType = map.getParamType();
                paramJo.put("type", (Object)openApiType);
                paramJo.put("desc", (Object)paramDesc);
                JSONObject paramStr = new JSONObject();
                openApiJo.put("param", (Object)paramArray);
                paramStr.put(paramName, (Object)paramJo);
                paramArray.add((Object)paramStr);
                properties.put(paramName, (Object)paramStr);
                if (map.getChildList().size() <= 0) continue;
                if (type.toLowerCase(Locale.ROOT).contains("array")) {
                    JSONArray jsonArray = new JSONArray();
                    paramStr.put(paramName, (Object)jsonArray);
                    for (CosmicOpenAPIParam childParam : map.getChildList()) {
                        childDesc = childParam.getDesc();
                        childParamName = childParam.getParamName();
                        childType = childParam.getParamType();
                        childParamJson = new JSONObject();
                        childParamJson.put("type", (Object)childType);
                        childParamJson.put("desc", (Object)childDesc);
                        parammStr = new JSONObject();
                        parammStr.put(childParamName, (Object)childParamJson);
                        jsonArray.add((Object)parammStr);
                    }
                    continue;
                }
                JSONObject jsonJo = new JSONObject();
                paramStr.put(paramName, (Object)jsonJo);
                for (CosmicOpenAPIParam childParam : map.getChildList()) {
                    childDesc = childParam.getDesc();
                    childParamName = childParam.getParamName();
                    childType = childParam.getParamType();
                    childParamJson = new JSONObject();
                    childParamJson.put("type", (Object)childType);
                    childParamJson.put("desc", (Object)childDesc);
                    parammStr = new JSONObject();
                    parammStr.put(childParamName, (Object)childParamJson);
                    jsonJo.putAll((Map)parammStr);
                }
            }
            for (Map map : headers) {
            }
        }
    }

    private static class RestfulApiToolHandler
    implements ToolHandler {
        private RestfulApiToolHandler() {
        }

        @Override
        public void handle(String chatSessionId, Tool tool, JSONArray tools, JSONArray functionTools) {
            String[] stringArray;
            JSONObject configTag = tool.getConfigTag();
            String operationId = ToolServiceFunctionCall.parseSelected(tool.getSelected()).getString("operations");
            if (operationId == null) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = operationId;
            }
            Map<String, OperationParam> operationParamMap = OpenAPIUtils.parserRestfulOperationParam(configTag, stringArray);
            for (Map.Entry<String, OperationParam> entry : operationParamMap.entrySet()) {
                ToolServiceFunctionCall.addToolAndFunction(chatSessionId, tool, entry.getValue(), null, tools, functionTools);
            }
        }
    }

    private static class OpenApiToolHandler
    implements ToolHandler {
        private OpenApiToolHandler() {
        }

        @Override
        public void handle(String chatSessionId, Tool tool, JSONArray tools, JSONArray functionTools) {
            JSONObject configTag = tool.getConfigTag();
            String swagger = configTag.getString("swaggerSchema");
            JSONObject swaggerJson = JSONObject.parseObject((String)swagger);
            JSONObject componentsJson = swaggerJson.getJSONObject("components");
            String components = componentsJson != null ? JSONObject.toJSONString((Object)componentsJson) : null;
            Map<String, OperationParam> operationParamMap = OpenAPIUtils.parseOperationParam(swagger);
            for (Map.Entry<String, OperationParam> entry : operationParamMap.entrySet()) {
                ToolServiceFunctionCall.addToolAndFunction(chatSessionId, tool, entry.getValue(), components, tools, functionTools);
            }
        }
    }

    private static interface ToolHandler {
        public void handle(String var1, Tool var2, JSONArray var3, JSONArray var4);
    }

    private static class InternalMcpExecutor
    implements ToolExecutor {
        private InternalMcpExecutor() {
        }

        @Override
        public BaseResult execute(String chatSessionId, Agent agent, AgentAction action, RunStep runStep, Tool tool, String operationId, Map<String, Object> params) {
            logger.info("actionName:{},action:{}", (Object)action.getName(), (Object)action.toString());
            Long apiId = Long.parseLong(operationId);
            CosmicOpenAPIInfo openApi = CosmicOpenAPIUtils.parserCosmicOpenAPIInfo(apiId);
            runStep.setType(openApi.getName());
            Map<String, Object> param = action.getInputs();
            if (param == null) {
                param = new HashMap<String, Object>();
            }
            if (!param.containsKey("pageSize")) {
                param.put("pageSize", 10);
            }
            logger.info("openApiFunction data:{}", (Object)JSONObject.toJSONString((Object)param.get("data")));
            param.put("optionvariables", ImmutableMap.builder().put((Object)"mutex_ignoremodify", (Object)"true").put((Object)"isStrict", (Object)"false").put((Object)"ignoreValidation", (Object)"true").build());
            logger.info("openApiFunction param:{}", (Object)JSONObject.toJSONString(param));
            HashMap<String, String> header = new HashMap<String, String>(0);
            CosmicOpenAPI api = new CosmicOpenAPI(apiId, param, header);
            long start = System.currentTimeMillis();
            OpenApiResult result = CosmicOpenAPIService.getService().call(api);
            BaseResult br = new BaseResult(result.getData() != null ? JSONObject.toJSONString((Object)result.getData()) : "");
            br.setErrCode(result.getErrorCode());
            br.setErrMsg(result.getMessage());
            long end = System.currentTimeMillis();
            TraceUtil.saveAgentCallToolLog(chatSessionId, runStep.getRunId(), apiId, openApi.getName(), JSONObject.toJSONString(param), JSONObject.toJSONString((Object)result), start, end);
            return br;
        }
    }

    private static class CosmicActionToolExecutor
    implements ToolExecutor {
        private CosmicActionToolExecutor() {
        }

        @Override
        public BaseResult execute(String chatSessionId, Agent agent, AgentAction action, RunStep runStep, Tool tool, String operationId, Map<String, Object> params) {
            CosmicAction cosmicAction = new CosmicAction();
            cosmicAction.setToolId(tool.getId());
            cosmicAction.setChatSessionId(chatSessionId);
            cosmicAction.setRunId(runStep.getRunId());
            cosmicAction.setRunStepId(runStep.getRunStepId());
            JSONObject toolParams = new JSONObject();
            cosmicAction.setToolParams(toolParams);
            JSONArray inputParams = new JSONArray();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                JSONObject param = new JSONObject();
                param.put("paramName", (Object)entry.getKey());
                param.put("paramValue", entry.getValue());
                inputParams.add((Object)param);
            }
            toolParams.put("inputParams", (Object)inputParams);
            long start = System.currentTimeMillis();
            BaseResult br = CosmicActionService.call(cosmicAction);
            long end = System.currentTimeMillis();
            if (br.getData() != null && br.getDataAsJSONObject() != null) {
                JSONObject output = br.getDataAsJSONObject().getJSONObject("output");
                br.setData(output);
            }
            TraceUtil.saveAgentCallToolLog(chatSessionId, runStep.getRunId(), tool.getId(), tool.getName(), JSONObject.toJSONString((Object)toolParams), JSONObject.toJSONString((Object)br.getData()), start, end);
            return br;
        }
    }

    private static class MCPTOOLExecutor
    implements ToolExecutor {
        private MCPTOOLExecutor() {
        }

        @Override
        public BaseResult execute(String chatSessionId, Agent agent, AgentAction action, RunStep runStep, Tool tool, String operationId, Map<String, Object> params) {
            logger.info("cal mcp tool ... params: {}", (Object)JSONObject.toJSONString(params));
            JSONObject congfitTag = tool.getConfigTag();
            MCPTool mcpTool = new MCPTool();
            JSONObject toolParams = new JSONObject();
            toolParams.put("operationId", (Object)operationId);
            Object properties = params.get("properties");
            if (properties != null) {
                params = (Map)properties;
            }
            toolParams.put("parameters", (Object)params);
            mcpTool.setToolId(tool.getId());
            mcpTool.setToolParams(toolParams);
            mcpTool.setChatSessionId(chatSessionId);
            mcpTool.setRunId(runStep.getRunId());
            logger.info("mcp operationId:{}", (Object)operationId);
            logger.info("tool function api.mcpTool:{}, configTag:{}", (Object)JSONObject.toJSONString((Object)mcpTool), (Object)JSONObject.toJSONString((Object)congfitTag));
            long start = System.currentTimeMillis();
            BaseResult result = MCPService.getService().callApi(congfitTag.toJSONString(), mcpTool);
            logger.info("mcp toolCallResult:{}", (Object)JSONObject.toJSONString((Object)result));
            long end = System.currentTimeMillis();
            TraceUtil.saveAgentCallToolLog(chatSessionId, runStep.getRunId(), tool.getId(), tool.getName(), JSONObject.toJSONString((Object)toolParams), JSONObject.toJSONString((Object)result.getData()), start, end);
            return result;
        }
    }

    private static class RestfulAPIToolExecutor
    implements ToolExecutor {
        private RestfulAPIToolExecutor() {
        }

        @Override
        public BaseResult execute(String chatSessionId, Agent agent, AgentAction action, RunStep runStep, Tool tool, String operationId, Map<String, Object> params) {
            JSONObject congfitTag = tool.getConfigTag();
            Map<String, OperationParam> operationParamMap = OpenAPIUtils.parserRestfulOperationParam(congfitTag, new String[0]);
            OperationParam operationParam = operationParamMap.get(operationId);
            boolean flag = operationParam != null && operationParam.getMethod().equalsIgnoreCase("post");
            RestfulAPI api = new RestfulAPI();
            JSONObject body = new JSONObject();
            JSONArray getParameters = new JSONArray();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                body.put(entry.getKey(), entry.getValue());
                JSONObject json = new JSONObject();
                json.put("name", (Object)entry.getKey());
                json.put("value", entry.getValue());
                getParameters.add((Object)json);
            }
            JSONObject toolParams = new JSONObject();
            toolParams.put("operationId", (Object)operationId);
            JSONArray parameters = new JSONArray();
            toolParams.put("parameters", (Object)parameters);
            if (flag) {
                JSONObject requestBody = new JSONObject();
                requestBody.put("contentType", (Object)"application/json");
                requestBody.put("body", (Object)JSONObject.toJSONString((Object)body));
                toolParams.put("requestBody", (Object)requestBody);
            } else {
                parameters.addAll((Collection)getParameters);
            }
            api.setToolParams(toolParams);
            api.setToolId(tool.getId());
            api.setChatSessionId(chatSessionId);
            api.setRunId(runStep.getRunId());
            logger.info("tool function api:{}", (Object)JSONObject.toJSONString((Object)api));
            long start = System.currentTimeMillis();
            BaseResult result = RestfulAPIService.getService().call(api);
            long end = System.currentTimeMillis();
            TraceUtil.saveAgentCallToolLog(chatSessionId, runStep.getRunId(), tool.getId(), tool.getName(), JSONObject.toJSONString((Object)toolParams), JSONObject.toJSONString((Object)result.getData()), start, end);
            return result;
        }
    }

    private static class ThirdOpenAPIToolExecutor
    implements ToolExecutor {
        private ThirdOpenAPIToolExecutor() {
        }

        @Override
        public BaseResult execute(String chatSessionId, Agent agent, AgentAction action, RunStep runStep, Tool tool, String operationId, Map<String, Object> params) {
            JSONObject congfitTag = tool.getConfigTag();
            String swagger = congfitTag.getString("swaggerSchema");
            OpenAPI openAPI = OpenAPIUtils.parserSwaggerConfig(swagger);
            boolean flag = false;
            if (openAPI != null) {
                for (Map.Entry<String, Path> entry : openAPI.getPaths().entrySet()) {
                    Path path = entry.getValue();
                    if (path == null) continue;
                    if (path.getGet() != null && path.getGet().getOperationId().equals(operationId)) {
                        flag = false;
                        break;
                    }
                    if (path.getPost() == null || !path.getPost().getOperationId().equals(operationId)) continue;
                    flag = true;
                    break;
                }
            }
            ThirdOpenAPI api = new ThirdOpenAPI();
            JSONObject body = new JSONObject();
            JSONArray getParameters = new JSONArray();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                body.put(entry.getKey(), entry.getValue());
                JSONObject json = new JSONObject();
                json.put("name", (Object)entry.getKey());
                json.put("value", entry.getValue());
                getParameters.add((Object)json);
            }
            JSONObject toolParams = new JSONObject();
            toolParams.put("operationId", (Object)operationId);
            JSONArray parameters = new JSONArray();
            toolParams.put("parameters", (Object)parameters);
            if (flag) {
                JSONObject requestBody = new JSONObject();
                requestBody.put("contentType", (Object)"application/json");
                requestBody.put("body", (Object)JSONObject.toJSONString((Object)body));
                toolParams.put("requestBody", (Object)requestBody);
            } else {
                parameters.addAll((Collection)getParameters);
            }
            api.setToolParams(toolParams);
            api.setToolId(tool.getId());
            api.setChatSessionId(chatSessionId);
            api.setRunId(runStep.getRunId());
            logger.info("tool function api:{}", (Object)JSONObject.toJSONString((Object)api));
            long start = System.currentTimeMillis();
            BaseResult result = OpenAPIService.getService().call(api);
            long end = System.currentTimeMillis();
            if (result.getData() != null && result.getDataAsJSONObject() != null) {
                String output = result.getDataAsJSONObject().getString("output");
                result.setData(output);
            }
            TraceUtil.saveAgentCallToolLog(chatSessionId, runStep.getRunId(), tool.getId(), tool.getName(), JSONObject.toJSONString((Object)toolParams), result.getData() != null ? result.getData().toString() : "", start, end);
            return result;
        }
    }

    public static class ToolExecutorFactory {
        private static final Map<String, ToolExecutor> executors = new HashMap<String, ToolExecutor>();

        public static ToolExecutor getExecutor(String type) {
            return executors.getOrDefault(type.toLowerCase(), null);
        }

        static {
            executors.put(ToolConstant.ToolType.THIRD_OPENAPI.getType(), new ThirdOpenAPIToolExecutor());
            executors.put(ToolConstant.ToolType.COSMIC_OPENAPI.getType(), new ThirdOpenAPIToolExecutor());
            executors.put(ToolConstant.ToolType.RESTFUL_API.getType(), new RestfulAPIToolExecutor());
            executors.put(ToolConstant.ToolType.MCP_TOOL.getType(), new MCPTOOLExecutor());
            executors.put(ToolConstant.ToolType.COSMIC_ACTION.getType(), new CosmicActionToolExecutor());
            executors.put(ToolConstant.ToolType.INTERNAL_MCP.getType(), new InternalMcpExecutor());
        }
    }

    public static interface ToolExecutor {
        public BaseResult execute(String var1, Agent var2, AgentAction var3, RunStep var4, Tool var5, String var6, Map<String, Object> var7);
    }

    public static class FunctionStrategyFactory {
        private static final Map<String, FunctionStrategy> strategies = new LinkedHashMap<String, FunctionStrategy>();

        public static void register(String type, FunctionStrategy strategy) {
            strategies.put(type, strategy);
        }

        public static List<FunctionStrategy> getAllStrategies() {
            return new ArrayList<FunctionStrategy>(strategies.values());
        }

        public static FunctionStrategy getStrategy(String type) {
            return strategies.get(type);
        }

        static {
            FunctionStrategyFactory.register(AgentSkillTypeEnum.TOOL.getId(), (chatSessionId, agent, action, runStep) -> ToolServiceFunctionCall.toolFunction(chatSessionId, agent, action, runStep));
            FunctionStrategyFactory.register(AgentSkillTypeEnum.PROMPT.getId(), ToolServiceFunctionCall::promptFunction);
            FunctionStrategyFactory.register(AgentSkillTypeEnum.RAG.getId(), ToolServiceFunctionCall::ragFunction);
            FunctionStrategyFactory.register(AgentSkillTypeEnum.PROCESS.getId(), ToolServiceFunctionCall::processFunction);
            FunctionStrategyFactory.register(AgentSkillTypeEnum.OPENAPI.getId(), ToolServiceFunctionCall::openApiFunction);
        }
    }

    public static interface FunctionStrategy {
        public BaseResult execute(String var1, Agent var2, AgentAction var3, RunStep var4);
    }
}

