/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.flow;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.flow.FlowConfigParamHelper;
import kd.ai.gai.core.flow.node.DesignNode;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.legacy.LegacyMigrationHelper;

public abstract class Action
extends Node
implements DesignNode {
    public static final String INPUT_PARAMS = "inputParams";
    public static final String OUTPUT_PARAMS = "outputParams";
    protected Map<String, Map<String, ParamDefinition>> params;
    protected String inputParamGroup;
    protected String outputParamGroup;
    @Deprecated
    private List<VarMapper> inParamMap;

    public void setInputParamGroup(String inputParamGroup) {
        this.inputParamGroup = inputParamGroup;
    }

    public void setOutputParamGroup(String outputParamGroup) {
        this.outputParamGroup = outputParamGroup;
    }

    public String getInputParamGroup() {
        return INPUT_PARAMS;
    }

    public String getOutputParamGroup() {
        return OUTPUT_PARAMS;
    }

    @Override
    public Map<String, Map<String, ParamDefinition>> getParams() {
        if (this.params == null) {
            this.params = new LinkedHashMap<String, Map<String, ParamDefinition>>();
            LegacyMigrationHelper.migrateNode(this);
        }
        return this.params;
    }

    @Override
    public ParamDefinition addParam(String group, ParamDefinition paramDefinition) {
        if (paramDefinition == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map groupParams = this.getParams().computeIfAbsent(group, k -> new LinkedHashMap());
        return groupParams.put(paramDefinition.getName(), paramDefinition);
    }

    @Override
    public void addParams(String group, Collection<ParamDefinition> paramDefinitions) {
        if (paramDefinitions == null || paramDefinitions.isEmpty()) {
            return;
        }
        for (ParamDefinition paramDefinition : paramDefinitions) {
            this.addParam(group, paramDefinition);
        }
    }

    @Override
    public void setParams(String group, Collection<ParamDefinition> paramDefinitions) {
        if (paramDefinitions == null || paramDefinitions.isEmpty()) {
            return;
        }
        Map groupParams = this.getParams().computeIfAbsent(group, k -> new LinkedHashMap());
        for (ParamDefinition paramDefinition : paramDefinitions) {
            if (paramDefinition == null) continue;
            String paramName = paramDefinition.getName();
            groupParams.put(paramName, paramDefinition);
        }
    }

    @Override
    public ParamDefinition removeParam(String group, String paramName) {
        Map<String, ParamDefinition> groupParams = this.getParams().get(group);
        if (groupParams == null) {
            return null;
        }
        ParamDefinition removed = groupParams.remove(paramName);
        if (groupParams.isEmpty()) {
            this.getParams().remove(group);
        }
        return removed;
    }

    @Override
    public Collection<ParamDefinition> clearGroupParams(String group) {
        Map<String, ParamDefinition> removed = this.getParams().remove(group);
        return removed != null ? removed.values() : Collections.emptyList();
    }

    @Override
    public void compileParamReference(Flow flow) {
        Map<String, Map<String, ParamDefinition>> originParamDefinitions = this.getParams();
        originParamDefinitions.forEach((groupKey, definitionMap) -> definitionMap.entrySet().forEach(entry -> {
            ParamDefinition originParamDefinition = (ParamDefinition)entry.getValue();
            if (!originParamDefinition.isReference() || originParamDefinition.isHeterogeneousReference()) {
                return;
            }
            ParamDefinition paramDef = FlowConfigParamHelper.createReferenceParamDefinition(flow, this, originParamDefinition);
            entry.setValue(paramDef);
        }));
    }

    @Deprecated
    public List<VarMapper> getInParamMap() {
        return this.inParamMap;
    }

    @Deprecated
    public void setInParamMap(List<VarMapper> inParamMap) {
        this.inParamMap = inParamMap;
    }
}

