/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.flow;

import com.alibaba.fastjson.annotation.JSONField;
import java.beans.Transient;
import java.util.List;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.flow.param.define.ParamDefinition;

public abstract class BatchAction
extends Action {
    public static final String BATCH_INPUT_GROUP = "BATCH_INPUT_GROUP";
    public static final String BATCH_OUTPUT_GROUP = "BATCH_OUTPUT_GROUP";
    public static final String BATCH_INNER_GROUP = "BATCH_INNER_GROUP";
    public static final String BATCH_PARAM_OUTPUT_LIST = "outputList";
    private int parallelLimit = 3;
    private int batchLimit = 100;
    private String mode = Mode.Single.name();

    public int getParallelLimit() {
        return this.parallelLimit;
    }

    public void setParallelLimit(int parallelLimit) {
        this.parallelLimit = parallelLimit;
    }

    public int getBatchLimit() {
        return this.batchLimit;
    }

    public void setBatchLimit(int batchLimit) {
        this.batchLimit = batchLimit;
    }

    @Transient
    @JSONField(serialize=false)
    public List<ParamDefinition> getBatchInputParams() {
        return this.getParamByGroup(BATCH_INPUT_GROUP);
    }

    @Transient
    @JSONField(serialize=false)
    public List<ParamDefinition> getBatchOutputParams() {
        return this.getParamByGroup(BATCH_OUTPUT_GROUP);
    }

    @Override
    @Transient
    @JSONField(serialize=false)
    public List<ParamDefinition> getInputParams() {
        List<ParamDefinition> inputParams = super.getInputParams();
        List<ParamDefinition> batchInputParams = this.getBatchInputParams();
        inputParams.removeAll(batchInputParams);
        return inputParams;
    }

    @Override
    @Transient
    @JSONField(serialize=false)
    public List<ParamDefinition> getOutputParams() {
        List<ParamDefinition> outputParams = super.getOutputParams();
        List<ParamDefinition> batchOutputParams = this.getBatchOutputParams();
        outputParams.removeAll(batchOutputParams);
        return outputParams;
    }

    @Transient
    @JSONField(serialize=false)
    public boolean isEnableBatch() {
        return this.mode.equals(Mode.Batch.name());
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public static enum Mode {
        Single,
        Batch;

    }
}

