/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.flow;

import java.io.Serializable;
import java.util.List;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.legacy.LegacyMigrationHelper;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.exception.KDBizException;

public class Condition
implements Serializable {
    private String name;
    private String desc;
    private RelationType relation;
    private List<Row> conditionRows;

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Row> getConditionRows() {
        return this.conditionRows;
    }

    public void setConditionRows(List<Row> conditionRows) {
        this.conditionRows = conditionRows;
    }

    public RelationType getRelation() {
        return this.relation;
    }

    public void setRelation(RelationType relation) {
        this.relation = relation;
    }

    public static class Row
    implements Serializable {
        private int leftNodeId;
        private String leftVarName;
        private Operator operator;
        private ValueType valueType;
        private String text;
        private int rightNodeId;
        private String rightVarName;
        private NodeParamPath leftParamPath;
        private NodeParamPath rightParamPath;

        @Deprecated
        public int getLeftNodeId() {
            return this.leftNodeId;
        }

        public void setLeftNodeId(int leftNodeId) {
            this.leftNodeId = leftNodeId;
        }

        @Deprecated
        public String getLeftVarName() {
            return this.leftVarName;
        }

        public void setLeftVarName(String leftVarName) {
            this.leftVarName = leftVarName;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public void setOperator(Operator operator) {
            this.operator = operator;
        }

        public ValueType getValueType() {
            return this.valueType;
        }

        public void setValueType(ValueType valueType) {
            this.valueType = valueType;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        @Deprecated
        public int getRightNodeId() {
            return this.rightNodeId;
        }

        public void setRightNodeId(int rightNodeId) {
            this.rightNodeId = rightNodeId;
        }

        @Deprecated
        public String getRightVarName() {
            return this.rightVarName;
        }

        public void setRightVarName(String rightVarName) {
            this.rightVarName = rightVarName;
        }

        public boolean check() {
            return (this.leftVarName != null || this.leftParamPath != null) && this.operator != null;
        }

        public NodeParamPath getLeftParamPath() {
            if (this.leftParamPath == null && StringUtils.isNotEmpty((CharSequence)this.leftVarName)) {
                this.leftParamPath = new NodeParamPath(String.valueOf(this.leftNodeId), LegacyMigrationHelper.migrateParamName(this.leftVarName));
            }
            return this.leftParamPath;
        }

        public void setLeftParamPath(NodeParamPath leftParamPath) {
            this.leftParamPath = leftParamPath;
        }

        public NodeParamPath getRightParamPath() {
            if (this.rightParamPath == null && StringUtils.isNotEmpty((CharSequence)this.rightVarName)) {
                this.rightParamPath = new NodeParamPath(String.valueOf(this.rightNodeId), LegacyMigrationHelper.migrateParamName(this.rightVarName));
            }
            return this.rightParamPath;
        }

        public void setRightParamPath(NodeParamPath rightParamPath) {
            this.rightParamPath = rightParamPath;
        }
    }

    public static enum RelationType {
        AND,
        OR;

    }

    public static enum ValueType {
        TEXT,
        DECIMAL,
        PARAM;

    }

    public static enum Operator {
        GT(">"),
        GET(">="),
        LT("<"),
        LET("<="),
        NE("!="),
        EQ("=="),
        ISNULL("== null"),
        ISNOTNULL("!= null");

        String value;

        private Operator(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public CompareTypeEnum toCompareTypeEnum() {
            switch (this) {
                case EQ: {
                    return CompareTypeEnum.EQUAL;
                }
                case NE: {
                    return CompareTypeEnum.NOTEQUAL;
                }
                case GT: {
                    return CompareTypeEnum.GREATER;
                }
                case GET: {
                    return CompareTypeEnum.GREATEROREQUAL;
                }
                case LT: {
                    return CompareTypeEnum.LESS;
                }
                case LET: {
                    return CompareTypeEnum.LESSOREQUAL;
                }
                case ISNULL: {
                    return CompareTypeEnum.ISNULL;
                }
                case ISNOTNULL: {
                    return CompareTypeEnum.ISNOTNULL;
                }
            }
            return null;
        }

        public static Operator parse(String operatorStr) {
            for (Operator op : Operator.values()) {
                if (!op.value.equalsIgnoreCase(operatorStr)) continue;
                return op;
            }
            return null;
        }

        public static Operator fromCompareTypeEnum(CompareTypeEnum compareTypeEnum) {
            switch (compareTypeEnum) {
                case EQUAL: {
                    return EQ;
                }
                case NOTEQUAL: {
                    return NE;
                }
                case GREATER: {
                    return GT;
                }
                case GREATEROREQUAL: {
                    return GET;
                }
                case LESS: {
                    return LT;
                }
                case LESSOREQUAL: {
                    return LET;
                }
                case ISNULL: {
                    return ISNULL;
                }
                case ISNOTNULL: {
                    return ISNOTNULL;
                }
            }
            CompareType compareType = FilterMetadata.get().getCompareTypeByCompareTypeId(compareTypeEnum.getId());
            throw new KDBizException(String.format("\u4efb\u52a1\u7f16\u6392\u6682\u4e0d\u652f\u6301\u6bd4\u8f83\u7b26[%s]", compareType.getName().getLocaleValue()));
        }
    }
}

