/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.flow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kd.ai.gai.core.domain.dto.ProcessNode;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.End;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.MessageAction;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.Start;
import kd.ai.gai.core.engine.flow.Transfer;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.bos.dataentity.TypesContainer;
import kd.bos.exception.KDBizException;

public class Flow
implements Serializable {
    private long defId;
    private String number;
    private String name;
    private long id;
    private Start start;
    private List<Action> actions = new ArrayList<Action>();
    private List<Transfer> transfers = new ArrayList<Transfer>();
    private End end;
    private int maxNodeId;
    private String paramMode;

    public long getDefId() {
        return this.defId;
    }

    public void setDefId(long defId) {
        this.defId = defId;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Start getStart() {
        return this.start;
    }

    public void setStart(Start start) {
        this.start = start;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public List<Transfer> getTransfers() {
        return this.transfers;
    }

    public void setTransfers(List<Transfer> transfers) {
        this.transfers = transfers;
    }

    public End getEnd() {
        return this.end;
    }

    public void setEnd(End end) {
        this.end = end;
    }

    public int getMaxNodeId() {
        return this.maxNodeId;
    }

    public void setMaxNodeId(int maxNodeId) {
        this.maxNodeId = maxNodeId;
    }

    public Transfer findTransferById(int id) {
        for (Transfer t : this.transfers) {
            if (t.getId() != id) continue;
            return t;
        }
        throw new KDBizException(Errors.idNotExisted("\u8fde\u7ebf", id), new Object[0]);
    }

    public Action findActionById(int id) {
        if (id == this.start.getId()) {
            return this.start;
        }
        if (id == this.end.getId()) {
            return this.end;
        }
        for (Action action : this.actions) {
            if (action.getId() != id) continue;
            return action;
        }
        throw new KDBizException(Errors.idNotExisted("\u64cd\u4f5c", id), new Object[0]);
    }

    public Flow initNewFlow() {
        this.start = new Start();
        this.start.setId(this.nextId());
        this.end = new End();
        this.end.setId(this.nextId());
        Transfer transfer = new Transfer();
        transfer.setId(this.nextId());
        this.transfers.add(transfer);
        this.start.addOutTransfer(transfer);
        this.end.addInTransfer(transfer);
        return this;
    }

    public int nextId() {
        return this.maxNodeId++;
    }

    public Transfer firstInTransfer(Node node) {
        if (node.getTransferInList().isEmpty()) {
            return null;
        }
        int transferId = node.getTransferInList().get(0);
        return this.findTransferById(transferId);
    }

    public Transfer firstOutTransfer(Node node) {
        if (node.getTransferOutList().isEmpty()) {
            return null;
        }
        int transferId = node.getTransferOutList().get(0);
        return this.findTransferById(transferId);
    }

    public Transfer createTransfer() {
        Transfer t = new Transfer();
        t.setId(this.maxNodeId++);
        this.transfers.add(t);
        return t;
    }

    public MessageAction createMessageAction() {
        MessageAction action = new MessageAction();
        this.createAction(action);
        return action;
    }

    public void createAction(Action action) {
        action.setId(this.maxNodeId++);
        this.actions.add(action);
    }

    private Action createAction(ProcessNodeType nodeType) {
        Action action = (Action)TypesContainer.createInstance((String)nodeType.getActionClassName());
        this.createAction(action);
        return action;
    }

    public JavaPluginAction appendJavaPluginAction() {
        JavaPluginAction action = new JavaPluginAction();
        action.setId(this.maxNodeId++);
        this.appendAction(action);
        return action;
    }

    public JavaPluginAction insertJavaPluginAction(Node beforeNode) {
        JavaPluginAction action = new JavaPluginAction();
        action.setId(this.maxNodeId++);
        this.insertNewAction(action, beforeNode);
        return action;
    }

    public LLMAction appendLLMAction() {
        LLMAction action = new LLMAction();
        action.setId(this.maxNodeId++);
        this.appendAction(action);
        return action;
    }

    public LLMAction insertLLMAction(Node beforeNode) {
        LLMAction action = new LLMAction();
        action.setId(this.maxNodeId++);
        this.insertNewAction(action, beforeNode);
        return action;
    }

    public MessageAction appendMessageAction() {
        MessageAction action = new MessageAction();
        action.setId(this.maxNodeId++);
        this.appendAction(action);
        return action;
    }

    public MessageAction insertMessageAction(Node beforeNode) {
        MessageAction action = new MessageAction();
        action.setId(this.maxNodeId++);
        this.insertNewAction(action, beforeNode);
        return action;
    }

    public void appendAction(Action action) {
        if (this.end == null) {
            throw new KDBizException(Errors.FLOW_NOT_INIT, new Object[0]);
        }
        End beforeNode = this.end;
        Transfer transfer = this.firstInTransfer(beforeNode);
        this.insertNewAction(action, beforeNode, transfer);
    }

    public void insertNewAction(Action action, Node beforeNode) {
        if (beforeNode == null) {
            beforeNode = this.end;
        }
        Transfer transfer = this.firstInTransfer(beforeNode);
        this.insertNewAction(action, beforeNode, transfer);
    }

    public void insertNewAction(Action newNode, Node beforeNode, Transfer transfer) {
        beforeNode.removeInTransfer(transfer);
        newNode.addInTransfer(transfer);
        Transfer nextTransfer = new Transfer();
        nextTransfer.setId(this.nextId());
        this.transfers.add(nextTransfer);
        newNode.addOutTransfer(nextTransfer);
        beforeNode.addInTransfer(nextTransfer);
        this.actions.add(newNode);
    }

    public void upNode(int nodeId) {
        Action next = this.findActionById(nodeId);
        Transfer commonTransfer = this.firstInTransfer(next);
        if (commonTransfer.getFromNodeId() == this.start.getId()) {
            return;
        }
        Action first = this.findActionById(commonTransfer.getFromNodeId());
        this.switchNodes(first, next, commonTransfer);
    }

    public void downNode(int nodeId) {
        Action first = this.findActionById(nodeId);
        Transfer commonTransfer = this.firstOutTransfer(first);
        if (commonTransfer.getToNodeId() == this.end.getId()) {
            return;
        }
        Action next = this.findActionById(commonTransfer.getToNodeId());
        this.switchNodes(first, next, commonTransfer);
    }

    public void switchNodes(Node first, Node next, Transfer commonTransfer) {
        Transfer outTransfer2 = this.firstOutTransfer(next);
        Transfer inTransfer1 = this.firstInTransfer(first);
        next.getTransferInList().clear();
        next.getTransferOutList().clear();
        next.addInTransfer(inTransfer1);
        next.addOutTransfer(commonTransfer);
        first.getTransferInList().clear();
        first.getTransferOutList().clear();
        first.addInTransfer(commonTransfer);
        first.addOutTransfer(outTransfer2);
    }

    public boolean deleteNode(int nodeId) {
        int index;
        if (nodeId == this.start.getId() || nodeId == this.end.getId()) {
            return false;
        }
        if (this.actions.isEmpty()) {
            return false;
        }
        Action action = this.findActionById(nodeId);
        if (action == null) {
            return false;
        }
        Transfer inTransfer = this.firstInTransfer(action);
        Transfer outTransfer = this.firstOutTransfer(action);
        Action next = outTransfer.getToNodeId() == this.end.getId() ? this.end : this.findActionById(outTransfer.getToNodeId());
        next.getTransferInList().clear();
        next.addInTransfer(inTransfer);
        for (index = 0; index < this.actions.size(); ++index) {
            if (this.actions.get(index).getId() != nodeId) continue;
            this.actions.remove(index);
            break;
        }
        for (index = 0; index < this.transfers.size(); ++index) {
            if (this.transfers.get(index).getId() != outTransfer.getId()) continue;
            this.transfers.remove(index);
            break;
        }
        return true;
    }

    public List<Action> actionList() {
        if (this.actions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Action> arrayList = new ArrayList<Action>(this.actions.size());
        Transfer transfer = this.firstOutTransfer(this.start);
        while (this.end.getId() != transfer.getToNodeId()) {
            Action action = this.findActionById(transfer.getToNodeId());
            arrayList.add(action);
            transfer = this.firstOutTransfer(action);
        }
        return arrayList;
    }

    public Node findNodeById(int nodeId) {
        if (nodeId == this.start.getId()) {
            return this.start;
        }
        if (nodeId == this.end.getId()) {
            return this.end;
        }
        return this.findActionById(nodeId);
    }

    public void newBranchAction(Action action, Node fromNode, Node endNode) {
        Transfer transfer1 = this.createTransfer();
        fromNode.addOutTransfer(transfer1);
        action.addInTransfer(transfer1);
        Transfer transfer2 = this.createTransfer();
        action.addOutTransfer(transfer2);
        endNode.addInTransfer(transfer2);
    }

    public List<Node> allUpNodes(int nodeId) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (nodeId == this.start.getId()) {
            return nodes;
        }
        Node node = this.findNodeById(nodeId);
        this.allUpNodes(node, nodes);
        return nodes;
    }

    private void allUpNodes(Node node, List<Node> nodes) {
        for (int inTransferId : node.getTransferInList()) {
            Transfer transfer = this.findTransferById(inTransferId);
            int fromNodeId = transfer.getFromNodeId();
            Node upNode = this.findNodeById(fromNodeId);
            if (nodes.contains(upNode)) continue;
            nodes.add(upNode);
            if (fromNodeId == this.start.getId()) continue;
            this.allUpNodes(upNode, nodes);
        }
    }

    public List<Node> getAllChildNodes(int nodeId) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (nodeId == this.end.getId()) {
            return nodes;
        }
        Node node = this.findNodeById(nodeId);
        this.allDownNodes(node, nodes);
        return nodes;
    }

    public void allDownNodes(Node node, List<Node> nodes) {
        List<Integer> transferOutList = node.getTransferOutList();
        for (int outTransferId : transferOutList) {
            Transfer transfer = this.findTransferById(outTransferId);
            Node downNode = this.findNodeById(transfer.getToNodeId());
            if (nodes.contains(downNode)) continue;
            nodes.add(downNode);
            if (downNode.getNodeType() == ProcessNodeType.End) continue;
            this.allDownNodes(downNode, nodes);
        }
    }

    public List<Transfer> getAllChildTransfers(int nodeId) {
        ArrayList<Transfer> transferList = new ArrayList<Transfer>();
        if (nodeId == this.end.getId()) {
            return transferList;
        }
        Node node = this.findNodeById(nodeId);
        this.allDownTransfers(node, transferList);
        return transferList;
    }

    private void allDownTransfers(Node node, List<Transfer> transfers) {
        List<Integer> transferOutList = node.getTransferOutList();
        for (int outTransferId : transferOutList) {
            Transfer transfer = this.findTransferById(outTransferId);
            if (transfers.contains(transfer)) continue;
            transfers.add(transfer);
            Node downNode = this.findNodeById(transfer.getToNodeId());
            if (downNode.getNodeType() == ProcessNodeType.End) continue;
            this.allDownTransfers(downNode, transfers);
        }
    }

    public void deleteTransferInFlowDesignMode(int transferId) {
        Node toNode;
        if (!this.isExistsTransfer(transferId)) {
            return;
        }
        Transfer transferToDelete = this.findTransferById(transferId);
        Node fromNode = this.findNodeById(transferToDelete.getFromNodeId());
        if (fromNode != null) {
            fromNode.removeOutTransfer(transferToDelete);
        }
        if ((toNode = this.findNodeById(transferToDelete.getToNodeId())) != null) {
            toNode.removeInTransfer(transferToDelete);
        }
        this.transfers.removeIf(transfer -> transfer.getId() == transferToDelete.getId());
    }

    public void deleteTransfersInFlowDesignMode(List<Integer> transferIds) {
        for (int transferId : transferIds) {
            this.deleteTransferInFlowDesignMode(transferId);
        }
    }

    public void deleteNodeInFlowDesignMode(int nodeId) {
        if (!this.isExistsNode(nodeId)) {
            return;
        }
        if (nodeId == this.start.getId() || nodeId == this.end.getId()) {
            return;
        }
        Node nodeToDelete = this.findNodeById(nodeId);
        ArrayList<Integer> listInTransferIds = new ArrayList<Integer>(nodeToDelete.getTransferInList());
        Iterator iterator = listInTransferIds.iterator();
        while (iterator.hasNext()) {
            int inTransferId = (Integer)iterator.next();
            this.deleteTransferInFlowDesignMode(inTransferId);
        }
        ArrayList<Integer> listOutTransferIds = new ArrayList<Integer>(nodeToDelete.getTransferOutList());
        Iterator iterator2 = listOutTransferIds.iterator();
        while (iterator2.hasNext()) {
            int outTransferId = (Integer)iterator2.next();
            this.deleteTransferInFlowDesignMode(outTransferId);
        }
        this.actions.removeIf(action -> action.getId() == nodeToDelete.getId());
    }

    public void deleteNodesInFlowDesignMode(List<Integer> nodeIds) {
        for (int nodeId : nodeIds) {
            this.deleteNodeInFlowDesignMode(nodeId);
        }
    }

    public void appendNewNodesInFlowDesignMode(List<Node> nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            Action newAction = this.createAction(node.getNodeType());
            if (newAction == null) continue;
            newAction.setId(node.getId());
            this.setMaxNodeId(node.getId() + 1);
            newAction.setBlockNodeId(node.getBlockNodeId());
            newAction.setName(node.getName());
            newAction.setType(node.getType());
            newAction.setPostion(node.getPostion());
            newAction.setTransferInList(node.getTransferInList());
            newAction.setTransferOutList(node.getTransferOutList());
        }
    }

    public void appendNewTransfersInFlowDesignMode(List<Transfer> transfers) {
        for (int i = 0; i < transfers.size(); ++i) {
            Transfer transfer = transfers.get(i);
            Transfer newTransfer = this.createTransfer();
            newTransfer.setId(transfer.getId());
            this.setMaxNodeId(transfer.getId() + 1);
            newTransfer.setFromNodeId(transfer.getFromNodeId());
            newTransfer.setToNodeId(transfer.getToNodeId());
            Node fromNode = this.findNodeById(newTransfer.getFromNodeId());
            fromNode.addOutTransfer(newTransfer);
            Node toNode = this.findNodeById(newTransfer.getToNodeId());
            toNode.addInTransfer(newTransfer);
        }
    }

    public List<ProcessNode> allUpProcessNodes(int nodeId) {
        return this.allUpProcessNodes(nodeId, false);
    }

    public List<ProcessNode> allUpProcessNodes(int nodeId, boolean includeSelfNode) {
        Node selfNode = this.findNodeById(nodeId);
        ArrayList<Node> nodeList = new ArrayList<Node>(8);
        if (includeSelfNode) {
            nodeList.add(selfNode);
        }
        nodeList.addAll(this.allUpNodes(nodeId));
        int count = includeSelfNode ? nodeList.size() + 1 : nodeList.size();
        ArrayList<ProcessNode> processNodeList = new ArrayList<ProcessNode>(count);
        if (!includeSelfNode) {
            nodeList.removeIf(node -> node.getId() == selfNode.getId());
        }
        for (Node node2 : nodeList) {
            ProcessNode processNode = ProcessNode.parse(node2);
            processNodeList.add(processNode);
        }
        return processNodeList;
    }

    public List<ProcessNode> allBlockInnerProcessNodes(int blockNodeId) {
        if (blockNodeId == -1) {
            return Collections.emptyList();
        }
        ArrayList<ProcessNode> processNodeList = new ArrayList<ProcessNode>(1);
        List<Action> actionList = this.getActions();
        actionList.forEach(action -> {
            if (action.getBlockNodeId() == blockNodeId) {
                processNodeList.add(ProcessNode.parse(action));
            }
        });
        return processNodeList;
    }

    public boolean isExistsNode(int nodeId) {
        try {
            return this.findNodeById(nodeId) != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isExistsTransfer(int transferId) {
        try {
            return this.findTransferById(transferId) != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public int getBlockNodeIdByActionId(int id) {
        for (Action action : this.actions) {
            if (action.getId() != id) continue;
            return action.getBlockNodeId();
        }
        return -1;
    }

    public String getParamMode() {
        return this.paramMode;
    }

    public void setParamMode(String paramMode) {
        this.paramMode = paramMode;
    }
}

