/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.flow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.engine.flow.End;
import kd.ai.gai.core.engine.flow.Position;
import kd.ai.gai.core.engine.flow.Start;
import kd.ai.gai.core.engine.flow.Transfer;
import kd.ai.gai.core.enuz.ProcessNodeType;

public class Node
implements Serializable {
    protected int id;
    protected String name;
    protected String desc;
    protected String type;
    protected String width;
    protected String height;
    protected List<Integer> transferInList = new ArrayList<Integer>();
    protected List<Integer> transferOutList = new ArrayList<Integer>();
    protected Position position;
    protected int blockNodeId = -1;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public List<Integer> getTransferInList() {
        return this.transferInList;
    }

    public void setTransferInList(List<Integer> transferInList) {
        this.transferInList = transferInList;
    }

    public List<Integer> getTransferOutList() {
        return this.transferOutList;
    }

    public void setTransferOutList(List<Integer> transferOutList) {
        this.transferOutList = transferOutList;
    }

    public Position getPostion() {
        return this.position;
    }

    public void setPostion(Position postion) {
        this.position = postion;
    }

    public void addInTransfer(Transfer transfer) {
        transfer.setToNodeId(this.getId());
        this.transferInList.add(transfer.getId());
    }

    public void addOutTransfer(Transfer transfer) {
        transfer.setFromNodeId(this.getId());
        this.transferOutList.add(transfer.getId());
    }

    public void removeInTransfer(Transfer transfer) {
        transfer.setToNodeId(-1);
        this.removeTransfer(this.transferInList, transfer);
    }

    public void removeOutTransfer(Transfer transfer) {
        transfer.setFromNodeId(-1);
        this.removeTransfer(this.transferOutList, transfer);
    }

    private void removeTransfer(List<Integer> transferList, Transfer transfer) {
        for (int index = 0; index < transferList.size(); ++index) {
            if (transferList.get(index).intValue() != transfer.getId()) continue;
            transferList.remove(index);
            break;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ProcessNodeType getNodeType() {
        if (this instanceof Start) {
            return ProcessNodeType.Start;
        }
        if (this instanceof End) {
            return ProcessNodeType.End;
        }
        return ProcessNodeType.valueOf(Integer.parseInt(this.type));
    }

    public int getBlockNodeId() {
        return this.blockNodeId;
    }

    public void setBlockNodeId(int blockNodeId) {
        this.blockNodeId = blockNodeId;
    }

    public boolean isBlockInnerNode() {
        return this.blockNodeId > 0;
    }

    public boolean isLoopBlockNode() {
        return ProcessNodeType.Loop == this.getNodeType();
    }

    public boolean isParallelBlockNode() {
        return ProcessNodeType.Parallel == this.getNodeType();
    }

    public boolean isBreakLoopNode() {
        return ProcessNodeType.BreakLoop == this.getNodeType();
    }

    public boolean isCusOptionNode() {
        return ProcessNodeType.CusOption == this.getNodeType();
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }
}

