/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.flow;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamSource;

public class Start
extends Action {
    public static final String SYSTEM_GROUP = "system";
    @Deprecated
    private List<Var> inputVars;

    @Override
    public String getInputParamGroup() {
        return "DEFAULT_GROUP";
    }

    @Override
    public String getOutputParamGroup() {
        return "DEFAULT_GROUP";
    }

    public List<Var> getInputVars() {
        return this.inputVars;
    }

    public void setInputVars(List<Var> inputVars) {
        this.inputVars = inputVars;
    }

    @Override
    public void compileParamReference(Flow flow) {
        this.addSystemParamDefinition();
        super.compileParamReference(flow);
    }

    public void addSystemParamDefinition() {
        BasicParamDefinition paramDefinition;
        this.removeSystemParamFromInputParams();
        List<ParamDefinition> systemParams = this.getParamByGroup(SYSTEM_GROUP);
        Map mapSystemParams = systemParams.stream().collect(Collectors.toMap(ParamDefinition::getName, Function.identity()));
        boolean isNeedSave = false;
        if (!mapSystemParams.containsKey("system.user_input")) {
            paramDefinition = ParamDefinitionBuilder.string("system.user_input").description("\u7528\u6237\u8f93\u5165").asBoth().makePublic().build();
            paramDefinition.setSource(ParamSource.DYNAMIC);
            paramDefinition.setDisplayName("system.user_input");
            systemParams.add(paramDefinition);
            isNeedSave = true;
        }
        if (!mapSystemParams.containsKey("system.chat_sessionid")) {
            paramDefinition = ParamDefinitionBuilder.string("system.chat_sessionid").description("\u4f1a\u8bddID").asBoth().makePublic().build();
            paramDefinition.setSource(ParamSource.DYNAMIC);
            paramDefinition.setDisplayName("system.chat_sessionid");
            systemParams.add(paramDefinition);
            isNeedSave = true;
        }
        if (!mapSystemParams.containsKey("system.skill_id")) {
            paramDefinition = ParamDefinitionBuilder.string("system.skill_id").description("\u6280\u80fdID").asBoth().makePublic().build();
            paramDefinition.setSource(ParamSource.DYNAMIC);
            paramDefinition.setDisplayName("system.skill_id");
            systemParams.add(paramDefinition);
            isNeedSave = true;
        }
        this.removeParam(SYSTEM_GROUP, "system.user_chat_history");
        if (!mapSystemParams.containsKey("system.chat_history")) {
            paramDefinition = ParamDefinitionBuilder.string("system.chat_history").description("\u65e7\u7684\u4f1a\u8bdd\u5386\u53f2\uff0c\u4e0d\u63a8\u8350\u4f7f\u7528\uff0c\u4e0d\u663e\u793a").asBoth().makePublic().build();
            paramDefinition.setSource(ParamSource.DYNAMIC);
            paramDefinition.setDisplayName("system.chat_history");
            systemParams.add(paramDefinition);
            isNeedSave = true;
        }
        if (!mapSystemParams.containsKey("system.chat_environment")) {
            paramDefinition = ParamDefinitionBuilder.string("system.chat_environment").description("\u4f7f\u7528\u73af\u5883\uff0c\u7528\u4e8e\u533a\u5206\u4f7f\u7528\u5165\u53e3\u662f\u4fa7\u8fb9\u680f\u6216\u79fb\u52a8\u7aef").asBoth().makePublic().build();
            paramDefinition.setSource(ParamSource.DYNAMIC);
            paramDefinition.setDisplayName("system.chat_environment");
            systemParams.add(paramDefinition);
            isNeedSave = true;
        }
        if (!mapSystemParams.containsKey("system.files")) {
            ObjectParamDefinition itemParamDefinition = ParamDefinitionBuilder.object("historyItem").property(ParamDefinitionBuilder.string("id").description("\u9644\u4ef6ID").build()).property(ParamDefinitionBuilder.string("name").description("\u9644\u4ef6\u540d\u79f0").build()).property(ParamDefinitionBuilder.string("url").description("\u9644\u4ef6URL").build()).build();
            ArrayParamDefinition paramDefinition2 = ParamDefinitionBuilder.objectArray("system.files", itemParamDefinition).description("\u9644\u4ef6\u96c6\u5408").asBoth().makePublic().build();
            paramDefinition2.setSource(ParamSource.DYNAMIC);
            paramDefinition2.setDisplayName("system.files");
            systemParams.add(paramDefinition2);
            isNeedSave = true;
        }
        if (!mapSystemParams.containsKey("system.execute_date")) {
            paramDefinition = ParamDefinitionBuilder.formatDate("system.execute_date").format("yyyy-MM-dd").description("\u4efb\u52a1\u6d41\u6267\u884c\u65e5\u671f").asBoth().makePublic().build();
            paramDefinition.setSource(ParamSource.DYNAMIC);
            paramDefinition.setDisplayName("system.execute_date");
            systemParams.add(paramDefinition);
            isNeedSave = true;
        }
        if (isNeedSave) {
            this.clearGroupParams(SYSTEM_GROUP);
            this.addParams(SYSTEM_GROUP, systemParams);
        }
    }

    private void removeSystemParamFromInputParams() {
        List<ParamDefinition> inputParams = this.getParamByGroup(this.getInputParamGroup());
        Iterator<ParamDefinition> iterator = inputParams.iterator();
        while (iterator.hasNext()) {
            ParamDefinition paramDefinition = iterator.next();
            switch (paramDefinition.getName()) {
                case "system.user_input": 
                case "system.chat_sessionid": 
                case "system.chat_history": 
                case "system.chat_environment": {
                    iterator.remove();
                    break;
                }
            }
        }
        this.clearGroupParams(this.getInputParamGroup());
        this.addParams(this.getInputParamGroup(), inputParams);
    }
}

