/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.dto.agent.MessageConfig;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.IActionCallBack;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.AskUserAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.handler.FlowNextHandler;
import kd.ai.gai.core.engine.handler.MessageHandler;
import kd.ai.gai.core.engine.message.AskUserCallbackMessage;
import kd.ai.gai.core.engine.message.AskUserMessage;
import kd.ai.gai.core.engine.message.ChatMessage;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.util.StrUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class AskUserHandler
implements IMessageHandler<AskUserMessage>,
IActionCallBack<AskUserCallbackMessage> {
    private static final Log log = LogFactory.getLog(AskUserHandler.class);

    @Override
    public Result process(Context context, AskUserMessage message) {
        AskUserCallbackMessage callbackMessage = new AskUserCallbackMessage();
        callbackMessage.setChatSessionId(context.getChatSessionId());
        callbackMessage.setFlowId(message.getFlowId());
        callbackMessage.setNodeId(message.getNodeId());
        FlowCacheData.putCache(context.getChatSessionId(), context.getChatSessionId() + "_ASK_USER", JSONObject.toJSONString((Object)callbackMessage));
        String userContent = MessageHandler.messageToHistory(message.getElementList());
        MessageConfig messageConfig = new MessageConfig();
        messageConfig.setAskUser(Boolean.TRUE);
        Message chatMessage = MessageService.insertMessage(context.getChatSessionId(), userContent, "", messageConfig.toString(), context.getCurrentSkill(), ChatMessageTypeEnum.PROCESS, context.messageIsEnable());
        PushMsgService.pushAskUser(context, message.getElementList(), StrUtils.longAsString(chatMessage.getMessageId()), messageConfig, message.isAllowUserInput(), message.isSseAutoClose());
        return new Result(Errors.OK, true);
    }

    @Override
    public void callback(AskUserCallbackMessage callbackMessage) {
        Context context = FlowCacheData.getContext(callbackMessage.getChatSessionId());
        if (context == null) {
            log.error("\u4f1a\u8bddID\uff08{}\uff09\u7684\u4e0a\u4e0b\u6587\u4e0d\u5b58\u5728\uff0c\u6709\u53ef\u80fd\u88ab\u6e05\u9664", (Object)callbackMessage.getChatSessionId());
            return;
        }
        Flow flow = FlowCacheData.getFlowById(callbackMessage.getChatSessionId(), callbackMessage.getFlowId());
        if (flow == null) {
            log.error("\u65e0\u6cd5\u627e\u5230\u6d41\u7a0bID\uff08{}\uff09\u7684\u7f13\u5b58\u4fe1\u606f\uff0c\u6709\u53ef\u80fd\u88ab\u6e05\u9664", (Object)callbackMessage.getFlowId());
            return;
        }
        HashMap<String, String> outData = new HashMap<String, String>();
        ChatMessage chatMessage = callbackMessage.getChatMessage();
        if (chatMessage.getInParaMap() != null && !chatMessage.getInParaMap().isEmpty()) {
            Map<String, String> inData = chatMessage.getInParaMap();
            AskUserAction askUserAction = (AskUserAction)flow.findActionById(callbackMessage.getNodeId());
            for (Var var : askUserAction.getOutputVarList()) {
                String val = inData.get(var.getName());
                if (val == null) continue;
                outData.put(var.getName(), val);
            }
        }
        if (StringUtils.isNotEmpty((String)chatMessage.getUserInput())) {
            outData.put("askUser_output", chatMessage.getUserInput());
        }
        FlowCacheData.setFlowNodeData(context.getChatSessionId(), callbackMessage.getFlowId(), callbackMessage.getNodeId(), outData);
        FlowNextHandler.next(context, callbackMessage.getFlowId(), callbackMessage.getNodeId());
    }
}

