/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.IActionCallBack;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.json.FlowRuntimeParserConfig;
import kd.ai.gai.core.engine.message.AskUserCallbackMessage;
import kd.ai.gai.core.engine.message.ChatMessage;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.engine.message.StartFlowMessage;
import kd.ai.gai.core.engine.message.llmcallback.ChatCallbackMessage;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.enuz.SkillSrcEnum;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.agent.AgentServiceService;
import kd.ai.gai.core.service.agent.ChatService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.trace.util.LogUtil;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.core.util.StrUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.collections4.MapUtils;

public class ChatHandler
implements IMessageHandler<ChatMessage>,
IActionCallBack<ChatCallbackMessage> {
    private static final Log log = LogFactory.getLog(ChatHandler.class);
    public static final String LLM_CT_RT = "LLM_CT_RT";
    public static final String LLM_CT_RT_THOUGHT = "LLM_CT_RT_THOUGHT";
    public static final String LLM_CT_END = "LLM_CT_END";
    public static final String LLM_CT_MESSAGE = "LLM_CT_MESSAGE";
    public static final String LLM_CT_THOUGHT_MESSAGE = "LLM_CT_THOUGHT_MESSAGE";

    @Override
    public Result process(Context context, ChatMessage chatMessage) {
        String askUserCallbackMsgStr;
        FlowCacheData.clearCache(context.getChatSessionId(), "flowCancelled");
        RequestContext rc = RequestContext.get();
        context.setTraceId(LogUtil.genTraceId());
        if (StringUtils.isEmpty((CharSequence)context.getChatTraceId())) {
            context.setChatTraceId(rc.getTraceId());
        }
        log.info("chatTraceId:{} monitorTraceId:{}", (Object)context.getChatTraceId(), (Object)rc.getTraceId());
        Message userMessage = null;
        Skill skill = this.getSkill(context, chatMessage);
        FlowCacheData.putContext(context.getChatSessionId(), context);
        if (StringUtils.isNotEmpty((CharSequence)chatMessage.getUserInput())) {
            boolean asTool = MapUtils.getBooleanValue(chatMessage.getInParaMap(), (Object)"asTool", (boolean)false);
            boolean needReply = MapUtils.getBooleanValue(chatMessage.getInParaMap(), (Object)"needReply", (boolean)true);
            EnableEnum enableEnum = asTool || !needReply || context.getSlideenv() == SLIDEENV.AGENT ? EnableEnum.NO : EnableEnum.YES;
            userMessage = MessageService.insertMessage(context.getChatSessionId(), chatMessage.getUserInput(), "", null, skill, ChatMessageTypeEnum.USER, enableEnum);
            if (!needReply || asTool) {
                PushMsgService.pushWaiting(context, 0L, userMessage.getRunId() + "");
                return new Result(Errors.OK);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(askUserCallbackMsgStr = FlowCacheData.getAndRemoveCache(context.getChatSessionId(), context.getChatSessionId() + "_ASK_USER")))) {
            log.info("ask user callback: {}", (Object)askUserCallbackMsgStr);
            AskUserCallbackMessage askUserCallbackMessage = (AskUserCallbackMessage)JSONObject.parseObject((String)askUserCallbackMsgStr, AskUserCallbackMessage.class, (ParserConfig)new FlowRuntimeParserConfig(), (Feature[])new Feature[0]);
            askUserCallbackMessage.setChatMessage(chatMessage);
            if (AgentServiceService.isNewFlowEngine()) {
                FlowUtils.signal(askUserCallbackMessage.getChatSessionId(), askUserCallbackMessage.getFlowId(), askUserCallbackMessage);
            } else {
                HandlerFactory.callback(askUserCallbackMessage);
            }
            return new Result(Errors.OK);
        }
        if (skill != null) {
            log.info("\u7528\u6237\u9009\u62e9\u6280\u80fd{},\u76f4\u63a5\u542f\u52a8\u6280\u80fd", (Object)chatMessage.getSkillId());
            return this.startSkill(context, skill, chatMessage.getUserInput(), chatMessage.getInParaMap() == null ? new HashMap() : chatMessage.getInParaMap(), true, userMessage);
        }
        context.setCurrentSkill(null);
        FlowCacheData.putContext(context.getChatSessionId(), context);
        ErrorCode errorCode = this.verifyData(context, chatMessage);
        if (errorCode != null) {
            this.sendError(context, errorCode);
            return new Result(errorCode);
        }
        FlowCacheData.clearCache(context.getChatSessionId(), LLM_CT_RT);
        FlowCacheData.clearCache(context.getChatSessionId(), LLM_CT_END);
        FlowCacheData.clearCache(context.getChatSessionId(), LLM_CT_MESSAGE);
        List<Skill> skillList = context.getSkillList();
        ArrayList skillMapList = new ArrayList(skillList.size());
        for (Skill sk : skillList) {
            HashMap<String, String> skillMap = new HashMap<String, String>();
            skillMap.put("ID", sk.getId());
            skillMap.put("DESCRIPTION", sk.getServiceDes());
            skillMapList.add(skillMap);
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("NAME", context.getAssistant().getName());
        paraMap.put("PERSONA", context.getAssistant().getPersona());
        paraMap.put("SKILL_LIST", JSON.toJSONString(skillMapList));
        String assistantContext = "-\u5f53\u524d\u65f6\u95f4: " + format.format(new Date()) + "\n";
        paraMap.put("ASSISTANT_CONTEXT", assistantContext);
        ChatCallbackMessage callbackMessage = new ChatCallbackMessage();
        callbackMessage.setParseOutput(false);
        callbackMessage.setChatSessionId(context.getChatSessionId());
        callbackMessage.setUserInput(chatMessage.getUserInput());
        callbackMessage.setUserMessage(userMessage);
        callbackMessage.setInParaMap(chatMessage.getInParaMap());
        LLMMessage llmMessage = new LLMMessage();
        llmMessage.setCallbackMessage(callbackMessage);
        llmMessage.setUserInput(chatMessage.getUserInput());
        llmMessage.setPromptId(context.getAssistant().getPromptId());
        llmMessage.setStream(true);
        llmMessage.setParamMap(paraMap);
        llmMessage.setChatSessionId(context.getChatSessionId());
        Result result = HandlerFactory.runHandler(context, llmMessage);
        result.setCallback(true);
        if (result.getErrorCode().equals((Object)Errors.OK)) {
            PushMsgService.pushWaiting(context, 0L, result.getTaskId());
        } else if (!result.getErrorCode().equals((Object)Errors.FAKE_OK)) {
            this.sendError(context, result.getErrorCode());
        }
        return result;
    }

    private Skill getSkill(Context context, ChatMessage chatMessage) {
        if (chatMessage.getSkillId() != 0L) {
            Skill skill = new Skill();
            skill.setId(String.valueOf(chatMessage.getSkillId()));
            skill.setType(chatMessage.getSkillType());
            skill.setSkillSrc(SkillSrcEnum.USER);
            context.setCurrentSkill(skill);
            return skill;
        }
        List<Skill> skillList = context.getSkillList();
        if (skillList != null && skillList.size() == 1) {
            return skillList.get(0);
        }
        return null;
    }

    private ErrorCode verifyData(Context context, ChatMessage chatMessage) {
        if (context.getAssistant() == null) {
            return Errors.ASSISTANT_NOT_INIT;
        }
        List<Skill> flowList = context.getSkillList();
        if (flowList == null || flowList.isEmpty()) {
            return Errors.ASSISTANT_NO_FLOW;
        }
        if (context.getAssistant().getPromptId() == 0L) {
            return Errors.ASSISTANT_NO_PROMPT;
        }
        if (StringUtils.isEmpty((CharSequence)chatMessage.getUserInput())) {
            return Errors.noUserInputError();
        }
        return null;
    }

    private void sendError(Context context, ErrorCode errorCode) {
        log.error("code: {} message: {}", (Object)errorCode.getCode(), (Object)errorCode.getMessage());
        PushMsgService.pushErrMsg(context, errorCode.getCode(), errorCode.getMessage());
    }

    @Override
    public void callback(ChatCallbackMessage callbackMessage) {
        Context context = FlowCacheData.getContext(callbackMessage.getChatSessionId());
        if (context == null) {
            log.error("chat session id [{}] , context is null", (Object)callbackMessage.getChatSessionId());
            return;
        }
        String errCode = callbackMessage.getErrCode();
        if (!Errors.OK.getCode().equals(errCode)) {
            log.error("\u56de\u8c03\u9519\u8bef,{}", (Object)callbackMessage);
            PushMsgService.pushErrMsg(context, callbackMessage.getErrCode(), callbackMessage.getErrMsg());
            TraceUtil.saveIfStreamAsyncLLMLog(context, callbackMessage);
            return;
        }
        TraceUtil.saveIfStreamAsyncLLMLog(context, callbackMessage);
        List<Skill> skillList = context.getSkillList();
        log.info("\u6240\u6709\u6280\u80fd\u5217\u8868\uff1a{}", (Object)JSONObject.toJSONString(skillList));
        if (skillList == null || skillList.isEmpty()) {
            this.noSkill(context, callbackMessage);
            return;
        }
        if (callbackMessage.isStream()) {
            this.stream(context, callbackMessage);
        } else {
            this.noStream(context, callbackMessage);
        }
    }

    private void stream(Context context, ChatCallbackMessage callbackMessage) {
        List<Skill> flowList = context.getSkillList();
        String endFlag = FlowCacheData.getCache(context.getChatSessionId(), LLM_CT_END);
        if (endFlag != null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)callbackMessage.getLlmValue()) && StringUtils.isEmpty((CharSequence)callbackMessage.getLlmThink())) {
            if (callbackMessage.isEnd()) {
                this.streamEnd(context, callbackMessage);
            }
            return;
        }
        String llmValueOld = FlowCacheData.getCache(context.getChatSessionId(), LLM_CT_RT);
        String llmThinkOld = FlowCacheData.getCache(context.getChatSessionId(), LLM_CT_RT_THOUGHT);
        log.info("llmValueOld\uff1a{},llmThinkOld:{}", (Object)llmValueOld, (Object)llmThinkOld);
        String llmValue = llmValueOld == null ? callbackMessage.getLlmValue() : llmValueOld + callbackMessage.getLlmValue();
        String llmThink = llmThinkOld == null ? callbackMessage.getLlmThink() : llmThinkOld + callbackMessage.getLlmThink();
        log.info("llmValueNew\uff1a{},llmThinkNew:{}", (Object)llmValue, (Object)llmThink);
        if (llmValue == null) {
            if (StringUtils.isNotEmpty((CharSequence)llmThink)) {
                String llmThinkMessageOld;
                if (StringUtils.isNotEmpty((CharSequence)llmThink)) {
                    PushMsgService.pushStreamThinkChat(context, callbackMessage.getTaskId(), "0", callbackMessage.getSeqNo(), llmThink, false, callbackMessage.getSearchInfos());
                }
                if ((llmThinkMessageOld = FlowCacheData.getCache(context.getChatSessionId(), LLM_CT_THOUGHT_MESSAGE)) != null) {
                    FlowCacheData.putCache(context.getChatSessionId(), LLM_CT_THOUGHT_MESSAGE, llmThinkMessageOld + callbackMessage.getLlmThink());
                } else {
                    FlowCacheData.putCache(context.getChatSessionId(), LLM_CT_THOUGHT_MESSAGE, callbackMessage.getLlmThink());
                }
            }
        } else {
            Object[] result = this.matchSkill(flowList, llmValue);
            int matchStatus = (Integer)result[0];
            if (matchStatus == 2) {
                FlowCacheData.putCache(context.getChatSessionId(), LLM_CT_END, "Y");
                PushMsgService.pushStreamDown(context, callbackMessage.getTaskId(), "0", callbackMessage.getLlmValue(), "", "0");
                Skill skill = (Skill)result[1];
                log.info("\u6d41\u5f0f\u4e2d\u63a7\u542f\u52a8\u6280\u80fd{}", (Object)skill.getId());
                this.startSkill(context, skill, callbackMessage.getUserInput(), callbackMessage.getInParaMap() == null ? new HashMap() : callbackMessage.getInParaMap(), false, callbackMessage.getUserMessage());
            } else {
                log.info("matchStatus != 2, llmValue:{}", (Object)llmValue);
                String llmMessageOld = FlowCacheData.getCache(context.getChatSessionId(), LLM_CT_MESSAGE);
                if (llmMessageOld != null) {
                    FlowCacheData.putCache(context.getChatSessionId(), LLM_CT_MESSAGE, llmMessageOld + callbackMessage.getLlmValue());
                } else {
                    FlowCacheData.putCache(context.getChatSessionId(), LLM_CT_MESSAGE, callbackMessage.getLlmValue());
                }
                if (matchStatus == -1) {
                    String message;
                    if (llmValueOld != null) {
                        message = llmValue;
                        FlowCacheData.clearCache(context.getChatSessionId(), LLM_CT_RT);
                    } else {
                        message = callbackMessage.getLlmValue();
                    }
                    if (StringUtils.isNotEmpty((CharSequence)message)) {
                        PushMsgService.pushStreamChat(context, callbackMessage.getTaskId(), "0", callbackMessage.getSeqNo(), message, false, callbackMessage.getSearchInfos());
                    }
                } else {
                    FlowCacheData.putCache(context.getChatSessionId(), LLM_CT_RT, llmValue);
                }
                if (callbackMessage.isEnd()) {
                    if (StringUtils.isNotEmpty((CharSequence)callbackMessage.getLlmValue())) {
                        PushMsgService.pushStreamChat(context, callbackMessage.getTaskId(), "0", callbackMessage.getSeqNo(), callbackMessage.getLlmValue(), false, callbackMessage.getSearchInfos());
                    }
                    this.streamEnd(context, callbackMessage);
                }
            }
        }
    }

    private void noStream(Context context, ChatCallbackMessage callbackMessage) {
        Skill skill = this.getSkillId(context, callbackMessage.getLlmValue());
        if (skill == null) {
            String llmThink = callbackMessage.getLlmThink();
            String llmValue = callbackMessage.getLlmValue();
            if (StringUtils.isNotEmpty((CharSequence)llmThink)) {
                PushMsgService.pushThinkChat(context, callbackMessage.getTaskId(), llmThink, callbackMessage.getSearchInfos());
            }
            if (StringUtils.isNotEmpty((CharSequence)llmValue)) {
                PushMsgService.pushChat(context, callbackMessage.getTaskId(), llmValue, callbackMessage.getSearchInfos());
            }
            MessageService.insertMessage(context.getChatSessionId(), callbackMessage.getLlmValue(), llmThink, null, null, ChatMessageTypeEnum.ASSISTANT, EnableEnum.YES);
        }
        PushMsgService.pushWaitingDone(context);
        if (skill == null) {
            return;
        }
        log.info("\u4e2d\u63a7\u542f\u52a8\u6280\u80fd{}", (Object)skill.getId());
        this.startSkill(context, skill, callbackMessage.getUserInput(), callbackMessage.getInParaMap() == null ? new HashMap() : callbackMessage.getInParaMap(), false, callbackMessage.getUserMessage());
    }

    private void noSkill(Context context, ChatCallbackMessage callbackMessage) {
        if (callbackMessage.isStream() && !callbackMessage.isEnd()) {
            PushMsgService.pushStreamChat(context, callbackMessage.getTaskId(), "0", callbackMessage.getSeqNo(), callbackMessage.getLlmValue(), false, callbackMessage.getSearchInfos());
        } else if (callbackMessage.isEnd() && callbackMessage.isStream()) {
            if (StringUtils.isNotEmpty((CharSequence)callbackMessage.getLlmValue())) {
                PushMsgService.pushStreamChat(context, callbackMessage.getTaskId(), "0", callbackMessage.getSeqNo(), callbackMessage.getLlmValue(), false, callbackMessage.getSearchInfos());
            }
            this.streamEnd(context, callbackMessage);
        }
    }

    private void streamEnd(Context context, ChatCallbackMessage callbackMessage) {
        Message message = MessageService.insertMessage(context.getChatSessionId(), FlowCacheData.getCache(context.getChatSessionId(), LLM_CT_MESSAGE), FlowCacheData.getCache(context.getChatSessionId(), LLM_CT_THOUGHT_MESSAGE), null, context.getCurrentSkill(), ChatMessageTypeEnum.ASSISTANT, EnableEnum.YES);
        PushMsgService.pushStreamDown(context, callbackMessage.getTaskId(), "0", "", StrUtils.longAsString(message.getMessageId()), "0");
        PushMsgService.pushWaitingDone(context);
    }

    public Object[] matchSkill(List<Skill> flowList, String llmValue) {
        int matchStatus = -1;
        Skill matchSkill = null;
        for (Skill skill : flowList) {
            log.info("matchSkill\uff1a{} - {}", (Object)llmValue, (Object)JSONObject.toJSONString((Object)skill));
            int matchStatusTmp = this.match(llmValue, skill.getId());
            if (matchStatusTmp > matchStatus) {
                matchStatus = matchStatusTmp;
            }
            if (matchStatus != 2) continue;
            matchSkill = skill;
            break;
        }
        log.info("matchStatus\uff1a{} - matchSkill:{}", (Object)matchStatus, (Object)JSONObject.toJSONString(matchSkill));
        return new Object[]{matchStatus, matchSkill};
    }

    public int match(String llmValue, String skillIdStr) {
        if (llmValue.contains(skillIdStr)) {
            return 2;
        }
        int matchIndex = -1;
        int i = 1;
        while (i <= skillIdStr.length() && llmValue.contains(skillIdStr.substring(0, i))) {
            matchIndex = i++;
        }
        if (matchIndex == -1) {
            if (llmValue.startsWith("```")) {
                return 1;
            }
            return -1;
        }
        if (matchIndex == skillIdStr.length()) {
            return 2;
        }
        if (llmValue.endsWith(skillIdStr.substring(0, matchIndex))) {
            return 1;
        }
        return -1;
    }

    private Skill getSkillId(Context context, String llmValue) {
        List<Skill> skillList = context.getSkillList();
        if (skillList == null || skillList.isEmpty()) {
            return null;
        }
        for (Skill skill : skillList) {
            if (!llmValue.contains(skill.getId())) continue;
            return skill;
        }
        return null;
    }

    private Result startSkill(Context context, Skill skill, String userInput, Map<String, String> inParaMap, boolean isUserSelected, Message userMessage) {
        skill.setSkillSrc(isUserSelected ? SkillSrcEnum.USER : SkillSrcEnum.AUTO);
        if (!isUserSelected) {
            PushMsgService.pushIdentifySkill(context, skill.getId());
        }
        context.setCurrentSkill(skill);
        FlowCacheData.putContext(context.getChatSessionId(), context);
        try {
            if (Skill.Type.PROCESS == skill.getType()) {
                return this.startProcess(context, skill, userInput, inParaMap);
            }
            return ChatService.startJavaAgentChat(context, userMessage, inParaMap);
        }
        catch (Exception e) {
            ErrorCode errorCode = null;
            if (e instanceof KDBizException) {
                String code = ((KDBizException)((Object)e)).getErrorCode().getCode();
                String message = ((KDBizException)((Object)e)).getErrorCode().getMessage();
                errorCode = new ErrorCode(code, message);
            } else {
                errorCode = Errors.startSkillError(e.getMessage());
            }
            log.error(e.getMessage(), (Throwable)e);
            if ("true".equals(System.getProperty("local_dev"))) {
                PushMsgService.pushErrMsg(context, errorCode.getCode(), errorCode.getMessage() + "\uff1a" + JSONObject.toJSONString((Object)e.getStackTrace()));
            } else {
                PushMsgService.pushErrMsg(context, errorCode.getCode(), errorCode.getMessage());
            }
            return new Result(errorCode);
        }
    }

    private Result startProcess(Context context, Skill skill, String userInput, Map<String, String> inParaMap) {
        StartFlowMessage startFlowMessage = new StartFlowMessage();
        startFlowMessage.setProcessId(Long.parseLong(skill.getId()));
        startFlowMessage.setChatSessionId(context.getChatSessionId());
        startFlowMessage.setInParams(inParaMap);
        startFlowMessage.setUserInput(userInput);
        if (AgentServiceService.isNewFlowEngine()) {
            return FlowUtils.startFlow(context, startFlowMessage);
        }
        return HandlerFactory.runHandler(context, startFlowMessage);
    }
}

