/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.llm.base.Result2User;
import kd.ai.gai.core.domain.llm.base.Result4Embedding;
import kd.ai.gai.core.domain.vo.RepoVO;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.EmbeddingMessage;
import kd.ai.gai.core.enuz.VectorMetricType;
import kd.ai.gai.core.rag.milvus.MilvusService;
import kd.ai.gai.core.service.RepoService;
import kd.ai.gai.core.service.embedding.EmbeddingService;
import kd.ai.gai.core.service.embedding.EmbeddingServiceFactory;
import kd.ai.gai.core.service.vdb.VDBServiceManager;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class EmbeddingHandler {
    private static final Log logger = LogFactory.getLog(EmbeddingHandler.class);
    private static final long LOCK_WAIT_TIME = 10000L;
    private static final String LOCK_KEY_PER = "gai_embedding_call_";

    public static void callback(Result2User result) {
        String taskId = result.getTaskId();
        try {
            if (!Errors.OK.getCode().equals(result.getCode())) {
                EmbeddingHandler.embeddingErrUpdate(result, "\u3010\u77e5\u8bc6\u5e93-Embedding\u3011\u5f02\u6b65\u8c03\u7528\u7ed3\u679c\u5f02\u5e38");
                return;
            }
            IAppCache taskCache = EngineCache.getAppCache(taskId);
            String llmParsedMessageString = (String)taskCache.get("EbTask" + taskId, String.class);
            logger.info("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011embedding\u5f02\u6b65\u8c03\u7528\u56de\u8c03\u7f13\u5b58\u83b7\u53d6\uff0ctaskId({}),content\uff1a{}", (Object)taskId, (Object)llmParsedMessageString);
            if (StringUtils.isEmpty((CharSequence)llmParsedMessageString)) {
                return;
            }
            EmbeddingMessage embeddingMessage = JsonUtil.fromJson(llmParsedMessageString, EmbeddingMessage.class);
            long repoId = embeddingMessage.getRepoId();
            long fileId = embeddingMessage.getFileId();
            RepoVO repoInfo = RepoService.queryRepoMainInfo(repoId);
            VectorMetricType vectorMetricType = repoInfo.getVectorMetricType();
            EmbeddingService embeddingService = EmbeddingServiceFactory.getExecutor(embeddingMessage.getLlm(), vectorMetricType);
            Result4Embedding result4Embedding = embeddingService.resultParse(result);
            embeddingMessage.setVectors(result4Embedding.getVectorList());
            List<Long> chunkIds = embeddingMessage.getChunkIds();
            List<List<Float>> vectors = embeddingMessage.getVectors();
            ArrayList<Chunk> chunkMilvesList = new ArrayList<Chunk>(chunkIds.size());
            for (int i = 0; i < chunkIds.size(); ++i) {
                Chunk chunk = new Chunk((long)chunkIds.get(i), repoId, vectors.get(i));
                chunkMilvesList.add(chunk);
            }
            if (MilvusService.enableVDB()) {
                logger.debug("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011\u5411\u91cf\u6570\u636e,BOS-VDB\u6a21\u5f0f \u4efb\u52a1\u6279\u6b21:{} ,\u5927\u5c0f:{} ,\u5f00\u59cb\u5199\u5165", (Object)taskId, (Object)chunkIds.size());
                VDBServiceManager.getStore(embeddingMessage.getLlm(), vectorMetricType).bachInsert(chunkMilvesList);
            } else {
                logger.debug("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011\u5411\u91cf\u6570\u636e,\u4efb\u52a1\u6279\u6b21:{} ,\u5927\u5c0f:{} ,\u5f00\u59cb\u5199\u5165", (Object)taskId, (Object)chunkIds.size());
                MilvusService.getExecutor(embeddingMessage.getLlm(), vectorMetricType).bachInsert(chunkMilvesList);
            }
            StringBuilder sql = new StringBuilder();
            sql.append("update t_gai_text_chunk set fstatus = ? ");
            sql.append("where fid in (");
            sql.append(String.join((CharSequence)",", Collections.nCopies(chunkMilvesList.size(), "?")));
            sql.append(')');
            Object[] params = new Object[chunkIds.size() + 1];
            params[0] = "C";
            for (int j = 0; j < chunkIds.size(); ++j) {
                params[j + 1] = chunkIds.get(j);
            }
            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)sql.toString(), (Object[])params);
            logger.info("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011\u5411\u91cf\u6570\u636e,\u4efb\u52a1\u6279\u6b21:{} \u5199\u5165\u6210\u529f", (Object)taskId);
            RequestContext rc = RequestContext.get();
            String lockKey = LOCK_KEY_PER.concat(rc.getTenantCode()).concat("_").concat(rc.getAccountId()).concat("_").concat(String.valueOf(fileId));
            logger.info(String.format("\u3010GPT-\u77e5\u8bc6\u5e93\u3011-\u6587\u4ef6embedding\u5f02\u6b65\u56de\u8c03\u4efb\u52a1, \u9501Key\uff1a%s", lockKey));
            DLock lock = EmbeddingHandler.getLock(lockKey);
            if (!lock.tryLock(10000L)) {
                logger.error(String.format("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011embedding\u5f02\u6b65\u56de\u8c03\u4efb\u52a1,\u83b7\u4efb\u52a1\u66f4\u65b0\u6743\u8d85\u65f6\uff0c\u4e2d\u65ad\u672c\u6b21\u4efb\u52a1\uff0c\u77e5\u8bc6\u5e93:%s, FileID: %s ", repoId, fileId));
            }
            try {
                RepoService.updateRepoDocStatus(embeddingMessage.getLlm(), repoId, fileId);
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    logger.info("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011embedding\u5f02\u6b65\u56de\u8c03\u4efb\u52a1,\u6587\u4ef6:\u3010{}\u3011\uff0c\u4efb\u52a1\u6279\u6b21\uff1a\u3010{}\u3011\u5b8c\u6210, \u91ca\u653e\u9501\uff1a{}", new Object[]{fileId, taskId, lockKey});
                    lock.unlock();
                    throw throwable;
                }
            }
            logger.info("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011embedding\u5f02\u6b65\u56de\u8c03\u4efb\u52a1,\u6587\u4ef6:\u3010{}\u3011\uff0c\u4efb\u52a1\u6279\u6b21\uff1a\u3010{}\u3011\u5b8c\u6210, \u91ca\u653e\u9501\uff1a{}", new Object[]{fileId, taskId, lockKey});
            lock.unlock();
        }
        catch (Exception e) {
            String errMsg = "\u3010\u77e5\u8bc6\u5e93-Embedding\u3011callback\u5f02\u5e38" + e.getMessage();
            logger.error(errMsg, (Throwable)e);
            EmbeddingHandler.embeddingErrUpdate(result, errMsg);
        }
    }

    private static void embeddingErrUpdate(Result2User result, String exeMsg) {
        String taskId = result.getTaskId();
        DynamicObject chunkInfo = QueryServiceHelper.queryOne((String)"gai_text_chunk", (String)String.join((CharSequence)",", "repoid", "fileid"), (QFilter[])new QFilter[]{new QFilter("taskid", "=", (Object)taskId)});
        long repoId = chunkInfo.getLong("repoid");
        long fileId = chunkInfo.getLong("fileid");
        String resultToJson = SerializationUtils.toJsonString((Object)result);
        String logMsg = String.format("traceId: %s ,errMsg:%s - %s", RequestContext.get().getTraceId(), exeMsg, resultToJson);
        logMsg = logMsg.length() > 2000 ? logMsg.substring(0, 2000) : logMsg;
        logger.error("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011\u6a21\u578bAICC\u56de\u8c03,\u5f02\u5e38: {}, repoId:{},fileId:{},\u7ed3\u679c:{}", new Object[]{exeMsg, repoId, fileId, resultToJson});
        DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=?,fmodifytime=? where fid = ?", (Object[])new Object[]{"D", new Timestamp(System.currentTimeMillis()), repoId});
        DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_text_chunk set fstatus=?  where ftaskid =? ", (Object[])new Object[]{"D", taskId});
        DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_doc_manage set ffilestatus=? ,flog=? where fentryid=? and ffilestatus not in (?,?,?)", (Object[])new Object[]{"G", logMsg, fileId, "D", "G", "H"});
    }

    public static Result2User process(EmbeddingMessage message) {
        EmbeddingService embeddingService = EmbeddingServiceFactory.getExecutor(message.getLlm(), VectorMetricType.L2);
        Result2User result2User = embeddingService.embeddingAsync(message);
        String taskId = result2User.getTaskId();
        message.setTaskId(taskId);
        message.setChunks(null);
        EngineCache.getAppCache(taskId).put("EbTask" + taskId, (Object)JsonUtil.messageToJson(message));
        logger.info("\u3010\u77e5\u8bc6\u5e93-Embedding\u3011\u5f02\u6b65\u8c03\u7528\u56de\u8c03\u7f13\u5b58\uff0ctaskId({}),content\uff1a{}", (Object)taskId, (Object)JsonUtil.messageToJson(message));
        return result2User;
    }

    private static DLock getLock(String lockKey) {
        logger.info(String.format("\u3010GPT-\u77e5\u8bc6\u5e93\u3011- embedding\u5f02\u6b65\u56de\u8c03\u4efb\u52a1, \u9501Key\uff1a%s", lockKey));
        DLock lock = DLock.create((String)lockKey, (String)String.format("\u9501:%s,\u3010GPT-\u77e5\u8bc6\u5e93\u3011embedding\u5f02\u6b65\u56de\u8c03\u4efb\u52a1\u9501", lockKey));
        lock.fastMode();
        return lock;
    }
}

