/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.engine.message.EndFlowMessage;
import kd.ai.gai.core.helper.ClusterWaiter;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.flow.flow.core.FlowRuntime;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class EndFlowHandler
implements IMessageHandler<EndFlowMessage> {
    private static final Log log = LogFactory.getLog(EndFlowHandler.class);

    @Override
    public Result process(Context context, EndFlowMessage message) {
        Result flowResult;
        Flow flow = FlowCacheData.getFlowById(context.getChatSessionId(), message.getFlowId());
        if (flow == null) {
            log.error("flow {} \u4e0d\u5b58\u5728\uff0c\u7f13\u5b58\u88ab\u6e05\u9664", (Object)message.getFlowId());
            PushMsgService.pushWaitingDone(context);
            return new Result(Errors.OK);
        }
        if (message.isError()) {
            flowResult = new Result(message.getErrorCode());
        } else {
            flowResult = new Result(Errors.OK);
            List<VarMapper> outParamMap = flow.getEnd().getOutParamMap();
            if (outParamMap != null && !outParamMap.isEmpty()) {
                HashMap<String, String> data = new HashMap<String, String>(outParamMap.size());
                for (VarMapper varMapper : outParamMap) {
                    Map<String, String> outDataMap = FlowCacheData.getFlowNodeData(context.getChatSessionId(), flow.getId(), varMapper.getOutNodeId());
                    data.put(varMapper.getInVarName(), outDataMap.get(varMapper.getOutVarName()));
                }
                flowResult.setData(data);
            }
        }
        flowResult.setStatus(Result.Status.END);
        String key = String.format("%s_%s", context.getChatSessionId(), flow.getDefId());
        FlowCacheData.putCache(context.getChatSessionId(), key, JSON.toJSONString((Object)flowResult));
        EndFlowHandler.terminateRuntime(context, flow);
        ClusterWaiter.release(key);
        PushMsgService.pushWaitingDone(context);
        this.clearFlowCacheData(context, message, flow);
        return flowResult;
    }

    private static void terminateRuntime(Context context, Flow flow) {
        FlowRuntime runtime = FlowCacheData.getRuntime(context.getChatSessionId(), flow.getId());
        if (runtime != null && !runtime.isTerminated()) {
            runtime.terminate();
            FlowCacheData.clearCache(context.getChatSessionId(), "FLOW_RUNTIME_DOC");
        }
    }

    private void clearFlowCacheData(Context context, EndFlowMessage message, Flow flow) {
        String chatSessionId = context.getChatSessionId();
        long flowId = message.getFlowId();
        FlowCacheData.clearFlowNodeData(chatSessionId, flowId, flow.getStart().getId());
        for (Action action : flow.getActions()) {
            FlowCacheData.clearFlowNodeData(chatSessionId, flowId, action.getId());
        }
        FlowCacheData.clearFlow(chatSessionId, flowId);
        FlowCacheData.clearCache(context.getChatSessionId(), context.getChatSessionId() + "_ASK_USER");
    }
}

