/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import java.util.Collections;
import java.util.Map;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.IActionCallBack;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.handler.FlowNextHandler;
import kd.ai.gai.core.engine.handler.SysOperateHandler;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.ForwardMessage;
import kd.ai.gai.core.engine.message.JavaActionMessage;
import kd.ai.gai.core.enuz.ForwardType;
import kd.ai.gai.core.service.PushMsgService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;

public class JavaActionHandler
implements IMessageHandler<JavaActionMessage>,
IActionCallBack<ForwardMessage> {
    private static final Log log = LogFactory.getLog(JavaActionHandler.class);

    @Override
    public Result process(Context context, JavaActionMessage message) {
        if (this.isSysOperation(message)) {
            Map<String, String> bizResult = this.callSysOperation(message);
            FlowCacheData.setFlowNodeData(context.getChatSessionId(), message.getFlowId(), message.getNodeId(), bizResult);
            return new Result(Errors.OK);
        }
        if (message.isFrontOperation()) {
            String bizPageIdOrRootPageId = message.getPageId() == null ? context.getRootPageId() : message.getPageId();
            Map<String, String> bizResult = this.callAction(context, message.getAppId(), message.getClassName(), new Object[]{bizPageIdOrRootPageId, message.getActionName(), message.getParams()});
            String actionResultStr = bizResult.get("actionresult");
            Result result = new Result(Errors.OK);
            if (StringUtils.isEmpty((String)actionResultStr)) {
                log.warn("\u524d\u7aef\u4e1a\u52a1\u64cd\u4f5c\u6ca1\u6709\u8fd4\u56deactionresult\u3002 {}", (Object)JsonUtil.toJson(message));
            } else if (context.getAssistantPageId() != null) {
                PageCache pageCache = new PageCache(context.getAssistantPageId());
                String actionKey = "action_result_" + context.getChatSessionId();
                pageCache.put(actionKey, actionResultStr);
                ForwardMessage forwardMessage = new ForwardMessage();
                forwardMessage.setChatSessionId(message.getChatSessionId());
                forwardMessage.setFlowId(message.getFlowId());
                forwardMessage.setNodeId(message.getNodeId());
                String forwardMessageKey = "forwardMessage_" + context.getChatSessionId();
                pageCache.put(forwardMessageKey, JsonUtil.toJson(forwardMessage));
                PushMsgService.pushForward(context, ForwardType.javaAction, actionKey, forwardMessageKey);
                result.setCallback(true);
            }
            FlowCacheData.setFlowNodeData(context.getChatSessionId(), message.getFlowId(), message.getNodeId(), bizResult);
            return result;
        }
        Map<String, String> bizResult = this.callAction(context, message.getAppId(), message.getClassName(), new Object[]{message.getActionName(), message.getParams()});
        FlowCacheData.setFlowNodeData(context.getChatSessionId(), message.getFlowId(), message.getNodeId(), bizResult);
        return new Result(Errors.OK);
    }

    public Map<String, String> callSysOperation(JavaActionMessage message) {
        SysOperateHandler sysOperateHandler = new SysOperateHandler();
        return sysOperateHandler.invokeAction(message.getActionName(), message.getParams());
    }

    private boolean isSysOperation(JavaActionMessage message) {
        return message.getClassName().trim().equals(SysOperateHandler.class.getName());
    }

    @Override
    public void callback(ForwardMessage callbackMessage) {
        FlowNextHandler.callBack(callbackMessage);
    }

    public Map<String, String> callAction(Context context, String appId, String className, Object[] bizParams) {
        FlowCacheData.restoreRequestContext(context.getChatSessionId());
        Object ret = DispatchServiceHelper.invokeBOSService((String)appId, (String)"IGPTService", (String)"invokeGptAction", (Object[])new Object[]{className, "invokeAction", bizParams});
        if (ret instanceof Map) {
            return (Map)ret;
        }
        log.error("{} : {} \u8c03\u7528\u8fd4\u56de\u7c7b\u578b\u4e0d\u662fMap<String,String>, \u8fd4\u56de\u503c: {} ", new Object[]{appId, className, ret});
        return Collections.emptyMap();
    }
}

