/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.vo.ChunkData;
import kd.ai.gai.core.domain.vo.ContextData;
import kd.ai.gai.core.domain.vo.KnowledgeCitationData;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.IActionCallBack;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.handler.FlowNextHandler;
import kd.ai.gai.core.engine.message.FlowErrorMessage;
import kd.ai.gai.core.engine.message.LLMActionMessage;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.engine.message.QueryEntityCallbackMessage;
import kd.ai.gai.core.engine.message.RepoReplyCallbackMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMActionCallbackMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMParsedMessage;
import kd.ai.gai.core.enuz.AttType;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.helper.KnowledgeCitationHelper;
import kd.ai.gai.core.service.ChunkService;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.agent.AgentServiceService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.core.util.StrUtils;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;

public class LLMActionHandler
implements IMessageHandler<LLMActionMessage>,
IActionCallBack<LLMActionCallbackMessage> {
    private static final Log log = LogFactory.getLog(LLMActionHandler.class);

    @Override
    public Result process(Context context, LLMActionMessage message) {
        LLMActionCallbackMessage callbackMessage = new LLMActionCallbackMessage();
        callbackMessage.setParseOutput(true);
        callbackMessage.setFlowId(message.getFlowId());
        callbackMessage.setNodeId(message.getNodeId());
        callbackMessage.setPageId(context.getAssistantPageId());
        callbackMessage.setChatSessionId(context.getChatSessionId());
        callbackMessage.setGlobalSessionId(context.getGlobalSessionId());
        callbackMessage.setMergeLastMessageCard(message.isMergeLastMessageCard());
        LLMMessage llmMessage = new LLMMessage();
        llmMessage.setCallbackMessage(callbackMessage);
        llmMessage.setUserInput(message.getUserInput());
        llmMessage.setPromptId(message.getPromptId());
        llmMessage.setRepoIdList(message.getRepoIdList());
        llmMessage.setStream(message.isStream());
        llmMessage.setParamMap(message.getParams());
        Result result = HandlerFactory.runHandler(context, llmMessage);
        result.setCallback(true);
        return result;
    }

    @Override
    public void callback(LLMActionCallbackMessage callbackMessage) {
        log.info("\u641c\u7d22\u6e90\u4fe1\u606f\uff1a {}", callbackMessage.getSearchInfos());
        String chatSessionId = callbackMessage.getChatSessionId();
        Context context = FlowCacheData.getContext(chatSessionId);
        String errCode = callbackMessage.getErrCode();
        if (StringUtils.isEmpty((CharSequence)errCode) || !errCode.equals(Errors.OK.getCode())) {
            errCode = StringUtils.isEmpty((CharSequence)errCode) ? Errors.LLM_ERROR.getCode() : errCode;
            log.error("\u56de\u8c03\u9519\u8bef", (Object)callbackMessage);
            FlowErrorMessage message = new FlowErrorMessage();
            String errMsg = callbackMessage.getErrMsg();
            if (!errCode.equals(Errors.MESSAGE_REPLACE_OK.getCode())) {
                errMsg = "\u5927\u8bed\u8a00\u6a21\u578b\u51fa\u9519\uff1a" + callbackMessage.getErrMsg();
            }
            message.setErrorCode(new ErrorCode(errCode, errMsg));
            message.setFlowId(callbackMessage.getFlowId());
            message.setChatSessionId(callbackMessage.getChatSessionId());
            HandlerFactory.runHandler(FlowCacheData.getContext(callbackMessage.getChatSessionId()), message);
            TraceUtil.saveIfStreamAsyncLLMLog(context, callbackMessage);
            return;
        }
        String llmValue = callbackMessage.getLlmValue();
        String llmThink = callbackMessage.getLlmThink();
        if (callbackMessage.isStream() && !callbackMessage.isEnd()) {
            if (StringUtils.isNotEmpty((CharSequence)llmThink)) {
                PushMsgService.pushStreamThinkChat(context, callbackMessage.getTaskId(), callbackMessage.getFlowId() + "", callbackMessage.getSeqNo(), llmThink, callbackMessage.isMergeLastMessageCard(), callbackMessage.getSearchInfos());
            }
            if (StringUtils.isNotEmpty((CharSequence)llmValue)) {
                PushMsgService.pushStreamChat(context, callbackMessage.getTaskId(), callbackMessage.getFlowId() + "", callbackMessage.getSeqNo(), llmValue, callbackMessage.isMergeLastMessageCard(), callbackMessage.getSearchInfos());
            }
            TraceUtil.saveIfStreamAsyncLLMLog(context, callbackMessage);
        } else if (callbackMessage.isEnd()) {
            if (callbackMessage.isStream()) {
                if (StringUtils.isNotEmpty((CharSequence)llmValue)) {
                    PushMsgService.pushStreamChat(context, callbackMessage.getTaskId(), callbackMessage.getFlowId() + "", callbackMessage.getSeqNo(), llmValue, callbackMessage.isMergeLastMessageCard(), callbackMessage.getSearchInfos());
                }
                SLIDEENV slideenv = context.getSlideenv();
                HashMap<String, Boolean> tagMap = new HashMap<String, Boolean>(3);
                tagMap.put("replaceLast", false);
                tagMap.put("concatLast", callbackMessage.isMergeLastMessageCard());
                LocalMemoryCache appCache = EngineCache.getLocalCache(chatSessionId);
                String taskId = callbackMessage.getTaskId();
                String msgContent = (String)appCache.get("streamBuffer" + taskId);
                msgContent = (msgContent == null ? "" : msgContent) + (llmValue == null ? "" : llmValue);
                String think = (String)appCache.get("streamThinkBuffer" + taskId);
                think = think == null ? "" : think;
                Message message = MessageService.insertMessage(context.getChatSessionId(), msgContent, think, JSON.toJSONString(tagMap), context.getCurrentSkill(), ChatMessageTypeEnum.ASSISTANT, context.messageIsEnable());
                PushMsgService.pushStreamDown(context, callbackMessage.getTaskId(), callbackMessage.getFlowId() + "", llmValue, StrUtils.longAsString(message.getMessageId()), "0");
                List<KnowledgeCitationData> citationInfos = callbackMessage.getCitationInfos();
                LLMActionHandler.sendChatBottomMsg(context, null, callbackMessage.getPageId(), context.getRootPageId(), context.getGlobalSessionId(), callbackMessage.getChatSessionId(), callbackMessage.getTaskId(), callbackMessage.getFlowId() + "", "\u53c2\u8003\u6587\u4ef6", citationInfos);
            }
            if (callbackMessage.getJsonValue() != null && !callbackMessage.getJsonValue().isEmpty()) {
                FlowCacheData.setFlowNodeData(callbackMessage.getChatSessionId(), callbackMessage.getFlowId(), callbackMessage.getNodeId(), callbackMessage.getJsonValue());
            } else {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("prompt_output", llmValue);
                if (StringUtils.isNotEmpty((CharSequence)llmThink)) {
                    data.put("reasoning_output", llmThink);
                }
                data.put("reference_output", JSONObject.toJSONString(callbackMessage.getCitationInfos()));
                FlowCacheData.setFlowNodeData(callbackMessage.getChatSessionId(), callbackMessage.getFlowId(), callbackMessage.getNodeId(), data);
            }
            TraceUtil.saveIfStreamAsyncLLMLog(context, callbackMessage);
            FlowNextHandler.callBack(callbackMessage);
        }
    }

    public static void promptNodeCallBack(LLMActionCallbackMessage callbackMessage) {
        log.info("\u65b0\u5f15\u64ce\u641c\u7d22\u6e90\u4fe1\u606f\uff1a {}", callbackMessage.getSearchInfos());
        String chatSessionId = callbackMessage.getChatSessionId();
        Context context = FlowCacheData.getContext(chatSessionId);
        Flow flow = FlowCacheData.getFlowById(callbackMessage.getChatSessionId(), callbackMessage.getFlowId());
        if (flow == null) {
            log.error("\u65e0\u6cd5\u627e\u5230\u6d41\u7a0bID\uff08{}\uff09\u7684\u7f13\u5b58\u4fe1\u606f\uff0c\u6709\u53ef\u80fd\u88ab\u6e05\u9664", (Object)callbackMessage.getFlowId());
            throw new KDBizException(Errors.flowInstanceNotExisted(callbackMessage.getFlowId()), new Object[0]);
        }
        String errCode = callbackMessage.getErrCode();
        if (StringUtils.isEmpty((CharSequence)errCode) || !errCode.equals(Errors.OK.getCode())) {
            errCode = StringUtils.isEmpty((CharSequence)errCode) ? Errors.LLM_ERROR.getCode() : errCode;
            log.error("\u56de\u8c03\u9519\u8bef", (Object)callbackMessage);
            FlowErrorMessage message = new FlowErrorMessage();
            String errMsg = callbackMessage.getErrMsg();
            if (!errCode.equals(Errors.MESSAGE_REPLACE_OK.getCode())) {
                errMsg = "\u5927\u8bed\u8a00\u6a21\u578b\u51fa\u9519\uff1a" + callbackMessage.getErrMsg();
            }
            message.setErrorCode(new ErrorCode(errCode, errMsg));
            message.setFlowId(callbackMessage.getFlowId());
            message.setChatSessionId(callbackMessage.getChatSessionId());
            HandlerFactory.runHandler(FlowCacheData.getContext(callbackMessage.getChatSessionId()), message);
            TraceUtil.saveIfStreamAsyncLLMLog(context, callbackMessage);
            throw new KDBizException(errCode);
        }
        String llmValue = callbackMessage.getLlmValue();
        String llmThink = callbackMessage.getLlmThink();
        if (callbackMessage.isStream() && !callbackMessage.isEnd()) {
            if (StringUtils.isNotEmpty((CharSequence)llmThink)) {
                PushMsgService.pushStreamThinkChat(context, callbackMessage.getTaskId(), callbackMessage.getFlowId() + "", callbackMessage.getSeqNo(), llmThink, callbackMessage.isMergeLastMessageCard(), callbackMessage.getSearchInfos());
            }
            if (StringUtils.isNotEmpty((CharSequence)llmValue)) {
                PushMsgService.pushStreamChat(context, callbackMessage.getTaskId(), callbackMessage.getFlowId() + "", callbackMessage.getSeqNo(), llmValue, callbackMessage.isMergeLastMessageCard(), callbackMessage.getSearchInfos());
            }
            TraceUtil.saveIfStreamAsyncLLMLog(context, callbackMessage);
        } else if (callbackMessage.isEnd()) {
            if (callbackMessage.isStream()) {
                if (StringUtils.isNotEmpty((CharSequence)llmValue)) {
                    PushMsgService.pushStreamChat(context, callbackMessage.getTaskId(), callbackMessage.getFlowId() + "", callbackMessage.getSeqNo(), llmValue, callbackMessage.isMergeLastMessageCard(), callbackMessage.getSearchInfos());
                }
                SLIDEENV slideenv = context.getSlideenv();
                HashMap<String, Boolean> tagMap = new HashMap<String, Boolean>(3);
                tagMap.put("replaceLast", false);
                tagMap.put("concatLast", callbackMessage.isMergeLastMessageCard());
                LocalMemoryCache appCache = EngineCache.getLocalCache(chatSessionId);
                String msgContent = (String)appCache.get("streamBuffer" + callbackMessage.getTaskId());
                msgContent = (msgContent == null ? "" : msgContent) + (llmValue == null ? "" : llmValue);
                String thinkContent = (String)appCache.get("streamThinkBuffer" + callbackMessage.getTaskId());
                thinkContent = thinkContent == null ? "" : thinkContent;
                Message message = MessageService.insertMessage(context.getChatSessionId(), msgContent, thinkContent, JSON.toJSONString(tagMap), context.getCurrentSkill(), ChatMessageTypeEnum.ASSISTANT, context.messageIsEnable());
                PushMsgService.pushStreamDown(context, callbackMessage.getTaskId(), callbackMessage.getFlowId() + "", llmValue, StrUtils.longAsString(message.getMessageId()), "0");
                List<KnowledgeCitationData> citationInfos = callbackMessage.getCitationInfos();
                LLMActionHandler.sendChatBottomMsg(context, null, callbackMessage.getPageId(), context.getRootPageId(), context.getGlobalSessionId(), callbackMessage.getChatSessionId(), callbackMessage.getTaskId(), callbackMessage.getFlowId() + "", "\u53c2\u8003\u6587\u4ef6", citationInfos);
            }
            TraceUtil.saveIfStreamAsyncLLMLog(context, callbackMessage);
            LLMActionHandler.signalFlow(chatSessionId, callbackMessage);
        }
    }

    public static void doCallback(RepoReplyCallbackMessage callbackMessage) {
        String chatSessionId = callbackMessage.getChatSessionId();
        Context context = FlowCacheData.getContext(chatSessionId);
        String errCode = callbackMessage.getErrCode();
        if (StringUtils.isEmpty((CharSequence)errCode) || !errCode.equals(Errors.OK.getCode())) {
            errCode = StringUtils.isEmpty((CharSequence)errCode) ? Errors.LLM_ERROR.getCode() : errCode;
            log.error("\u56de\u8c03\u9519\u8bef", (Object)callbackMessage);
            FlowErrorMessage message = new FlowErrorMessage();
            message.setErrorCode(new ErrorCode(errCode, "\u5927\u8bed\u8a00\u6a21\u578b\u51fa\u9519\uff1a" + callbackMessage.getErrMsg()));
            message.setFlowId(callbackMessage.getFlowId());
            message.setChatSessionId(callbackMessage.getChatSessionId());
            HandlerFactory.runHandler(FlowCacheData.getContext(callbackMessage.getChatSessionId()), message);
            TraceUtil.saveIfStreamAsyncLLMLog(context, callbackMessage);
            return;
        }
        String llmValue = callbackMessage.getLlmValue();
        String llmThink = callbackMessage.getLlmThink();
        if (callbackMessage.isStream() && !callbackMessage.isEnd() && callbackMessage.isShowMessage()) {
            if (StringUtils.isNotEmpty((CharSequence)llmThink)) {
                PushMsgService.pushStreamThinkChat(context, callbackMessage.getTaskId(), callbackMessage.getFlowId() + "", callbackMessage.getSeqNo(), llmThink, false, callbackMessage.getSearchInfos());
            }
            if (StringUtils.isNotEmpty((CharSequence)llmValue)) {
                PushMsgService.pushStreamChat(context, callbackMessage.getTaskId(), callbackMessage.getFlowId() + "", callbackMessage.getSeqNo(), llmValue, false, callbackMessage.getSearchInfos());
            }
            TraceUtil.saveIfStreamAsyncLLMLog(context, callbackMessage);
        } else if (callbackMessage.isEnd()) {
            if (callbackMessage.isStream() && callbackMessage.isShowMessage()) {
                if (StringUtils.isNotEmpty((CharSequence)llmValue)) {
                    PushMsgService.pushStreamChat(context, callbackMessage.getTaskId(), callbackMessage.getFlowId() + "", callbackMessage.getSeqNo(), llmValue, false, callbackMessage.getSearchInfos());
                }
                SLIDEENV slideenv = context.getSlideenv();
                HashMap<String, Boolean> tagMap = new HashMap<String, Boolean>(3);
                tagMap.put("replaceLast", false);
                tagMap.put("concatLast", false);
                LocalMemoryCache appCache = EngineCache.getLocalCache(chatSessionId);
                String msgContent = (String)appCache.get("streamBuffer" + callbackMessage.getTaskId());
                msgContent = (msgContent == null ? "" : msgContent) + (llmValue == null ? "" : llmValue);
                String think = (String)appCache.get("streamThinkBuffer" + callbackMessage.getTaskId());
                think = think == null ? "" : think;
                Message message = MessageService.insertMessage(context.getChatSessionId(), msgContent, think, JSON.toJSONString(tagMap), context.getCurrentSkill(), ChatMessageTypeEnum.ASSISTANT, context.messageIsEnable());
                PushMsgService.pushStreamDown(context, callbackMessage.getTaskId(), callbackMessage.getFlowId() + "", llmValue, StrUtils.longAsString(message.getMessageId()), "0");
                List<KnowledgeCitationData> citationInfos = callbackMessage.getCitationInfos();
                LLMActionHandler.sendChatBottomMsg(context, null, callbackMessage.getPageId(), context.getRootPageId(), context.getGlobalSessionId(), callbackMessage.getChatSessionId(), callbackMessage.getTaskId(), callbackMessage.getFlowId() + "", "\u53c2\u8003\u6587\u4ef6", citationInfos);
            }
            if (callbackMessage.getJsonValue() != null && !callbackMessage.getJsonValue().isEmpty()) {
                FlowCacheData.setFlowNodeData(callbackMessage.getChatSessionId(), callbackMessage.getFlowId(), callbackMessage.getNodeId(), callbackMessage.getJsonValue());
            }
            TraceUtil.saveIfStreamAsyncLLMLog(context, callbackMessage);
            if (AgentServiceService.isNewFlowEngine()) {
                LLMActionHandler.signalFlow(chatSessionId, callbackMessage);
            } else {
                Map<String, String> data = callbackMessage.getFlowOutput();
                FlowCacheData.setFlowNodeData(callbackMessage.getChatSessionId(), callbackMessage.getFlowId(), callbackMessage.getNodeId(), data);
                FlowNextHandler.callBack(callbackMessage);
            }
        }
    }

    public static void sendChatBottomMsg(Context context, String k, String pageId, String rootPageId, String globalSessionId, String chatSessionId, String taskId, String flowId, String title, List<KnowledgeCitationData> knowledgeCitationData) {
        if (knowledgeCitationData == null || knowledgeCitationData.isEmpty()) {
            return;
        }
        StringBuilder logMsgBuilder = new StringBuilder();
        ArrayList<Long> citationChunkIds = new ArrayList<Long>();
        for (KnowledgeCitationData citationData : knowledgeCitationData) {
            List<KnowledgeCitationData.ChunkItem> chunkItems = citationData.getChunkItems();
            if (chunkItems.isEmpty()) continue;
            for (KnowledgeCitationData.ChunkItem chunkItem : chunkItems) {
                Long chunkId = chunkItem.getChunkId();
                citationChunkIds.add(chunkId);
            }
        }
        List<Chunk> chunks = ChunkService.getByListWithTaskCache(citationChunkIds, chatSessionId, taskId, "needcachedKnowledge");
        KnowledgeCitationHelper.cacheFilePreviewParams(chatSessionId, "needcachedKnowledge", taskId);
        ArrayList<ContextData.Item> webItems = new ArrayList<ContextData.Item>(knowledgeCitationData.size());
        for (KnowledgeCitationData citationData : knowledgeCitationData) {
            ChunkData chunkData;
            long chunkId;
            List<KnowledgeCitationData.ChunkItem> chunkItems;
            String citationTitle = citationData.getTitle();
            String source = citationData.getSource();
            String linkUrl = citationData.getLinkUrl();
            long fileId = citationData.getFileId();
            int order = citationData.getOrder();
            ContextData.Item item = null;
            if ("doc".equals(source)) {
                item = new ContextData.Item(AttType.document, citationTitle, linkUrl, order);
                item.setFileId(fileId + "");
                chunkItems = citationData.getChunkItems();
                if (!chunkItems.isEmpty()) {
                    block3: for (KnowledgeCitationData.ChunkItem chunkItem : chunkItems) {
                        chunkId = chunkItem.getChunkId();
                        for (Chunk chunk : chunks) {
                            if (chunk.getId() != chunkId) continue;
                            logMsgBuilder.append("[gairepodoc]");
                            logMsgBuilder.append(fileId).append("##").append(chunkId).append("##").append(chunkItem.getChunkOrder()).append("##").append(chunkItem.getPage()).append("##").append(chatSessionId).append("##").append(taskId);
                            logMsgBuilder.append("[/gairepodoc]");
                            chunkData = new ChunkData(chunkItem.getChunkOrder(), chunk.getChunk(), chunkItem.getPage());
                            item.getSuperscript().add(chunkData);
                            continue block3;
                        }
                    }
                }
            } else if ("bill".equals(source)) {
                item = new ContextData.Item(AttType.bill, citationTitle, linkUrl, order);
                item.setFileId(fileId + "");
                chunkItems = citationData.getChunkItems();
                if (!chunkItems.isEmpty()) {
                    block5: for (KnowledgeCitationData.ChunkItem chunkItem : chunkItems) {
                        chunkId = chunkItem.getChunkId();
                        for (Chunk chunk : chunks) {
                            if (chunk.getId() != chunkId) continue;
                            logMsgBuilder.append("[gairepodoc]");
                            logMsgBuilder.append(fileId).append("##").append(chunkId).append("##").append(chunkItem.getChunkOrder()).append("##").append(chunkItem.getPage()).append("##").append(chatSessionId).append("##").append(taskId);
                            logMsgBuilder.append("[/gairepodoc]");
                            chunkData = new ChunkData(chunkItem.getChunkOrder(), chunk.getChunk(), chunkItem.getPage());
                            item.getSuperscript().add(chunkData);
                            continue block5;
                        }
                    }
                }
            } else if ("code".equals(source)) {
                logMsgBuilder.append("[gairepodoc]");
                logMsgBuilder.append(fileId);
                logMsgBuilder.append("[/gairepodoc]");
                item = new ContextData.Item(AttType.code, citationTitle, linkUrl, order);
                item.setFileId(fileId + "");
            } else {
                logMsgBuilder.append("[gairepodoc]");
                logMsgBuilder.append(fileId);
                logMsgBuilder.append("[/gairepodoc]");
                String url = linkUrl;
                boolean isNextCloud = url.startsWith("{domainContextUrl}");
                if (isNextCloud) {
                    String domainContextUrl = UrlService.getDomainContextUrl();
                    url = url.replaceFirst("\\{domainContextUrl\\}", domainContextUrl);
                }
                item = new ContextData.Item(AttType.knowledge, citationTitle, url, order);
                item.setPreviewByCosmic(false);
            }
            webItems.add(item);
        }
        ContextData contextData = new ContextData(chatSessionId, taskId, flowId + "", title, webItems);
        SLIDEENV assistantDevice = context.getSlideenv();
        Message message = MessageService.insertMessage(chatSessionId, logMsgBuilder.toString(), "", null, context.getCurrentSkill(), ChatMessageTypeEnum.PROCESS, context.messageIsEnable());
        contextData.setMessageId(StrUtils.longAsString(message.getMessageId()));
        PushMsgService.pushChatBottom(context, contextData);
    }

    public static void doQueryEntityCallback(QueryEntityCallbackMessage callbackMessage) {
        String chatSessionId = callbackMessage.getChatSessionId();
        Context context = FlowCacheData.getContext(chatSessionId);
        String errCode = callbackMessage.getErrCode();
        if (StringUtils.isEmpty((CharSequence)errCode) || !errCode.equals(Errors.OK.getCode())) {
            errCode = StringUtils.isEmpty((CharSequence)errCode) ? Errors.LLM_ERROR.getCode() : errCode;
            log.error("\u56de\u8c03\u9519\u8bef", (Object)callbackMessage);
            FlowErrorMessage message = new FlowErrorMessage();
            message.setErrorCode(new ErrorCode(errCode, "\u5927\u8bed\u8a00\u6a21\u578b\u51fa\u9519\uff1a" + callbackMessage.getErrMsg()));
            message.setFlowId(callbackMessage.getFlowId());
            message.setChatSessionId(callbackMessage.getChatSessionId());
            HandlerFactory.runHandler(FlowCacheData.getContext(callbackMessage.getChatSessionId()), message);
            TraceUtil.saveIfStreamAsyncLLMLog(context, callbackMessage);
            return;
        }
        String llmValue = callbackMessage.getLlmValue();
        if (callbackMessage.isEnd()) {
            HashMap<String, Boolean> tagMap = new HashMap<String, Boolean>(3);
            tagMap.put("replaceLast", false);
            tagMap.put("concatLast", false);
            LocalMemoryCache appCache = EngineCache.getLocalCache(chatSessionId);
            String msgContent = (String)appCache.get("streamBuffer" + callbackMessage.getTaskId());
            msgContent = (msgContent == null ? "" : msgContent) + (llmValue == null ? "" : llmValue);
            String think = (String)appCache.get("streamThinkBuffer" + callbackMessage.getTaskId());
            think = think == null ? "" : think;
            Message message = MessageService.insertMessage(context.getChatSessionId(), msgContent, think, JSON.toJSONString(tagMap), context.getCurrentSkill(), ChatMessageTypeEnum.ASSISTANT, context.messageIsEnable());
            callbackMessage.setAllMsg(msgContent);
            TraceUtil.saveIfStreamAsyncLLMLog(context, callbackMessage);
            LLMActionHandler.signalFlow(chatSessionId, callbackMessage);
        }
    }

    private static void signalFlow(String chatSessionId, LLMParsedMessage callbackMessage) {
        try {
            FlowUtils.signal(chatSessionId, callbackMessage.getFlowId(), callbackMessage);
        }
        catch (Exception ex) {
            ErrorCode errorCode;
            log.error("signalFlow error", (Throwable)ex);
            if (ex instanceof KDException) {
                errorCode = ((KDException)((Object)ex)).getErrorCode();
            } else if (ex instanceof kd.ai.gai.exception.KDException) {
                kd.ai.gai.exception.KDException gaiKDException = (kd.ai.gai.exception.KDException)((Object)ex);
                errorCode = new ErrorCode(gaiKDException.getErrorCode().getCode(), gaiKDException.getMessage());
            } else {
                errorCode = Errors.internalError(ex.getMessage());
            }
            FlowErrorMessage message = new FlowErrorMessage();
            message.setErrorCode(errorCode);
            message.setFlowId(callbackMessage.getFlowId());
            message.setChatSessionId(callbackMessage.getChatSessionId());
            HandlerFactory.runHandler(FlowCacheData.getContext(callbackMessage.getChatSessionId()), message);
        }
    }
}

