/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.engine.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.ChatItem;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.domain.dto.PromptOutVar;
import kd.ai.gai.core.domain.dto.TrustLayerContext;
import kd.ai.gai.core.domain.llm.LLMSearchInfo;
import kd.ai.gai.core.domain.llm.base.ModelResult;
import kd.ai.gai.core.domain.llm.base.ModelResultParam;
import kd.ai.gai.core.domain.llm.base.Result2User;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.domain.vo.APIReferenceData;
import kd.ai.gai.core.domain.vo.KnowledgeCitationData;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.IActionCallBack;
import kd.ai.gai.core.engine.IMessageHandler;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.agent.AgentCallBackMessage;
import kd.ai.gai.core.engine.agent.AgentMessage;
import kd.ai.gai.core.engine.handler.Decrypt;
import kd.ai.gai.core.engine.handler.LLMActionHandler;
import kd.ai.gai.core.engine.handler.StopStreamHandler;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.engine.message.QueryEntityCallbackMessage;
import kd.ai.gai.core.engine.message.RepoReplyCallbackMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMActionCallbackMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMParsedMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMRawMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.OutPreVar;
import kd.ai.gai.core.enuz.agent.RoleModeEnum;
import kd.ai.gai.core.helper.GPTLicenseHelper;
import kd.ai.gai.core.helper.KnowledgeCitationHelper;
import kd.ai.gai.core.service.ChatHistoryService;
import kd.ai.gai.core.service.LlmServiceFactory;
import kd.ai.gai.core.service.PromptService;
import kd.ai.gai.core.service.agent.AgentServiceService;
import kd.ai.gai.core.service.llm.LlmService;
import kd.ai.gai.core.service.trusty.SensitiveCheckService;
import kd.ai.gai.core.trace.entity.PromptLog;
import kd.ai.gai.core.trace.entity.TrustLayerLog;
import kd.ai.gai.core.trace.entity.VectorRetrieverLog;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.core.util.GaiUtils;
import kd.ai.gai.core.util.PropUtil;
import kd.ai.gai.core.util.StrUtils;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class LLMHandler
implements IMessageHandler<LLMMessage>,
IActionCallBack<LLMRawMessage> {
    private static final Log logger = LogFactory.getLog(LLMHandler.class);
    private static final String STOP_RESULT_KEY_MESSAGESENDED = "stop_result_messagesended";

    @Override
    public void callback(LLMRawMessage result) {
        String chatSessionId;
        String taskId = String.valueOf(result.getId());
        LocalMemoryCache taskCache = EngineCache.getLocalCache(taskId);
        String llmParsedMessageString = (String)taskCache.get("llmTask" + taskId);
        logger.info("GAI \u5f02\u6b65\u8c03\u7528\u56de\u8c03\u7f13\u5b58\u83b7\u53d6\uff0ctaskId({}),content\uff1a{}", (Object)taskId, (Object)llmParsedMessageString);
        if (StringUtils.isEmpty((CharSequence)llmParsedMessageString)) {
            throw new KDBizException("GAI \u5f02\u6b65\u8c03\u7528\u56de\u8c03\u7f13\u5b58\u83b7\u53d6\u5931\u8d25\u3002");
        }
        LLMParsedMessage llmParsedMessage = JsonUtil.fromJson(llmParsedMessageString, LLMParsedMessage.class);
        if (this.isTaskStop(result, llmParsedMessage, chatSessionId = llmParsedMessage.getChatSessionId())) {
            logger.info(String.format("\u4efb\u52a1[%s] \u5df2\u505c\u6b62\uff0c\u4e0d\u518d\u53d1\u9001\u6d88\u606f\u3002", taskId));
            return;
        }
        logger.info("AICC \u56de\u8c03 LLMHandler {}", JSON.toJSON((Object)result));
        LocalMemoryCache appCache = EngineCache.getLocalCache(chatSessionId);
        llmParsedMessage.setTaskId(taskId);
        llmParsedMessage.setErrCode(result.getErrCode());
        llmParsedMessage.setErrMsg(result.getErrMsg());
        if (!Errors.OK.getCode().equals(result.getErrCode())) {
            long time = System.currentTimeMillis();
            logger.info("LLMToken callback error,errorCode:{},time:{},taskId:{}", new Object[]{result.getErrCode(), time, taskId});
            taskCache.put("task_first_token_time", (Object)String.valueOf(time));
            if (AgentServiceService.isNewFlowEngine()) {
                llmParsedMessage.setEnd(true);
                LLMHandler.llmHandlerCallback(llmParsedMessage, chatSessionId);
            } else {
                HandlerFactory.callback(llmParsedMessage);
            }
            logger.info("task : {} is error {} -- {}.", new Object[]{taskId, result.getErrCode(), result.getErrMsg()});
            return;
        }
        try {
            boolean end;
            Prompt prompt = (Prompt)appCache.get("prompt" + taskId);
            LLM llm = prompt.getLlm();
            boolean stream = result.isStream();
            LlmService helper = LlmServiceFactory.getExecutor(llm, stream);
            String msg = null;
            String think = null;
            if (stream) {
                String streamRepoBuffer;
                boolean hasThink;
                int seqNo = result.getStreamSeqNO();
                List<LLMSearchInfo> searchInfos = null;
                if (result.isParsedResult()) {
                    think = result.getLlmThinkValue();
                    msg = result.getLlmValue();
                    searchInfos = result.getSearchInfoList();
                } else {
                    List<String> lineList = result.getResult();
                    StringBuilder msgBuild = new StringBuilder();
                    StringBuilder thinkBuild = new StringBuilder();
                    boolean isEnd = false;
                    for (String line : lineList) {
                        ModelResult modelResult = helper.getResult(new ModelResultParam(true, line));
                        if (modelResult.getContent() != null) {
                            msgBuild.append(modelResult.getContent());
                        } else if (modelResult.getThink() != null) {
                            thinkBuild.append(modelResult.getThink());
                        } else {
                            isEnd = true;
                        }
                        if (searchInfos != null) continue;
                        searchInfos = modelResult.getSearchInfoList();
                    }
                    if (!isEnd) {
                        think = thinkBuild.toString();
                        msg = msgBuild.toString();
                    }
                }
                logger.info("\u6d41\u5f0f\u6279\u6b21\uff1a  {}, msg:{},think:{}, searchInfo: {}", new Object[]{seqNo, msg, think, JSON.toJSONString(searchInfos)});
                if (seqNo == 0) {
                    long first = System.currentTimeMillis();
                    taskCache.put("task_first_token_time", (Object)String.valueOf(first));
                    llmParsedMessage.setSearchInfos(searchInfos);
                }
                if (msg != null && msg.isEmpty() && think != null && think.isEmpty() && !"success".equals(result.getStatus()) && seqNo != 0) {
                    return;
                }
                String msgCached = (String)appCache.get("streamBuffer" + taskId);
                String thinkCached = (String)appCache.get("streamThinkBuffer" + taskId);
                if (StringUtils.isEmpty((CharSequence)msg) && StringUtils.isEmpty((CharSequence)think) && StringUtils.isEmpty((CharSequence)msgCached) && StringUtils.isEmpty((CharSequence)thinkCached)) {
                    return;
                }
                Object hasThinkObj = appCache.get("streamHasThink" + taskId);
                boolean bl = hasThink = hasThinkObj != null && (Boolean)hasThinkObj != false;
                if (!hasThink && StringUtils.isNotEmpty((CharSequence)think)) {
                    hasThink = true;
                    appCache.put("streamHasThink" + taskId, (Object)hasThink);
                }
                if (hasThink && StringUtils.isEmpty((CharSequence)thinkCached) && StringUtils.isNotEmpty((CharSequence)think) && StringUtils.isEmpty((CharSequence)(think = StrUtils.clearStartNewLine(think))) && StringUtils.isEmpty((CharSequence)msg)) {
                    return;
                }
                if (hasThink && StringUtils.isNotEmpty((CharSequence)think)) {
                    if (StringUtils.endsWith((CharSequence)think, (CharSequence)"\n")) {
                        appCache.put("streamThinkNewLine" + taskId, (Object)"\n");
                        think = think.substring(0, think.length() - 1);
                        if (StringUtils.isEmpty((CharSequence)think) && StringUtils.isEmpty((CharSequence)msg)) {
                            return;
                        }
                    } else {
                        String thinkNewLineCached = (String)appCache.get("streamThinkNewLine" + taskId);
                        if (StringUtils.isNotEmpty((CharSequence)thinkNewLineCached)) {
                            appCache.remove(new String[]{"streamThinkNewLine" + taskId});
                            think = String.format("\n%s", think);
                        }
                    }
                }
                if (StringUtils.isEmpty((CharSequence)msgCached) && StringUtils.isNotEmpty((CharSequence)msg) && StringUtils.isEmpty((CharSequence)(msg = StrUtils.clearStartNewLine(msg))) && StringUtils.isEmpty((CharSequence)think)) {
                    return;
                }
                if (msg == null && think == null) {
                    end = true;
                    msg = (String)appCache.get("streamBuffer" + taskId);
                    String allThink = (String)appCache.get("streamThinkBuffer" + taskId);
                    streamRepoBuffer = (String)appCache.get("streamRepoBuffer" + taskId);
                    String allChatMsg = (msg == null ? "" : msg) + (streamRepoBuffer != null ? streamRepoBuffer : "");
                    llmParsedMessage.setAllMsg(allChatMsg);
                    llmParsedMessage.setAllThink(allThink);
                    this.saveAiccTaskInfo(taskId, llmParsedMessage);
                    if (msg != null && !msg.contains("functioncall")) {
                        ChatHistoryService.save(chatSessionId, prompt.getId(), Collections.singletonList(new ChatItem(1, allChatMsg, allThink)));
                    }
                    msg = StringUtils.isNotEmpty((CharSequence)streamRepoBuffer) ? KnowledgeCitationHelper.getSupKnowledgeIndex(chatSessionId, taskId, prompt.getChunkIdList(), streamRepoBuffer) : "";
                    llmParsedMessage.setSeqNo(result.getStreamSeqNO());
                    List<KnowledgeCitationData> citationInfos = KnowledgeCitationHelper.getCitationInfo(chatSessionId, taskId);
                    logger.info("\u3010\u6d41\u3011\u5927\u6a21\u578b\u6d41\u5f0f\u6d88\u606f\u6c47\u603b\uff1a{}\u3002\r\n\u3002\u641c\u7d22\u51fa\u7684chunkIds\uff1a{} \u3002\u4f7f\u7528\u7684\u77e5\u8bc6\u5e93\u5f15\u7528\u4fe1\u606f\u4e3a{}", new Object[]{allChatMsg, JSON.toJSON(prompt.getChunkIdList()), JSON.toJSON(citationInfos)});
                    llmParsedMessage.setCitationInfos(citationInfos);
                    if (llmParsedMessage.isParseOutput()) {
                        JSONObject jsonObject = GaiUtils.toJson(allChatMsg);
                        HashMap<String, String> outMap = new HashMap<String, String>(jsonObject.isEmpty() ? Collections.singletonMap(OutPreVar.GPT_OUTPUT.getVar(), allChatMsg) : LLMHandler.getPromptJsonMap(allChatMsg, jsonObject, prompt.getPromptOutVarList()));
                        if (StringUtils.isNotEmpty((CharSequence)allThink)) {
                            outMap.put(OutPreVar.RESONING_OUTPUT.getVar(), allThink);
                        }
                        llmParsedMessage.setJsonValue(outMap);
                    }
                } else {
                    String streamBuffer;
                    String streamThinkBuffer;
                    end = false;
                    List<Long> chunkIdList = prompt.getChunkIdList();
                    if (null != chunkIdList && !chunkIdList.isEmpty()) {
                        streamRepoBuffer = (String)appCache.get("streamRepoBuffer" + taskId);
                        if (StringUtils.isNotEmpty((CharSequence)streamRepoBuffer)) {
                            if (msg != null && !msg.contains("########")) {
                                appCache.put("streamRepoBuffer" + taskId, (Object)(streamRepoBuffer + msg));
                                return;
                            }
                            msg = KnowledgeCitationHelper.getSupKnowledgeIndex(chatSessionId, taskId, chunkIdList, streamRepoBuffer + msg);
                            appCache.put("streamRepoBuffer" + taskId, (Object)"");
                        } else if (msg != null && msg.contains("########")) {
                            appCache.put("streamRepoBuffer" + taskId, (Object)msg);
                            return;
                        }
                    }
                    String string = streamThinkBuffer = null == (streamThinkBuffer = (String)appCache.get("streamThinkBuffer" + taskId)) ? "" : streamThinkBuffer;
                    if (StringUtils.isNotEmpty((CharSequence)think)) {
                        appCache.put("streamThinkBuffer" + taskId, (Object)(streamThinkBuffer + think));
                    }
                    String string2 = streamBuffer = null == (streamBuffer = (String)appCache.get("streamBuffer" + taskId)) ? "" : streamBuffer;
                    if (msg != null) {
                        if (msg.contains("function.name") || msg.contains("function.arguments") || msg.contains("function_call") || msg.contains("tool_call")) {
                            appCache.put("streamBuffer" + taskId, (Object)"functioncall");
                        } else {
                            appCache.put("streamBuffer" + taskId, (Object)(streamBuffer + msg));
                        }
                    }
                    llmParsedMessage.setSeqNo(result.getStreamSeqNO());
                }
            } else {
                end = true;
                int seqNo = result.getStreamSeqNO();
                if (seqNo == 0) {
                    long first = System.currentTimeMillis();
                    logger.info("LLMToken set no stream first token return time:{},taskId:{}", (Object)first, (Object)taskId);
                    taskCache.put("task_first_token_time", (Object)String.valueOf(first));
                }
                ModelResult modelResult = helper.getResult(new ModelResultParam(false, result.getResult().get(0)));
                if (result.isParsedResult()) {
                    msg = result.getLlmValue();
                    think = result.getLlmThinkValue();
                } else {
                    msg = modelResult.getContent();
                    think = modelResult.getThink();
                }
                msg = StrUtils.clearStartNewLine(msg);
                think = StrUtils.clearStartNewLine(think);
                ChatHistoryService.save(chatSessionId, prompt.getId(), Collections.singletonList(new ChatItem(1, msg, think)));
                llmParsedMessage.setAllThink(think);
                List<Long> chunkIdList = prompt.getChunkIdList();
                chunkIdList = LlmServiceFactory.getExecutor(LLM.BAIDU_ERNIE_BOT, true).filterContext(msg, chunkIdList);
                logger.info("\u3010\u975e\u6d41\u3011\u4f7f\u7528\u7684\u77e5\u8bc6\u5e93\u5757\u4fe1\u606f\uff1a{}\u3002", JSON.toJSON(chunkIdList));
                msg = KnowledgeCitationHelper.getSupKnowledgeIndex(chatSessionId, taskId, chunkIdList, msg);
                List<KnowledgeCitationData> citationInfos = KnowledgeCitationHelper.getCitationInfo(chatSessionId, taskId);
                llmParsedMessage.setCitationInfos(citationInfos);
                if (llmParsedMessage.isParseOutput()) {
                    JSONObject jsonObject = GaiUtils.toJson(msg);
                    HashMap<String, String> outMap = new HashMap<String, String>(jsonObject.isEmpty() ? Collections.singletonMap(OutPreVar.GPT_OUTPUT.getVar(), msg) : LLMHandler.getPromptJsonMap(msg, jsonObject, prompt.getPromptOutVarList()));
                    if (StringUtils.isNotEmpty((CharSequence)think)) {
                        outMap.put(OutPreVar.RESONING_OUTPUT.getVar(), think);
                    }
                    llmParsedMessage.setJsonValue(outMap);
                }
            }
            llmParsedMessage.setStream(stream);
            llmParsedMessage.setEnd(end);
            llmParsedMessage.setLlmValue(msg);
            llmParsedMessage.setLlmThink(think);
        }
        catch (Exception e) {
            logger.error("gai LLM callback \u5f02\u6b65\u8c03\u7528\u51fa\u9519\u3002", (Throwable)e);
            if (e instanceof KDBizException) {
                String errCode = ((KDBizException)((Object)e)).getErrorCode().getCode();
                errCode = StringUtils.isEmpty((CharSequence)errCode) ? Errors.LLM_ERROR.getCode() : errCode;
                llmParsedMessage.setErrCode(errCode);
            } else {
                llmParsedMessage.setErrCode(Errors.LLM_ERROR.getCode());
            }
            llmParsedMessage.setErrMsg(e.getMessage());
        }
        if (LLMHandler.stopChatSession(chatSessionId, taskId, true)) {
            return;
        }
        if (AgentServiceService.isNewFlowEngine()) {
            LLMHandler.llmHandlerCallback(llmParsedMessage, chatSessionId);
        } else {
            HandlerFactory.callback(llmParsedMessage);
        }
    }

    private void saveAiccTaskInfo(String taskId, LLMParsedMessage llmParsedMessage) {
        try {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("msg", llmParsedMessage.getAllMsg());
            map.put("think", llmParsedMessage.getAllThink());
            TraceUtil.saveTaskFormatContent(taskId, JSON.toJSONString(map));
        }
        catch (Exception e) {
            logger.error("saveAiccTaskInfo error", (Throwable)e);
        }
    }

    private static void llmHandlerCallback(LLMParsedMessage llmParsedMessage, String chatSessionId) {
        if (llmParsedMessage instanceof LLMActionCallbackMessage) {
            LLMActionCallbackMessage llmActionCallbackMessage = (LLMActionCallbackMessage)llmParsedMessage;
            LLMActionHandler.promptNodeCallBack(llmActionCallbackMessage);
        } else if (llmParsedMessage instanceof RepoReplyCallbackMessage) {
            RepoReplyCallbackMessage repoReplyCallbackMessage = (RepoReplyCallbackMessage)llmParsedMessage;
            LLMActionHandler.doCallback(repoReplyCallbackMessage);
        } else if (llmParsedMessage instanceof QueryEntityCallbackMessage) {
            QueryEntityCallbackMessage queryEntityCallbackMessage = (QueryEntityCallbackMessage)llmParsedMessage;
            LLMActionHandler.doQueryEntityCallback(queryEntityCallbackMessage);
        } else {
            HandlerFactory.callback(llmParsedMessage);
        }
    }

    @Override
    public Result process(Context context, LLMMessage message) {
        Result2User result2User;
        logger.info("gai\u8017\u65f6\u8bb0\u5f55 1.process ");
        String chatSessionId = context.getChatSessionId();
        Prompt prompt = message.getPrompt();
        Result result = new Result();
        if (message.getPrompt() == null) {
            long promptId = message.getPromptId();
            prompt = PromptService.getById(promptId);
            if (message.getRepoIdList() != null && !message.getRepoIdList().isEmpty()) {
                HashSet<Long> allRepoSet = new HashSet<Long>(message.getRepoIdList());
                if (prompt.getRepoIds() != null) {
                    allRepoSet.addAll(prompt.getRepoIds());
                }
                logger.info("\u5408\u5e76\u77e5\u8bc6\u5e93\uff0c\u539f\u6765\uff1a{}\uff0c\u4f20\u9012{},\u7ed3\u679c{}", new Object[]{prompt.getRepoIds(), message.getRepoIdList(), allRepoSet});
                prompt.setRepoIds(new ArrayList<Long>(allRepoSet));
            }
            prompt.setPromptType(0);
        }
        if (Context.needCheckLicense(context)) {
            try {
                GPTLicenseHelper.checkLic("gai_prompt", prompt.getId());
                if (prompt.getRepoIds() != null && prompt.getRepoIds().size() > 0) {
                    GPTLicenseHelper.checkLic("ai_gai_reporag", 0L);
                }
            }
            catch (KDBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
                result.setErrorCode(e.getErrorCode());
                return result;
            }
        }
        Decrypt.decrypt(prompt);
        List<UserHistoryMessage> history = ChatHistoryService.getPromptHistory(chatSessionId, prompt.getRemembercount(), prompt.getId());
        boolean sync = message.isSync();
        long start = System.currentTimeMillis();
        long traceId = TraceUtil.buildTraceId(context, message);
        if (sync) {
            LLMParsedMessage callbackMessage = message.getCallbackMessage();
            long flowId = 0L;
            int nodeId = 0;
            if (callbackMessage != null) {
                flowId = callbackMessage.getFlowId();
                nodeId = callbackMessage.getNodeId();
            }
            long startLlm = (result2User = LlmService.syncGpt(prompt, message.getParamMap(), history, message.getUserInput(), chatSessionId, traceId, message.getUseKnowledgeTopK(), flowId, nodeId)).getStartLlm() == 0L ? start : result2User.getStartLlm();
            long end = System.currentTimeMillis();
            String think = result2User.getThink();
            String content = result2User.getContent();
            ChatHistoryService.save(chatSessionId, prompt.getId(), Collections.singletonList(new ChatItem(0, message.getUserInput())));
            ChatHistoryService.save(chatSessionId, prompt.getId(), Collections.singletonList(new ChatItem(1, content, think)));
            String taskId = result2User.getTaskId();
            content = KnowledgeCitationHelper.getSupKnowledgeIndex(chatSessionId, taskId, prompt.getChunkIdList(), content);
            List<KnowledgeCitationData> citationInfos = KnowledgeCitationHelper.getCitationInfo(chatSessionId, taskId);
            List<APIReferenceData> apiReferenceData = KnowledgeCitationHelper.boxCitationInfoToAPIService(citationInfos);
            HashMap<String, String> data = new HashMap<String, String>(2);
            data.put("taskId", taskId);
            data.put("think", think);
            data.put("llmValue", content);
            data.put("referenceInfos", SerializationUtils.toJsonString(apiReferenceData));
            if (message.getCallbackMessage() != null && message.getCallbackMessage().isParseOutput()) {
                JSONObject jsonObject = GaiUtils.toJson(content);
                Map<String, String> outMap = jsonObject.isEmpty() ? Collections.singletonMap(OutPreVar.GPT_OUTPUT.getVar(), content) : LLMHandler.getPromptJsonMap(content, jsonObject, prompt.getPromptOutVarList());
                data.put("jsonValue", SerializationUtils.toJsonString(outMap));
            }
            data.put("citationInfos", SerializationUtils.toJsonString(citationInfos));
            if (result2User.getSearchInfoList() != null && !result2User.getSearchInfoList().isEmpty()) {
                data.put("searchInfos", SerializationUtils.toJsonString(result2User.getSearchInfoList()));
            }
            result.setData(data);
            TraceUtil.saveSyncLLMLog(result2User.getTaskId(), context, message, content, think, prompt, traceId, startLlm, end, result2User.getCode());
        } else {
            result2User = LlmService.doAsyncGpt(message.isStream(), prompt, message.getParamMap(), history, message.getUserInput(), chatSessionId, message.getCallbackMessage(), traceId, message.getUseKnowledgeTopK());
            String taskId = result2User.getTaskId();
            long startLlm = result2User.getStartLlm();
            logger.info("LLMToken \u5f00\u59cb\u8c03\u7528LLM\u65f6\u95f4\uff1a{},traceId:{},taskId:{}", new Object[]{startLlm, traceId, taskId});
            TraceUtil.endLLMLog(taskId, traceId, startLlm);
            LLMParsedMessage callbackMessage = message.getCallbackMessage();
            callbackMessage.setChatSessionId(chatSessionId);
            LocalMemoryCache taskCache = EngineCache.getLocalCache(taskId);
            taskCache.put("llmTask" + taskId, (Object)JsonUtil.messageToJson(callbackMessage));
            taskCache.put("MsgSplit.LLM" + taskId, (Object)prompt.getLlm().getNumber());
            logger.info("GAI \u5f02\u6b65\u8c03\u7528\u56de\u8c03\u7f13\u5b58\uff0ctaskId({}),content\uff1a{}", (Object)taskId, (Object)JsonUtil.messageToJson(callbackMessage));
            EngineCache.getLocalCache(chatSessionId).put("prompt" + taskId, (Object)prompt);
            LLMParsedMessage llmParsedMessage = message.getCallbackMessage();
            if (llmParsedMessage instanceof AgentCallBackMessage) {
                AgentCallBackMessage agentCallBackMessage = (AgentCallBackMessage)llmParsedMessage;
                AgentMessage agentMessage = agentCallBackMessage.getAgentMessage();
                String roleMode = agentMessage.getAgent().getRoleMode();
                if (roleMode.equals(RoleModeEnum.FUNCTIONCALL.getId()) && agentMessage.getUserInput().startsWith("functioncall")) {
                    ChatHistoryService.save(chatSessionId, prompt.getId(), Collections.singletonList(new ChatItem(2, agentMessage.getUserInput())));
                } else {
                    ChatHistoryService.save(chatSessionId, prompt.getId(), Collections.singletonList(new ChatItem(0, message.getUserInput())));
                }
                if (roleMode.equals(RoleModeEnum.FUNCTIONCALL.getId())) {
                    taskCache.put("function_call_mask", (Object)true);
                }
            } else {
                ChatHistoryService.save(chatSessionId, prompt.getId(), Collections.singletonList(new ChatItem(0, message.getUserInput())));
            }
            TrustLayerContext trustLayerContext = result2User.getTrustLayerContext();
            if (trustLayerContext != null && trustLayerContext.getMaskingInfoList() != null && !trustLayerContext.getMaskingInfoList().isEmpty()) {
                taskCache.put("TrustLayer.MaskingContext" + taskId, (Object)JSON.toJSONString((Object)trustLayerContext));
                taskCache.put("MsgSplit.Enable" + taskId, (Object)"true");
            }
            taskCache.put("TrustLayer.SensitiveCheck.Enable", (Object)String.valueOf(SensitiveCheckService.isNeedCheck()));
            List<Chunk> chunkList = result2User.getChunkList();
            long beforeChunk = result2User.getBeforeChunk();
            long endChunk = result2User.getEndChunk();
            VectorRetrieverLog vectorRetrieverLog = new VectorRetrieverLog(chatSessionId, traceId, message.getUserInput(), JSON.toJSONString(chunkList), callbackMessage, prompt, beforeChunk, endChunk);
            vectorRetrieverLog.setTaskId(taskId);
            String llmParamString = result2User.getLlmParamString();
            long startPrompt = result2User.getStartPrompt();
            long endPrompt = result2User.getEndPrompt();
            PromptLog promptLog = new PromptLog(taskId, chatSessionId, traceId, prompt.getServiceNumber(), JSON.toJSONString(chunkList), llmParamString, callbackMessage, prompt, startPrompt, endPrompt);
            TrustLayerLog trustLayerLog = new TrustLayerLog(chatSessionId, traceId, message.getUserInput(), prompt, callbackMessage.getFlowId(), callbackMessage.getNodeId());
            trustLayerLog.setTaskId(taskId);
            trustLayerLog.setStart(result2User.getStartTrust());
            trustLayerLog.setEnd(result2User.getEndTrust());
            trustLayerLog.setErrorCode(result2User.getCode());
            trustLayerLog.setErrorMsg(result2User.getErrMsg());
            TraceUtil.saveTraceStepsLog(chatSessionId, traceId, vectorRetrieverLog, promptLog, trustLayerLog);
            result.setTaskId(taskId);
        }
        result.setErrorCode(new ErrorCode(result2User.getCode(), result2User.getErrMsg()));
        logger.info("gai\u8017\u65f6\u8bb0\u5f55 2.process done ");
        return result;
    }

    private static Map<String, String> getPromptJsonMap(String origin, JSONObject jsonObject, List<PromptOutVar> promptOutVarList) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (promptOutVarList == null || promptOutVarList.isEmpty()) {
            throw new KDBizException("\u8bf7\u68c0\u67e5prompt\u4e2d\u63d0\u793a\u8f93\u51fa\u53c2\u6570\u914d\u7f6e.");
        }
        for (PromptOutVar promptOutVar : promptOutVarList) {
            if (promptOutVar.getVar().equals(OutPreVar.GPT_OUTPUT.getVar())) {
                if (promptOutVar.getJsonAnalysis()) {
                    if (jsonObject.isEmpty()) {
                        throw new KDBizException("json\u63d0\u53d6\u5f02\u5e38\uff1a" + origin);
                    }
                    result.put(OutPreVar.GPT_OUTPUT.getVar(), jsonObject.toJSONString());
                    continue;
                }
                result.put(OutPreVar.GPT_OUTPUT.getVar(), origin);
                continue;
            }
            if (!jsonObject.containsKey((Object)promptOutVar.getVar()) && promptOutVar.getVar().contains(".")) {
                Object value = PropUtil.getValueByPath(jsonObject, promptOutVar.getVar());
                result.put(promptOutVar.getVar(), value == null ? null : value.toString());
                continue;
            }
            result.put(promptOutVar.getVar(), jsonObject.getString(promptOutVar.getVar()));
        }
        return result;
    }

    private boolean isTaskStop(LLMRawMessage result, LLMParsedMessage llmParsedMessage, String chatSessionId) {
        String taskId = String.valueOf(result.getId());
        LocalMemoryCache taskCache = EngineCache.getLocalCache(taskId);
        String hasSendStop = (String)taskCache.get(STOP_RESULT_KEY_MESSAGESENDED + taskId);
        if (StringUtils.isNotEmpty((CharSequence)hasSendStop)) {
            return true;
        }
        boolean isNeedStop = false;
        if (LLMHandler.stopChatSession(chatSessionId, taskId, false)) {
            return true;
        }
        if (StopStreamHandler.isTaskStopped(taskId) || "stopped".equals(result.getStatus())) {
            logger.info("task : {} is stopped.", (Object)taskId);
            isNeedStop = true;
        } else if (StopStreamHandler.isSSEStopped(llmParsedMessage.getChatSessionId(), RequestContext.get().getTraceId())) {
            logger.info(" SEStop task : {} .", (Object)taskId);
            StopStreamHandler.stopTask(taskId);
            isNeedStop = true;
        } else if (llmParsedMessage.getFlowId() != 0L && StopStreamHandler.isStopped(llmParsedMessage.getChatSessionId(), llmParsedMessage.getFlowId())) {
            logger.warn(String.format("flow %s is stopped. task:%s", llmParsedMessage.getFlowId(), taskId));
            StopStreamHandler.stopTask(taskId);
            isNeedStop = true;
        }
        if (isNeedStop) {
            result.setErrCode(Errors.STOP_STREAM.getCode());
            result.setErrMsg(Errors.STOP_STREAM.getMessage());
            taskCache.put(STOP_RESULT_KEY_MESSAGESENDED + taskId, (Object)"true");
        }
        return isNeedStop;
    }

    private static boolean stopChatSession(String chatSessionId, String taskId, boolean stopStream) {
        String flowCancelled = FlowCacheData.getCache(chatSessionId, "flowCancelled");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)flowCancelled) && Boolean.parseBoolean(flowCancelled)) {
            if (StringUtils.isNotEmpty((CharSequence)taskId)) {
                LlmService.stopGpt(Long.parseLong(taskId));
            }
            Context context = FlowCacheData.getContext(chatSessionId);
            FlowUtils.stopChat(context, taskId, "0");
            return true;
        }
        return false;
    }
}

